var md = md || {};
md.widgets = md.widgets || {};

md.widgets.MooLoupe = new Class({
    Implements: [Options, Events],

    options: {
        width: 200,
        height: 100,
        magnification: 1,
        controls: true,
        hidden: false,
        circular: false,
        padding: 0,
        'main-image': null  /* REQUIRED */
    },

    initialize: function(elementId, options){
        var _this = this;
        this.setOptions(options);
        this.element = $(elementId);
        this.magnification = this.options.magnification;

        if (!this.options['main-image']) {
            console.error("Mooloupe: 'main-image' parameter is required");
            return false;
        }

        this.options['main-image'].addEvent('load', function() {
            _this.start();
        });
    },

    start: function() {
        var _this = this;

        this.imgSrc = this.options['main-image'].get('src');

        this.img = {
            width: this.options['main-image'].width,
            height: this.options['main-image'].height
        }
        this.naturalImg = {
            width: this.options['main-image'].naturalWidth,
            height: this.options['main-image'].naturalHeight
        }

        this.loupePosition = {
            x: (this.img.width / 2) - (this.options.width / 2),
            y: (this.img.height / 2) - (this.options.height / 2)
        }

        if ($$('div.mooloupe').length < 1) {
            
            this.widget = new Element('div.mooloupe').wraps(this.element);
            this.wrapper = new Element('div.mooloupe-wrapper').wraps(this.element);
            this.loupe = new Element('div.mooloupe-loupe').inject(this.wrapper).setStyles({
                width: _this.options.width,
                height: _this.options.height,
                top: this.loupePosition.y,
                left: this.loupePosition.x
            });
            this.loupe_content_wrapper = new Element('div.mooloupe-loupe-content-wrapper').inject(this.loupe);

            if (this.options.padding) {
                this.loupe_content_wrapper.setStyles({
                    width: _this.options.width - this.options.padding * 2,
                    height: _this.options.height - this.options.padding * 2,
                    top: this.options.padding,
                    left: this.options.padding
                })
            }

            if (this.options.circular) {
                this.loupe_content_wrapper.setStyles({
                    'border-radius': this.options.height / 2 + 'px'
                })
            }

            if (this.options.controls) {
                var controls = new Element('div.mooloupe-controls').inject(this.widget, 'top');
                var zoom_in = new Element('a.mooloupe-loupe-control.mooloupe-zoomin', {
                    href: '#',
                    html: '<i class="fa fa-plus-circle"></i>',
                    title: 'Zoom in'
                }).inject(this.loupe_content_wrapper);
                var zoom_out = new Element('a.mooloupe-loupe-control.mooloupe-zoomout', {
                    href: '#',
                    html: '<i class="fa fa-minus-circle"></i>',
                    title: 'Zoom out'
                }).inject(this.loupe_content_wrapper);
                var reset_zoom = new Element('a.mooloupe-loupe-control.mooloupe-reset', {
                    href: '#',
                    html: '<i class="fa fa-refresh"></i>',
                    title: 'Reset zoom'
                }).inject(this.loupe_content_wrapper);
                var show_hide = new Element('a.mooloupe-control', {
                    href: '#',
                    html: '<i class="fa fa-times"></i><i class="fa fa-search"></i>',
                    title: 'Show/hide loupe'
                }).inject(controls);
                var loupe_close = new Element('a.mooloupe-loupe-control.mooloupe-close', {
                    href: '#',
                    html: '<i class="fa fa-times-circle"></i>',
                    title: 'Close'
                }).inject(this.loupe_content_wrapper);

                zoom_in.addEvent('click', function() {
                    _this.zoomIn();
                    return false;
                });
                zoom_out.addEvent('click', function() {
                    _this.zoomOut();
                    return false;
                });
                reset_zoom.addEvent('click', function() {
                    _this.resetZoom();
                    return false;
                });
                show_hide.addEvent('click', function() {
                    _this.toggle();
                    return false;
                });
                loupe_close.addEvent('click', function() {
                    _this.toggle();
                    return false;
                });
            }

            this.loupe.makeDraggable({
                limit: {
                    x: [0, this.img.width - this.options.width + this.options.padding * this.magnification],
                    y: [0, this.img.height - this.options.height + this.options.padding * this.magnification]
                },
                onDrag: function(draggable, droppable) {
                    _this.render();
                }
            });

        }

        if (this.options.hidden) {
            this.widget.addClass('mooloupe-hidden');
        }

        this.updateElement();
        this.render();
    },

    zoomIn: function() {
        this.magnification += 0.2;
        this.render();
    },

    zoomOut: function() {
        this.magnification -= 0.2;
        if (this.magnification <= 0) {
            this.magnification = 0;
        }
        this.render();
    },

    resetZoom: function() {
        this.magnification = this.options.magnification;
        this.render();
    },

    toggle: function() {
        if (!this.widget) {
            this.start();
        }
        
        this.widget.toggleClass('mooloupe-hidden');
    },

    updateElement: function() {
        this.loupe_content_wrapper.set('html', '');
        this.cloned = this.element.clone();
        this.cloned.setStyles({
            position: 'absolute'
        });
        this.cloned.inject(this.loupe_content_wrapper);
    },

    render: function() {
        var _this = this;

        var currentPos = {
            x: parseInt(this.loupe.getStyle('left')),
            y: parseInt(this.loupe.getStyle('top'))
        }

        this.backgroundSize = {
            width: this.img.width + (this.naturalImg.width - this.img.width) * this.magnification,
            height: this.img.height + (this.naturalImg.height - this.img.height) * this.magnification
        }

        this.backgroundPosition = {
            x: -currentPos.x * (this.backgroundSize.width - this.options.width) / (this.img.width - this.options.width),
            y: -currentPos.y * (this.backgroundSize.height - this.options.height) / (this.img.height - this.options.height)
        }

        this.cloned.setStyles({
            width: this.backgroundSize.width,
            height: this.backgroundSize.height,
            left: this.backgroundPosition.x,
            top: this.backgroundPosition.y
        });
        this.cloned.getElements('.overlays, .overlays img').setStyles({
            height: this.backgroundSize.height
        });
        this.cloned.getElements('.overlays img').setStyles({
            width: this.backgroundSize.width
        });
    }
});