tinymce.PluginManager.add('placeholder', function(editor) {
    editor.on('init', function() {
        var label = new Label;
        onBlur();

        tinymce.DOM.bind(label.el, 'click', onFocus);
        editor.on('focus', onFocus);
        editor.on('blur', onBlur);
        editor.on('change', onBlur);
        editor.on('setContent', onBlur);
        editor.on('keydown', onKeydown);

        function getContent(){
            var _content = editor.getContent();
            var _doc = (new DOMParser()).parseFromString('<div class="dom_wrapper">'+_content+'</div>','text/html');
            Array.prototype.slice.call(_doc.querySelectorAll('body *.tiny-mce-inlince-placeholder')).forEach(function(theEl){
                if(theEl.parentElement)
                    theEl.parentElement.removeChild(theEl)
            });
            Array.prototype.slice.call(_doc.querySelectorAll('body [data-mce-bogus]')).forEach(function(theEl){
                var _p = theEl.parentElement;
                if(_p){
                    _p.removeChild(theEl);

                    if( _p.childNodes.length == 0) {
                        if(_p.parentElement)
                            _p.parentElement.removeChild(_p);
                    }
                }
            });
            //body = (new XMLSerializer()).serializeToString(_doc.querySelector('body > *.dom_wrapper')).innerHTML;
            _content = _doc.querySelector('body > *.dom_wrapper').innerHTML;

            return _content;
        }

        function onFocus(ev) {
            var _content = getContent();
            var tinyImages = _content.match(/<img class="tinymce-image"/)
            var theContent = _content.replace(/<(?:[^>=]|='[^']*'|="[^"]*"|=[^'"][^\s>]*)*>/g, "").trim();

            if (!editor.settings.readonly === true || ( theContent != '' || tinyImages) ) {
                label.hide();
            }
            editor.execCommand('mceFocus', false);
        }

        function onBlur() {
            var _content = getContent();
            
            var tinyImages = _content.match(/<img class="tinymce-image"/)
            var theContent = _content.replace(/<(?:[^>=]|='[^']*'|="[^"]*"|=[^'"][^\s>]*)*>/g, "").trim();
            var theContent = theContent.replace(/&nbsp;/g, "").trim()

            if ( theContent == '' && !tinyImages) {
                label.show();
            } else {
                label.hide();
            }
        }

        function onKeydown(){
            label.hide();
        }
    });

    var Label = function(){
        var placeholder_text = editor.getElement().getAttribute("placeholder") || editor.settings.placeholder;
        var placeholder_attrs = editor.settings.placeholder_attrs || {class: 'tiny-mce-inlince-placeholder', style: {top:'5px', left:0, color: '#888', width:'98%', overflow: 'hidden', 'white-space': 'pre-wrap'} };
        var contentAreaContainer = editor.getContentAreaContainer() || editor.getContainer() || editor.getElement();

        tinymce.DOM.setStyle(contentAreaContainer, 'position', 'relative');
        
        // Create label el
        this.el = tinymce.DOM.add( contentAreaContainer, editor.settings.placeholder_tag || "label", placeholder_attrs, placeholder_text );
    }

    Label.prototype.hide = function(){
        if(typeof this.el !== 'undefined' && this.el !== null && this.el !== false)
            tinymce.DOM.setStyle( this.el, 'display', 'none' );
        else
            editor.targetElm.removeClass('empty')
    }

    Label.prototype.show = function(){
        if(typeof this.el !== 'undefined' && this.el !== null && this.el !== false)
            tinymce.DOM.setStyle( this.el, 'display', '' );
        else
            editor.targetElm.addClass('empty')
    }
});