/*
---

script: Delegator.FakeLabel.js

description: iPad doesn't seem to support label interactions. Writing a delegator to simulate it on links.

requires:
  - Behavior/Delegator
  - Behavior/Event.Mock

provides: [Delegator.FakeLabel]

...
*/
Delegator.register('click', 'fakeLabel', {
	defaults: {
		target: 'input'
	},
	handler: function(event, element, api) {
		var input = element.getElement(api.get('target'));
		if (['checkbox', 'radio'].contains(input.get('type'))) {
			input.checked = true;
			input.fireEvent('change', new Event.Mock(input, 'change'));
		}
		input.focus();
	}
});