/*
---
description: Provides functionality to add a class to one element in a group when it is clicked.
provides: [Delegator.SelectOne]
requires: [Behavior/Delegator, Core/Element.Event]
script: Delegator.SelectOne.js
name: Delegator.SelectOne

...
*/
Delegator.register('click', 'selectOne', {
  require: ['targets'],
  defaults: {
    'class': 'selected'
  },
  handler: function(event, link, api){
    var targets = link.getElements(api.get('targets'));
    if (targets.length == 0) api.fail('Could not find targets for selector ' + api.get('targets'));

    targets.removeClass(api.get('class'));
    if (targets.contains(link)) {
      link.addClass(api.get('class'));
    } else {
      targets.some(function(el){
        if (el.contains(link)) {
          el.addClass(api.get('class'));
          return true; //exit out of loop
        }
      });
    }
  }
});