/*
---
description: Allows you to display a specific slide in a gallery
provides: [Delegator.ShowSlide]
requires: [Clientcide/Behavior.Tabs]
script: Delegator.ShowSlide.js
name: Delegator.ShowSlide

...
*/

/*
  IMPORTANT: If you are using this linker to reference a tabs instance in a popup
  you must remember that the tabs element is cloned into the popup, meaning that there are
  two in the document. The popup will always be the first one in the DOM. Write your tabs selector
  accordingly.
*/

Delegator.register('click', 'ShowSlide', {
  requireAs: {
    tabs: String, //selector to the tabs instance; see warning above.
    index: Number //index tab to show
  },
  handler: function(event, link, api){
    var target = link.getElement(api.get('tabs'));
    if (!target) api.fail('Could not find target for selector ' + api.get('tabs'));
    var tabs = target.getBehaviorResult('Tabs');
    if (!tabs) api.fail('The target element is not part of a tabs interface');
    tabs.show(api.getAs(Number, 'index'));
  }
});