/*
---
description: Tabs extension w/ pagination
provides: [Delegator.TabsPagination]
requires: [Clientcide/Behavior.Tabs]
script: Delegator.TabsPagination.js
name: Delegator.TabsPagination

...
*/

/*
  IMPORTANT: If you are using this linker to reference a tabs instance in a popup
  you must remember that the tabs element is cloned into the popup, meaning that there are
  two in the document. The popup will always be the first one in the DOM. Write your tabs selector
  accordingly.

  Example usage:

  <div id="comic-popup" class="modal">
		<div data-behavior="Tabs" data-tabs-options="
				'tabs-selector': '.thumbs a',
				'sections-selector': '.slide',
				'smooth': false,
				'smoothSize': false
			" id="comic-tabs">
			<div class="modal-body">
				<div class="slides">
					<div class="page-left" data-trigger="PageTabs" data-pagetabs-options="
						'tabs': '!body #comic-tabs',
						'direction': 'back'
					"></div>
					<div class="page-right" data-trigger="PageTabs" data-pagetabs-options="
						'tabs': '!body #comic-tabs',
						'direction': 'next'
					"></div>
					<div class="slide">
						<img src="../Images/AMS-ePub-04-cell1.jpg" alt="" />
					</div>
					<div class="slide hidden">
						<img src="../Images/AMS-ePub-04-cell2.jpg" alt="" />
					</div>
					<div class="slide hidden">
						<img src="../Images/AMS-ePub-04-cell3.jpg" alt="" />
					</div>
					<div class="slide">
						<img src="../Images/AMS-ePub-04-cell4.jpg" alt="" />
					</div>
					<div class="slide hidden">
						<img src="../Images/AMS-ePub-04-cell5.jpg" alt="" />
					</div>
					<div class="slide hidden">
						<img src="../Images/AMS-ePub-04-cell6.jpg" alt="" />
					</div>
					<div class="slide">
						<img src="../Images/AMS-ePub-04-cell7.jpg" alt="" />
					</div>
					<div class="slide hidden">
						<img src="../Images/AMS-ePub-04-cell8.jpg" alt="" />
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<div class="thumbs">
					<div class="scroller scrollable horizontal">
						<a><img src="../Images/AMS-ePub-04-cell1th.jpg" width="70" height="70" alt="Cell 1"/></a>
						<a><img src="../Images/AMS-ePub-04-cell2th.jpg" width="70" height="70" alt="Cell 2"/></a>
						<a><img src="../Images/AMS-ePub-04-cell3th.jpg" width="70" height="70" alt="Cell 3"/></a>
						<a><img src="../Images/AMS-ePub-04-cell4th.jpg" width="70" height="70" alt="Cell 4"/></a>
						<a><img src="../Images/AMS-ePub-04-cell5th.jpg" width="70" height="70" alt="Cell 5"/></a>
						<a><img src="../Images/AMS-ePub-04-cell6th.jpg" width="70" height="70" alt="Cell 6"/></a>
						<a><img src="../Images/AMS-ePub-04-cell7th.jpg" width="70" height="70" alt="Cell 7"/></a>
						<a><img src="../Images/AMS-ePub-04-cell8th.jpg" width="70" height="70" alt="Cell 8"/></a>
					</div>
				</div>
				<a class="close btn primary">Close</a>
			</div>
		</div>
	</div>

*/

Delegator.register('click', 'PageTabs', {
  requireAs: {
    tabs: String //selector to the tabs instance; see warning above.
  },
  handler: function(event, link, api){
    var target = link.getElement(api.get('tabs'));
    if (!target) api.fail('Could not find target for selector ' + api.get('tabs'));
    var tabs = target.getBehaviorResult('Tabs');
    if (!tabs) api.fail('The target element is not part of a tabs interface');

    var now = tabs.now;
    var next = api.get('direction') == 'back' ? next = now - 1 : next = now + 1;

    if (!tabs.tabs[next]) return;

    tabs.show(next);
  }
});