/*
---

script: Fx.Scrollability.js

description: Provides logging messages for iBooks

requires:
  - More/Fx.Scroll
  - Scrollability

provides: [Fx.Scrollability]

...
*/

if (Browser.Platform.ios) {
	Fx.Scrollability = new Class({

		Extends: Fx.Scroll,

		current: [0, 0],

		start: function(x, y){
			if (!this.check(x, y)) return this;
			return this.constructor.prototype.start.apply(this, [this.current, [-x, -y]]);
		},

		set: function(){
			var now = Array.flatten(arguments);
			scrollability.scrollTo(this.element, now[0], now[1]);
			this.current = now;
			return this;
		},

		compute: function(){
			return this.parent.apply(this, arguments);
		}

	});
} else {
	Fx.Scrollability = Fx.Scroll
}