Accessibility = new Class({
    Implements: [Options, Events],
    options: {
        button: {
            "active-aria-label" : "End accessible experience",
            "inactive-aria-label" : "Start accessible experience"
        }
    },
    initialize: function(options) {
        this.setOptions(options);
        var feedback = this.options.container.getElement(this.options.data.feedback),
            feedback_end_note = this.options.container.getElement(".header-feedback"),
            accessibility_button = new Element('button.accessibility.inactive', {"data-active": false, "tabindex": 0, "aria-label": this.options.button["inactive-aria-label"]}).inject(this.options.container, "top"),
            accessibility_status = new Element('div.note.status.accessibility').inject(this.options.container.getElement(".widget-header .notes")),
            accessibility_note = new Element('div.note.accessibility', {"role": "definition",tabindex:0}).inject(this.options.container.getElement(".widget-header .notes")),
            accessibility_instruction = new Element('div.instruction.accessibility', {html: "Select the correct answer."}).inject(this.options.container.getElement(".widget-body"), "top"),
            _this = this;

        if($("asyncVoiceEl")==null){
          var asyncVoiceEl = new Element('div');

          asyncVoiceEl.set("id","asyncVoiceEl").set("role","alert").set("aria-live","polite").setStyles({
            "clip":"rect(0px,0px,0px,0px)",
            "position": "absolute",
            "top":"-1000%",
            "left":"-1000%"
          });
          new Element('span').set("id","asyncVoiceEl-add").inject(asyncVoiceEl);
          asyncVoiceEl.inject(_this.options.container,'after');
          _this.options.container.addEvent("FireAsyncVoice",function(txt){
            _this.asyncVoice(txt);
          });
        }
        accessibility_button.addEvent("click", function() {    
            var is_active = (this.get("data-active") === "true");
            
            if(is_active){
                this
                    .set("tabindex", 0)
                    .set("aria-label", _this.options.button["inactive-aria-label"]);
                
                _this.options.container
                    .removeProperty("tabindex")
                    .removeProperty("aria-label")
                    .removeClass("Accessibility");
                _this.options.container
                    .getElements("[role='button']")
                        .removeProperty("role")
                        .removeProperty("tabindex");
                _this.options.container
                    .getElements("[aria-live='assertive']")
                        .removeProperty("aria-live");

                _this.options.container.fireEvent("AccessibilityStatusChange",false);
            }
            else{
                this
                    .set("tabindex", 0)
                    .set("aria-label", _this.options.button["active-aria-label"]);
                
                _this.options.container
                    //.set("tabindex", 0)
                    //.set("aria-label", "Interactive Widget")
                    .addClass("Accessibility");
            
                accessibility_status
                    .set("tabindex", 0)
                    .focus();
                setTimeout(function(){
                    accessibility_status
                        .removeProperty("tabindex")
                        //.set("aria-live", "assertive")
                    ;
                }, 1250);
                
                accessibility_instruction.set("aria-live", "assertive");
                feedback.set("aria-live", "assertive");
                feedback_end_note.set("aria-live", "assertive");
                accessibility_note.set("aria-live", "assertive");
                _this.options.container.getElement(".widget-body").focus();
                accessibility_note.focus();
                for(var i = 0; i < _this.options.data.elements.length; i++){
                    _this.options.container.getElements(_this.options.data.elements[i])
                        .each(function(obj, i){
                            obj
                                .set("role", "button")
                                .addEvent("keypress", function(e){
                                    if(e.code === 13 || e.code === 32)
                                        e.target.fireEvent("click");
                                });
                        });
                }

                _this.options.container.fireEvent("AccessibilityStatusChange",true);
            }
            this.set("data-active", !is_active);

        });
        
        this.options.container.getElement(".widget-header .notes .note.initial").set("tabindex", 0);
        for(var i = 0; i < this.options.data.elements.length; i++){
            this.options.container.getElements(this.options.data.elements[i])
                .each(function(obj, i){
                    obj
                        .set("tabindex", 0);
                });
        }

        this.options.container.fireEvent("AccessibilityButtonAdded",{});
    },
    render: function() {
    },
    asyncVoice:function(txt){
      elem1 = document.getElementById("asyncVoiceEl-add");
      //set role attribute on inner element
      elem1.setAttribute("role", "alert");
      elem1.setAttribute("aria-live", "polite");
      //change initial clip property to auto
      document.getElementById('asyncVoiceEl').style.clip='auto';
      // create and append the text node
      alertText = document.createTextNode(txt);
      elem1.appendChild(alertText);
      //toggle visibility from visible to hidden and back again
      elem1.style.visibility='hidden';
      elem1.style.visibility='visible';
    }
});