var SliderAccess = new Class({
    Implements: [Options, Events],
    Extends:AlternateSlider,
    currentStep:0,
    keyRight:"right",
    keyLeft:"left",
    keyUp:"up",
    keyDown:"down",
    options:{
      labels:null
    },
    initialize:function(parent,dragel,options){
        var _this = this;
        this.parent(parent,dragel,options);

        if(options.range!=null && options.range.length>0){
            _this.currentStep = options.range[0];
        }

        if(options.keyRight!=null){
          _this.keyRight = options.keyRight;
        }

        if(options.keyLeft!=null){
          _this.keyLeft = options.keyLeft;
        }

        if(options.keyUp!=null){
          _this.keyUp = options.keyUp;
        }

        if(options.keyDown!=null){
          _this.keyDown = options.keyDown;
        }

      if (options.labels != null) {

        switch ( typeOf(options.labels) ) {
          case "string":
          case "elements":
            var labels_items = $$(options.labels);
            this.options.labels = labels_items;
            this.options.labels.each(function(e,i){
              if(e.get("data-position")==null){
                 e.set("data-position",_this.options.labels.indexOf(e));
              }
              if(e.get("tabindex")==null || e.get("tabindex")<0){
                 e.set("tabindex",0);
              }
            });
            break;
          case "object":
            this.options.labels = new Array();
            Array.each(options.labels, function (e, i) {
              var item = $$(e.target);
              item.setProperty("data-position", e.position);
              _this.options.labels.push(item);
            });
            break;
        }

        if (_this.options.labels != null) {
          _this.options.labels.addEvent("click",function(e,i){
            _this.set(this.getProperty("data-position"));
           });

          _this.options.labels.addEvent("keypress",function(e,i){
            if(e.key=="enter" || e.key=="space")
              _this.set(this.getProperty("data-position"));
          });
        }
      }

        dragel.set("tabindex",0).set('aria-hidden','true');
        dragel.addEvent("keydown",function(e){



            var positive = null;
            if(e.key=="enter" || e.key=="space" || e.key==_this.keyRight || e.key==_this.keyUp){
                positive = true;
            }
            if(e.key==_this.keyLeft || e.key==_this.keyDown){
                positive = false;
            }

            if(positive!=null){
              if(_this.drag.value==null){
                if(_this.drag.value["now"]==null)_this.drag.value["now"] = new Array();
              }

              if(_this.axis=="x"){
                var cv = this.getStyle("left");
                cv = new Number(cv.replace("px",""));

                if((cv>0 && _this.step<_this.max) || (cv>0 && _this.step==_this.max && !positive) ||  (cv==0 && positive) ){

                  if(positive)cv+=10;
                  else cv-=10;

                  this.setStyle("left",cv);
                  _this.drag.value["now"][_this.axis]=cv;

                }
                else{
                  this.setStyle("left",cv);
                  _this.drag.value["now"][_this.axis]=cv;
                }
              }
              else{
                var cv = this.getStyle("top");
                cv = new Number(cv.replace("px",""));
                if((cv>0 && _this.step<_this.max) || (cv>0 && _this.step==_this.max && !positive) ||  (cv==0 && positive) ){

                  if(positive)cv++;
                  else cv--;

                  this.setStyle("top",cv);
                  _this.drag.value["now"][_this.axis]=cv;

                }
                else{
                  this.setStyle("left",cv);
                  _this.drag.value["now"][_this.axis]=cv;
                }
              }
              _this.draggedKnob();
            }
        });
    },
    set:function(value){
        this.parent(value);
        this.currentStep = value;
    }
});