var md = md || {};
md.widgets = md.widgets || {};
md.widgets.d3Charts = new Class({
    Implements: [Options, Events],

    data: null,

    options: {
        type: 'bar',
        data: [],
        'color-set': '1'
    },

    initialize: function(containerSelector, options){
        this.setOptions(options);
        this.options.container = document.body;
        this.containerSelector = containerSelector;

        var _this = this;

        this.margin = {top: 20, right: 20, bottom: 30, left: 55},
        this.width = this.options.width - this.margin.left - this.margin.right,
        this.height = this.options.height - this.margin.top - this.margin.bottom;

        this.update(options);
    },

    update: function(options) {
        this.setOptions(options);

        switch(this.options['color-set']) {
            case '1':
                this.colors = d3.scale.category20();
                break;
            case '2':
                this.colors = d3.scale.category20b();
                break;
            default:
                this.colors = d3.scale.category20c();
        }

        switch(this.options.type) {
            case 'dimplebar':
                this.renderDimpleBar();
                break;
            case 'bar':
                this.renderBar();
                break;
            case 'bar-percent':
                this.renderBarPercentage();
                break;
            case 'pie':
                this.renderPie();
                break;
            default:
        }
    },

    renderDimpleBar: function() {
        $$(this.containerSelector)[0].set('html', '');
        this.columnNames = Object.keys(this.options.data[0]);

        var svg = dimple.newSvg(this.containerSelector, 800, 600);
        var chart = new dimple.chart(svg, this.options.data);
        chart.addCategoryAxis("x", this.columnNames[0]);
        chart.addMeasureAxis("y", this.columnNames[1]);
        chart.addSeries(null, dimple.plot.bar);
        chart.draw();
    },

    renderBar: function() {
        var _this = this;

        this.x = d3.scale.ordinal()
            .rangeRoundBands([0, this.width], .1);

        this.y = d3.scale.linear()
            .range([this.height, 0]);

        this.xAxis = d3.svg.axis()
            .scale(this.x)
            .orient("bottom");

        var max = d3.max(this.options.data, function(d) { return +d["Digit Span"];} );
        this.yAxis = d3.svg.axis()
            .scale(this.y)
            .orient("left")
            .ticks(max)
            .tickFormat(d3.format(",.0f"));

        this.columnNames = Object.keys(this.options.data[0]);

        $$(_this.containerSelector)[0].set('html', '');
        _this.svg = d3.select(_this.containerSelector).append("svg")
            .attr("width", this.width + this.margin.left + this.margin.right)
            .attr("height", this.height + this.margin.top + this.margin.bottom)
            .append("g")
                .attr("transform", "translate(" + this.margin.left + "," + this.margin.top + ")");

        _this.x.domain(_this.options.data.map(function(d) { return d[_this.columnNames[0]]; }));
        _this.y.domain([0, d3.max(_this.options.data, function(d) { return d[_this.columnNames[1]]; })]);

        _this.svg.append("g")
            .attr("class", "x axis")
            .attr("transform", "translate(0," + _this.height + ")")
            .call(_this.xAxis)
        .append("text")
            .attr("x", 10)
            .attr("y", 17)
            .attr("dy", ".71em")
            .style("text-anchor", "end")
            .text(_this.options['label-x']);

        _this.svg.append("g")
            .attr("class", "y axis")
            .call(_this.yAxis)
        .append("text")
            .attr("transform", "rotate(-90)")
            .attr("y", -45)
            .attr("x", -100)
            .attr("dy", ".71em")
            .style("text-anchor", "end")
            .text(_this.options['label-y']);

        _this.svg.selectAll(".bar")
            .data(this.options.data)
        .enter().append("rect")
            .attr("class", "bar")
            .attr("x", function(d) { return _this.x(d[_this.columnNames[0]]); })
            .attr("width", _this.x.rangeBand())
            .attr("fill", function(d, i) { return _this.colors(i); })
            .attr("y", function(d) { return _this.y(d[_this.columnNames[1]]); })
            .attr("height", function(d) { return _this.height - _this.y(d[_this.columnNames[1]]); });
    },

    renderBarPercentage: function() {
        var _this = this;

        this.x = d3.scale.ordinal()
            .rangeRoundBands([0, this.width], .3);

        this.y = d3.scale.linear()
            .range([this.height, 0]);

        this.xAxis = d3.svg.axis()
            .scale(this.x)
            .orient("bottom");

        this.yAxis = d3.svg.axis()
            .scale(this.y)
            .orient("left")
            .tickValues([0, .25, .5, .75, 1])
            .tickFormat(d3.format(".0%"));

        this.columnNames = Object.keys(this.options.data[0]);

        $$(_this.containerSelector)[0].set('html', '');
        _this.svg = d3.select(_this.containerSelector).append("svg")
            .attr("width", this.width + this.margin.left + this.margin.right)
            .attr("height", this.height + this.margin.top + this.margin.bottom)
            .append("g")
                .attr("transform", "translate(" + this.margin.left + "," + this.margin.top + ")");

        _this.x.domain(_this.options.data.map(function(d) { return d[_this.columnNames[0]]; }));
        _this.y.domain([0, d3.max(_this.options.data, function(d) { return d[_this.columnNames[1]]; })]);

        _this.svg.append("g")
            .attr("class", "x axis")
            .attr("transform", "translate(0," + _this.height + ")")
            .call(_this.xAxis)
        .append("text")
            .attr("x", 10)
            .attr("y", 17)
            .attr("dy", ".71em")
            .style("text-anchor", "end")
            .text(_this.options['label-x']);

        _this.svg.append("g")
            .attr("class", "y axis")
            .call(_this.yAxis)
        .append("text")
            .attr("transform", "rotate(-90)")
            .attr("y", -55)
            .attr("x", -70)
            .attr("dy", ".71em")
            .style("text-anchor", "end")
            .text(_this.options['label-y']);

        _this.svg.selectAll(".bar")
            .data(this.options.data)
        .enter().append("rect")
            .attr("class", "bar")
            .attr("x", function(d) { return _this.x(d[_this.columnNames[0]]); })
            .attr("width", _this.x.rangeBand())
            .attr("fill", function(d, i) { return _this.colors(i); })
            .attr("y", function(d) { return _this.y(d[_this.columnNames[1]]); })
            .attr("height", function(d) { return _this.height - _this.y(d[_this.columnNames[1]]); });
    },

    renderPie: function() {
        var _this = this;

        $$(_this.containerSelector)[0].set('html', '');
        var w = _this.width,
        h = _this.height,
        r = h / 2 - _this.margin.top,
     
        data = _this.options.data;
        this.columnNames = Object.keys(this.options.data[0]);
        
        var vis = d3.select(_this.containerSelector)
            .append("svg:svg")
            .data([data])
                .attr("width", w)
                .attr("height", h)
            .append("svg:g")
                .attr("transform", "translate(" + (w / 2) + "," + (h / 2) + ")")
     
        var arc = d3.svg.arc()
            .outerRadius(r);
     
        var pie = d3.layout.pie()
            .value(function(d) { return d[_this.columnNames[1]]; });
     
        var arcs = vis.selectAll("g.slice")
            .data(pie)
            .enter()
                .append("svg:g")
                    .attr("class", "slice");
     
            arcs.append("svg:path")
                    .attr("fill", function(d, i) { return _this.colors(i); } )
                    .attr("d", arc);
     
            arcs.append("svg:text")
                    .attr("transform", function(d) {
                    d.innerRadius = 0;
                    d.outerRadius = r;
                    return "translate(" + arc.centroid(d) + ")";
                })
                .attr("text-anchor", "middle")
                .text(function(d, i) { return data[i][_this.columnNames[0]]; });
    }
});