/*
---

script: flashlog.js

description: Provides logging messages for iBooks

requires:
  - Core/DomReady
  - Core/Element.Event

provides: [flashlog]

...
*/

var flashlog = {};

window.onload = (function(){
	flashlog.logDiv = new Element('div', {
		id: 'log',
		styles: {
			backgroundColor: "#fff",
			border: "1px solid #000"
		},
		events: {
			click: function(){
				this.set('html', '');
			}
		}
	});
	if (Browser.Platform.ios) document.body.addClass('iOS');
});
var log = function(){
	new Element('div', {
		styles: {
			borderBottom: '3px solid #666'
		},
		html: Array.join(arguments, ' ')
	}).inject(flashlog.logDiv);
	flashlog.logDiv.inject(document.body);
};
flashlog.destroy = function() {
	if (flashlog.flashDiv){
		flashlog.flashDiv.destroy();
		delete flashlog.flashDiv;
	}
};
var flash = function(args, type){
	if (flashlog.flashDiv) flashlog.destroy();
	flashlog.flashDiv = new Element('div', {
		'class': 'alert-message flash'
	}).inject(document.body);
	flashlog.flashDiv.addClass(type);
	flashlog.flashDiv.show().innerHTML += '<p>' +  Array.join(args, ' ') + '</p>';
	clearTimeout(flashlog.flashTimer);
	flashlog.flashTimer = destroy.delay(3000);
};
['error', 'success', 'info', 'warning'].each(function(type){
	flash[type] = function(){
		flash(arguments, type);
	};
});
