MetrodigiWidget = new Class({
    Implements: [Options, Events],

    options: {
    },

    // initialize - widget initialization
    initialize: function(options) {
		this.setOptions(options);
        this.container = this.options.container;
        this.body = this.container.getElement('.widget-body');
		this.currentSlide = this.options.currentSlide;

        this.createDOM();
        this.insertActionText();
        this.clickEvent = this.isTouchDevice() ? 'touchstart' : 'click';

    },

    createDOM: function() {
    },

    isTouchDevice: function() {
        return !!('ontouchstart' in window);
    },

    // insertActionText - check for touch device and sets tab/click to
    // .responsive-call-to-action elements
    insertActionText: function() {
        for(i = 0; i < this.container.getElements('.responsive-call-to-action').length; i++){
            text = this.container.getElements('.responsive-call-to-action')[i].get('html');

						word = this.checkCasing(text);

            this.container.getElements('.responsive-call-to-action')[i].set('html', word);
        }
    },

		checkCasing : function(text){
				character = text[0];
				var word = this.isTouchDevice() ? 'tap' : 'click';
				if (character === character.toUpperCase()) {
						word = word.charAt(0).toUpperCase() + word.slice(1);
				}
				return word;
		},

    getFeedback: function(correct_answers, total_answers) {
        return 'You correctly answered ' + correct_answers + ' of ' + total_answers + ' questions.';
    },

		// Reset the whole widget
    reset: function() {
        this.currentSlide = 1;
        this.render();
        this.container.set("data-restarted", true);
    },


    next: function() {
        this.currentSlide = this.nextSlide;
        this.render();
    },

    // Previous slide
    previous: function() {
		this.currentSlide = this.prevSlide;
		this.render();
    },


    render: function() {
		var slide;

		slide = this.options.container.getElement('article.slide-' + this.currentSlide);

		if(slide != null){
				this.nextSlide = slide.get('data-next-slide');
				this.prevSlide = slide.get('data-prev-slide');
				$$('.active').removeClass('active');
				$$('.slide-' + this.currentSlide).addClass('active');
		}
    }
});
