/**
 * @class MetrodigiWidgetEditable
 *
 * This class contains all the necesary methods to enable
 * the widget editable functionality. For development class
 * MetrodigiWidget should extend from this class to inheritate
 * these methods. For production this can be skipped.
 *
 */
MetrodigiWidgetEditable = new Class({
    Implements: [Options, Events],
    root: "/Pearson/pearson-portal/",
    isEditMode: false,
    assets: [],
    initializated:false,
    /*
     * Initializes the editable widget
     * @param {Array} options
     */
    initialize: function (options) {
        var _this = this;

        // Merge the default options of the Class with the options passed in
        this.setOptions(options);

        // Parse URL parameters
        this.isEditMode = this.getURLParameter('mdedit') ? true : false;
        this.root = this.getURLParameter('docRoot') || this.root;

        // Enable edit mode
        if (this.isEditMode) {
            // set widget id
            var widget_id = _this.getURLParameter('widget_id');
            if (widget_id) {
                _this.widget_id = widget_id;
            }

            // Load the necessary assets to enable edit mode
            this.loadAssets(this.assets, function () {
                if(!_this.initializated){
                    // Listen for messages from the portal
                    _this.listenPostMessages();

                    // Get widget data
                    _this.sendPostMessages('get-widget-data');


                    // Parse reusable editable elements
                    _this.parseElements();

                    // Enable custom edit mode funtionality
                    _this.bindEditMode();

                    // set basic md-edit-mode class
                    $$('body')[0].addClass('md-edit-mode');

                    _this.initializated = true;

                    _this.afterInitialize.call(_this);

                    // Get widget data
                    _this.sendPostMessages('widget-initialized');
                }


            });

            if (typeof options.extra !== 'undefined') {
                this.sendWidgetOptions(options.extra);
            } else {
                this.sendWidgetOptions();
            }
        }
        else {

            this.loadAssets(this.assets, function () {
                if(!_this.initializated){
                    _this.listenPostMessages();
                    _this.afterAssetsLoad();
                    _this.initializated = true;
                    _this.afterInitialize.call(_this);
                }
            });
        }
        this.accessibility(null, {visuallyHide: options.visuallyHideLongStatic});
        if(!options.preventCleanDomForPearsonAccessibility){
            this.cleanDomForPearsonAccessibility();
        }

        _this.beforeInitMediumEditor.call(_this);
    },

    afterInitialize: function(){},

    /*
     *
     * Event fired after assets were loaded and is non-edit mode
     */
    afterAssetsLoad: function () {
    },

    /*
     *
     * Reads accessibility_data json and adds it to the elements of  the DOM
     */
    // accessibility: function () {
    //     var _this = this;
    //     if(window.event.type === "load"){
    //         window.addEvent('domready', function () {
    //             _this.accessibilityAltSearch();
    //             _this.accessibilityIndex();
    //         });
    //     }
    //     else{
    //         window.addEvent('load', function () {
    //             _this.accessibilityAltSearch();
    //             _this.accessibilityIndex();
    //         });
    //     }
    // },

    // Per Pearson Request , so widgets work in Firefox
    accessibility: function (e, options) {
        var _this = this;
        try {
            accessibility_data.images.each(function (image, i) {
                if (!image.altLong) image.altLong = '';
                if (!image.alt) image.alt = '';
            });
        } catch (e) {}
        var evt = e || window.event;
        if(evt === "load"){
            window.addEvent('domready', function () {
                _this.accessibilityAltSearch();
                _this.accessibilityIndex(options);
            });
        }
        else{
            window.addEvent('load', function () {
                _this.accessibilityAltSearch();
                _this.accessibilityIndex(options);
            });
        }
    },
    accessibilityAltSearch: function(){
        var _this = this;
        if (typeof accessibility_data !== 'undefined') {
            // Images
            if (typeof accessibility_data.images !== 'undefined') {
                var images = $$('img');
                var iframes = $$('iframe');
                Array.each(accessibility_data.images, function (item, itemIdx) {
                    Array.each(images, function(image){
                        var src = image.get('src');
                        var className = image.get('class');
                        var n = src.lastIndexOf('/');
                        var final_src = src.substring(n + 1);
                        if (final_src === item.src && className != 'image-feedback-hidden') {
                            image.set('alt', item.alt);

                            var longStaticItemId = "longstatic-"+ itemIdx;

                            if($$('#' + longStaticItemId).length) longStaticItemId+='D';
                            image.set('aria-describedby', longStaticItemId);
                            image.insertAdjacentHTML('afterend', '<p id="'+ longStaticItemId +'" class="visually-hidden">'+ item.altLong +'</p>');
                            return false;
                        }else if(className == 'image-feedback-hidden'){
                            image.set('data-alt', item.alt);
                            image.set('data-longText', item.altLong);
                            return false;
                        }
                        if (className == 'tinymce-image') {
                            var name = image.get('data-name');
                            if (name == item.src) {
                                image.set('alt', item.alt);
                                //image.set('aria-describedby', 'longstatic-'+itemIdx);
                                image.insertAdjacentHTML('afterend', '<p id="longstatic-'+itemIdx+'" style="position:absolute;left:-1000%;left:-1000vw;max-width:1px;max-height:1px;overflow: hidden;">'+ item.altLong +'</p>');
                            }
                        }
                    });

                    Array.each(iframes, function(iframe){
                        var src = iframe.get('src');                        
                        if (src !== null && src.lastIndexOf !== undefined){

                            var n = src.lastIndexOf('/');
                            var final_src = src.substring(n + 1);
                            if (final_src === item.src) {
                                iframe.set('aria-label', item.alt);
    
                                var longStaticItemId = "longstatic-"+ itemIdx;
    
                                if($$('#' + longStaticItemId).length) longStaticItemId+='D';
                                iframe.set('aria-describedby', longStaticItemId);
                                iframe.insertAdjacentHTML('afterend', '<p id="'+ longStaticItemId +'" class="visually-hidden">'+ item.altLong +'</p>');
                                return false;
                            }
                        }

                    });
                });
            }
        }
        if (_this.isEditMode) {
            _this.sendPostMessages('access-ready');
        }
    },

    accessibilityIndex: function(options) {

        var _this = this;
        if (typeof accessibility_index !== 'undefined'){
            if (typeof accessibility_index.descriptions[0].longdesc != 'undefined' && accessibility_index.descriptions[0].longdesc != '' ){
                if ($$('#longdesc').length == 0){
                    var divLongDescription = new Element('p#longdesc', {
                        html: accessibility_index.descriptions[0].longdesc,
                        styles: (options.visuallyHide ? null : {display: 'none'}),
                        class: (options.visuallyHide ? 'visually-hidden' : null)
                    });
                    divLongDescription.inject($$('.MetrodigiWidget')[0], 'top');
                }
            }
        }
    },
    /*
     * Gets a specified parameter from the URL
     * @param {String} name
     */
    getURLParameter: function (name) {
        name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)");
        var results = regex.exec(window.location.href);

        if (results == null)
            return null;
        else
            return results[1];
    },
    /*
     * Searches for reusable editable elements and
     * parses them
     */
    parseElements: function () {
        var _this = this;

        // Start intro-line element
        this.saveTimer = null;
        if ($$('.MetrodigiWidget #intro-line').length > 0) {
            $$('.MetrodigiWidget #intro-line')[0]
                    .set('contenteditable', 'true')
                    .set('data-md-editable', 'md-content-editable')
                    .addEvent('input', function (e) {
                        clearTimeout(_this.saveTimer);
                        _this.saveTimer = setTimeout(function () {
                            _this.saveRequest({
                                method: 'setHTML',
                                selector: '#intro-line',
                                html: $('intro-line').get('html')
                            });
                        }, 1000);
                    });
            setTimeout(function () {
                parent.postMessage({
                    method: 'toggle-checkbox',
                    selector: '#intro-line-input'
                }, "*");
            }, 700);
        }
        // End intro-line element

        // Define reusable editable elements
        // ...


        // Parse custom editable elements
        this.parseCustomElements();
    },
    /*
     * Searches for reusable editable elements and
     * parses them
     */
    parseCustomElements: function () {
        /*
         * This is just a function specification,
         * each widget instance has to redefine this function.
         */
    },
    /*
     * Loads dinamically the required assets for this element
     * @param {Array} assets
     * @param {Function} callback
     */
    loadAssets: function (assets, callback) {
        callback = callback || function () {
        };

        var imagesArray = new Array();
        var total = assets.length;
        var cont = 0;
        var onLoad = function () {
            if (++cont == total)
                callback();
        };

        if (total) {
            assets.each(function (e, i) {
                if (typeof (e) == "string")
                    e = {source: e};

                if (e.source.indexOf(".png") > 0 || e.source.indexOf(".gif") > 0 || e.source.indexOf(".jpg") > 0 || e.source.indexOf(".jpeg") > 0) {
                    imagesArray.push(e.source);
                }

                if (e.source.indexOf(".js") > 0) {
                    var extra = e.extra || {};
                    extra.onLoad = onLoad;
                    Asset.javascript(e.source, extra);
                }

                if (e.source.indexOf(".css") > 0) {
                    var extra = e.extra || {};
                    extra.onLoad = onLoad;
                    Asset.css(e.source, extra);
                }
            });

            if (imagesArray.length > 0) {
                Asset.images(imagesArray, {
                    onLoad: onLoad
                });
            }
        } else {
            callback();
        }
    },
    /*
     * Listens to messages sent from the portal
     */
    listenPostMessages: function () {
        var _this = this;
        window.addEventListener("message", function (message) {
            switch (message.data.method) {
                case "get-widget-data":
                    _this.widget_id = message.data.widget_id;
                    break;
                case "change-display-mode":
                    $$(message.data.element).set("md-data-display-mode", message.data.mode);
                    break;
                case "toggleHTML":
                    var prepend = false;
                    if (typeof message.data.prepend !== 'undefined') {
                        prepend = message.data.prepend;
                    }
                    _this.saveRequest({
                        method: "toggleHTML",
                        selector: message.data.wrapper,
                        elementID: message.data.elementID,
                        toggle: "" + message.data.value,
                        prepend: prepend
                    }, function () {
                        document.location.reload();
                    });
                    break;
                // default:
                //     console.warn('Unknown md-widget message', message, message.data);
            }

            if( typeof message.data.method != 'undefined' && message.data.method == 'async-inline-message-reload' ){
                debugger;
                document.location.reload();
                return;
            }
            //console.log(message);
            //console.log(message.type);
            //console.log(message.data.method);
            if( typeof message.data.method == 'undefined' || message.data.method != 'async-inline-message' ){
                _this.customPostMessages(message);
            } else {
                _this.asyncInlinePostMessages(message, message.data.data ? message.data.data : {} );
            }
        });
    },
    reportAsyncInlinePostMessages: function (data, should_reload) {
        parent.postMessage({
            method: 'async-inline-message',
            data: data
        }, "*");

        if( should_reload ){
            document.location.reload();
        }
    },
    /*
     * Defines new custom cases for messages sent from the portal
     */
    customPostMessages: function (message) {
        /*
         * This is just a function specification,
         * each widget instance has to redefine this function.
         */
    },

    asyncInlinePostMessages: function ( message ){

    },
    /*
     * Sends post message to the portal to notify that the widget is focused
     */
    notifyFocusCapture: function () {
        if (parent && parent != window) {
            this.sendPostMessages('widget-capture-focus');
        }
    },
    /*
     * Send widget options defined in the HTML
     */
    sendWidgetOptions: function (extra) {
        if (parent && parent != window) {
            var _this = this;
            this.readRequest(function (data) {
                var options = {
                    'data-xml-type': _this.container.get('data-xml-type'),
                    'widget-data': data
                };
                if (typeof extra !== 'undefined') {
                    Array.each(extra, function (item) {
                        options[item] = _this.container.get(item);
                    });
                }
                _this.sendPostMessages('widget-options', {
                    options: options
                });
                ;
            });
        }
    },
    /*
     * Sends message to the portal
     * @param {String} method
     * @param {Array} options
     */
    sendPostMessages: function (method, options) {
        params = {method: method}
        for (var attrname in options) {
            params[attrname] = options[attrname];
        }

        parent.postMessage(params, "*");
    },
    /*
     * Saves changes to the html file
     * @param {Object} request
     * @param {Function} callback
     */
    saveRequest: function (request, callback) {
        callback = callback || function () {
        };
        request.path = '';

        if (typeof request !== "string") {
            request = JSON.stringify(request);
        }
        console.log('REQUEST');
        console.log(request);
        var formData = new FormData();
        formData.append('savedata', request);
        formData.append('widget_id', this.widget_id);
        var xhr = new XMLHttpRequest();

        xhr.open('POST', this.root + 'api/index.php/save/');
        xhr.onload = function () {
            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                callback(response);
            } else {
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },
    /*
     * Reads the json data from the selector #md-widget-data
     * @param {Function} callback
     */

    readRequest: function (callback) {
        callback = callback || function () {
        };
        var xhr = new XMLHttpRequest();
        xhr.onload = function () {
            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                callback(response);
            }
        };
        xhr.open('GET', this.root + 'api/index.php/save?object_result=true&widget_id=' + this.widget_id);
        xhr.send(null);
    },
    /*
     * Enables custom edit mode funtionality
     */
    bindEditMode: function () {
        /*
         * This is just a function specification,
         * each widget instance has to redefine this function.
         */
    },

    /**
     * Check if the current widget should
     * initialize the medium editor
     */
    beforeInitMediumEditor: function () {
        var widgetXmlTypes = [
            /* AdvancedFlashcards */'TF',
            /* LineReader */'list-text',
            /* InteractiveMap */'toggle', 'timeline', 'comparative',
        ];

        var widgetTypes = [
            /* ImageOverlay */'imageOverlay',
            /* MultiviewTimeline */'timeline',
            /* WeightedAdaptiveScenario */'weightedAdaptiveScenarios',
        ];

        var widgetXmlType = $$('#MetrodigiWidget').length > 0 ? $$('#MetrodigiWidget')[0].get('data-xml-type') : null;
        var widgetType = document.widgetType;

        if (widgetXmlTypes.indexOf(widgetXmlType) >= 0 || widgetTypes.indexOf(widgetType) >= 0) {
            this.initMediumEditor();
        }
    },

    /**
     * Loads required assets, then initialize the medium editor.
     */
    initMediumEditor: function () {
        var isEditMode = this.getURLParameter('mdedit') ? true : false;

        (new Element('style', {
            type: 'text/css',
            html: 'body[medium-editor="true"] #intro-line {font-family: "HelveticaNeueETW01", sans-serif !important;}'
        })).inject($$('head')[0]);

        if (!isEditMode) return;

        var mediumCSS = Asset.css('../_framework/weditor/weditor.css');
        var mediumScript = Asset.javascript('../_framework/weditor/weditor.js', {
            onLoad: afterLoadMediumScript
        });

        function afterLoadMediumScript () {
            new Weditor(undefined, {
                wrapperSelector: '#intro-line[contenteditable="true"]'
            });
            console.log('medium editor initialized');
        }
    }
});




/**
 * @class MetrodigiWidget
 *
 * This class contains all the necesary methods to start a new
 * widget-type. It extends from MetrodigiWidgetEditable to inheritate
 * the edditable methods for the widget.
 *
 * All custom widget classes should extend from this class.
 *
 */
MetrodigiWidget = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidgetEditable,
    options: {
    },
    /*
     * Initializes the widget
     * @param {Array} options
     */
    initialize: function (options) {
        // Merge the default options of the Class with the options passed in
        this.setOptions(options);

        // Get widget structure elements
        this.getWidgetStructure();

        // Create the Dom
        this.createDOM();

        // Determines the clickEvent depending the device
        this.clickEvent = this.isTouchDevice() ? 'touchstart' : 'click';

        // Replace "click" for "touch" on touch devices
        this.insertActionText();

        // Set touch-device attribute to true on touch devices
        if (this.isTouchDevice()) {
            $$("body").set("touch-device", "true");
        }

        // Remove the blue outline on focus
        this.removeBlueFocusOutline();

        // Call parent MetrodigiWidgetEditable
        this.parent(this.options);

        // Render the widget
        this.render();

        this.buildHotspots();
    },
    /*
     * Gets widget structure elements
     */
    getWidgetStructure: function () {
        this.container = this.options.container;
        this.header = this.container.getElement('.widget-header');
        this.body = this.container.getElement('.widget-body');
        this.footer = this.container.getElement('.widget-footer');
    },
    /*
     * Checks if widget is running on a touch device
     */
    isTouchDevice: function () {
        return !!('ontouchstart' in window);
    },
    /*
     * Removes the blue outline on focus
     */
    removeBlueFocusOutline: function () {
        window.addEvent('domready', function () {
            (new Element('style', {
                type: 'text/css',
                html: '*:active,*:focus{outline:none;}*:active.non-keyboard-outline,*:focus.non-keyboard-outline{outline:rgba(125,173,217,0.4) solid 2px;box-shadow:0 0 6px rgb(125,173,217);}'
            })).inject($$('head')[0]);

            window.lastKey = new Date();
            window.lastClick = new Date();
            document.addEvent('focusin', function (e) {
                $$(".non-keyboard-outline").removeClass("non-keyboard-outline");
                var wasByKeyboard = lastClick < lastKey;
                if (wasByKeyboard) {
                    e.target.addClass("non-keyboard-outline");
                }
            });
            document.addEvent('click', function () {
                window.lastClick = new Date();
            });
            document.addEvent('keydown', function () {
                window.lastKey = new Date();
            });
        });
    },
    /*
     * Checks if the widget is runing on a touch device
     * and sets tab/click to .responsive-call-to-action elements
     */
    insertActionText: function () {
        this.container.getElements('.responsive-call-to-action').each(function (element) {
            var word = this.isTouchDevice() ? 'tap' : 'click';
            var character = element.get('html').charAt(0);

            if (character === character.toUpperCase())
                word = word.charAt(0).toUpperCase() + word.slice(1);

            element.set('html', word);
        }, this);
    },
    /*
     * Builds widget's DOM
     */
    createDOM: function () {
        /*
         * This is just a function specification,
         * each widget instance has to redefine this function.
         */

    },
    /*
     * Renders the Hotspots (EDIT-78)
     */
    buildHotspots: function () {
        if (this.options.hotspots && this.options.hotspots.length > 0) {
            var _this = this;

            this.infoWrapper = new Element('div#infoWrapper');

            if ($$('.map')[0]) {
                this.infoWrapper.inject($$('.map')[0]);
            }
            else {
                this.infoWrapper.inject($$(this.container)[0]);
            }

            this.options.hotspots.each(function (popup, i) {
                position = '';

                if (typeof popup.position != 'undefined') {
                    position = popup.position;
                }

                img = new Element('button', {
                    'type': 'image',
                    'src': '../_base_pearson/images/info.png',
                    'class': 'icon-info info-' + i,
                    'data-info': 'info-' + i,
                    'aria-label': "Map callout: " + popup.text
                }).inject(_this.infoWrapper);

                popup.x = popup.x * 1;
                popup.y = popup.y * 1;

                img.setStyle('top', popup.y);
                img.setStyle('left', popup.x);

                text = new Element('span', {
                    html: popup.text,
                    'tabindex': 0,
                    'class': 'popup txt hidden info-' + i,
                    'data-info': 'info-' + i,
                    'data-position': position,
                }).inject(_this.infoWrapper);


                if (position == 'left') {
                    text.setStyle('top', popup.y + -35);
                    text.setStyle('left', popup.x - 205);

                } else if (position == 'top') {
                    text.setStyle('top', popup.y - 140);
                    text.setStyle('left', popup.x - 78);

                }
                else {
                    text.setStyle('top', popup.y + 40);
                    text.setStyle('left', popup.x - 78);

                }
            });

            $(document.body).addEvent('click', function (e) {
                if (!$(e.target).hasClass("icon-info")) {
                    $$('body span.popup').addClass('hidden');
                }
            });

            $$('body .icon-info').addEvent('click', function (e, i) {

                if ($$('body span.' + this.getAttribute('data-info'))[0].hasClass("hidden")) {
                    $$('body span.popup').addClass('hidden');
                    $$('body span.' + this.getAttribute('data-info')).removeClass('hidden');
                    //$$('body span.' + this.getAttribute('data-info'))[0].focus();
                }
                else {

                    $$('body span.popup').addClass('hidden');
                }

            });
        }
    },

    detectContentEditableEditorPanelElements:function(){
        if($$('div.editable-element-panel[contenteditable="true"]:not(.detection-binded)').length>0){
            var _this = this;
            var _window = window;
            if(_this.detection_interval_id==null){
                _this.detection_interval_id = setInterval(function () {
                    var selection = window.getSelection(),
                            range = new Object();
                    range.collapsed = true;
                    var is_editable_panel_element = false;
                    try {

                        var sel_wrapper = $$(selection.baseNode.parentNode).getParent('div.editable-element-panel[contenteditable="true"]')[0];

                        if(sel_wrapper == null){
                            var attrib = $$(selection.baseNode.parentNode).get('contenteditable')[0];
                            if(attrib == null || attrib == false || attrib == 'false')
                                return;
                            if(!$$(selection.baseNode.parentNode)[0].hasClass('editable-element-panel')){
                                return;
                            }

                            sel_wrapper = $$(selection.baseNode.parentNode)[0];
                        }

                        if(_window =! _window.parent && !sel_wrapper.hasClass("focused")){
                            //console.log( $$(selection.baseNode).get("html") );
                            sel_wrapper.addClass("focused");

                            console.log(selection, $$(selection.baseNode));

                            var element = "";
                            if(selection.baseNode.nodeType==3){
                                element = selection.baseNode.nodeValue;
                            }
                            else{
                                element = new Element("div");
                                element.adopt($$(selection.baseNode)[0].clone());
                                element = element.get("html");
                            }

                            var parent_element = null;
                            parent_element = $$(selection.baseNode.parentNode)[0];


                            while(parent_element!=null && !parent_element.getParent().hasClass("editable-element-panel")){
                                parent_element = parent_element.getParent();
                            }

                            //console.log(parent_element, $$(selection.baseNode.parentNode));

                            parent_element_wrapper = new Element("div");
                            parent_element_wrapper.adopt(parent_element.clone());
                            //console.log(parent_element.get("html"));

                            _this.sendPostMessages("toggle-editor-panel",{
                                active: true,
                                el: element,
                                parent: parent_element_wrapper.get("html")//$$(selection.baseNode.parentNode).clone()
                            });
                        }
                    } catch (e) {
                        //console.log (e);
                    }


                }, 50);
            }

            $$('div.editable-element-panel[contenteditable="true"]').addEvent("blur",function(e){
                if(_window =! _window.parent){
                    e.target.removeClass("focused");
                    _this.sendPostMessages("toggle-editor-panel",{
                        active: false
                    });
                }
            });

            $$('div.editable-element-panel[contenteditable="true"]').addClass("detection-binded");
        }
    },
    render: function () {
        /*
         * This is just a function specification,
         * each widget instance has to redefine this function.
         */
    },

    getBookPath:function(pattern){
        var pathUpload = location.href;
        if (pathUpload.indexOf("?") > 0) {
            pathUpload = pathUpload.split("?")[0];
        }

        pathUpload = pathUpload.substr(pathUpload.indexOf(pattern)).split('/');
        pathUpload = pathUpload.splice(1, pathUpload.length - 2).join('/');

        return pathUpload;
    },

    cleanDomForPearsonAccessibility: function(){
        if ( $$('.MetrodigiWidget.container').length > 0 ){
            var propertiesToRemove = [
                'title',
                'aria-describedby'
            ];
            $$('.MetrodigiWidget.container').forEach( function (container) {
                propertiesToRemove.forEach( function(property) {
                    container.removeProperty(property);
                });
            });
        }
    },

    /**
     * Utility function, clear timers on window blur,
     * user interaction and every new call.
     * LLama el cb si el iframe esta con foco o lo llamará
     * cuando la ventana tenga el foco
     * [TODO: update description]
     * @param  {Function}  cb
     */
    clearTimersOnUserInteraction: function (cb) {
        var _this = this;

        if (!this._runCallbackEvent) {
            // create custom event
            this._runCallbackEvent = document.createEvent('Event');
            this._runCallbackEvent.initEvent('runcallback', true, true);
        }

        if (!this._timerList) {
            this._timerList = [];
        }

        // clear previus clearTimersOnUserInteraction
        onUserInteraction();

        window.addEventListener('focus', runCallback, false);
        document.addEventListener('runcallback', beforeRunCb, false);
        runCallback();

        function runCallback () {
            if (document.hasFocus()) {
                window.removeEventListener('focus', runCallback, false);
                document.dispatchEvent(_this._runCallbackEvent);
              }
        }

        function beforeRunCb () {
            document.removeEventListener('runcallback', beforeRunCb, false);

            // add your setTimeout/setInterval to timers
            cb(_this._timerList);

            setTimeout(function () {
                window.addEventListener('touchstart', onUserInteraction, false);
                window.addEventListener('click', onUserInteraction, false);
                window.addEventListener('keydown', onUserInteraction, false);
                window.addEventListener('blur', onUserInteraction, false);
            }, 100);
        }

        function onUserInteraction () {
            window.removeEventListener('touchstart', onUserInteraction, false);
            window.removeEventListener('click', onUserInteraction, false);
            window.removeEventListener('keydown', onUserInteraction, false);
            window.removeEventListener('blur', onUserInteraction, false);

            clearTimers();
        }

        function clearTimers () {
            var timersLength = _this._timerList.length;
            for (var i = 0; i < timersLength; i++) {
                clearTimeout(_this._timerList[i]);
            }
            _this._timerList = [];
        }
    }
});
