MetrodigiWidget = new Class({
    Implements            : [Options, Events],
    root                  : "/Pearson/pearson-portal/",
    booksRoot             : null,
    isEditMode            : null,
    changeTrackingEnabled : false,
    options               : {},
    assets                : [],
    initializated         : false,
    mementoQueue          : [],
    requestWorking        : false,
    // initialize - widget initialization
    initialize: function(options) {
        var that = this;

        var widget_id = that.getURLParameter('widget_id');
        if (widget_id) {
            that.widget_id = widget_id;
        }
        
        this.setOptions(options);

        if( this.assets.length > 0 ){
            this.loadAssets(this.assets, _intialize_procedure.bind(this) );    
        } else {
            _intialize_procedure.call(this);
        }
        
        function _intialize_procedure(){ 
            this.paramsParse();


            this.container = this.options.container;
            this.body = this.container.getElement('.widget-body')!=null?this.container.getElement('.widget-body'):null;
            this.currentSlide = this.options.currentSlide;

            this.createDOM();
            this.insertActionText();

            this.clickEvent = this.isTouchDevice() ? 'touchstart' : 'click';

            if (this.getURLParameter('mdedit')) {

                this.checkForRequire();

                if(this.require==null || this.require.length==0){
                    this.bindEditMode();
                    this.editMode();
                    this.bindEditModeAfterTagParse();
                    this.detectContentEditableEditorPanelElements();
                }
                else{
                    this.requireAssets(this.require,function(){
                        that.bindEditMode();
                        that.editMode();
                        that.bindEditModeAfterTagParse();
                        that.detectContentEditableEditorPanelElements();
                    });
                }
            }
            else{
                this.receivePreviewMessages();
                that.afterInitialize();
            }

            if(this.isTouchDevice()){
              $$("body").set("touch-device", "true");
            }

            if (this.isEditMode) {
                this.bindDefaultEditables();
            }

            this.removeBlueFocusOutline();

            this.accessibility();

            if( this.assets.length > 0 )
                this.afterAssetsLoaded.call(this);
        }

        this.cleanDomForPearsonAccessibility();
    },
    afterAssetsLoaded: function(){
    },
    /*
     * Loads dinamically the required assets for this element
     * @param {Array} assets
     * @param {Function} callback
     */
    loadAssets: function (assets, callback) {
        callback = callback || function () {
        };

        var done;
        var imagesArray = new Array();
        var total = assets.length;
        var cont = 0;
        var onLoad = function () {
            if (++cont == total && !done) {
                done = true;
                callback();
            }
        };

        setTimeout(function () {
            // ensure callback call
            if (!done) {
                done = true;
                callback();
            }
        }, 3000)

        if (total) {
            assets.each(function (e, i) {
                if (typeof (e) == "string")
                    e = {source: e};

                if (e.source.indexOf(".png") > 0 || e.source.indexOf(".gif") > 0 || e.source.indexOf(".jpg") > 0 || e.source.indexOf(".jpeg") > 0) {
                    imagesArray.push(e.source);
                }

                if (e.source.indexOf(".js") > 0) {
                    var extra = e.extra || {};
                    extra.onLoad = onLoad;
                    Asset.javascript(e.source, extra);
                }

                if (e.source.indexOf(".css") > 0 || e.source.indexOf(".ttf") > 0 || e.source.indexOf(".eot") > 0 || e.source.indexOf(".woff") > 0) {
                    var extra = e.extra || {};
                    extra.onLoad = onLoad;
                    Asset.css(e.source, extra);
                }
            });

            if (imagesArray.length > 0) {
                Asset.images(imagesArray, {
                    onLoad: onLoad
                });
            }
        } else {
            done = true;
            callback();
        }
    },
    /*
     *
     * Reads accessibility_data json and adds it to the elements of  the DOM
     */
    accessibility: function (e) {
        var _this = this;
        try {
            accessibility_data.images.each(function (image, i) {
                if (!image.altLong) image.altLong = '';
                if (!image.alt) image.alt = '';
            });
        } catch (e) {}
        var evt = e || window.event;
        if(evt === "load"){
            window.addEvent('domready', function () {
                _this.accessibilityAltSearch();
                _this.accessibilityIndex();
            });
        }
        else{
            window.addEvent('load', function () {
                _this.accessibilityAltSearch();
                _this.accessibilityIndex();
            });
        }
    },

    accessibilityAltSearch: function () {
        if (typeof accessibility_data !== 'undefined') {
            // Images
            if (typeof accessibility_data.images !== 'undefined') {
                var images = $$('img');
                Array.each(accessibility_data.images, function (item, itemIdx) {
                    Array.each(images, function(image){
                        var src = image.get('src');
                        var name = image.get('data-name');
                        var n = src.lastIndexOf('/');
                        var final_src = src.substring(n + 1);
                        if (final_src === item.src || name === item.src) {
                            image.set('alt', item.alt);
                            image.set('aria-describedby', 'longstatic-'+itemIdx);
                            image.insertAdjacentHTML('afterend', '<p id="longstatic-'+itemIdx+'" class="visually-hidden">'+ item.altLong +'</p>');
                            return false;
                        }
                    });
                });
            }
        }
    },

    accessibilityIndex: function() {

        var _this = this;

        if (typeof accessibility_index !== 'undefined'){
            if (typeof accessibility_index.descriptions[0].longdesc != 'undefined' && accessibility_index.descriptions[0].longdesc != '' ){
                if ($$('#longdesc').length == 0){
                    var divLongDescription = new Element('p#longdesc', {
                        html: accessibility_index.descriptions[0].longdesc,
                        styles: {
                            display: 'none'
                        }
                    });
                    divLongDescription.inject($$('.MetrodigiWidget')[0], 'top');
                }
            }
        }
    },
    /*
     * Sends message to the portal
     * @param {String} method
     * @param {Array} options
     */
    sendPostMessages: function (method, options) {
        params = {method: method}
        for (var attrname in options) {
            params[attrname] = options[attrname];
        }

        parent.postMessage(params, "*");
    },
    paramsParse:function(){
        if (this.getURLParameter('mdedit')) {
            this.isEditMode = true;
        }
        else{
            this.isEditMode = false;
        }

        if (this.options.docRoot) {
            this.root = options.docRoot;
        }

        if (this.getURLParameter('docRoot')) {
            this.root = this.getURLParameter('docRoot');
        }

        if (this.getURLParameter('widgetRoot')) {
            this.widgetRoot = this.getURLParameter('widgetRoot');
        }

        if (this.getURLParameter('booksRoot')) {
            this.booksRoot = this.getURLParameter('booksRoot');
        }
    },
    afterInitialize: function() {

    },
    bindDefaultEditables: function() {
        var that = this;
        this.saveTimer = null;
        if ($$('.MetrodigiWidget #intro-line').length > 0) {
            $$('.MetrodigiWidget #intro-line')[0]
                .set('contenteditable', 'true')
                .set('data-md-editable', 'md-content-editable')
                .addEvent('input', function(e) {
                    clearTimeout(that.saveTimer);
                    that.saveTimer = setTimeout(function() {
                        that.saveRequest({
                            method: 'setHTML',
                            selector: '#intro-line',
                            html: $('intro-line').get('html')
                        }, true);
                    }, 1000);
                });
            setTimeout(function() {
                parent.postMessage({
                    method: 'toggle-checkbox',
                    selector: '#intro-line-input'
                }, "*");
            }, 700);
        }
    },
    removeBlueFocusOutline: function() {
        window.onload = (function() {
            (new Element('style', {
                type: 'text/css',
                html: '*:active,*:focus{outline:none;}*:active.non-keyboard-outline,*:focus.non-keyboard-outline{outline:rgba(125,173,217,0.4) solid 2px;box-shadow:0 0 6px rgb(125,173,217);}'
            })).inject($$('head')[0]);

            window.lastKey = new Date();
            window.lastClick = new Date();
            document.addEvent('focusin', function(e) {
                $$(".non-keyboard-outline").removeClass("non-keyboard-outline");
                var wasByKeyboard = lastClick < lastKey;
                if (wasByKeyboard) {
                    e.target.addClass( "non-keyboard-outline");
                }
            });
            document.addEvent('click', function(){
                window.lastClick = new Date();
            });
            document.addEvent('keydown', function() {
                window.lastKey = new Date();
            });
        });
    },
    isEditModeAvaible: function() {
        if(this.isEditMode==null){
            if (this.getURLParameter('mdedit')) {
                this.isEditMode = true;
            }
            else{
                this.isEditMode = false;
            }
        }

        return this.isEditMode;
    },
    checkForRequire: function() {
        if(this.require==null){
            this.require = new Array();
        }
        if($$('[data-md-editable="md-html-editor"]').length>0){
            this.require.push("../_framework/html-editor/js/tinymce/tinymce.min.js");
        }

        if($$('[data-md-editable="md-fileupload-multiple"]').length>0 || $$('[data-md-editable="md-file"]').length>0){
            this.require.push("../_framework/form-upload/file-upload.css");
            this.require.push("../_framework/form-upload/Source/Form.Upload.js");
            this.require.push("../_framework/form-upload/Source/Form.MultipleFileInput.js");
            this.require.push("../_framework/form-upload/Source/Request.File.js");
        }
    },
    createDOM: function() {
    },
    isTouchDevice: function() {
        return !!('ontouchstart' in window);
    },
    // insertActionText - check for touch device and sets tab/click to
    // .responsive-call-to-action elements
    insertActionText: function() {
        for (i = 0; i < this.container.getElements('.responsive-call-to-action').length; i++) {

            var word = this.isTouchDevice() ? 'tap' : 'click';

            text = this.container.getElements('.responsive-call-to-action')[i].get('html');
            character = text[0];

            if (character === character.toUpperCase()) {
                word = word.charAt(0).toUpperCase() + word.slice(1);
            }

            this.container.getElements('.responsive-call-to-action')[i].set('html', word);
        }
    },
    getFeedback: function(correct_answers, total_answers) {
        return 'You correctly answered ' + correct_answers + ' of ' + total_answers + ' questions.';
    },
    // Reset the whole widget
    reset: function() {
        this.currentSlide = 1;
        this.render();
        this.container.set("data-restarted", true);
    },
    next: function() {
        this.currentSlide = this.nextSlide;
        this.render();
        $$('[tabindex=0]:visible')[0].focus();
    },
    // Previous slide
    previous: function() {
        this.currentSlide = this.prevSlide;
        this.render();
        $$('[tabindex=0]:visible')[0].focus();
    },
    getURLParameter: function(name) {
        name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var regexS = "[\\?&]" + name + "=([^&#]*)";
        var regex = new RegExp(regexS);
        var results = regex.exec(window.location.href);
        if (results == null) {
            return null;
        }
        else {
            return results[1];
        }
    },
    render: function() {
        var slide;

        slide = this.options.container.getElement('article.slide-' + this.currentSlide);

        if (slide != null) {
            this.nextSlide = slide.get('data-next-slide');
            this.prevSlide = slide.get('data-prev-slide');
            $$('.active').removeClass('active');
            $$('.slide-' + this.currentSlide).addClass('active');
        }
    },
    getDocumentPath: function() {
        var pathUpload = location.href;
        if (pathUpload.indexOf("?") > 0) {
            pathUpload = pathUpload.split("?")[0];
        }

        return pathUpload;
    },
    getBookPath:function(pattern){
        var pathUpload = location.href;
        if (pathUpload.indexOf("?") > 0) {
            pathUpload = pathUpload.split("?")[0];
        }

        pathUpload = pathUpload.substr(pathUpload.indexOf(pattern)).split('/');
        pathUpload = pathUpload.splice(1, pathUpload.length - 2).join('/');

        return pathUpload;
    },
    saveRequest: function(request, noRefresh) {

        if (request.path == null) {

            if(this.booksRoot==null){
                request.path = this.getBookPath('/pearson-books/');
                if(request.path==""){
                    request.path = this.getBookPath('/pearson-books-dev/');
                }
            }
            else{
                request.path = this.getBookPath('/'+this.booksRoot+'/');
            }
        }

        if(this.widgetRoot){
            request.widgetRoot = this.widgetRoot;
        }

        if (typeof request !== "string") {
            request = JSON.stringify(request);
        }

        var formData = new FormData();
        formData.append('savedata', request);
        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + 'api/index.php/save/');
        xhr.onload = function() {
            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                if (!noRefresh) {
                    window.location.reload();
                }

            } else {
                alert(xhr.status + ' Error when saving widget. Please contact the system administrator.');
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },
    saveRequestProcedure: function($_el, $_request, $_action, $_callback) {
        
        this.mementoQueue.push({
            el: $_el, 
            request: $_request, 
            action: $_action, 
            callback: $_callback
        });

        if( this.requestWorking ) {
            return;
        }

        function makeSakeRequest() {
            var current = this.mementoQueue.shift();
            doSaveRequestProcedure.call(this, current.el, current.request, current.action, current.callback);
        }

        function doSaveRequestProcedure(el, request, action, callback){
            var change_tracking = el !== null && el.hasClass('md-track-changes');

            if (request.path == null || request.path == "") {

                if(this.booksRoot==null){
                    request.path = this.getBookPath('/pearson-books/');
                    if(request.path==""){
                        request.path = this.getBookPath('/pearson-books-dev/');
                    }
                }
                else{
                    request.path = this.getBookPath('/'+this.booksRoot+'/');
                }
            }

            if(this.widgetRoot){
                request.widgetRoot = this.widgetRoot;
            }


            if (typeof request !== "string") {
                request = JSON.stringify(request);
            }

            var formData = new FormData();
            formData.append('savedata', request);
            formData.append('widget_id', this.widget_id);
            var xhr = new XMLHttpRequest();

            var save_url = 'api/index.php/save/';
            if (change_tracking) {
               // save_url += 'changetracking/';
            }
            xhr.open('POST', this.root + (action!=null && action != "" ? action : save_url));
            xhr.onload = function() {
                if (xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);
                    //window.location.reload();

                    if(callback){
                        callback(response);
                    }

                } else {
                    console.error(xhr.status, xhr.responseText);
                }

                if( this.mementoQueue.length == 0 ){
                    this.requestWorking = false;
                } else {
                    makeSakeRequest.call(this);
                }
            }.bind(this);
            xhr.send(formData);
        }

        this.requestWorking = true;
        makeSakeRequest.call(this);
    },
    executeReques: function(request, action) {

        if (request.path == null) {
            if(this.booksRoot==null){
                request.path = this.getBookPath('/pearson-books/');
                if(request.path==""){
                    request.path = this.getBookPath('/pearson-books-dev/');
                }
            }
            else{
                request.path = this.getBookPath('/'+this.booksRoot+'/');
            }
        }

        if(this.widgetRoot){
            request.widgetRoot = this.widgetRoot;
        }

        var formData = new FormData();

        if (typeof request !== "string") {
            request = JSON.stringify(request);
            Object.each(request,function(e,i){
                formData.append(i, e);
            });
        }


        var xhr = new XMLHttpRequest();
        xhr.open('POST', this.root + (action!=null && action != "" ? action : 'api/index.php/save/'));
        xhr.onload = function() {
            if (xhr.status === 200) {
                var response = JSON.parse(xhr.responseText);
                //window.location.reload();

            } else {
                console.error(xhr.status, xhr.responseText);
            }
        };
        xhr.send(formData);
    },
    receivePreviewMessages: function(){
      window.addEventListener("message", function(message) {
        switch(message.data.method){
          case "change-display-mode":
            $$(message.data.element).set("md-data-display-mode", message.data.mode);
            break;
        }
      });
    },

    editMode: function() {
        var that = this;

        that.parseElements();


        window.addEventListener("message", function(message) {

            /*
            var pathOriginal = location.href;

            if (pathOriginal.indexOf("?") > 0) {
                pathOriginal = pathOriginal.split("?")[0];
            }

            var path = pathOriginal.substr(pathOriginal.indexOf('/pearson-books/')).split('/');
            path = path.splice(1, path.length - 2).join('/');

            if(path==""){
                path = pathOriginal.substr(pathOriginal.indexOf('/pearson-books-dev/')).split('/');
                path = path.splice(1, path.length - 2).join('/');
            }
            */

            var path = "";
            if(that.booksRoot==null){
                path = that.getBookPath('/pearson-books/');
                if(path==""){
                    path = that.getBookPath('/pearson-books-dev/');
                }
            }
            else{
                path = that.getBookPath('/'+that.booksRoot+'/');
            }


            that.postMessageReceived(message, path);

        });

        // get widget data
        parent.postMessage({
            method: 'get-widget-data'
        }, "*");

    },
    parseElements: function(context) {
        var that = this;
        var cont = 0;

        $$('body')[0].addClass('md-edit-mode');
        var elements = null;


        /*
         STANDARD CONTROL TEXTFIELD
         */
        cont = 0;
        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-textfield"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-textfield"]:not(.processed)');
        }



        elements.each(function(e, i) {

            var html = e.get("html");
            e.set("html", "");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textfield-" + cont + (new Date().getTime()))
                e.set("id", e.get("data-md-id"));

            }


            if(e.get("data-md-textfield-label")!=null){
                var label = new Element("label.textfield-label",{
                    html:e.get("data-md-textfield-label"),
                    for:e.get("data-md-id")+"-textfield-id"
                });
                label.inject(e)
            }

            var textFieldButton = new Element("input", {
                class: "textfield md-button-popup md-button-textfield",
                "data-control-type": "textfield",
                "data-target-id": e.get("data-md-id"),
                value: html,
                type: "text",
                placeholder: "Enter the text",
                id:e.get("data-md-id")+"-textfield-id"
            });

            textFieldButton.inject(e);

            //textFieldButton.addEvent("click",that.PostMessageControl.bind(that));



            e.addClass("processed");
            cont++;
        });
        /*
         STANDARD CONTROL HTML EDITOR
         */
        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-html-editor"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-html-editor"]:not(.processed)');
        }

        elements.each(function(e, i) {

            var html = e.get("html");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textarea-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var textareaButton = new Element("textarea", {
                html: html,
                class: "html-editor-textarea  md-button-popup md-button-textarea",
                "data-control-type": "textarea",
                "data-target-id": e.get("data-md-id"),
                placeholder: "Enter the content"
            });
            e.set("html", "");
            textareaButton.inject(e);
            //textareaButton.addEvent("click",that.PostMessageControl.bind(that));


            e.addClass("processed");
            cont++;
        });

        /*
         TITLE BODDY CONTROL
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-title-body"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-title-body"]:not(.processed)');
        }

        elements.each(function(e, i) {

            var html = e.get("html");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textarea-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var textareaButton = new Element("button", {
                html: "Add/Edit Content",
                class: "md-button-popup md-button-title-body",
                "data-control-type": "title-body",
                "data-target-id": e.get("data-md-id")
            });
            textareaButton.inject(e, "before");
            textareaButton.addEvent("click", that.PostMessageControl.bind(that));


            e.addClass("processed");
            cont++;
        });

        /*
         MULTI OPTIONS CONTROL
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-multiple-options"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-multiple-options"]:not(.processed)');
        }

        elements.each(function(e, i) {

            var html = e.getElement("[data-md-multiple-options-sample]").clone(true,true);
            html.removeAttribute("data-md-multiple-options-sample");
            html.removeClass("processed");
            html.getElements(".processed").removeClass("processed");
            html = new Element("div").adopt(html);
            //e.getElement("[data-md-multiple-options-sample]").dispose();


            var config  = e.get("data-md-multiple-options-config");
            if(config!=null && config!=""){
                config = JSON.decode(config);
            }
            else{
                config=null;
            }

            var entryTag = "div";

            if(config!=null && config.entryTag && config.entryTag!=""){
                entryTag = config.entryTag;
            }

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textarea-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            if(e.get("data-md-multiple-options-label")!=null){
                var label = new Element("label.textfield-label",{
                    html:e.get("data-md-multiple-options-label"),
                    for:e.get("data-md-id")+"-multiple-options-id"
                });
                label.inject(e,"before")
            }

            var textareaButton = new Element("button", {
                html: config && config.addButtonLabel ? config.addButtonLabel : "Add Option",
                class: "md-button md-button-multiple",
                "data-target-id": e.get("data-md-id")
            });
            textareaButton.inject(e,"after");
            textareaButton.addEvent("click", function(){
                var newel = new Element(entryTag+".option-entry",{
                    html:html.get("html")
                });
                newel.inject(e);
                that.parseElements(newel);
                that.fireEvent("md-multiple-options-option-added",{container:e,el:newel,button:this});
            });

            if(config!=null && config.addfirstitem!=null && config.addfirstitem==true){

                var newel = new Element(entryTag+".option-entry",{
                    html:html.get("html")
                });
                newel.inject(e);
                that.parseElements(newel);
                that.fireEvent("md-multiple-options-option-added",{container:e,el:newel,button:this});

            }


            e.addClass("processed");
            cont++;
        });

        /*
        FILE UPLOAD MULTIPLE CONTROL
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-fileupload-multiple"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-fileupload-multiple"]:not(.processed)');
        }

        var strVar="";
        strVar += "<fieldset>";
        strVar += "		<legend>Upload Files<\/legend>";
        strVar += "";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<label for=\"url\" class=\"floated\">File: <\/label>";
        strVar += "			<input type=\"file\" class=\"files\" name=\"files[]\" multiple><br>";
        strVar += "		<\/div>";
        strVar += "";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<input type=\"submit\" id=\"_submit\" name=\"_submit\" value=\"Upload\">";
        strVar += "		<\/div>";
        strVar += "<input type='hidden' value='' name='method'/>";
        strVar += "	<\/fieldset>";


        elements.each(function(e, i) {

            var html = e.get("html");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "fileupload-multiple-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var textareaButton = new Element("form", {
                html: strVar,
                class: "md-editable md-multiple-fileupload-multiple",
                enctype: "multipart/form-data",
                method: "POST",
                action: that.root+  'api/index.php/upload/?widget_id='+that.widget_id
            });

            textareaButton.getElement(".files").set("id",e.get("id")+"file-field");

            textareaButton.inject(e, "bottom");
            //textareaButton.addEvent("click", that.PostMessageControl.bind(that));

            var upload = new Form.Upload(e.get("id")+"file-field", {
                fields:{
                    path:that.getDocumentPath(),
                    directory: e.get("data-target-directory") != null && e.get("data-target-directory") != "" ? e.get("data-target-directory") : "images"
                },
                onComplete: function(filesU){
                    that.fireEvent("md-fileupload-multiple-complete",{
                        files:JSON.decode(filesU),
                        upload:upload
                    });
                }
            });


            e.addClass("processed");
            cont++;
        });


        /*
         FILE UPLOAD
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-file"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-file"]:not(.processed)');
        }

        var strVar="";
        strVar += "<fieldset>";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<label for=\"url\" class=\"floated\">File: <\/label>";
        strVar += "			<input type=\"file\" class=\"files\" name=\"files[]\" multiple><br>";
        strVar += "		<\/div>";
        strVar += "";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<input type=\"submit\" id=\"_submit\" name=\"_submit\"  value=\"Upload\">";
        strVar += "		<\/div>";
        //strVar += "     <input type='hidden' value='1' name='test' />";
        strVar += "	<\/fieldset>";

        elements.each(function(e, i) {
            var html = e.get("html");
            e.set("html","");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "file-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var config  = e.get("data-md-file-config");
            if(config!=null && config!=""){
                config = JSON.decode(config);
            }
            else{
                config=null;
            }

            var link = new Element("a.file-link",{
                href: e.get("data-file-path"),
                html: e.get("data-file-name"),
                target:"_blank"
            });
            link.inject(e);

            var textareaButton = new Element("div", {
                html: "Edit <div class='edit-toggle'></div><div class='uploader-control'></div>",
                class: "md-button md-button-file md-button-file-edit",
                id: e.get("id")+"-button-edit"
            });
            textareaButton.inject(e);
            textareaButton.addEvent("click", function(e){
                this.getParent('[data-md-editable="md-file"]').getElement(".uploader-control").toggleClass("active");
            });


            var formUploader = new Element("form", {
                html: strVar,
                class: "md-editable md-multiple-fileupload-multiple",
                enctype: "multipart/form-data",
                method: "POST",
                action: that.root+  'api/index.php/upload/?widget_id='+that.widget_id
            });


            formUploader.getElement(".files").set("id",e.get("id")+"file-field");
            textareaButton.getElement(".uploader-control").adopt(formUploader);


            var targetDirectory = e.get("data-target-directory") != null && e.get("data-target-directory") != "" ? e.get("data-target-directory") : "images";
            if(config && config.targetDirectory && config.targetDirectory!=""){
                targetDirectory = config.targetDirectory;
            }


            var upload = new Form.Upload(e.get("id")+"file-field", {
                fields:{
                    path:that.getDocumentPath(),
                    widget_id: that.widget_id,
                    directory:targetDirectory
                },
                onComplete: function(filesU){

                    filesU=JSON.decode(filesU);

                    if(config !=null && config.deleteLastImage!=null && config.deleteLastImage){
                        that.saveRequestProcedure(e,
                            {
                                method:"deleteImage",
                                imageName: e.get("data-file-name"),
                                imagePath: e.get("data-file-path"),
                                directory: e.get("data-target-directory") != null && e.get("data-target-directory") != "" ? e.get("data-target-directory") : "images"
                            },
                            null,
                            function (rs) {

                                e.getElement(".file-link").set("html",filesU[0].filename);
                                e.getElement(".file-link").set("href",filesU[0].path);
                                that.fireEvent("md-file-added-edited",{
                                    files:filesU,
                                    upload:upload,
                                    el:e
                                });
                            }
                        );
                    }
                    else{
                        e.getElement(".file-link").set("html",filesU[0].filename);
                        e.getElement(".file-link").set("href",filesU[0].path);
                        that.fireEvent("md-file-added-edited",{
                            files:filesU,
                            upload:upload,
                            el:e
                        });
                    }


                }
            });

            var deleteButton = new Element("div", {
                html: "Delete <div class='delete-button'></div>",
                class: "md-button md-button-file md-button-file-delete",
                id: e.get("id")+"-button-edit"
            });
            deleteButton.inject(e);
            deleteButton.addEvent("click", function(ev){

                if(!confirm("are you sure to want to delete this image?")) return;

                //this.getParent('[data-md-editable="md-file"]').getElement(".uploader-control").toggleClass("active");
                that.saveRequestProcedure(e,
                    {
                        method:"deleteImage",
                        imageName: e.get("data-file-name"),
                        imagePath: e.get("data-file-path"),
                        directory: targetDirectory
                    },
                    null,
                    function (rs) {

                        that.fireEvent("md-file-delete",{
                            el:e,
                            event:ev
                        });
                    }
                );


            });


            e.addClass("processed");
            cont++;
        });

        if ($$('[data-md-editable="md-html-editor"].processed:not(.initialized)').length > 0) {
            $$('[data-md-editable="md-html-editor"].processed:not(.initialized)').each(function(e) {

                tinymce.init({
                    selector: "#" + e.get("id") + " textarea",
                    plugins: [
                        "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                        "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                        "save table contextmenu directionality emoticons template paste textcolor"
                    ],
                    setup: function(editor) {
                        editor.on('change', function(editorEvent) {
                            var theEditor = this;
                            if (this.timerId != null) {
                                clearTimeout(this.timerId);
                                this.timerId = null;
                            }
                            this.timerId = setTimeout(function() {
                                that.editorOnChangeEventListener(theEditor, editorEvent);
                            }, 500)

                        });
                    }
                });

                e.addClass("initialized");
            });


            //$$('[data-md-editable="md-html-editor"].processed').addClass("initialized");
        }
    },
    PostMessageControl: function(ev) {
        var target = ev.target;
        var type = ev.target.get("data-control-type");
        switch (type) {
            case "textfield":
                if (parent) {
                    parent.postMessage({method: 'edit-control-textfield', type: type, promptText: "Enter the text", id: target.getAttribute("data-target-id"), content: $(target.getAttribute("data-target-id")).get("html")}, "*");
                }
                return false;
                break;
            case "textarea":
                if (parent) {
                    parent.postMessage({method: 'edit-control-textarea', type: type, promptText: "Enter the content", id: target.getAttribute("data-target-id"), content: $(target.getAttribute("data-target-id")).get("html")}, "*");
                }
                return false;
                break;
            case "title-body":
                if (parent) {
                    parent.postMessage({method: 'edit-control-title-body', type: type, promptText: "Enter the content", id: target.getAttribute("data-target-id"), content: {
                        title: $(target.getAttribute("data-target-id")).getElement("[md-title-body-target='title']").get("html"),
                        body: $(target.getAttribute("data-target-id")).getElement("[md-title-body-target='body']").get("html")
                    }
                    }, "*");
                }
                return false;
                break;
        }
    },
    bindEditMode: function() {

    },
    editorOnChangeEventListener: function(e) {

    },
    postMessageReceived: function(message, path) {
        var that = this;
        switch(message.data.method){
            case "get-widget-data":
                this.widget_id = message.data.widget_id;
                break;
            default:
                // console.warn('md-widget Unknown message', message);
        }
    },
    notifyFocusCapture: function() {
        if(parent && parent!=window) {
            parent.postMessage({method:'widget-capture-focus'},"*");
        }
    },
    bindEditModeAfterTagParse: function() {

    },
    bindChangeTracking: function() {
        var _this = this;
        if (!this.isEditMode || this.changeTrackingEnabled) {
            return false;
        }

        var elements = $$('.md-track-changes');
        elements.each(function(el, i) {

            new Element('div.md-track-changes-container').wraps(el);

            _this.enableFieldChangeTracking(el, {
                field_type: el.get('data-md-field-type'),
                field_id: el.get('data-md-field-id'),
                content: el.get('value')
            });
        });

        this.changeTrackingEnabled = true;
    },
    enableFieldChangeTracking: function(el, params) {
        el.addClass('md-field-tracking');
        parent.postMessage({
            method: 'retrieve-change-history',
            id: el.get('data-md-field-id'),
            content: el.value
        }, "*");
    },
    addFieldChangeTrackingControl: function(el, changes, trackerId) {

        var that = this;

        if(el.getElement("a.md-track-changes-control")==null){

            var control = new Element('a.md-track-changes-control', {
                html: changes.length+' pending change' + ((changes.length>1)?'s':'')
            });

            var approve_button = new Element('a.md-track-changes-control.approve', {
                html: "Approve",
                "data-track-id":changes && changes[0]?changes[0].id:""
            });
            var not_approve_button = new Element('a.md-track-changes-control.not-approve', {
                html: "Not Approved",
                "data-track-id":changes && changes[0]?changes[0].id:""
            });

            var cancel_button = new Element('a.md-track-changes-control.cancel', {
                html: "Cancel"
            });

            control.addEvent("click",function(){
                control.hide();
                approve_button.show();
                not_approve_button.show();
                cancel_button.show();
            });

            approve_button.addEvent("click",function(){
                parent.postMessage({
                    method: 'track-tracking-change-status',
                    track_id: this.get('data-track-id'),
                    status: 2,
                    id: trackerId,
                    content:that.onTrackChangeApproved()
                }, "*");

                $$("[data-md-field-id='"+trackerId+"']")[0].set("value",that.onTrackChangeApproved());

                control.show();
                approve_button.hide();
                not_approve_button.hide();
                cancel_button.hide();
            });

            not_approve_button.addEvent("click",function(){
                parent.postMessage({
                    method: 'track-tracking-change-status',
                    track_id: this.get('data-track-id'),
                    status: 3,
                    id: trackerId
                }, "*");

                control.show();
                approve_button.hide();
                not_approve_button.hide();
                cancel_button.hide();
            });

            cancel_button.addEvent("click",function(){
                control.show();
                approve_button.hide();
                not_approve_button.hide();
                cancel_button.hide();
            });

            var trackerDimmension = $$("[data-md-field-id='"+trackerId+"']")[0].getComputedSize();
            $$("[data-md-field-id='"+trackerId+"']")[0].hide();
            var changeEditor = $$("[data-md-field-id='"+trackerId+"']")[0].clone();
            changeEditor.set("value",changes && changes[0]?changes[0].content:"");
            changeEditor.removeAttribute("data-md-field-id");
            changeEditor.addClass("md-track-changes-editor-"+trackerId);
            changeEditor.addClass("md-track-changes");
            changeEditor.set("md-track-id",trackerId);


            var change = new Element('div.md-track-changes-show.md-track-changes-preview-'+trackerId, {
                html:  changes && changes[0]?changes[0].diff:"",
                style:"width:"+trackerDimmension.width+"px;height:"+trackerDimmension.height+"px;"
            });

            change.addEvent("mouseenter",function(){
                change.hide();
                changeEditor.show();
            })

            changeEditor.addEvent("mouseleave",function(){
                change.show();
                changeEditor.hide();

                parent.postMessage({
                    method: 'widget-test-difference',
                    content:$$("[data-md-field-id='"+trackerId+"']")[0].get("value"),
                    change: this.get("value"),
                    track_id: changes && changes[0]?changes[0].id:"",
                    id: trackerId
                }, "*");
            });


            change.inject(el);
            changeEditor.inject(el);
            control.inject(el);
            approve_button.inject(el);
            not_approve_button.inject(el);
            cancel_button.inject(el);


        }
        else{

            if(changes.length>0){

                var control = el.getElement("a.md-track-changes-control").set({
                    html: changes.length+' pending change' + ((changes.length>1)?'s':'')
                });

                var approve_button = el.getElement("a.md-track-changes-control.approve");
                approve_button.set('data-track-id',changes && changes[0]?changes[0].id:"")
                var not_approve_button = el.getElement("a.md-track-changes-control.not-approve");
                not_approve_button.set('data-track-id',changes && changes[0]?changes[0].id:"")
                var cancel_button = el.getElement('a.md-track-changes-control.cancel');

                var change = el.getElement('div.md-track-changes-show').set({
                    html:  changes && changes[0]?changes[0].diff:""
                });
            }
            else{
                el.getElements("*:not([data-md-field-id])").dispose();
                el.getElements("*[data-md-field-id]").show();

            }
        }

    },
    onTrackChangeApproved:function(){

    },
    requireAssets: function(assetss, callback){
        if(assetss!=null){
            var total = assetss.length;
            var cont = 0;
            var onLoad = function(){
                if( cont + 1 == total ){
                    if(callback)
                        callback();
                }
                cont++;
            };
            assetss.each(function(e,i){

                if(typeof(e) == "string"){
                    assetss[i] = e = {
                        source:e
                    };
                }

                if(e.type == null || e.type == ""){
                   if(e.source.indexOf(".png")>0 || e.source.indexOf(".gif")>0 || e.source.indexOf(".jpg")>0 || e.source.indexOf(".jpeg")>0){
                       assetss[i].type = "image";
                   }

                   if(e.source.indexOf(".js")>0){
                       assetss[i].type = "javascript";
                   }

                   if(e.source.indexOf(".css")>0){
                       assetss[i].type = "style";
                   }
                }
            });
            var imagesArray = new Array();
            assetss.each(function(e,i){
                switch(e.type){
                    case "image":
                        imagesArray.push(e.source);
                        break;
                    case "style":
                        var extra;
                        if(e.extra){
                            extra = e.extra;
                        }
                        else{
                            extra = {};
                        }
                        extra.onLoad=onLoad;
                        Asset.css(e.source,extra)
                        break;
                    case "javascript":
                        var extra;
                        if(e.extra){
                            extra = e.extra;
                        }
                        else{
                            extra = {};
                        }
                        extra.onLoad=onLoad;
                        Asset.javascript(e.source,extra)
                        break;
                }
            });

            if(imagesArray.length>0){
                Asset.images(imagesArray,{
                    onLoad:onLoad
                });
            }



        }
    },
    detectContentEditableEditorPanelElements:function(){
        if($$('div.editable-element-panel[contenteditable="true"]:not(.detection-binded)').length>0){
            var _this = this;
            var _window = window;
            if(_this.detection_interval_id==null){
                _this.detection_interval_id = setInterval(function () {
                    var selection = window.getSelection(),
                            range = new Object();
                    range.collapsed = true;
                    var is_editable_panel_element = false;
                    try {

                        var sel_wrapper = $$(selection.baseNode.parentNode).getParent('div.editable-element-panel[contenteditable="true"]')[0];

                        if(sel_wrapper == null){
                            var attrib = $$(selection.baseNode.parentNode).get('contenteditable')[0];
                            if(attrib == null || attrib == false || attrib == 'false')
                                return;
                            if(!$$(selection.baseNode.parentNode)[0].hasClass('editable-element-panel')){
                                return;
                            }

                            sel_wrapper = $$(selection.baseNode.parentNode)[0];
                        }

                        if(_window =! _window.parent && !sel_wrapper.hasClass("focused")){
                            //console.log( $$(selection.baseNode).get("html") );
                            sel_wrapper.addClass("focused");

                            console.log(selection, $$(selection.baseNode));

                            var element = "";
                            if(selection.baseNode.nodeType==3){
                                element = selection.baseNode.nodeValue;
                            }
                            else{
                                element = new Element("div");
                                element.adopt($$(selection.baseNode)[0].clone());
                                element = element.get("html");
                            }



                            var parent_element = new Element("div");
                            parent_element.adopt($$(selection.baseNode.parentNode)[0].clone());
                            //console.log(parent_element.get("html"));

                            _this.sendPostMessages("toggle-editor-panel",{
                                active: true,
                                el: element,
                                parent: parent_element.get("html")//$$(selection.baseNode.parentNode).clone()
                            });
                        }
                    } catch (e) {
                    }


                }, 50);
            }

            $$('div.editable-element-panel[contenteditable="true"]').addEvent("blur",function(e){
                if(_window =! _window.parent){
                    e.target.removeClass("focused");
                    _this.sendPostMessages("toggle-editor-panel",{
                        active: false
                    });
                }
            });

            $$('div.editable-element-panel[contenteditable="true"]').addClass("detection-binded");
        }
    },

    cleanDomForPearsonAccessibility: function(){
        if ( $$('.MetrodigiWidget.container').length > 0 ){
            var propertiesToRemove = [
                'title',
                'aria-describedby'
            ];
            $$('.MetrodigiWidget.container').forEach( function (container) { 
                propertiesToRemove.forEach( function(property) {
                    container.removeProperty(property);
                });
            });
        }
    },

    /**
     * Utility function, clear timers on window blur,
     * user interaction and every new call.
     * LLama el cb si el iframe esta con foco o lo llamará
     * cuando la ventana tenga el foco
     * [TODO: update description]
     * @param  {Function}  cb
     */
    clearTimersOnUserInteraction: function (cb) {
        var _this = this;

        if (!this._runCallbackEvent) {
            // create custom event
            this._runCallbackEvent = document.createEvent('Event');
            this._runCallbackEvent.initEvent('runcallback', true, true);
        }

        if (!this._timerList) {
            this._timerList = [];
        }

        // clear previus clearTimersOnUserInteraction
        onUserInteraction();

        window.addEventListener('focus', runCallback, false);
        document.addEventListener('runcallback', beforeRunCb, false);
        runCallback();

        function runCallback () {
            if (document.hasFocus()) {
                window.removeEventListener('focus', runCallback, false);
                document.dispatchEvent(_this._runCallbackEvent);
              }
        }

        function beforeRunCb () {
            document.removeEventListener('runcallback', beforeRunCb, false);

            // add your setTimeout/setInterval to timers
            cb(_this._timerList);

            setTimeout(function () {
                window.addEventListener('touchstart', onUserInteraction, false);
                window.addEventListener('click', onUserInteraction, false);
                window.addEventListener('keydown', onUserInteraction, false);
                window.addEventListener('blur', onUserInteraction, false);
            }, 100);
        }

        function onUserInteraction () {
            window.removeEventListener('touchstart', onUserInteraction, false);
            window.removeEventListener('click', onUserInteraction, false);
            window.removeEventListener('keydown', onUserInteraction, false);
            window.removeEventListener('blur', onUserInteraction, false);

            clearTimers();
        }

        function clearTimers () {
            var timersLength = _this._timerList.length;
            for (var i = 0; i < timersLength; i++) {
                clearTimeout(_this._timerList[i]);
            }
            _this._timerList = [];
        }
    }
});

Score = new Class({
    initialize: function(total, correct){
        this.total = total;
        this.correct = correct;

        this.score = Math.round(this.correct*100/this.total);
    },
    getMessage: function() {
//      if(this.score >= 70) {
        return "You completed the challenge. You got " + this.correct + " out of " + this.total + " correct on the first try.";
//      } else {
//          return "Good job! You completed the challenge. You only got " + this.correct + " out of " + this.total + " correct on the first try.";
//      }
    }
});

$extend(Selectors.Pseudo, {
    visible: function() {
        if (this.getStyle('visibility') != 'hidden' && this.isVisible() && this.isDisplayed()) {
            return this;
        }
    }
});
