/**
 * Gruntfile to autoprefix CSS.
 * install globally with
 *   "sudo npm install --save grunt-postcss"
 *   "sudo npm install --save autoprefixer-core"
 * Then invoke with
 *   "grunt prefix"
 **/


var autoprefixer = require('autoprefixer-core');
var csswring = require('csswring');

module.exports = function (grunt) {

    // Project configuration.
    grunt.initConfig({
        postcss: {
            options: {
                map: true,
                processors: [
                    // browsers: 'last 1 version'
                    autoprefixer({browsers: ['> 0.4%', 'last 6 version']}).postcss,
                    csswring.postcss
                ]
            },
            dist: {
                // OPS/css
//                src: '**/*.css'
                src: '**/OPS/css/*.css'
            }
        }
    }); // end initConfig()
    
    // Load the plugin that provides the "postcss" task.
    grunt.loadNpmTasks('grunt-postcss');

    // Default task(s).
    grunt.registerTask('default', ['postcss']);
    
    // Task invoked with 'grunt hello'
    grunt.registerTask('hello', 'grunt hello function', function () {
        grunt.log.write('Hello2\n').ok();
    });
};