/**

TODO: JQuery is being loaded at least 3 times on this page...


 * Author: ???, Aaron Melocik
 * Major Revision: 3.31.2015
 *
 *
 * Popup
 **/

/**
 * script: FORMERLY metrodigi-popup.js ; currently unknown?
 *
 * Description: Provides mobile shim for Popup elements
 * to make the element fit in small windows.
 *
 * EXAMPLE instantiation:
 *
 *       try {
 *           new md.widgets.Popup($('popup-4'), `<iframe
 *           src="../components/metrodigi/ch02-advanced_flashcards-01/index.html" 
 *           class="gadget" 
 *           width="700" 
 *           height="600" 
 *           data-minwidth="149" 
 *           data-minheight="149" 
 *           allowfullscreen="yes" 
 *           seamless="seamless" 
 *           sandbox="allow-same-origin allow-scripts allow-popups allow-forms" 
 *           lang="en-us" 
 *           title="" 
 *           data-offlinesupport="yes" 
 *           data-displaytarget="embed">
 *       </iframe>`, {
 *               "title": "Title 4",
 *               "closeBtn": true
 *           });
 *       } catch (error) {
 *           console.log("Widget init error: ", error)
 *       }
 *
 **/
md.widgets.Popup = new Class({
    Implements: [Options],
    options: {
        closeBtn: false,
        closeBtnText: 'Close',
        position: 'fixed', //CAN be relative, so shows where clicked
        alignment: 'topLeft',
        minimumScaleSize: 0.33
    },

    initialize: function (ele, html, options) {        
        this.el = ele;
        this.viewportDimensions = {};
        this.deviceRotationListenerActive = false;

        // trigger for the fallback text. Can be found in resonsive-v2.js, as window._breakpoint_width.
        this.minimumWidgetSizeToDisplay = window._breakpoint_width || 700;
        this.minimumScaleSize = this.options.minimumScaleSize;

        this.setOptions(options);

        if (typeOf(html) == 'string') {
            this.popupEl = Elements.from(html, false);
        } else {
            this.popupEl = html;
        }

        this.TEMPlistenForResize();
        this.el.addEvent('click', this.show.bind(this));
    }, // end initialize()

    /**
     * Create the modal element by:
     *   1. Create a Mask to cover the page content
     *   2. Create a modal div
     *   3. Creates and binds/listens for a 'close' function that restores body overflow, pauses media, and destroys the modal.
     *   4. Checks for a Title element, and creates and adopts.
     *   5. Creates a modalBody element which adopts the main iframe element.
     *   7. Checks for a Close Button element, and creates and adopts.
     **/
    createModal: function () {
        var _this = this;
        // NOTE FROM AARON: not sure why this is here, but leaving this in from legacy code.
        // var $ = document.id;

        // _this.mask. We will use _this.mask.element.getWidth() and _this.mask.element.getHeight() to calculate viewable screen area.
        _this.mask = new Mask(document.body, {
            destroyOnHide: true,
            width: '100%',
            height: '100%'
        });

        _this.modal = new Element('div', {
            'class': 'modal',
        });
        _this.modal.width;
        _this.modal.height;
        _this.modal.inject(_this.mask.element);

        _this.modal.modalTitle = null;
        if (_this.options.title && _this.options.title.length > 0) {
            _this.modal.modalTitle = new Element('header', {
                'class': 'modal-header',
                text: _this.options.title
            });
            _this.modal.modalTitle.inject(_this.modal);
        }

        // Create the main modal body div, which then adopts the iframe element (from the <html> passed into the Popup() constructor).
        _this.modal.modalBody = new Element('div', {
            'class': 'modal-body'
        });
        _this.modal.modalBody.width;
        _this.modal.modalBody.height;
        _this.modal.modalBody.scaleSize = 1;
        _this.modal.modalBody.inject(_this.modal);

        // Create the iframe element
        _this.modal.modalBody.iframeEl = _this.popupEl[0];
        _this.modal.modalBody.iframeEl.inject(_this.modal.modalBody);
        _this.modal.modalBody.iframeEl.requestedWidth = _this.modal.modalBody.iframeEl.width.toFloat() || 700;
        _this.modal.modalBody.iframeEl.requestedHeight = _this.modal.modalBody.iframeEl.height.toFloat() || 580;
        _this.modal.modalBody.iframeEl.setStyles({
            'min-width': _this.modal.modalBody.iframeEl.requestedWidth,
            'min-height': _this.modal.modalBody.iframeEl.requestedHeight,
        });
        _this.modal.modalBody.inject(_this.modal);

        // If there is a close button, create this.modal.modalFooter, and inject into main modal
        if (_this.options.closeBtn) {
            _this.modal.modalFooter = new Element('div', {
                'class': 'modal-footer'
            });
            _this.modal.modalFooter.inject(_this.modal);

            _this.modal.modalFooter.closeEl = new Element('a', {
                'class': 'modal-close btn primary',
                'text': _this.options.closeBtnText
            });
            _this.modal.modalFooter.closeEl.inject(_this.modal.modalFooter);
        }

        // Create a "bad orientation" notification element. Starts hidden.
        _this.orientationNotificationElement = new Element('div', {
            'class': 'orientation-notification',
            'html': '<h2>Rotate your screen to view this widget.</h2>'
        });
        _this.orientationNotificationElement.setStyles({
            'padding': '10px',
            'display': 'none'
        });
        _this.modal.modalBody.adopt(_this.orientationNotificationElement);

        _this.bindModalEvents();
    }, // end createModal()


    /**
     * Bind modal events,
     * mostly close().
     **/
    bindModalEvents: function () {
        var _this = this;

        _this.modal.addEventListener('click', function (event) {
            var ev = event || window.event;
            ev.stopPropagation();
        }); // end addEventListener(click _this.modal)

        var close = function () {
            try {
                document.body.removeClass('no-overflow');
            } catch (error) {
                console.error('cannot do "document.body.removeClass(\'no-overflow\')", error is', error);
            }

            // Pause any playing media elements.
            try {
                _this.modal.getElements('video, audio').each(function (el) {
                    el.pause();
                });
            } catch (error) {
                console.error('cannot get _this.modal a/v elements, error is', error);
            }

            try {
                if (!!window.screen.unlockOrientation) {
                    window.screen.unlockOrientation();
                }
            } catch (error) {
                console.error('cannot get unlockOrientation, error is', error);
            }

            try {
                _this.modal.destroy();
                _this.modal = undefined;
            } catch (error) {
                console.error('cannot do "_this.modal = undefined", error is', error);
            } // end try-catch

            _this.popupEl[0].removeAttribute('style');
            _this.mask.element.destroy();
        }.bind(_this);

        var closeAndStop = function (e) {
            var ev = e || event;
            close();
            ev.preventDefault();
        };

        if (_this.options.closeBtn) {
            _this.modal.modalFooter.closeEl.addEvent('click', close);
        }

        _this.mask.element.addEvent('hide', closeAndStop);
        _this.mask.element.addEvent('click', closeAndStop);
        _this.el.addEvent('click:relay(.close)', closeAndStop);
    }, // end bindModalEvents()

    /**
     * Update dimensons for the widget, the modal, and the window/viewport.
     * Note that modalBody wraps the iframe with 0 padding.
     * Also note: can refactor to use md.userDevice.
     **/
    updateDimensions: function () {
        var _this = this;

        _this.modal.dataset.width = _this.modal.getWidth().toFloat();
        _this.modal.dataset.height = _this.modal.getHeight().toFloat();
        if (_this.modal.dataset.height > _this.modal.dataset.width) {
            _this.modal.orientation = "portrait";
        } else {
            _this.modal.orientation = "landscape";
        }

        // NOTE: try scaling with Viewport, too...        
        _this.modal.modalBody.width = _this.modal.modalBody.getWidth().toFloat(); // this reflects the actual size after scaling!
        _this.modal.modalBody.height = _this.modal.modalBody.getHeight().toFloat(); // this reflects the actual size after scaling!
        _this.modal.modalBody.scaleSize = _this.modal.modalBody.iframeEl.getStyle('transform');
        if (_this.modal.modalBody.scaleSize && _this.modal.modalBody.scaleSize !== "none") {
            _this.modal.modalBody.scaleSize = _this.modal.modalBody.scaleSize.replace('scale(', '');
            _this.modal.modalBody.scaleSize = _this.modal.modalBody.scaleSize.replace(')', '');
            _this.modal.modalBody.scaleSize = _this.modal.modalBody.scaleSize.toFloat();
        } else {
            _this.modal.modalBody.scaleSize = 1;
        }

        _this.modal.modalBody.iframeEl.width = _this.modal.modalBody.iframeEl.getWidth().toFloat();
        _this.modal.modalBody.iframeEl.height = _this.modal.modalBody.iframeEl.getHeight().toFloat();
        if (_this.modal.modalBody.iframeEl.height > _this.modal.modalBody.iframeEl.width) {
            _this.modal.modalBody.iframeEl.orientation = "portrait";
        } else {
            _this.modal.modalBody.iframeEl.orientation = "landscape";
        }

        _this.viewportDimensions.width = _this.mask.element.getWidth();
        _this.viewportDimensions.height = _this.mask.element.getHeight();
        if (_this.viewportDimensions.height > _this.viewportDimensions.width) {
            _this.viewportDimensions.orientation = "portrait";
        } else {
            _this.viewportDimensions.orientation = "landscape";
        }
    }, // end updateDimensions()

    
    /**
     * 1. Render the elements on the screen
     * 2. Remove all explicit styles from the mask so it will listen to our .CSS
     * 3. Remove scrollbars from screen
     * 4. Update all the object data based on rendered dimensions
     * 5. Position, scale, rotate, and calculate optimum dimensions
     * 6. Re-render if necessary
     **/
    show: function (e) {
        var _this = this;

        // Lazily build and add the modal DOM on first attempt to show.
        if (_this.modal === undefined) {
            _this.createModal();
        }
        e.preventDefault();

        _this.mask.show();
        _this.mask.element.removeAttribute('style');
        document.body.addClass('no-overflow');

        // TODO: make sure this fires after elements are initially rendered so we can check size...
        window.setTimeout(function () {
            _this.updateDimensions();
            _this.positionModal();
        }, 250, _this);

        _this.el.fireEvent('popupVisible', this);
    }, // end show()


    /**
     * positionModal will variously position, prompt for rotation, and resize the modal
     * to try to get the best fit for the modal & widget content.
     *
     * Procedures to try are:
     *   1) Drop the padding on the modalBody
     *   2) Prompt for a better orientation
     *   3) Scale the widget so the width fits
     *   4) Drop padding on the header and move the close button up to an "X"
     *
     * Opting to avoid screen.orientation at the moment because it is not well supported.
     *   https://developer.mozilla.org/en-US/docs/Web/API/Screen/orientation
     **/
    positionModal: function () {
        var _this = this;
        var traceCounter = 0;

        // 1. remove padding
        if (_this.modalFitsInViewport()) {
            return true;
        }
        _this.modal.modalBody.setStyle('padding', '0px');

        if (_this.modalFitsInViewport()) {
            return true;
        }

        // 2. compare orientation of screen & modal and toggle the interactive and orientation notification
        if (_this.viewportDimensions.orientation !== _this.modal.orientation) {
            if (_this.orientationNotificationElement.getStyle('display') === 'none') {
                _this.modal.modalBody.iframeEl.hide();
                _this.orientationNotificationElement.show();
            }
        } else if (_this.orientationNotificationElement.getStyle('display') !== 'none') {
            _this.modal.modalBody.iframeEl.show();
            _this.orientationNotificationElement.hide();
        }

        if (_this.modalFitsInViewport()) {
            return true;
        }

        // 3. if the width is too large, scale to fit the screen
        var deltaHeight = (_this.viewportDimensions.height / _this.modal.dataset.height);
        var deltaWidth = (_this.viewportDimensions.width / _this.modal.modalBody.iframeEl.getWidth());

        if (deltaWidth < 1) {
            _this.modal.modalBody.scaleSize = deltaWidth;
        }

        // minimum threshhold for scaling
        if (_this.modal.modalBody.scaleSize < _this.minimumScaleSize) {
            _this.sizeNotificationElement = new Element('div', {
                'class': 'size-notification',
                'html': '<h2>This content cannot be displayed on your screen size.</h2>'
            });
            _this.sizeNotificationElement.setStyle('padding', '10px');
            _this.modal.modalBody.adopt(_this.sizeNotificationElement);

            if (_this.orientationNotificationElement.getStyle('display') !== 'none') {
                _this.orientationNotificationElement.hide();
            }

            if (_this.modal.modalBody.iframeEl.getStyle('display') !== 'none') {
                _this.modal.modalBody.iframeEl.hide();
            }
        } else { // viewport is not smaller than allowable size, so shrink
            
            // MooTools setStyle rounds the passed value to the nearest integer, so rounding up first.
            var newModalBodyWidth = (_this.modal.modalBody.width * _this.modal.modalBody.scaleSize) + 1;
            var newModalBodyHeight = (_this.modal.modalBody.height * _this.modal.modalBody.scaleSize) + 1;
            
            newModalBodyWidth = '' + newModalBodyWidth + 'px';
            newModalBodyHeight = '' + newModalBodyHeight + 'px';
            
            _this.modal.modalBody.setStyles({
                '-o-transform': 'scale(' + _this.modal.modalBody.scaleSize + ')',
                '-ms-transform': 'scale(' + _this.modal.modalBody.scaleSize + ')',
                '-moz-transform': 'scale(' + _this.modal.modalBody.scaleSize + ')',
                '-webkit-transform': 'scale(' + _this.modal.modalBody.scaleSize + ')',
                'transform': 'scale(' + _this.modal.modalBody.scaleSize + ')'
            });
            
            _this.modal.modalBody.iframeEl.setStyle('position', 'absolute');

            /**
             * Override all inline CSS elements inside iframe
             * and change from inline to inline-block.
             * This should allow scaling to work on Opera & Safari.
             * 
             * We will need to refactor some styling code in widgets for 100% compatability...
             **/
            var iframeDocument = _this.modal.modalBody.iframeEl.contentDocument;
            iframeDocument.addEvent('domready', function () {
                var allIframeElements = this.getElements('*');
                for (var i = 0; i < allIframeElements.length; i++) {
                    if (allIframeElements[i].getStyle('display') === 'inline') {
//                        var thisWidth = allIframeElements[i].getWidth();
//                        var thisHeight = allIframeElements[i].getHeight();
                        allIframeElements[i].setStyle('display', 'inline-block');
//                        allIframeElements[i].setStyle('width', 'auto');
                        allIframeElements[i].setStyle('width', 'initial');
//                        allIframeElements[i].setStyle('width', thisWidth);
//                        allIframeElements[i].setStyle('height', thisHeight);
                    }
                }
            }); // end iframeDocument.addEvent(domready)

            _this.modal.modalBody.setStyle('width', newModalBodyWidth);
            _this.modal.modalBody.setStyle('height', newModalBodyHeight);

            if (_this.modalFitsInViewport()) {
                return true;
            } else {

                console.log("modal still doesn't fit...");
                console.log(this.modal.modalBody);
            }
        }

        // 4. If the height is too large, shrink the header padding and replace the close button with a font-awesome hovering "X".
        if (deltaHeight < 1) {

            _this.modal.modalTitle.setStyle('padding', '0px');
            if (!!_this.modal.modalFooter) {
                _this.modal.modalFooter.addClass('little-close-icon');
                _this.modal.modalFooter.closeEl.setProperties({
                    'text': '',
                    'html': '<i class="fa fa-times"></i>' // f00d
                        //                  'html': '<i class="fa fa-times-circle"></i>' // f057);
                });
            }
        } // end (shrink header padding and change modal footer to "X")

        if (_this.modalFitsInViewport()) {
            return true;
        }
    }, // end positionModal()

    /**
     * Can attach this event to an "onresize" event
     * to fire repositioning of modal on screen resize...
     * But that's really only helpful for PCs in a window.
     * Mobile devices need to listen to a "orientation change"
     * event, which is not implemented here...
     **/
    TEMPlistenForResize: function () {
        //        var _this = this;
        //        
        //        _this.boundResizeListener = function(event) {
        ////            console.log('resizing and running _this.positionModal()');
        //            _this.positionModal();
        //        }
        //        _this.boundResizeListener = _this.boundResizeListener.bind(_this);
        ////        boundResizeListener = boundResizeListener.bind(_this);
        //        
        //        window.addEventListener('resize', function(event) {
        //            _this.boundResizeListener(event);
        //        }); // end addEventListener();
    },

    /**
     * Basic repeating test to determine whether or not the modal is fitting in the viewport.
     **/
    modalFitsInViewport: function () {
        var _this = this;
        
        _this.updateDimensions();
        if (_this.viewportDimensions.width >= _this.modal.modalBody.width &&
            _this.viewportDimensions.height >= _this.modal.dataset.height) {
            return true;
        }

        if (_this.viewportDimensions.width < _this.modal.dataset.width ||
            _this.viewportDimensions.width < _this.modal.modalBody.width ||
            _this.viewportDimensions.height < _this.modal.height) {
            return false;
        }

        return false;
    }, // end modalFitsInViewport()
});