var PearsonPlayerWrapper = new Class({
	Implements: [Options, Events],
	playerId:null,
	playerElement:null,
	loaded:false,
	currentTimeMilliseconds:0,
	currentTime:0,
	totalMilliseconds:0,
	timeId:null,
	volumeBeforeMute: 100,
	initialize:function(options){
		this.setOptions(options);
		// bind the message listeners
        if (window.addEventListener) {
            window.addEventListener("message", this.messageListener.bind(this), false);
        } else {
            window.attachEvent("onmessage", this.messageListener.bind(this));
        }
		this.attachInternalEvents();
        this.render();
	},
	fetchTime:function(time){
		if(time==null) return;

		var time_miliseconds = time;
		this.options.container.getElement(".progress-range").set("value",time_miliseconds);
		time = time / 1000;
		var m = Math.floor(time/60);
		var s = Math.floor(time - m*60);8
		this.options.container.getElement(".time-wrapper").set("html",(m<10?"0"+m:m)+":"+(s<10?"0"+s:s));
	},
	bindTimer:function(){
		if(this.timeId==null){
			var time_diff = 250;
			this.timerId = setInterval(function(){

				this.currentTimeMilliseconds+=time_diff;
				this.fetchTime(this.currentTimeMilliseconds);
				this.currentTime = this.currentTimeMilliseconds/1000;
				this.fireEvent("timeupdate",this.currentTime);

			}.bind(this),time_diff);
		}
	},
	unbindTimer:function(){
		if(this.timerId!=null){
			clearInterval(this.timerId);
			this.timerId = null;
		}
	},

	setVolume:function (volume, sendCommand) {
		if(!this.loaded) return;
		// default param
		sendCommand = sendCommand === undefined ? true : sendCommand;
		volume = parseInt(volume, 10);
		if (volume > 0) {
			this.options.container.getElement(".volume-icon").removeClass("muted");
		}
		this.options.container.getElement(".volume-icon").removeClass("fa-volume-up");
		this.options.container.getElement(".volume-icon").removeClass("fa-volume-down");
		this.options.container.getElement(".volume-icon").removeClass("fa-volume-off");
		if (volume >= 60) {
			this.options.container.getElement(".volume-icon").addClass("fa-volume-up");
		}
		else if (volume < 60 && volume >= 20) {
			this.options.container.getElement(".volume-icon").addClass("fa-volume-down");
		}
		else if (volume < 20) {
			this.options.container.getElement(".volume-icon").addClass("fa-volume-off");
		}

		if (sendCommand) {
			this.sendCommandMessage( 'setVolume', params = {'percent':volume} );
			this.fireEvent("volume",volume);
		}
	},
	mute:function(mute){
		if(!this.loaded) return;

		if(mute==null){
			if(this.options.container.getElement(".volume-icon").hasClass("muted")){
				mute=false;
			}
			else{
				mute=true;
			}
		}

		var volumeInput = this.options.container.getElement(".volume-range");
		if(mute){
			this.sendCommandMessage( 'mute', {} );
			this.options.container.getElement(".volume-icon").addClass("muted");
			this.fireEvent("mute");
			var currentVolume = parseInt(volumeInput.value, 10);
			this.volumeBeforeMute = currentVolume === 0 ? 100 : currentVolume;
			volumeInput.set("value", 0);
		}
		else{
			this.sendCommandMessage( 'unMute', {} );
			this.options.container.getElement(".volume-icon").removeClass("muted");
			this.fireEvent("unMute");
			volumeInput.set("value", this.volumeBeforeMute);
			this.setVolume(this.volumeBeforeMute);
		}
	},
	play:function(time){
		if(!this.loaded) return;
		var _this = this;
		var time_to_send = time;
		if(time!=null){
			this.sendCommandMessage( 'seek', params = {'percent':(100*time/this.totalMilliseconds)});
			this.sendCommandMessage( 'play', {});
			this.fetchTime(this.time);
			time_to_send = time/1000;
		}
		else{
			this.sendCommandMessage( 'play', {});
			time_to_send = this.currentTimeMilliseconds/1000;
		}
		this.bindTimer();
		_this.options.container.getElement(".play-button").addClass("hide");
    	_this.options.container.getElement(".pause-button").removeClass("hide");
    	this.fireEvent("play",time_to_send);
	},
	pause:function(){
		if(!this.loaded) return;
		var _this = this;

		this.sendCommandMessage( 'pause', {});
		this.unbindTimer();
		_this.options.container.getElement(".play-button").removeClass("hide");
    	_this.options.container.getElement(".pause-button").addClass("hide");

    	this.fireEvent("pause",this.currentTimeMilliseconds);

	},
	stop:function(){
		if(!this.loaded) return;
		this.sendCommandMessage( 'stop', {});
	},
	messageListener:function(message){
		var msg = {};
		if(message.data!=null && message.data.method!=null) return;
		// convert the stringified JSON back to JSON object
        msg.data = JSON.parse(message.data);

        //get playerId from a fallback mechanism, as a fall back on some platforms/browsers
        //var playerId = ((typeof msg.data.payload != "undefined") 
        //    && msg.data.payload.playerId) ? msg.data.payload.playerId : getFrameTarget(message).id;
		var playerId = this.playerId;


		//console.log(msg.data);

        
				//Make sure we are getting to the right events
        if (msg.data.type && msg.data.type == "message" && msg.data.method && msg.data.method == "publish") {
            //And we have a Media Player ready for playback event
            if(msg.data.payload.message.action == 'spp_readyForPlayback') {
								// enable volume
								this.options.container.getElement(".volume-range").removeProperty("disabled");
                //lets enable all the buttons, now that the player is ready
                //var buttonsArr = document.getElementsByTagName('button');
                //for (var i = 0; i < buttonsArr.length; i++) {
                //    buttonsArr[i].disabled=false;
                //    
                //}
                
                //lets jack up the volume since this is a demo. :-)
                this.sendCommandMessage( 'setVolume', params = {'percent':100});
                this.options.container.getElement(".player-template-wrapper").removeClass("not-loaded");
                this.loaded = true;
                //this.sendCommandMessage( 'play', {});
/*
            }

            if(msg.data.payload.message.action == "spp_played") {
            	this.totalMiliseconds = msg.data.payload.message.mediaLength.value;
            	this.options.container.getElement(".progress-range").set("value",0);
            	this.options.container.getElement(".progress-range").set("max",this.totalMiliseconds);
*/
                this.fireEvent("ready_to_play");
            }

            if(msg.data.payload.message.action == "spp_played") {
            	this.totalMilliseconds = msg.data.payload.message.mediaLength.value;
            	this.options.container.getElement(".progress-range").set("value",0);
            	this.options.container.getElement(".progress-range").removeProperty("disabled");
            	this.options.container.getElement(".volume-range").removeProperty("disabled");
            	this.options.container.getElement(".progress-range").set("max",this.totalMilliseconds);
            	this.fireEvent("metadata_readed");
           }
            
            //Playback finished, lets change the button state to "replay"
            if(msg.data.payload.message.action == 'spp_finished') {

            	this.unbindTimer();
            	this.options.container.getElement(".play-button").removeClass("hide");
    			this.options.container.getElement(".pause-button").addClass("hide");
    			this.fireEvent("finish");

                //document.getElementById('audioPlayerButton').innerHTML="Replay Audio";
            }
        }
	},
	sendCommandMessage: function( command, payload) {
        var params = JSON.stringify({
            "type": "command",
            "method": command,
            "playerId": this.playerId,
            "payload": payload
				});
        this.playerElement.contentWindow.postMessage(params, '*');
    },
    addPlayerTemplate: function(){
    	var _this = this;

    	var template="";
		template += "<div class=\"player-template-wrapper not-loaded\">";
		template += "	<div class=\"buttons-wrapper\">";
		template += "		<div class=\"play-button fa fa-play\"><\/div>";
		template += "		<div class=\"pause-button hide fa fa-pause\"><\/div>";
		template += "		<div class=\"stop-button hide fa fa-stop\"><\/div>";
		template += "	<\/div>";
		template += "	<div class=\"progress-wrapper\">";

		template += "		<input type='range' disabled='disabled' min=\"0\" max=\"100\" value=\"0\" class=\"progress-range\"\/>";

		template += "	<\/div>";
		template += "	<div class=\"time-wrapper\">";
		template += "	00:00";
		template += "	<\/div>";
		template += "	<div class=\"volume-wrapper\">";
		template += "		<div class='volume-icon fa fa-volume-up'></div>";	

//		template += "		<div class='volume-slider-wrapper'><input type=range min=\"0\" max=\"100\" value=\"100\" class=\"volume-range\"\/></div>";

		template += "		<div class='volume-slider-wrapper'><input disabled='disabled' type='range' min=\"0\" max=\"100\" value=\"100\" class=\"volume-range\"\/></div>";

		template += "	<\/div>";
		template += "<\/div>";

    	(Elements.from(template)[0]).inject(this.options.container);

    	this.options.container.getElement(".play-button").addEvent("click",function(){
    		_this.play();
    	});
    	this.options.container.getElement(".pause-button").addEvent("click",function(){
    		_this.pause();
    	});

/*
    	this.options.container.getElement(".progress-range").addEvent("change",function(){
    		var current = this.get("value");
    		_this.unbindTimer();
    		_this.currentTime = current;
    		_this.bindTimer();
    		console.log(current);

*/
    	this.options.container.getElement(".progress-range").addEvent("mousedown",function(){
    		_this.pause();

    		//_this.currentTimeMilliseconds = current;
    		//_this.bindTimer();
    	});

    	this.options.container.getElement(".progress-range").addEvent("mouseup",function(){
				var current = new Number(this.get("value"));
				current = parseInt(current, 10);
    		_this.unbindTimer();
    		_this.currentTimeMilliseconds = current * 1000;
    		_this.currentTime = current;
    		_this.play(current);
    		_this.fireEvent("seeked",_this.currentTime);
    	});

    	this.options.container.getElement(".volume-range").addEvent("change",function(){
    		var current = new Number(this.get("value"));
    		_this.setVolume(current);
    	});
    	this.options.container.getElement(".volume-range").addEvent("input",function(){
    		var current = new Number(this.get("value"));
    		_this.setVolume(current);
    	});

    	this.options.container.getElement(".volume-icon").addEvent("click",function(){
    		_this.mute();
    	});
    },
	render:function(){
		this.addPlayerTemplate();

		//generate random ID
		var randomId = this.playerId = "player_" + (new Date()).getTime();

		window.pearsonAudioWrapperNS = window.pearsonAudioWrapperNS || {};
		if( typeof window.pearsonAudioWrapperNS.proxy == "undefined") {
			window.pearsonAudioWrapperNS.proxy = function(id) {
				var thePlayerIframe = $(id);
				if(thePlayerIframe){
					thePlayerIframe.getPrevious().removeClass('not-loaded');
					thePlayerIframe.fireEvent('PearsonPlayerIframeLoaded');
				}
			}
		}
		
		this.playerElement = new Element("iframe",{
			src: this.options.url,
			name: randomId,
			id: randomId,
			style: "position: absolute; border: 0; clip: rect(0, 0, 0, 0); width: 1px; height: 1px; margin: -1px; padding: 0; overflow: hidden;", 
			allow: "autoplay",
			onLoad: "setTimeout(function(){window.pearsonAudioWrapperNS.proxy('"+ randomId +"')},2000)"
		});
		this.options.container.adopt(this.playerElement);

		this.playerElement.addEvent('PearsonPlayerIframeLoaded', function(){
			this.messageListener({
				data: JSON.stringify({
					type: 'message',
					method: 'publish',
					payload:{
						message: {
							action: 'spp_readyForPlayback'
						}
					}
				})
			});
		}.bind(this));
		
	},
	attachInternalEvents: function(){
	}
});
