var SliderAccess = new Class({
    Implements: [Options, Events],
    Extends:Slider,
    currentStep:0,
    keyRight:"right",
    keyLeft:"left",
    keyUp:"up",
    keyDown:"down",
    options:{
      labels:null
    },
    initialize:function(parent,dragel,options){
        var _this = this;
        this.parent(parent,dragel,options);

        if(options.range!=null && options.range.length>0){
            _this.currentStep = options.range[0];
        }

        if(options.keyRight!=null){
          _this.keyRight = options.keyRight;
        }

        if(options.keyLeft!=null){
          _this.keyLeft = options.keyLeft;
        }

        if(options.keyUp!=null){
          _this.keyUp = options.keyUp;
        }

        if(options.keyDown!=null){
          _this.keyDown = options.keyDown;
        }

      if (options.labels != null) {

        switch ( typeOf(options.labels) ) {
          case "string":
          case "elements":
            var labels_items = $$(options.labels);
            this.options.labels = labels_items;
            this.options.labels.each(function(e,i){
              if(e.get("data-position")==null){
                 e.set("data-position",_this.options.labels.indexOf(e));
              }
              if(e.get("tabindex")==null || e.get("tabindex")<0){
                 e.set("tabindex",0);
              }
            });
            break;
          case "object":
            this.options.labels = new Array();
            Array.each(options.labels, function (e, i) {
              var item = $$(e.target);
              item.setProperty("data-position", e.position);
              _this.options.labels.push(item);
            });
            break;
        }

        if (_this.options.labels != null) {
          _this.options.labels.addEvent("click",function(e,i){
            _this.set(this.getProperty("data-position"));
           });

          _this.options.labels.addEvent("keypress",function(e,i){
            if(e.key=="enter" || e.key=="space")
              _this.set(this.getProperty("data-position"));
          });
        }
      }

        dragel.set("tabindex",0);
        dragel.addEvent("keydown",function(e){

            if(e.key=="enter" || e.key=="space" || e.key==_this.keyRight || e.key==_this.keyUp){
                if(options.range!=null && options.range.length>0 && options.range[options.range.length-1]==_this.currentStep ){
                    return;
                }
                _this.currentStep++;
            }
            if(e.key==_this.keyLeft || e.key==_this.keyDown){
                if(options.range!=null && options.range.length>0 && options.range[0]==_this.currentStep ){
                    return;
                }

                if(_this.currentStep-1<0){
                    return;
                }
                _this.currentStep--;
            }

            _this.set(_this.currentStep);
        });
    },
    set:function(value){
        this.parent(value);
        this.currentStep = value;
    }
});