/*
---

script: epub.js

description: Main epub startup file.

requires:
 - Core/DomReady
 - More/Assets
 - Behavior/Behavior
 - Behavior/Delegator
 - Behavior/Element.Data
 - Behavior/BehaviorAPI
 - Behavior/Behavior
 - Behavior/Event.Mock
 - Behavior/Delegator
 - More/Mask
 - More-Behaviors/Delegator.AddRemoveClass
 - More-Behaviors/Behavior.FxAccordion
 - Clientcide/Behavior.Tabs

provides: [epub]

...
*/

window.onload = (function(){
	var behavior = new Behavior({
		selector: '[data-behavior]:not(.hidden .modal [data-behavior])'
	}).apply(document.body);
	var delegator = new Delegator({
		getBehavior: function(){ return behavior; }
	}).attach(document.body);

	// Prevent click events from bubbling out of Poe widgets (this prevents page turns
	// and other side effects.)
	document.body.addEvent('click:relay(.smartwidget)', function (e) {
		e.stopPropagation();

		// We prevent the default if it was not an anchor or media element that was
		// clicked; we allow default actions on these elements so that the browser
		// media controls work and links can be followed.
		if (['a', 'audio', 'video'].indexOf(e.target.tagName.toLowerCase()) === -1) e.preventDefault();
	});
});

Mask.implement({
	options: {
		useIframeShim: false
	},
	render: function(){
		//copy of render method from Mask, but the tag here is an anchor
		this.element = new Element('a', {
			'class': this.options['class'],
			id: this.options.id || 'mask-' + String.uniqueID(),
			styles: Object.merge({}, this.options.style, {
				display: 'none'
			}),
			events: {
				click: function(event){
					this.fireEvent('click', event);
					if (this.options.hideOnClick) this.hide();
				}.bind(this)
			}
		});

		this.hidden = true;
	}
});