var md = md || {};
    md.dragdrop = md.dragdrop || {}; 

md.dragdrop.Quiz = new Class({
	Implements: [Options, Events],
	options: {
		reverse: false,
		minHeight: '100px',
		score: false,
		instructions: 'Drag the answers in the right column to the corresponding items on the left.',
		shuffleQuestions: false
	},
	initialize: function (el, questionSet, options) {
		this.el = el;

		// Setup state variables.
		var questions = [];
		var answers = [];
		this.questionMapping = {};
		this.reflowable = document.body.hasClass('book-type-reflowable') && !(window.parent && window.parent.Lindgren);

		// Merge the options.
		this.setOptions(options);

		this.reflowable ? this.el.getElement('.draggable-container') : $$('body')[0];

		// Prepare the questions.
		questionSet.each(function (question) {
			// Switch question and answer if the reverse option is set.
			if (this.options.reverse) {
				var q = question.answer;
				var a = question.question;
			} else {
				var q = question.question;
				var a = question.answer;
			}

			// Add the questions and answers to our state variables.
			questions.push(q);
			answers.push(a);
			this.questionMapping[q] = a;
		}.bind(this));

		// If we have duplicate questions, show error
		if (questions.length !== questions.unique().length) {
			throw('Questions has duplicate question, There should not be any duplicate questions');
		}

		if(this.options.shuffleQuestions) {
			// Shuffle and save the prepared questions.
			this.questions = questions.shuffle();
			// Save the prepared answers.
			this.answers = answers;
		} else {
			// Save the prepared questions.
			this.questions = questions;
			// Shuffle and save the prepared answers.
			this.answers = answers.shuffle();
		}

		// Create the UI.
		this.createDOM();

		// Add the drag interaction.
		this.makeDrag();
		if (this.options.score) {
			this.incorrectAnswers = 0;
			this.correctAnswers = 0;
		}
	},
	makeDrag: function () {
		var matchingGameOptions = {
			draggables: this.el.getElements('.draggable'),
			droppables: this.el.getElements('.droppable'),
			draggablesContainer: this.reflowable ? this.el.getElement('.draggable-container') : $$('body')[0],

			correctHandler: function (draggable, droppable) {
				// Have the droppable accept the draggable.
				droppable.adopt(draggable.clone());
				// Cleanup the temporary draggable.
				draggable.destroy();

				if (this.options.score) {
					this.correctAnswers += 1;
					this.el.getElement('.dragdropquiz-correct-score').set('text', this.correctAnswers);
				}
				this.fireEvent("answerCorrect", {draggable: draggable, droppable: droppable, correctAnswers: this.correctAnswers});
			}.bind(this),
			incorrectHandler: function () {
				if (this.options.score) {
					this.incorrectAnswers += 1;
					this.el.getElement('.dragdropquiz-incorrect-score').set('text', this.incorrectAnswers);
				}
				this.fireEvent("answerIncorrect", {incorrectAnswers: this.incorrectAnswers});
			}.bind(this)
		};

		if (this.reflowable) {
			matchingGameOptions.appContainer = this.el.getElement('.dragdropquiz-container');
		}

		// Create a Matching Game to handle the drag and drop interaction.
		new md.dragdrop.MatchingGame(this.el, matchingGameOptions);
	},
	reset: function (e) {
		e.stop();
		// Reset the UI.
		this.createDOM();

		// Recreate the drag interaction.
		this.makeDrag();
		if (this.options.score) {
			this.incorrectAnswers = 0;
			this.correctAnswers = 0;
		}
	},
	createDOM: function() {
		var widgetContainer = new Element('div', {'class': 'dragdropquiz-container'}),
			instructions = new Element('div', { 'class': 'dragdropquiz-instructions', text: this.options.instructions }),
			resetButtonWrapper = new Element('div', {'class': 'dragdropquiz-reset-wrapper'}),
			resetButton = new Element('button', { 'class': 'dragdropquiz-reset btn', text: 'Reset', events: { click: this.reset.bind(this) } });

		widgetContainer.adopt(instructions);

		if (this.options.score) {
			var scoreContainer = new Element('div', { 'class': 'dragdropquiz-score' }),
				correctContainer = new Element('div', { html: '<span class="correct-label">Correct</span>' }),
				// correctScore = new Element('blockquote').adopt(new Element('small', { 'class': 'dragdropquiz-correct-score', text: '0' })),
				correctScore = new Element('div', { 'class': 'dragdropquiz-correct-score', text: '0' }),
				incorrectContainer = new Element('div', { html: '<span class="incorrect-label">Incorrect</span>' }),
				// incorrectScore = new Element('blockquote').adopt(new Element('small', { 'class': 'dragdropquiz-incorrect-score', text: '0' }));,
				incorrectScore = new Element('div', { 'class': 'dragdropquiz-incorrect-score', text: '0' });

			widgetContainer.adopt(scoreContainer.adopt(correctContainer.adopt(correctScore), incorrectContainer.adopt(incorrectScore)));
		}


		this.questionContainer = new Element('div', {'class': 'draggable-container', styles: { 'min-height': this.options.minHeight }});
		this.questions.each(function(question){
			var questionWrapper = new Element("div", {"class":"question-wrapper"});
			questionWrapper.adopt(new Element('div', {
				'class': 'draggable question chaucer smartwidget',
				'data-textid': this.questionMapping[question],
				'text': question
			}));

			this.questionContainer.adopt(questionWrapper);
		}.bind(this));

		this.answerContainer = new Element('div', {'class': 'droppable-container'});
		this.answers.each(function(answer){
			var answerText = new Element('div');
			answerText.adopt(new Element('h5', {text: answer}));

			var answerHolder = new Element('div', {
				'class': 'droppable',
				'data-textid': answer
			});
			var answerEl = new Element('div', {	'class': 'answer' });
			answerEl.adopt([answerText, answerHolder]);
			this.answerContainer.adopt(answerEl);
		}.bind(this));

		resetButtonWrapper.adopt(resetButton);
		widgetContainer.adopt(this.answerContainer, this.questionContainer, resetButtonWrapper.adopt(resetButton));

		this.el.empty();
		this.el.adopt(widgetContainer);

		// If we are in a reflowable.
		if (this.reflowable) {
			// Make the container position relative.
			widgetContainer.setStyle('position', 'relative');
			// Add a page break class to the parent.
			this.el.getParent().addClass('page-break');
		}
	}
});

md.dragdrop.StepByStepQuiz = new Class({
	Extends: md.dragdrop.Quiz,
	initialize: function(el, questionSet, options){
		this.parent(el, questionSet, options);
		this.hideQuestions();
		this.addEvent("answerCorrect", function(data){
			this.hideQuestions();
		}.bind(this));
	},
	hideQuestions: function(visibleIndex){
		// if(this.draggablesContainer == document.body) {
		// 	throw("StepByStepQuiz doesnt work with body as draggable container.")
		// }
		var draggables = this.questionContainer.getElements('.draggable');
		draggables.setStyle("display","none");
		if(draggables.length>0) {
			draggables[0].setStyle("display","block");
		}
	},
	reset: function(e){
		this.parent(e);
		this.hideQuestions();
	}
});