window._scale_container = 'body';
window._breakpoint_width = 700;
window._is_touch_device = !!('ontouchstart' in window);
window._is_small_device = navigator.userAgent.match(/(iPhone|iPod)/g);
window._is_large_device = navigator.userAgent.match(/(iPad)/g);
window._this_iframe_src = this.location.toString().split("/")[this.location.toString().split("/").length-2];
window._initiated = false;

function calculate_container_size() {
	console.log('calculate_container_size');

	var width = (window.innerWidth > 0) ? window.innerWidth : screen.width;
	
	if (window._is_touch_device) {
	   
	    width = window.parent.screen.width *2;

		if (window._is_small_device && parent == window) {	// fullscreen mode
			$$('html').setStyle('width', 700);

		}
		else if (window._is_large_device && width < 700) {	// large device fallback
			
			$$(window._scale_container)[0].removeClass('hide-content');
			
			unset_screenshot_fall_back();
			
		}
		else {	// large device without fallback
			$$(window._scale_container)[0].removeClass('hide-content');
			$$(window._scale_container)[0].getParent('html').set('style', '');

			unset_screenshot_fall_back();
		}
	}
	else if (width < window._breakpoint_width) { // desktop fallback
		
		if(!window._initiated) {
			$$(window._scale_container)[0].setStyle("opacity","0");
			
			setTimeout(function(){
				$$(window._scale_container)[0].setStyle("opacity","1");
				$$(window._scale_container)[0].addClass('hide-content');
				set_screenshot_fall_back("desktop");
			}, 2000);

		}else {
			$$(window._scale_container)[0].addClass('hide-content');
			set_screenshot_fall_back("desktop");

		}
	}
	else { // desktop without fallback
		$$(window._scale_container)[0].removeClass('hide-content');
		unset_screenshot_fall_back("desktop");
	}
}

function poll_call(condition, callback, time) {
	var _time = time != null ? time + 200 : 0;
	if (time >= 7000) {
		// poll_call timeout
		return;
	}
	if (eval(condition)) {
		// poll_call complete
		callback();
	}
	else {
		setTimeout(function() {
			poll_call(condition, callback, _time);
		}, 200);
	}
}

function get_iframe_old(src) {
	if (!src) {
		return false;
	}
	var iframes = parent.window.document.getElementsByTagName('iframe');
	for (var i = iframes.length - 1; i >= 0; i--) {
		if (iframes[i].getAttribute('src').search(src.trim()) > -1) {
			return iframes[i];
		}
	};
	return false;
}

function get_iframe(win){
    var object = {},
	    iframesOnPage = parent.window.document.querySelectorAll('iframe')
    for (var i = 0; i < iframesOnPage.length; i++){
        if(win === iframesOnPage[i].contentWindow) object = iframesOnPage[i];
    }
	return object
}

function closest(el, tag) {
    while (el) {
        if (el.tagName.toLowerCase() == tag) {
        	return el;
        }
        el = el.parentNode;
    }
}

function hasClass(el,cls) {
	return el.className.match(new RegExp('(\\s|^)'+cls+'(\\s|$)'));
}

function addClass(el,cls) {
	if (!hasClass(el,cls)) el.className += " "+cls;
}

function removeClass(el,cls) {
	if (hasClass(el,cls)) {
    	var reg = new RegExp('(\\s|^)'+cls+'(\\s|$)');
		el.className=el.className.replace(reg,' ');
	}
}

var screenshotSet = false;
function set_screenshot_fall_back(device){

	try{
		if (parent && parent!=window) {
			var el = get_iframe(window);
			if (el.getAttribute('data-is-visible') == null || el.getAttribute('data-is-visible')) {
				
				var figure = closest(el, 'figure');
				
				el.setAttribute("data-initial-height", el.getAttribute("height"));
				
				el.style.height = '1px';
				
				var url_screenshot_image = this.location.toString().split("/");
				
				delete url_screenshot_image[url_screenshot_image.length-1];

				var screenshot_element = figure.children[figure.children.length - 2];
				
				if (screenshot_element.tagName.toLowerCase() != 'div') {
					console.log("not a div")
					screenshot_element = figure.children[figure.children.length - 3];
				}

				if (typeof screenshot_element === 'undefined') {
					console.log("element undefined")
					//createScreenshot();
				} else if (screenshot_element.tagName.toLowerCase() != 'div') {
					//console.log("not a div but defined")
					if (!screenshot_element.classList.contains('fallback-screenshot')) {
						//console.log("classlist")
						//createScreenshot();
					}
				}
				//} else {
				if (!screenshotSet) {
					console.log("creating screenshot");
					screenshotSet = true;
					createScreenshot();
				}
				//}

				function createScreenshot() {
					console.log("parent image: " + document.body.getElement("img").src.split("/"));
					var imageSRC = document.body.getElement("img").src.split("/");
					imageSRC = imageSRC[imageSRC.length-1]
					console.log("imageSRC: " + imageSRC);
					screenshot_element = el;
					var img = parent.window.document.createElement('img');
					img.setAttribute('src', url_screenshot_image.join('/') + 'images/' + imageSRC);
					//img.setAttribute('src', url_screenshot_image.join('/') + 'screenshot-image.png');
					img.setAttribute('width', '100%');
					img.setStyle('max-height','570px')

					var img_wrp = parent.window.document.createElement('div');
					img_wrp.setAttribute('class', 'fallback-img-wrapper fullscreen fullscreen-gadget lightbox');
					var div = parent.window.document.createElement('div');
					div.setAttribute('class', 'fallback-screenshot ' + (device + ' ' || '') + window.call_to_action);
					img_wrp.appendChild(img);
					div.appendChild(img_wrp);
					div.inject(el);
					div.inject(figure.getElement('header'), 'after');
				}

				el.setAttribute('data-is-visible', 'false');
			}
		}
	}
	catch(ex){
		console.warn('set_screenshot_fall_back', ex);
	}
}

function unset_screenshot_fall_back(){
	screenshotSet = false;
	if (parent && parent != window) {
		var el = get_iframe(window);
		if (el.getAttribute('data-is-visible') != null && el.getAttribute('data-is-visible') == 'false') {
			var figure = closest(el, 'figure');
			// figure.setAttribute('data-screenshot-fallback', '0');
			el.parentNode.style.opacity = "1";
			el.style.height = el.getAttribute("data-initial-height") + 'px';
			var screenshot_element = figure.children[figure.children.length - 3];
			if (screenshot_element.tagName.toLowerCase() != 'div') {
				screenshot_element = figure.children[figure.children.length - 2];
				console.log("screenshot_element from not div: " + screenshot_element);
			}
			if (screenshot_element.getAttribute('class') && screenshot_element.getAttribute('class').substring(0, 'fallback-screenshot'.length) == 'fallback-screenshot') {
				console.log("screenshot_element from class: " + screenshot_element);
				screenshot_element.remove();
			}
			el.setAttribute('data-is-visible', true);
		}
	}

	reInit();
}
function insert_fall_back_content() {

		height = document.window.getHeight();

		if (window._is_touch_device) {
			//var html = "<i class='fa fa-info'></i><h2 class='fall-back-text'>This display is too small for the content to function properly. To ensure an optimal experience please view this content on a device with a larger screen.</h2>";
		}
		else {
			var html = "<i class='fa fa-info'></i><h2 class='fall-back-text'>This display is too small for the content to function properly. To ensure an optimal experience please view this content on a device with a larger screen or expand your browser window.</h2>";

			fall_back = new Element('div.fall-back-content', {
				html: html
			}).inject($$(window._scale_container)[0], 'top');

			$$(fall_back)[0].setStyles({
				"height" : height + "px",
				"line-height" : height + "px",
			});

			$$('.fall-back-text')[0].setStyles({
				"padding-top" : height /2 - 50 + "px"
			});

			injectCSS();
		}

}



/* check for touch device */

if(isTouchDevice()){
		window.call_to_action = "tap";
}else{
		window.call_to_action = "click";
}


function isTouchDevice(){
    return typeof window.ontouchstart !== 'undefined';
}

function capitaliseFirstLetter(string){
    return string.charAt(0).toUpperCase() + string.slice(1);
}


function insert_call_to_action_text(){

		for(i = 0; i < $$('.responsive-call-to-action').length; i++){

			var word = window.call_to_action;

			text = $$('.responsive-call-to-action')[i].get('html');
			character = text[0];

			if (character === character.toUpperCase()) {
					word = capitaliseFirstLetter(word);
			}

			$$('.responsive-call-to-action')[i].set('html', word);
			if(word == 'Click' && $$('.responsive-call-to-action')[i].hasClass('drag')){
                $$('.responsive-call-to-action')[i].set('html', 'Drag');
            }
		}
}

function init(){
	$$('body').addClass('loaded');
	$$('div.fall-back-content').destroy();
	calculate_container_size();
	if(!window._initiated) {
		window._initiated = true;
	}
	insert_fall_back_content();
	//insert_call_to_action_text();
}

function reInit(){

	if(document.loaded) {
	    init();
	} else {
	    if (window.addEventListener) {
	        window.addEventListener('load', init, false);
	    } else {
	        window.attachEvent('onload', init);
	    }
	}
}

window.addEvent('resize', calculate_container_size);
window.addEventListener('orientationchange', calculate_container_size);

/* Hack to call init function only once */
if(document.loaded) {
    init();
} else {
    if (window.addEventListener) {
        window.addEventListener('load', init, false);
    } else {
        window.attachEvent('onload', init);
    }
}


/* remove blue focus on mouse interaction */
window.onload = (function() {
	injectCSS();

	window.lastKey = new Date();
    window.lastClick = new Date();
	document.addEvent('focusin', function(e) {
		$$(".non-keyboard-outline").removeClass("non-keyboard-outline");
		var wasByKeyboard = lastClick < lastKey;
		if (wasByKeyboard) {
			e.target.addClass( "non-keyboard-outline");
		}
	});
	document.addEvent('click', function(){
        window.lastClick = new Date();
    });
    document.addEvent('keydown', function() {
        window.lastKey = new Date();
    });
});

function injectCSS() {
	var headTag = document.getElementsByTagName("head")[0].innerHTML;
	var newCSS = headTag + '<style type="text/css">';
	newCSS += '*:active,*:focus{outline:none;}*:active.non-keyboard-outline,*:focus.non-keyboard-outline{outline:rgba(125,173,217,0.4) solid 2px;box-shadow:0 0 6px rgb(125,173,217);}';
	newCSS += '</style>';
	document.getElementsByTagName("head")[0].innerHTML = newCSS;

	if (parent && parent != window) {
		headTag = parent.window.document.getElementsByTagName("head")[0].innerHTML;
		newCSS = headTag + '<style type="text/css">';
		newCSS += "figure .fallback-screenshot .fallback-img-wrapper:before{background:#666;content:'This display is too small for the content to function properly. To ensure an optimal experience please view this content on a device with a larger screen.';color:white;font-size:1em;position:static;display:block;z-index:1000;outline:1px solid #000;height:auto;text-align:center;line-height:1.6em;padding:10px;}figure .fallback-screenshot.desktop .fallback-img-wrapper:before{content:'This display is too small for the content to function properly. To ensure an optimal experience please widen your browser window.';}figure[data-screenshot-fallback='1'] .lc_iframeinner{display:none;}figure .fallback-screenshot.desktop.tap .fallback-img-wrapper:before{content:'This display is too small for the content to function properly. To ensure an optimal experience please widen your browser window.';}figure .fallback-screenshot.desktop.click .fallback-img-wrapper:before{content:'This display is too small for the content to function properly. To ensure an optimal experience please widen your browser window.';}figure .fallback-screenshot.desktop:after{font-size:0.9em;line-height:1.4em;padding:0.6em 0em;}figure .fallback-screenshot{border:1px solid #000;position:relative}";
		newCSS += '</style>';
		parent.window.document.getElementsByTagName("head")[0].innerHTML = newCSS;
	}
}
