window._scale_container = 'body';
window._breakpoint_width = 700;
window._is_touch_device = !!('ontouchstart' in window);
window._is_small_device = navigator.userAgent.match(/(iPhone|iPod)/g);
window._is_large_device = navigator.userAgent.match(/(iPad)/g);
window._this_iframe_src = this.location.toString().split("/")[this.location.toString().split("/").length-2];
window._current_scale = 1;
window._first_inner_height = window.innerHeight;

if(window.responsiveLibLoaded) throw new Error('already loaded');
window.responsiveLibLoaded = true;

function calculate_container_size() {
  var width = (window.innerWidth > 0) ? window.innerWidth : screen.width;
  if (window._is_touch_device) {
        try{
            var padding = parseInt(window.parent.document.getElementsByTagName("section")[0].getComputedStyle("padding").split(" ")[1]);
        }
        catch(ex){
            console.log(ex)
        }




        //alert(width);
      //width = window.parent.screen.width - padding*2
      //alert(width);
    if (window._is_small_device && parent == window) {    // full screen mode
      //console.log(1, width);
      $$('html').setStyle('width', Math.max(window._breakpoint_width, width) );
    }
    else if (window._is_large_device && width < 700) {    // large device fallback
      //console.log(2, width);
      //$$(window._scale_container)[0].removeClass('hide-content');
      /*
      $$(window._scale_container)[0].getParent('html').setStyles({
        '-webkit-transform': 'scale(' + (width / 700) + ')',
        '-webkit-transform-origin': '0 0',
        'width': width-40
      });
      */
      //unset_screenshot_fall_back();
      injectScaleCSS(width / window._breakpoint_width);
    }
    else if (window._is_small_device || width < 700) {    // small device
      //console.log(3, width);
      //$$(window._scale_container)[0].addClass('hide-content');
      injectScaleCSS(width / window._breakpoint_width);
      //poll_call('parent && parent != window && get_iframe(window._this_iframe_src)', set_screenshot_fall_back);
    }
    else {                          // large device without fallback
      //console.log(4, width);
      //$$(window._scale_container)[0].removeClass('hide-content');
      $$(window._scale_container)[0].getParent('html').set('style', '');
      //unset_screenshot_fall_back();
    }
  }
  else if (width < window._breakpoint_width) {        // desktop fallback
    //console.log(5, width);
    //$$(window._scale_container)[0].addClass('hide-content');
    //set_screenshot_fall_back("desktop");
    injectScaleCSS(width / window._breakpoint_width);
  }
  else {                            // desktop without fallback
    //console.log(6, width);
    //$$(window._scale_container)[0].removeClass('hide-content');
    //unset_screenshot_fall_back("desktop");
    unsetScaleCSS();
  }
}

var originalDragForDrag = Drag.prototype.drag;
Drag.prototype.drag = function(theEvent){
  var that = this;
  //console.log('prototype');
  originalDragForDrag.call(this, theEvent);
  var scale = window._current_scale;
  if( scale !=null && scale < 1 ){
    var relativePosition = {x: 0, y: 0};
    if(
      typeof this.element.get('data-responsive-transform-origin') === 'undefined' ||
      this.element.get('data-responsive-transform-origin') === null ||
      this.element.get('data-responsive-scale') != scale
    ){
      var parentRelative = this.element;
      do{
        parentRelative = parentRelative.getParent();
      } while(parentRelative.getStyle('position') != 'static');

      if(parentRelative!==null){
        relativePosition = parentRelative.getPosition();
        this.element.set('data-responsive-transform-origin', JSON.encode(relativePosition));
        this.element.set('data-responsive-scale', scale);
      }

    } else {
      parentRelative = JSON.decode( this.element.get('data-responsive-transform-origin') );
    }
    var cursor = {
        x : theEvent.event.x || theEvent.event.pageX || theEvent.page.x,
        y : theEvent.event.y || theEvent.event.pageY || theEvent.page.y,
      };
    var pOriginal = this.value.now,
        width = this.element.getWidth(),
        height = this.element.getHeight(),
        transform = {
          left: (cursor.x - width / 2 ) / scale,
          top: (cursor.y - parentRelative.y - height / 2 ) / scale
        }
    ;


    var ua = window.navigator.userAgent;
    var iOS = !!ua.match(/iPhone/i);
    var webkit = !!ua.match(/WebKit/i);
    var iOSSafari = iOS && webkit && !ua.match(/CriOS/i);
    var Android = !!ua.match(/Android/i);

    if(document.widgetType == 'fillInTheBlank') {

      if(iOSSafari || Android){
        var relHeight = 26;
        transform = {
          left: (cursor.x/scale - width/2 ),
          top: (cursor.y/scale - relHeight/scale -  height/scale)
        }

        if(transform.top > height) {
          transform.top = (cursor.y/scale - relHeight/scale - height/scale + 10*scale);
          // if(Android) transform.top -= relHeight;
        }
        if(transform.left > width) {
          transform.left = (cursor.x/scale - width/2/scale - 40*scale);
        }

        // if(transform.left < 0) transform.left = cursor.x + transform.left;
        if(transform.top < 0) transform.top = (relHeight - height)/scale;
      }

      else{
        // dragPlaceholder works well when dragging
        if (that.element.hasClass('input-drag-placeholder')) return;

        var diff = $$('#main-content')[0].getBoundingClientRect().top - $$('.widget-body')[0].getBoundingClientRect().top;
        transform = {
          left: (cursor.x/scale - width/2/scale),
          top: (cursor.y/scale - $$('.widget-body')[0].getBoundingClientRect().top - diff/scale  + height/2/scale)
        }


        if(transform.top > height) {
          transform.top = (cursor.y/scale  - $$('.widget-body')[0].getBoundingClientRect().top - diff/scale  + height/2/scale)
        }
        if(transform.left > width) {
          transform.left = (cursor.x/scale - width/2/scale);
        }

        // if(transform.left < 0) transform.left = cursor.x + transform.left;
        // if(transform.top < 0) transform.top = height/scale;
      }


    }

    else if(document.widgetType == 'textMap' && is_iPad){
        transform = {
            left: cursor.x - width/2,
            top: cursor.y - height
        }

    }
    else if(document.widgetType == 'imageDragAndDrop' && is_iPad){
        var relHeight = 0;
        transform = {
            left: (cursor.x/scale  - width/2 ),
            top: (cursor.y/scale - relHeight/scale -  height/scale)
        }

        if(transform.top > height) {
            transform.top = (cursor.y/scale - relHeight/scale - height/scale/0.7 );
            // if(Android) transform.top -= relHeight;
        }
        if(transform.left > width) {

            transform.left = (cursor.x/scale - width/2/scale*0.7 );
        }

        // if(transform.left < 0) transform.left = cursor.x + transform.left;
        if(transform.top < 0) transform.top = (relHeight - height)/scale;
    }

    else if(document.widgetType == 'interactiveMapComparative'){
        return
    }

    else if(document.widgetType == 'timeline'){
        return
    }

    else if(document.widgetType=='interactiveMapTimeline'){
        return
    }
    else if(document.widgetType == 'timeline'){
        return
    }
    else if(document.widgetType == 'mediaGallery'){
        return
    }
    else if (document.widgetType === 'imageOverlay') {
      return;
    }

    else{
      if(transform.left > width) {
        transform.left = (cursor.x  - this.element.getParent().getPosition().x -  width / 2 ) / scale;
      }

      if(transform.top > height) {
        transform.top = (cursor.y - this.element.getParent().getPosition().y - height / 2 ) / scale;
      }
      if(transform.left < 0)  transform.left = 0;
      if(transform.top < 0) transform.top = 0;
    }

    if(window._is_small_device && window != parent ){
        var _transform = { top : transform.top, left: transform.left }
        transform.top = (cursor.y - parentRelative.y*0 - height ) / scale;
        if(document.widgetType == 'fillInTheBlank'){
            if(iOSSafari){
                transform.top -= 50;
            }
            if(Android){
                transform.top = _transform.top
            }
        }
        if(document.widgetType == 'textMap' ){
            if(is_iPad){
                transform.top = _transform.top;
            }
            // if(iOSSafari){
            //     transform.top = _transform.top - heigh
            // }
        }
        if(document.widgetType == 'interactiveMapComparative'){
            transform= _transform
        }

    }



    //console.log(event, scale, this.element, this.element.getParent().getParent().getPosition(), parentRelative, pOriginal, width, height, transform);
    this.element.set('data-p-original', JSON.encode(pOriginal));
    this.element.setStyles(transform);
    this.element.fireEvent('onDragPositionRecalculated', transform);
  }
};

var is_iPad = navigator.userAgent.match(/iPad/i) != null;

Class.refactor(Drag,
{
    attach: function(){
        this.handles.addEvent('touchstart', this.bound.start);
        return this.previous.apply(this, arguments);
    },

    detach: function(){
        this.handles.removeEvent('touchstart', this.bound.start);
        return this.previous.apply(this, arguments);
    },

    start: function(event){
        console.log('start')

        if(document.widgetType == 'interactiveMapComparative'){
           if(event.target.hasClass('line')) return
        }

        document.body.addEvents({
            touchmove: this.bound.check,
            touchend: this.bound.cancel
        });

        this.previous.apply(this, arguments);

        event.preventDefault();
    },

    check: function(event){
        console.log('event')
        if (this.options.preventDefault) event.preventDefault();
        var distance = Math.round(Math.sqrt(Math.pow(event.page.x - this.mouse.start.x, 2) + Math.pow(event.page.y - this.mouse.start.y, 2)));
        if (distance > this.options.snap){
            this.cancel();

            if(document.widgetType == 'imageDragAndDrop' && is_iPad){

                $$('.draggable.grab').addEvents({
                    mousemove: this.bound.drag,
                    mouseup: this.bound.stop
                });
                $$('.draggable.grab').addEvents({
                    touchmove: this.bound.drag,
                    touchend: this.bound.stop
                });
            }
            else {
                this.document.addEvents({
                    mousemove: this.bound.drag,
                    mouseup: this.bound.stop
                });
                document.body.addEvents({
                    touchmove: this.bound.drag,
                    touchend: this.bound.stop
                });
            }


            this.fireEvent('start', [this.element, event]).fireEvent('snap', this.element);
        }
    },

    cancel: function(event){
        console.log('cancel')
        if(document.widgetType == 'imageDragAndDrop' && is_iPad){


            $$('.draggable.grab').removeEvents({
                touchmove: this.bound.check,
                touchend: this.bound.cancel
            });
        }
        else{
            document.body.removeEvents({
                touchmove: this.bound.check,
                touchend: this.bound.cancel
            });
        }

        return this.previous.apply(this, arguments);
    },

    stop: function(event){
        console.log('stop')
        if(document.widgetType == 'imageDragAndDrop' && is_iPad ){

            $$('.draggable.grab').removeEvents({
                touchmove: this.bound.drag,
                touchend: this.bound.stop
            });
        }
        else {
            document.body.removeEvents({
                touchmove: this.bound.drag,
                touchend: this.bound.stop
            });
        }

        return this.previous.apply(this, arguments);
    }
});

//send function to callback Stack
setTimeout(function(){
    if(document.widgetType != 'fillInTheBlank'){
        Class.refactor(Drag.Move, {
            checkDroppables: function() {
                //if scale
                var scale = window._current_scale;
                if( scale !=null && scale < 1 && window._is_small_device){

                    var overed = this.droppables.filter(function(el, i){
                        //el = el.getCoordinates(();
                        el = this.positions ? this.positions[i] : this.getDroppableCoordinates(el);
                        el.left*=scale;
                        el.right*=scale;
                        el.bottom*=scale;
                        el.top*=scale;
                        var now = this.mouse.now;
                        console.log(el, this.positions, this.droppables, now, (now.x > el.left && now.x < el.right && now.y < el.bottom && now.y > el.top) );
                        return (now.x > el.left && now.x < el.right && now.y < el.bottom && now.y > el.top);
                    }, this).getLast();

                    if (this.overed != overed){
                        if (this.overed) this.fireEvent('leave', [this.element, this.overed]);
                        if (overed) this.fireEvent('enter', [this.element, overed]);
                        this.overed = overed;
                        console.log("this.overed");
                    }

                } else {
                    var a = this.droppables.filter(function(d, c) {
                        d = this.positions ? this.positions[c] : this.getDroppableCoordinates(d);
                        var b = this.mouse.now;
                        return ( b.x > d.left && b.x < d.right && b.y < d.bottom && b.y > d.top) ;
                    }, this).getLast();
                    if (this.overed != a) {
                        if (this.overed) {
                            this.fireEvent("leave", [this.element, this.overed]);
                        }
                        if (a) {
                            this.fireEvent("enter", [this.element, a]);
                        }
                        this.overed = a;
                    }
                }

            }
        })
    }
}, 0)



function injectScaleCSS(ratio){
  if(ratio>1)ratio=1;
  //ratio = ratio.toFixed(2);
  window._current_scale = ratio;
  $$("body")[0].setStyles({
    //"zoom": ratio,
    "transform": "scale("+ratio+")",
    "transform-origin":"0 0",
    "-ms-transform": "scale("+ratio+")",
    "-ms-transform-origin":"0 0",
    "-moz-transform": "scale("+ratio+")",
    "-moz-transform-origin": "0 0",
    "-o-transform": "scale("+ratio+")",
    "-o-transform-origin": "0 0",
    "-webkit-transform": "scale("+ratio+")",
    "-webkit-transform-origin": "0 0",
    "min-width": window._breakpoint_width+"px",
    "min-height": '100vh'
  });

  if(window.d3Objects){
    window.d3Objects.forEach(function(obj){
      obj.update();
    });
  }
  // console.log("body scaled height", $$('body')[0].getBoundingClientRect().height);
  // console.log("body scaled width", $$('body')[0].getBoundingClientRect().width);
  // console.log("text scaled height", $$('[data-next="scenario_7839"] .text')[0].getBoundingClientRect().height);
  // console.log("text scaled width", $$('[data-next="scenario_7839"] .text')[0].getBoundingClientRect().width);

  var ua = window.navigator.userAgent;
  var Android = !!ua.match(/Android/i);
  var iOS = !!ua.match(/iPhone/i);
  var webkit = !!ua.match(/WebKit/i);
  var iOSSafari = iOS && webkit && !ua.match(/CriOS/i);
  var is_iPad = ua.match(/iPad/i) != null;
  var widgetType = document.widgetType || $$('#MetrodigiWidget').get('data-xml-type')[0];

  if(iOSSafari){

    if($$('#MetrodigiWidget').get('data-xml-type')[0] == "adaptive_scenario"){

      var contentMinHeight = $$('.widget-content')[0].getBoundingClientRect().height
      $$('.widget-content').setStyles({
        'min-height': contentMinHeight
      })

      $$('#intro:not(.resized)').setStyles({
          //   'font-size': '65%',
          'line-height': '160%'
      });

      $$('#intro:not(.resized)').addClass('resized')

      $$('.segment .media img').setStyles({
          //350 due css rule
          'max-height': 350*0.60+ 'px'
      })

      document.resizeSegments = new CustomEvent('resizeSegments');
      document.addEventListener('resizeSegments', function() {

          $$('.segment.showed:not(.resized)').setStyles({
              'font-size': '60%',
              'line-height': '160%'
          });

          $$('.segment.choices.showed:not(.resized) .title').setStyles({
              'font-size': 100 * (1 + ratio) + '%'
          })

          $$('.segment.showed:not(.resized)').addClass('resized')
      })

    }

    if($$('#MetrodigiWidget').get('data-xml-type')[0] == "Open"){
      $$('.item:not(".intro")').setStyles({
        "-webkit-transform": "scale(0.7)",
        "-webkit-transform-origin": "0 0",
        // "background": "red",
        // "width": "875px"
        "width": "942px"
      })

      $$('.results').setStyles({
        "-webkit-transform": "scale(0.7)",
        "-webkit-transform-origin": "0 0",
        // "background": "red",
        // "width": "934px"
        width: "1000px"
      })

    }

    if (widgetType == 'T / F' || widgetType == 'Open' || widgetType == 'Likert') {
        if(!document.resizeQuestionsCalled){
            document.resizeQuestionsCalled = +new Date();
        }else{
            if( (+new Date() - document.resizeQuestionsCalled) > 700){
                console.log("too fast, double lib load")
                return false;
            }
        }
        document.resizeQuestions = new CustomEvent('resizeQuestions');


        function resizeQuestions(e){

            $$('.question').map(function(question){


                setTimeout(function(){

                    question.getSiblings().map(function(div){

                        div.setStyles({
                            "-webkit-transform": "scale(0.75)",
                            "-webkit-transform-origin": "0 0"
                        });

                        div.getChildren('label').setStyles({
                            'font-size': 10 +'px'
                        })
                    });

                },0)



              if(question.getBoundingClientRect().width >= 192){

                question.addClass('resized');
                question.setStyles({
                  // background: 'red',
                  // "-webkit-transform": "scale(0.75)",
                  // "-webkit-transform-origin": "0 0",
                    'font-size': 8.4 + 'px',
                    'width': '100%',
                  'margin-bottom': '5px'
                })

              }
            });
            document.questionsLoaded = true;
        }

      document.addEventListener('resizeQuestions', resizeQuestions);

      document.unResizeQuestions = new CustomEvent('unResizeQuestions');
      document.addEventListener('unResizeQuestions', function(){
          document.unResizedQuestionsCalled = true;
          // $$('.alert')[0].setStyles({
          //     // background: 'red',
          //     "-webkit-transform": "scale(1)",
          //     "-webkit-transform-origin": "0 0"
          // })
          $$('.resized').setStyles({
              'font-size':  14.01 + 'px',
              // "-webkit-transform": "scale(1)",
              // "-webkit-transform-origin": "0 0",
              'margin-bottom': '5px'
          })

      })


      document.resizeQuestionsOnAlert =new CustomEvent('resizeQuestionsOnAlert');
      document.addEventListener('resizeQuestionsOnAlert', function() {
          if(!document.unResizedQuestionsCalled){
              $$('.resized').setStyles({
                  // "-webkit-transform": "scale(0.75)",
                  // "-webkit-transform-origin": "0 0",
                  'font-size':  8.4 + 'px',
                  'width': '100%',
                  'margin-bottom': '5px'
              })
          }



      });

      document.resizeQuestionsOnAlertOff =new CustomEvent('resizeQuestionsOnAlertOff');

      document.addEventListener('resizeQuestionsOnAlertOff', function() {

        setTimeout(function(){ //it magically fix font size after resizing on alert. Not kidding
            $$('.resized')[0].click();
        }, 0)

        if(!document.unResizedQuestionsCalled){
            $$('.resized').map(function(question){

                question.setStyles({
                    // background: 'red',
                    'font-size': 8.4 + 'px',
                    //   'width': '100%'
                    // "-webkit-transform-origin": "0 0",
                    // 'margin-bottom': '5px'
                })
            })
        }
        else{
            $$('.resized').map(function(question){

                question.setStyles({
                    // background: 'red',
                    'font-size': 14.001 + 'px',
                    //   'width': '100%'
                    // "-webkit-transform-origin": "0 0",
                    // 'margin-bottom': '5px'
                })
            })
        }
      });


      document.resizeResults = new CustomEvent('resizeResults');
      document.addEventListener('resizeResults', function() {

        var resultQuestions = $$('.results .question-wrapper').getChildren('p');
        if(resultQuestions.length){
          resultQuestions.map(function(_question){
            _question.setStyles({
              "margin-left": '15px',
              transform: 'scale(0.75)',
              "transform-origin": "0 0",
              width: '700px'
            })
          })
        }

        $$('.scam-questions-resume-item').setStyles({
          transform: 'scale(0.7)',
          "transform-origin": "0 0",
          width: '977px'
        })
      });
    }


    if(document.widgetType == 'interactiveMapComparative'){

    }
    if (document.widgetType == 'tabsAccordion') {
      var isMac = navigator.platform.match(/(Mac)/i) ? true : false;

      // only if safari mobile
      if (iOSSafari && !isMac) {
        var paragraphsContainer = $$('.tab-accordion-entry .md-data-set-item>div:not(.md-placeholder)');
        paragraphsContainer.setStyles({
          "-webkit-transform": "scale(0.7)",
          "-webkit-transform-origin": "0 0"
        })

        paragraphsContainer.getChildren('p').map(function(elem){
          elem.setStyles({
            width: '915px' //915
          })
        })

        // HACK: prevent the accordion tabs to run off the screen
        $$(paragraphsContainer).getParent().setStyles({
          width: '0px'
        });
      }
    }

    if(document.widgetType == 'weightedAdaptiveScenarios'){

        function resizeWeightedAdaptiveScenarios(){
            var paragraph = $$('.widget-content .scenario p:not(.visually-hidden, .title)');

            var diffHeight = paragraph[0].offsetHeight * 0.3;

            paragraph[0].setStyles({
                "-webkit-transform": "scale(0.7)",
                "-webkit-transform-origin": "0 0",
                // background: 'red',
                width: '971px',
                'margin-bottom': '-'+ (diffHeight - 20) + 'px'

            })

            var title = $$('.widget-content .scenario p.title, .choices');

            title[0].setStyles({
                "-webkit-transform": "scale(0.7)",
                "-webkit-transform-origin": "0 0",
                // background: 'red',
                width: '971px'
            })

        }
        resizeWeightedAdaptiveScenarios();

        document.resizeWidget = new CustomEvent('resizeWidget');
        document.addEventListener('resizeWidget', resizeWeightedAdaptiveScenarios)


    }

    if(document.widgetType == 'fillInTheBlank') {
          // iOSSafari
          injectFITBSharedStyles(ratio);
          injectFITBSharedAndroidIosStyles(ratio);
    }

    if (document.widgetType === 'tabsAccordion') {
      // iOSSafari
      if ((window.screen.availWidth === 375 && window.screen.availHeight === 667) ||
        window.screen.availWidth === 414 && window.screen.availHeight === 736) {
        // iphone 6 | 6s | 6 plus | 6s plus

        // fix headers scale
        // TODO: try other solution with meta viewport
        $$('.tab-entry-title span').set('style', 'font-size: 8px; line-height: 1.3;');
      }
    }
  }

  if(Android){

      if(document.widgetType == 'fillInTheBlank') {
          // Android
          injectFITBSharedStyles(ratio);
          injectFITBSharedAndroidIosStyles(ratio);
          injectFITBSharedNotIosStyles(ratio);

          setTimeout(function(){
              $$('#word-list li').map(function(li){
                  var top = Number(li.get('data-top')) + 5.5/ratio;
                  li.setStyles({
                      top:  top + 'px'
                  })
                  li.set('data-top', top)
              })
          },100)
      }

      if($$('#MetrodigiWidget').get('data-xml-type')[0] == "adaptive_scenario"){

          $$('.segment .media img').setStyles({
              //350 due css rule
              'max-height': 350*0.85+ 'px'
          })

      }
  }

  if(document.widgetType == 'assessableTable'){
        setTimeout(resizeAssesableTable, 0);

        function resizeAssesableTable(i){
            // update ratio
            var ratio = window._current_scale;

            // hold bottom button bar position
            var widgetFooterHeight = document.querySelector('#footer').getBoundingClientRect().height;
            $$('#footer').setStyles({
                bottom: 'auto',
                // avoid body 3d transform
                // calculate window height one time to prevent infinite window resize
                top: (window._first_inner_height - widgetFooterHeight) * (1 / ratio) + 'px'
            });

            function resizeDragables(){
                // update ratio
                var ratio = window._current_scale;

                var prevHeight = Number($('top-table').style.height.split('px')[0]);
                $$('#top-table').setStyle('height', 'auto');

                if (iOS || Android) {
                    $('top-table').style.height = $('top-table').getHeight() * ratio + 'px'
                }

                var width = window.innerWidth / ratio;
                var height = $$('body')[0].getBoundingClientRect().height / ratio;

                $$('#assessment-area').setStyles({
                    width: width  - 40,
                    // width: '100vw',
                    // height: 'calc(100vh - '+ (39 + 26 * ratio) + 'px)'
                    // height: height - (26*ratio)
                });

                if (!iOS) {
                    $$('#assessment-area').setStyles({
                        height: (window._first_inner_height / ratio) - (122 / ratio)
                    });
                }




                $$('.challenge #top-table .cell').setStyles({
                    height: 40 * ratio + 'px', //CSS
                    padding: 10 * ratio + 'px' //CSS
                })

                $$('.challenge #table-container').setStyles({
                    // height: '628px',
                    width: (width - 40) * ratio,
                    '-webkit-transform': 'scale(' + (1/ratio) + ')',
                    '-webkit-transform-origin': '0px 0px 0px'
                })

                $$('.challenge #top-table-container').setStyles({
                    'margin-bottom': 10 * ratio +'px'
                })
                $$('.challenge #top-table .cell:not(.is-assessable)').setStyles({
                    'line-height': '150%',
                    'font-size' :  ratio* 100 + '%'
                })

                $$('.challenge #top-table .cell.is-assessable)').setStyles({
                    'line-height': '150%',
                    'font-size' :   (ratio*100)+5 + '%'
                })

                $$('#top-table .cell .content').setStyles({
                    'max-height' : 150 * ratio + 'px'  //CSS - relative
                })

                $$('#bottom-table .redips-drag').map(function(drag){
                    var height;
                    // var lineHeight = drag.getElement('p').getComputedStyle('line-height').replace('px','');
                    // var threeLines = lineHeight*3;

                    if(drag.clientHeight < drag.scrollHeight){
                        height = drag.offsetHeight*ratio*2.5 + 'px';
                    } else{
                        if(is_iPad){
                            height = (drag.offsetHeight) *ratio* 0.6 + 'px';
                        }else{
                            height = 0;
                        }


                    }
                    drag.setStyles({
                        height: 'auto',
                        'font-size': ratio*100 + '%',
                        'line-height': (1 + ratio )*100 + '%'
                    })
                })
                $$('.redips-drag').addClass('responsive')

                $$('#top-table-caption').setStyles({
                    'font-size': ratio*100 + '%',
                    'line-height' : '150%',
                    'min-height': 20 * ratio + 'px',
                    'margin-bottom': 10 + ratio + 'px'
                })


                $$('#top-table .title').setStyles({
                    height: 30 * ratio + 'px',
                    'font-size' : ratio*100 + '%'
                })

                $$('#top-table .cell.media img, audio, video, #top-table .cell img').setStyles({
                    'max-height': 200 * ratio*0.4 + 'px'
                })

                $$('#bottom-table .content').setStyles({
                    'min-height': 37*0.5/ratio  + 'px'
                })

                $$('#bottom-table td').setStyles({
                    height: 'auto'
                })
            }

            resizeDragables();

            if (!window._resizeDragables) {
              window._resizeDragables = resizeDragables;
              document.resizeDraggable = new CustomEvent('resizeDraggable');
            }

            document.removeEventListener('resizeDraggable', window._resizeDragables);
            document.addEventListener('resizeDraggable', window._resizeDragables);
        }
    }

  if(is_iPad){

      if(document.widgetType == 'textMap'){

          document.resizeWidget = new CustomEvent('resizeWidget');
          document.addEventListener('resizeWidget', function(){
              var newWidth = 670*ratio;
              var newHeight = 500*ratio;

              $$('.quiz-mode')[0].setStyles({
                  'width' : newWidth,
                  'height': newHeight,
                  '-webkit-transform': 'scale(' + 1/ratio + ')',
                  '-webkit-transform-origin' : '0px 0px 0px',
                  'font-size': ratio * 100 + '%'
              })

              $$('.entry-element').map(function(entry){

                  var width = entry.getBoundingClientRect().width;
                  var height = entry.getBoundingClientRect().height;
                  entry.setStyles({
                      'max-width': 300* ratio ,
                      // height: height * ratio * ratio,
                      padding: 15 * ratio * ratio,
                      'margin-bottom': 5 * ratio
                  })
                  entry.addClass('resized')
              })

              $$('.description-wrapper').setStyles({
                  'padding': 15 * ratio * ratio,
                  'min-height': 70 * ratio * ratio,
                  'min-width': 150 * ratio,
                  'max-width': 300 * ratio,
              })

              var canvasWrapper = $$('canvas.canvas-wrapper')[0]
              var canvasWidth = canvasWrapper.get('width')
              var canvasHeight = canvasWrapper.get('height')
              canvasWrapper.set('width', canvasWidth);
              canvasWrapper.set('height', canvasHeight);

              var draggable = $$('.draggable.grab')[0];
              draggable.setStyles({
                  top: draggable.style.top.replace('px', '') * ratio,
                  left: draggable.style.left.replace('px', '') * ratio
              })

          })
      }
  }
  //iOS & Android
  if(iOSSafari || Android){


    if(document.widgetType == 'imageOverlay'){


      setTimeout(function(){
        var wrapper = $$('.imagemap-wrapper')[0];
        if(wrapper.offsetWidth == wrapper.getElement('img').offsetWidth){
          var wrapperRatio = ratio;
          var imageRatio = ratio/0.9
          wrapper.setStyles({
            width: wrapper.offsetWidth/wrapperRatio
          })
          var imageStyle = {
            width: wrapper.getElement('img').offsetWidth/imageRatio,
            height: wrapper.getElement('img').height/imageRatio,
            margin: 'auto'
          }
          $$('img, .overlays').setStyles(imageStyle);
          $$('.image-area').setStyles({
           'max-width': 'calc((100%/'+ ratio +  ') - 160px)'
          })

        }
      },200)

    }
    setTimeout(function(){
      if(document.widgetType == 'timeline'){
        document.resizePopUp = new CustomEvent('resizePopUp');
        document.addEventListener('resizePopUp', function(){
          // var popupStyle = window.getComputedStyle($$('.event-popup')[0])
          // var minHeight = popupStyle['min-height'].replace('px','');
          // var minWidth = popupStyle['min-height'].replace('px','');;
          // $$('.timeline-container .event-popup').setStyles({
          //   // 'min-height': minHeight*ratio + 'px',
          //   // 'min-width':  minWidth*ratio+ 'px',
          //   '-webkit-transform': 'scale('+ ratio +')'
          // })
        })
      }
    }, 200)

  }
  else{
    if(document.widgetType == 'fillInTheBlank') {
      // not iOS || Android
      injectFITBSharedStyles(ratio);
      injectFITBSharedNotIosStyles(ratio);

      setTimeout(function(){
        var yAxis = ($('main-content').getBoundingClientRect().top - 100 * ratio);

        $$('#word-bank label, #word-bank h2').setStyles({
          '-webkit-transform-origin' : '0px ' + yAxis > 0 ? '-' + yAxis : yAxis  + 'px 0px'
        })
      }, 0);
    }
  }

  if (widgetType == 'T / F' || widgetType == 'Open' || widgetType == 'Likert') {
    // hold bottom button bar position
    var widgetFooterHeight = document.querySelector('.widget-footer').getBoundingClientRect().height;
    $$('.widget-footer').setStyles({
      bottom: 'auto',
      top: (window.innerHeight - widgetFooterHeight) * (1/ratio) + 'px'
    });

    injectSISharedStyles(ratio);
  }
}
function unsetScaleCSS(){
  var ratio = 1;
  var widgetType = document.widgetType || $$('#MetrodigiWidget').get('data-xml-type')[0];
  window._current_scale = null;
  $$("body")[0].set('style', '');

  if(document.widgetType == 'fillInTheBlank') {
    // unset responsive styles
    $$('.widget-body, .widget-content, .widget-header, .widget-footer, #main-content, #main-content label, #word-bank label, #word-bank h2')
      .set('style', '');

    // remove only responsive styles
    $$('#word-bank').setStyles({
      float: '',
      'margin-right': '',
      'margin-left': ''
    });

    if (window.data && !window.data.sameWordsLength) {
      $$('input.processed').forEach(function (el) {
        // remove input responsive styles
        el.setStyles({
          'max-width': '',
          'font-size': ''
        });

        setTimeout(function () {
          // restore initial width
          var initialWidth = el.getBoundingClientRect().width;
          el.parentElement.setStyles({
            'width': initialWidth + 'px',
            'min-width': initialWidth + 'px'
          })

          var dragPlaceholder = $$(el).getNext('.input-drag-placeholder');

          if (dragPlaceholder[0]) {
            dragPlaceholder[0].setStyle('width', el.getSize().x);
          }
        }, 0);
      })
    }

    $$('#main-content .input-drag-placeholder').setStyles({
      'font-size': ''
    });

    // set work bank default styles
    $$('#word-bank').setStyles({
      float: '',
      'margin-right': '',
      'margin-left': ''
    });

    // set work list default styles
    var defaultLeft = 539;
    $$('#word-list li').setStyles({
      left: defaultLeft + 'px'
    });
    $$('#word-list li').set('data-left', defaultLeft);
    var defaultTop = 38;
    $("word-list").getElements("> li").forEach(function (li) {
      li.setStyles({
        'top': defaultTop+'px',

        // remove styles
        'transform-origin': '',
        'transform': '',
        'font-size': '',
        'margin': '',
      });

      var li_size = li.getSize();

      li.set('data-top', li.getStyle('top').toInt());
      defaultTop += li_size.y + 5;
    });
  }

  if (document.widgetType === 'tabsAccordion') {
    $$('.tab-entry-title span').set('style', null);
  }

  if (document.widgetType == 'assessableTable') {
    document.removeEventListener('resizeDraggable', window._resizeDragables);
    // $('top-table').style.height = null;

    $$('#footer').setStyles({
      bottom: null,
      top: null
    });

    $$('#assessment-area').setStyles({
      width: null,
      // height: null
    });

    $$('#top-table .cell').set('style', null);

    $$('#table-container').set('style', null);

    $$('.challenge #top-table-container').set('style', null);

    $$('.challenge #top-table .cell:not(.is-assessable)').set('style', null);

    $$('.challenge #top-table .cell.is-assessable)').set('style', null);

    $$('#top-table .cell .content').set('style', null);

    $$('#bottom-table .redips-drag').setStyles({
      // height: 'auto',
      'font-size': null,
      'line-height': null
    });

    $$('.redips-drag').removeClass('responsive');

    $$('#top-table-caption').set('style', null);

    $$('#top-table .title').setStyles({
      'height': null,
      'font-size': null
    });

    $$('#top-table .cell.media img, audio, video, #top-table .cell img').set('style', null);

    $$('#bottom-table .content').setStyles({
      'min-height': null
    });

    $$('#bottom-table td').set('style', null);
  }

  if (widgetType == 'T / F' || widgetType == 'Open' || widgetType == 'Likert') {
    // undo bottom button bar responsive styles
    $$('.widget-footer').set('style', null);

    injectSISharedStyles(ratio);
  }
}

function poll_call(condition, callback, time) {
  var _time = time != null ? time + 200 : 0;
  if (time >= 7000) {
    // poll_call timeout
    return;
  }
  if (eval(condition)) {
    // poll_call complete
    callback();
  }
  else {
    setTimeout(function() {
      poll_call(condition, callback, _time);
    }, 200);
  }
}

function get_iframe_old(src) {
  if (!src) {
    return false;
  }
  var iframes = parent.window.document.getElementsByTagName('iframe');
  for (var i = iframes.length - 1; i >= 0; i--) {
    if (iframes[i].getAttribute('src').search(src.trim()) > -1) {
      return iframes[i];
    }
  };
  return false;
}

function get_iframe(win){
    var object = {},
      iframesOnPage = parent.window.document.querySelectorAll('iframe')
    for (var i = 0; i < iframesOnPage.length; i++){
        if(win === iframesOnPage[i].contentWindow) object = iframesOnPage[i];
    }
  return object
}

function closest(el, tag) {
    while (el) {
        if (el.tagName.toLowerCase() == tag) {
          return el;
        }
        el = el.parentNode;
    }
}

function hasClass(el,cls) {
  return el.className.match(new RegExp('(\\s|^)'+cls+'(\\s|$)'));
}

function addClass(el,cls) {
  if (!hasClass(el,cls)) el.className += " "+cls;
}

function removeClass(el,cls) {
  if (hasClass(el,cls)) {
      var reg = new RegExp('(\\s|^)'+cls+'(\\s|$)');
    el.className=el.className.replace(reg,' ');
  }
}

function set_screenshot_fall_back(device){
  try{
    if (parent && parent!=window) {
      var el = get_iframe(window);
      if (el.getAttribute('data-is-visible') == null || el.getAttribute('data-is-visible')) {
        var figure = closest(el, 'figure');
        // figure.setAttribute('data-screenshot-fallback', '1');
        el.setAttribute("data-initial-height", el.getAttribute("height"));
        el.parentNode.style.opacity = "0";
        el.style.height = '1px';
        var url_screenshot_image = this.location.toString().split("/");
        delete url_screenshot_image[url_screenshot_image.length-1];

        var screenshot_element = figure.children[figure.children.length - 1];
        if (screenshot_element.tagName != 'div') {
          screenshot_element = figure.children[figure.children.length - 2];
        }
        if (screenshot_element.getAttribute('class').substring(0, 'fallback-screenshot'.length) != 'fallback-screenshot') {
          var img = parent.window.document.createElement('img');
          img.setAttribute('src', url_screenshot_image.join('/') + 'screenshot-image.png');
          img.setAttribute('width', '100%');
          var img_wrp = parent.window.document.createElement('div');
          img_wrp.setAttribute('class', 'fallback-img-wrapper fullscreen fullscreen-gadget lightbox');
          var div = parent.window.document.createElement('div');
          div.setAttribute('class', 'fallback-screenshot ' + (device + ' ' || '') + window.call_to_action);
          img_wrp.appendChild(img);
          div.appendChild(img_wrp);
          if ( figure.getElementsByTagName('figcaption') ) {
            figure.insertBefore(div,figure.getElementsByTagName('figcaption')[0]);
          } else {
            figure.appendChild(div);
          }
          // el.after('<div class="fallback-screenshot ' + (device || '') + ' ' + window.call_to_action + '"><a href="'+this.location+'" class="fullscreen fullscreen-gadget lightbox" data-fullscreen="gadget"><img src="'+url_screenshot_image.join('/') + 'screenshot-image.png" width="100%"/></a></div>');
        }
        el.setAttribute('data-is-visible', 'false');
      }
    }
  }
  catch(ex){
    console.warn('set_screenshot_fall_back', ex);
  }
}

function unset_screenshot_fall_back(){
  if (parent && parent != window) {
    var el = get_iframe(window);
    if (el.getAttribute('data-is-visible') != null && el.getAttribute('data-is-visible') == 'false') {
      var figure = closest(el, 'figure');
      // figure.setAttribute('data-screenshot-fallback', '0');
      el.parentNode.style.opacity = "1";
      el.style.height = el.getAttribute("data-initial-height") + 'px';
      var screenshot_element = figure.children[figure.children.length - 1];
      if (screenshot_element.tagName != 'div') {
        screenshot_element = figure.children[figure.children.length - 2];
      }
      if (screenshot_element.getAttribute('class').substring(0, 'fallback-screenshot'.length) == 'fallback-screenshot') {
        screenshot_element.remove();
      }
      el.setAttribute('data-is-visible', true);
    }
  }
}
function insert_fall_back_content() {
    height = document.window.getHeight();
    if (window._is_touch_device) {
      var html = "<i class='fa fa-info'></i><h2 class='fall-back-text'>This display is too small for the content to function properly. To ensure an optimal experience please view this content on a device with a larger screen.</h2>";
    }
    else {
      var html = "<i class='fa fa-info'></i><h2 class='fall-back-text'>This display is too small for the content to function properly. To ensure an optimal experience please view this content on a device with a larger screen or expand your browser window.</h2>";
    }
    fall_back = new Element('div.fall-back-content', {
        html: html
    }).inject($$(window._scale_container)[0], 'top');

    $$(fall_back)[0].setStyles({
      "height" : height + "px",
      "line-height" : height + "px",
    });

    $$('.fall-back-text')[0].setStyles({
      "padding-top" : height /2 - 50 + "px"
    });


}



/* check for touch device */

if(isTouchDevice()){
    window.call_to_action = "tap";
}else{
    window.call_to_action = "click";
}


function isTouchDevice(){
    return typeof window.ontouchstart !== 'undefined';
}

function capitaliseFirstLetter(string){
    return string.charAt(0).toUpperCase() + string.slice(1);
}


function insert_call_to_action_text(){

    for(i = 0; i < $$('.responsive-call-to-action').length; i++){

      var word = window.call_to_action;

      text = $$('.responsive-call-to-action')[i].get('html');
      character = text[0];

      if (character === character.toUpperCase()) {
          word = capitaliseFirstLetter(word);
      }

      $$('.responsive-call-to-action')[i].set('html', word);
      if(word == 'Click' && $$('.responsive-call-to-action')[i].hasClass('drag')){
                $$('.responsive-call-to-action')[i].set('html', 'Drag');
            }
    }
}

// source: https://gist.github.com/nmsdvid/8807205#file-new_gist_file-js-L6
function debounce(func, wait, immediate) {
  var timeout;
  return function () {
    var context = this, args = arguments;
    clearTimeout(timeout);
    timeout = setTimeout(function () {
      timeout = null;
      if (!immediate) func.apply(context, args);
    }, wait);
    if (immediate && !timeout) func.apply(context, args);
  };
}

function init(e){
  e.stopPropagation();

  $$('body').addClass('loaded');
  $$('div.fall-back-content').destroy();
  calculate_container_size();
  //insert_fall_back_content();
  //insert_call_to_action_text();
}

window.addEvent('domready', function () {
  setTimeout(function () {
    calculate_container_size();
  }, 0);
});

if (document.widgetType == 'assessableTable') {
  window.addEventListener("load", function (event) {
    calculate_container_size();
  });

  window.addEvent('resize', debounce(calculate_container_size, 100));
} else {
  window.addEvent('resize', calculate_container_size);
}
window.addEventListener('orientationchange', calculate_container_size);

/* Hack to call init function only once */
if(document.loaded) {
    init();
} else {
    if (window.addEventListener) {
        window.addEventListener('load', init, false);
    } else {
        window.attachEvent('onload', init);
    }
}


/* remove blue focus on mouse interaction */
window.addEvent('domready', function() {
  injectCSS();

  window.lastKey = new Date();
  window.lastClick = new Date();
  document.addEvent('focusin', function(e) {
    $$(".non-keyboard-outline").removeClass("non-keyboard-outline");
    var wasByKeyboard = lastClick < lastKey;
    if (wasByKeyboard) {
      e.target.addClass( "non-keyboard-outline");
    }
  });
  document.addEvent('click', function(){
        window.lastClick = new Date();
    });
    document.addEvent('keydown', function() {
        window.lastKey = new Date();
    });
});

function injectCSS() {
  var headTag = document.getElementsByTagName("head")[0].innerHTML;
  var newCSS = headTag + '<style type="text/css">';
  newCSS += '*:active,*:focus{outline:none;}*:active.non-keyboard-outline,*:focus.non-keyboard-outline{outline:rgba(125,173,217,0.4) solid 2px;box-shadow:0 0 6px rgb(125,173,217);}';
  newCSS += '</style>';
  document.getElementsByTagName("head")[0].innerHTML = newCSS;

  if (parent && parent != window) {
    try{
        headTag = parent.window.document.getElementsByTagName("head")[0].innerHTML;
        newCSS = headTag + '<style type="text/css">';
        newCSS += "figure .fallback-screenshot .fallback-img-wrapper:before{background:#666;content:'This display is too small for the content to function properly. To ensure an optimal experience please view this content on a device with a larger screen.';color:white;font-size:1em;position:static;display:block;z-index:1000;outline:1px solid #000;height:auto;text-align:center;line-height:1.6em;padding:10px;}figure .fallback-screenshot.desktop .fallback-img-wrapper:before{content:'This display is too small for the content to function properly. To ensure an optimal experience please widen your browser window.';}figure[data-screenshot-fallback='1'] .lc_iframeinner{display:none;}figure .fallback-screenshot.desktop.tap .fallback-img-wrapper:before{content:'This display is too small for the content to function properly. To ensure an optimal experience please widen your browser window.';}figure .fallback-screenshot.desktop.click .fallback-img-wrapper:before{content:'This display is too small for the content to function properly. To ensure an optimal experience please widen your browser window.';}figure .fallback-screenshot.desktop:after{font-size:0.9em;line-height:1.4em;padding:0.6em 5em;}figure .fallback-screenshot{border:1px solid #000;position:relative}";
        newCSS += '</style>';

        parent.window.document.getElementsByTagName("head")[0].innerHTML = newCSS;
    }
    catch(e){

    }

  }
}

/**
 * Shared SurveyInventory responsive styles
 */
function injectSISharedStyles (ratio) {
  // make content scrollable
  var widgetHeaderBCR = document.querySelector('.widget-header').getBoundingClientRect();
  var widgetFooterBCR = document.querySelector('.widget-footer').getBoundingClientRect();
  var windowHeight = window.innerHeight;
  $$('.widget-content')[0].setStyles({
    'height': ((windowHeight - widgetHeaderBCR.height - widgetFooterBCR.height) * (1 / ratio)) + 'px',
    'overflow-y': 'scroll',
    'min-height': 'initial',
    'max-height': 'initial'
  });
}

/**
 * Shared FillInTheBlank responsive styles
 */
function injectFITBSharedStyles (ratio) {
  if (window.data && !window.data.sameWordsLength) {
    // fix inputs width
    setTimeout(function functionName() {
      $$('.blank-wrapper .processed').forEach(function (inputEl) {
        var inputWidth = inputEl.getBoundingClientRect().width;
        if (inputWidth === 0) {
          return;
        }
        var dragPlaceholder = $$(inputEl).getNext('.input-drag-placeholder');
        inputEl.parentElement.setStyles({
          width: 2 + inputWidth + 'px',
          'min-width': 2 + inputWidth + 'px'
        });

        inputEl.setStyles({
          'max-width': 2 + inputWidth + 'px'
        });

        dragPlaceholder.setStyle('width', inputEl.getSize().x);
      });
    }, 0);
  }

  // avoid the bottom of the contents from being cut
  $$('.widget-body').setStyle('overflow', 'initial');

  // hold bottom button bar position
  var widgetFooterHeight = document.querySelector('.widget-footer').getBoundingClientRect().height;
  $$('.widget-footer').setStyles({
    bottom: 'auto',

    // avoid body 3d transform
    top: (window.innerHeight - widgetFooterHeight) * (1/ratio) + 'px'
  });

  $$('.MetrodigiWidget .widget-header').setStyles({
    'padding' : 13 * ratio + 'px '+ 15 * ratio + 'px 0',
    'width' : 670 * ratio+ 'px',
    'font-size': ratio * 100 + '%',

    // avoid body 3d transform
    '-webkit-transform': 'scale(' + 1/ratio + ')',
    '-webkit-transform-origin' : '0px 0px 0px'
  });

  $$('.widget-content').setStyles({
    'padding-bottom': 24 * ratio + 'px',
    'min-height': 476 * ratio + 'px'
  });

  $$('.MetrodigiWidget .widget-body').setStyles({
    'padding' : 13 * ratio + 'px '+ 15 * ratio + 'px',
    // 'padding-top': 13 + 13/ratio + 'px',
  });

  $$('#word-list li').setStyles({
    'width': $$('#word-bank').getSize()[0].x,
    'margin': 5 * ratio + 'px ' + 10 * ratio + 'px ' + 5 * ratio + 'px ' + 40 * ratio + 'px',
    'font-size': ratio * 100 + '%',
    '-webkit-transform': 'scale(' + 1/ratio + ')',
    '-webkit-transform-origin' : '0px 0px 0px'
  });

  $('main-content').setStyles({
    width: 500 * ratio + 'px',
    height: ratio * 100 + '%',
    padding: 5 * ratio + 'px',
    '-webkit-transform': 'scale(' + 1/ratio + ')',
    '-webkit-transform-origin' : '0px -' +  ($('main-content').getBoundingClientRect().top + 10*ratio) + 'px 0px',
    'line-height': '18px',
    'font-size': ratio * 100 + '%',
  });

  $$('#word-bank').setStyles({
    float: 'right',
    'margin-right': 14 + 'px', //was left
    'margin-left': '3px'
    // 'padding-top': - $$('.widget-body')[0].getBoundingClientRect().top + $('main-content').getBoundingClientRect().top
  });

  setTimeout(function () {
    $$('#word-bank label ul, #word-bank h2 ul').setStyles({
      'margin-top' : 16 * ratio + 'px',
    });

    $$('#main-content input').setStyles({
      'font-size': 13 * ratio + 'px'
    });

    $$('#main-content .input-drag-placeholder').setStyles({
      'font-size': 13 * ratio + 'px'
    });

    $$('#word-bank label, #word-bank h2').setStyles({
      'font-size' : 16 * ratio + 'px',
      'line-height':  16 * ratio + 'px',
      'margin-left': 3 * ratio + 'px',
      '-webkit-transform': 'scale(' + 1/ratio + ')'
    })

    $$('#main-content')[0].click();

    var isEditMode = $$('body').hasClass('md-edit-mode')[0];
    if (!isEditMode) {
      $$('#word-bank').setStyle('width', '143px');
    }
  }, 0);

  document.draggablesResized = {ratio : ratio};

  document.resizeAnswers = new CustomEvent('resizeAnswers');

  document.addEventListener('resizeAnswers', function () {
    $$('#main-content span').setStyles({
      'font-size': ratio * 100 +'%',
      padding: 0
    })
  })
}

function injectFITBSharedAndroidIosStyles (ratio) {
  // $$('body')[0].style.transform.split('(')[1].split(')')[0] get ratio scale
  var widgetHeader = $$('.MetrodigiWidget .widget-header');
  var headerWidth = widgetHeader[0].getStyle('width').replace('px','');

  $$('.MetrodigiWidget .widget-header').setStyles({
    'width' : headerWidth * ratio+ 'px'
  });

  setTimeout(function () {
    var yAxis = ($('main-content').getBoundingClientRect().top - 40 * ratio);

    $$('#word-bank label, #word-bank h2').setStyles({
      '-webkit-transform-origin' : '0px ' + yAxis > 0 ? '-' + yAxis : yAxis  + 'px 0px'
    });
  }, 0);
}

function injectFITBSharedNotIosStyles (ratio) {
  setTimeout(function () {
    var $h2 = $$('h2')[0];

    if (!$h2) return;

    var left = $h2.getBoundingClientRect().left / ratio - 23 * ratio;

    $$('#word-list li').setStyles({
      left: left + 'px'
    });

    $$('#word-list li').set('data-left', left);
  }, 0);
}