window._scale_container = 'body';
window._breakpoint_width = 700;

function calculate_container_size() {

	var width = document.window.getWidth();

	if (width < window._breakpoint_width) {
		$$(window._scale_container)[0].addClass('hide-content');
	}else{
		$$(window._scale_container)[0].removeClass('hide-content');
	}
}
function insert_fall_back_content() {
		height = document.window.getHeight()
		fall_back = new Element('div.fall-back-content', {
				html: "<i class='fa fa-info'></i><h2 class='fall-back-text'>The interactive widget cannot display on your device due to size restrictions.<br/><br/>Expanding your browser window or viewing this content on a device with a larger screen should fix the problem.</h2>"
		}).inject($$(window._scale_container)[0], 'top');

		$$(fall_back)[0].setStyles({
			"height" : height + "px",
			"line-height" : height + "px",
		});

		$$('.fall-back-text')[0].setStyles({
			"padding-top" : height /2 - 50 + "px"
		});
}



/* check for touch device */

if(isTouchDevice()){
		window.call_to_action = "tap";
}else{
		window.call_to_action = "click";
}


function isTouchDevice(){
    return typeof window.ontouchstart !== 'undefined';
}

function capitaliseFirstLetter(string){
    return string.charAt(0).toUpperCase() + string.slice(1);
}


function insert_call_to_action_text(){

		for(i = 0; i < $$('.responsive-call-to-action').length; i++){

			var word = window.call_to_action;

			text = $$('.responsive-call-to-action')[i].get('html');
			character = text[0];

			if (character === character.toUpperCase()) {
					word = capitaliseFirstLetter(word);
			}

			$$('.responsive-call-to-action')[i].set('html', word);

		}
}

function init(){

	$$('body').addClass('loaded');
	$$('div.fall-back-content').destroy();
	calculate_container_size();
	insert_fall_back_content();
	insert_call_to_action_text();

}

window.addEvent('resize', calculate_container_size);


/* Hack to call init function only once */
if(document.loaded) {
    init();
} else {
    if (window.addEventListener) {
        window.addEventListener('load', init, false);
    } else {
        window.attachEvent('onload', init);
    }
}


/* remove blue focus on mouse interaction */
window.onload = (function() {
	injectCSS();

	window.lastKey = new Date();
    window.lastClick = new Date();
	document.addEvent('focusin', function(e) {
		$$(".non-keyboard-outline").removeClass("non-keyboard-outline");
		var wasByKeyboard = lastClick < lastKey;
		if (wasByKeyboard) {
			e.target.addClass( "non-keyboard-outline");
		}
	});
	document.addEvent('click', function(){
        window.lastClick = new Date();
    });
    document.addEvent('keydown', function() {
        window.lastKey = new Date();
    });
});

function injectCSS() {
	var headNode = document.getElementsByTagName("head")[0];
	var headTag = headNode.innerHTML;
	var newCSS = headTag + '<style type="text/css">*:active,*:focus{outline:none;}*:active.non-keyboard-outline,*:focus.non-keyboard-outline{outline:rgba(125,173,217,0.4) solid 2px;box-shadow:0 0 6px rgb(125,173,217);}</style>';

    /***************
     * NOTE: Aaron removed this code:
     *   $$('head').append(newCSS);
     * because it wasn't actually adding anything to the head.
     **************/
    headNode.innerHTML = newCSS;
}
