AdaptiveScenario = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {
    },
    current_element: null,
    breadcrumbs: [],
    initialize: function (options) {
        this.options = options;
        this.generateDOM();
        this.parent(options);
        if(this.options.container.getElement('.matching-assessment-header'))
            this.matching_assessment_header_text = this.options.container.getElement('.matching-assessment-header').get('html');
        else
            this.matching_assessment_header_text = "";

        $$('.segment.choices').set('role', 'radiogroup')
        $$('.segment.choices').getElement('.title').map(function(title, index){
            var id = 'choice-title-' + index
            var titleText = title.get('text')
            new Element('legend.title', {
                text: titleText,
                id: id,
                'tabindex': -1
            }).inject(title,'before')

            title.getParent().set('aria-labelledby', id)
            title.remove()

        })
        var titles = $$('.segment').getElement('.title')

        new Element('h2.title', {
            text: titles[0].get('text')
        }).inject(titles[0], 'before')


        titles[0].remove();



        $$("[id^='final-summary']").getElement('.title').map(function(summary){
            new Element('h2.title', {
                text: summary.get('text')
            }).inject(summary, 'before')
            summary.remove();
        })


        this.cleanUpDomContent();
    },
    cleanUpDomContent: function(){
        $$('.text').forEach( function(theText) {
            if( theText.getElements('p').length > 0 ){
                theText.getElements('p').forEach( function (theP){
                    //console.log(theP.getElement('br'), theP.get('text').trim());
                    if( theP.getElement('br') && theP.get('text').trim() == "" ){
                        new Element('br').inject(theP, "before");
                        theP.dispose();
                    }
                });
            }
        });
    },
    fixRelationShips: function(data){

        var data_copy = [],
            must_save_data = false;

        if( data !== null && data !== undefined && data.length > 0){
            
            data.forEach(function( item, index ){

                if( $(item.selector) == null ){
                    return;
                }

                var new_item = JSON.parse(JSON.stringify(item));
                if( new_item.next !== null && new_item.next !== undefined && new_item.next != ''){
                    var match = data.find( function( _item ){
                        return _item.selector == item.next
                    } );

                    if(match == null || match == undefined){
                        must_save_data = true;
                        var name_splited = new_item.next.split('_');
                        switch(name_splited[0]){
                            case 'scenario':
                                data_copy.push({
                                    selector: new_item.next,
                                    next: ""
                                });
                                break;
                            case 'final-summary':
                            case 'final-assessment':
                                data_copy.push({
                                    selector: new_item.next,
                                    next: ""
                                });
                                break;
                            case 'consequence':
                                data_copy.push({
                                    selector: new_item.next,
                                    next: "",
                                    index: 0
                                });
                                break;
                            case 'choices':
                                data_copy.push({
                                    selector: new_item.next,
                                    next: "",
                                    index: 0,
                                    choice: ''
                                });
                                break;
                        }
                        console.log("-- added "+ name_splited[0] + ": "+new_item.next + " --");
                    } else {
                        if( $(match.selector) == null ){

                            var _match = match,
                                _element = null,
                                _find = null;

                            while( true ){
                                if( _match.next == '' || _match.next == null || _match.next == undefined ){
                                    break;
                                } else if( $(_match.next) == null ) {
                                    _match = data.find( function( _item ){
                                        return _item.selector == _match.next
                                    } );
                                } else {
                                    _find = _match.selector;
                                    break;
                                }
                            }

                            if(_find != null && _find != undefined && _find != ''){
                                console.log("-- linked: "+new_item.next + " --");
                                new_item.next = _find;
                            }
                            else{
                                console.log("-- deleted: "+new_item.next + " --");
                                delete new_item.next;
                            }

                            must_save_data = true;
                        }
                    }
                }

                data_copy.push( new_item );
            });


        }

        //
        //_this.saveRequest({method: 'mdData', options: { 'json': json_data }});
        //
        if(must_save_data){

            console.log("-- saved data validated --");

            this.saveRequest(
                {
                    method: 'mdData', 
                    options: { 
                        'json': data_copy 
                    }
                },
                function( response ){
                    parent.postMessage({
                        type: 'data-validated',
                        data: data_copy
                    }, "*");
                }
            );

        } else {
            parent.postMessage({
                type: 'data-validated',
                data: data_copy
            }, "*");
        }

        
    },
    asyncInlinePostMessages: function( message, data ){
        //this.reportAsyncInlinePostMessages({result: true});
        this.processPostMessages(
            data, 
            (function(){
                this.reportAsyncInlinePostMessages({result: true});
            }).bind(this)
        );

    },
    customPostMessages: function (message) { 
        // ensure message.data is an object
        var messageData;
        try {
            messageData = typeof message.data === 'string' ? JSON.parse(message.data) : message.data;
        } catch (e) {
            messageData = message.data;
        }

        this.processPostMessages(messageData, null, ( 'no_reload' in messageData ? !messageData.no_reload : true ) );
    },
    processPostMessages: function (data, result_callback, should_reload) {
        var _this = this;
        var id = data.id;
        var element = $(id);

        switch (data.method) {
            /*
             case 'removeSegments':
             Array.each(data.segments, function (item) {
             var remove = false;
             element = $(item);
             if (element  && !element.hasClass('choices')) {
             element.remove();
             remove = true;
             }
             if (remove) {
             var content = $$('.widget-content')[0];
             _this.saveRequest({method: 'mdHtml', options: {selector: '.widget-content', html: content.get('html')}});
             }
             });
             break;*/
            case  'validate-data':
                this.fixRelationShips(data.data);
                break;
            case 'addSegment':
                var elements = '';
                Array.each(data.segments, function (item) {
                    element = $(item);
                    var type = item.split('_')[0];
                    if (element == null && type != 'sequence' && type != 'final-assessment') {
                        if(type == 'matching-assessment') {
                            var time = parseInt(Date.now());
                            var new_element = '<div class="segment" id="' + item + '">' +
                                                '<div class="matching-assessment-header">Match the items on the left to the right by either dragging the node to the correct answer or double tapping it.</div>'+
                                                '<div class="objects">' +
                                                    '<div class="objects-to-match"></div><div class="objects-matches"></div><div class="objects-svg-wrapper"></div>'+
                                                    ''+
                                                    //'<div name="object-'+time+'" data-selected="true"><input type="radio" name="'+item+'" checked="checked"/><label></label></div>' +
                                                    //'<div name="object-'+(time+1)+'" data-selected="false"><input type="radio" name="'+item+'" /><label></label></div>' +
                                                '</div>' +
                                          '</div>';
                        } else if (data.type === 'normal') {
                            var new_element = '<div class="segment" id="' + item + '"><div class="title"></div><div class="media"></div><div class="text"></div></div>';
                        } else {
                            var new_element = '<div class="segment choices" id="' + item + '"><div class="title">Pick from one of the options below:</div></div>';
                        }
                    } else if (element == null && type == 'sequence' || type == 'final-assessment') {                        
                        var time = parseInt(Date.now());
                        var new_element = '<div class="segment" id="' + item + '">' +
                                                '<div class="question"></div>' +
                                                '<div class="feedback"></div>' +
                                                '<div class="answers">' +
                                                    '<div name="answer-'+time+'" data-selected="true"><input type="radio" name="'+item+'" checked="checked"/><label></label></div>' +
                                                    '<div name="answer-'+(time+1)+'" data-selected="false"><input type="radio" name="'+item+'" /><label></label></div>' +
                                                '</div>' +
                                          '</div>';
                    }
                    elements += new_element;
                    $$('.widget-content').appendHTML(new_element);
                });
                if (elements !== '') {
                    this.saveRequest({method: 'mdAppend', options: {selector: '.widget-content', html: elements}}, function(){
                        if( typeof result_callback != 'undefined'  && result_callback != null){
                            result_callback.call();
                        } else if( typeof should_reload == 'undefined' || should_reload == true ){
                            document.location.reload(true);
                        }
                    });
                }
                break;
            case 'readSegment':
                var pathUpload = location.href;
                if (pathUpload.indexOf("?") > 0) {
                    pathUpload = pathUpload.split("?")[0];
                }
                if (element) {
                    if(data.type == 'sequence' || data.type == 'final-assessment'){
                        var question = element.getElement('.question').get('html');
                        var feedback = element.getElement('.feedback').get('html');
                        var answers = [];
                        element.getElement('.answers').getChildren().each(function(elem){
                            var el = $(elem);
                            var answer = {text: el.getElement('label').get('html'), selected: el.get('data-selected'), name: el.get('name')};
                            answers.push(answer);
                        });

                        this.sendPostMessages('notEmpty', {question: question, feedback: feedback, id: data.id, type: data.type, answers: answers});
                    }else if(data.type == 'matching-assessment') {
                        var objects_elements = $(id).getElements(".object-element");
                        var objects = [];
                        if(objects_elements.length>0){
                            objects_elements.forEach(function(element_object){
                                var object_data = {};
                                object_data.object = element_object.getElement(".object").get("html");
                                object_data.match = element_object.getElement(".object-match").get("html");

                                objects.push(object_data);
                            });
                        }
                        //console.log(objects);
                        this.sendPostMessages('notEmpty', {objects: objects, id: data.id, type: data.type, path: pathUpload});
                    }else{
                        var title = element.getElement('.title').get('html');
                        var text = element.getElement('.text').get('html');
                        var media = element.getElement('.media').get('html');
                        var media_element = element.getElement('.media');
                        var sub_element = media_element.getElement('img');
                        var src = '';
                        var media_type = 'image';
                        if (sub_element === null) {
                            media_type = 'iframe';
                            sub_element = media_element.getElement('iframe');
                        }
                        if (sub_element !== null) {
                            src = sub_element.get('src');
                        }
                        this.sendPostMessages('notEmpty', {media_type: media_type, src: src, media: media, title: title, text: text, id: data.id, type: data.type, path: pathUpload});
                    }
                } else {
                    this.sendPostMessages('empty', {path: pathUpload});
                }
                break;
            case 'saveSegment':
                if(data.type == 'sequence' || data.type == 'final-assessment'){
                    var question = data.question;
                    var feedback = data.feedback;
                    var answers = data.answers;
                    element.getElement('.question').set('html', question);
                    element.getElement('.feedback').set('html', feedback);

                    answers.each(function(elem){
                        if(element.getElement('div[name="'+elem.name+'"]')){
                            element.getElement('div[name="'+elem.name+'"]').getElement('label').set('html', elem.text);
                            element.getElement('div[name="'+elem.name+'"]').set('data-selected', false);
                        } else {
                            var newElement = new Element('div', {
                                'name': elem.name,
                                'data-selected': false,
                                'html': '<input type="radio" name="'+data.id+'" /><label>'+elem.text+'</label>'
                            });
                            element.getElement('.answers').grab(newElement);
                        }
                    });
                    element.getElement('div[name="'+data.selected+'"]').set('data-selected', true);
                } else if (data.type == 'matching-assessment' ){
                    if(data.objects !=null && data.objects.length>0){
                        $(id).getElement(".objects .objects-to-match").empty();
                        data.objects.forEach(function(entry){
                            var object_data = new Element("div.object-element");
                            var object_data_object = new Element("div.object",{
                                text: entry.object
                            });
                            var object_data_match = new Element("div.object-match",{
                                text: entry.match
                            });

                            object_data.adopt(object_data_object);
                            object_data.adopt(object_data_match);

                            $(id).getElement(".objects .objects-to-match").adopt(object_data);
                            $(id).getElement(".objects .objects-matches").empty();
                            $(id).getElement(".objects .objects-svg-wrapper").empty();
                        });
                    }
                } else{
                    var title = data.title;
                    var text = data.text;
                    var media = data.media;
                    element.getElement('.title').set('html', title);
                    element.getElement('.text').set('html', text);
                    element.getElement('.media').set('html', media);
                }
                this.saveRequest({method: 'mdHtml', options: {selector: '#' + id, html: element.get('html')}}, function(){
                        if( typeof result_callback != 'undefined' && result_callback != null){
                            result_callback.call();
                        } else if( typeof should_reload == 'undefined' || should_reload == true ){
                            document.location.reload(true);    
                        }
                        
                    });
                break;
        }
    },
    generateDOM: function () {
        var _this = this;
        Array.each(this.options.data, function (item) {
            var split = item.selector.split('_'),
                    html = '';
            switch (split[0]) {
                case 'choices':
                    if (typeof item.choice !== 'undefined') {
                        //html += '<div class="choice"><input type="radio" name="' + item.selector + '" value="' + item.next + '">\n\ <label>' + item.choice + '</label></div>';
                        html += '<div class="choice"><input type="radio" name="' + item.selector + '" aria-label="' + item.choice + '" value="' + item.next + '">\n\ <label>' + item.choice + '</label></div>';
                        if ($(item.selector)) {
                            $(item.selector).appendHTML(html);
                        }
                    }
                    break;
                case 'sequence':
                case 'final-assessment':
                    $(item.selector).addClass('final-assessment');
                    $(item.selector).getElement('.question').addClass('title');
                    var answers = $(item.selector).getElement('.answers').getChildren();
                    if (answers) {
                        answers.each(function(elem){
                            elem.addClass('choice');
                        });
                    }
                    if (typeof item.next !== 'undefined') {
                        $(item.selector).set('data-next', item.next);
                    }
                    break;
                case 'intro':

                    _this.current_element = $(item.selector);
                    _this.current_element.set('data-next', item.next);
                    if (item.next !== '') {
                        $('next').removeProperty('disabled');
                    }
                    break;
                case 'matching-assessment':

                    var _touch_device = 'ontouchstart' in window // works on most browsers 
                                    || 'onmsgesturechange' in window; // works on ie10;

                    
                    if(_touch_device){
                        $(item.selector).addClass("mobile-version")
                    }
                    $(item.selector).getElements(".object-element").set("tabindex", 1);
                    var match = $(item.selector).getElements(".object-element .object-match");
                    match.hide();
                    var match_array = [];
                    var match_wrapper = $(item.selector).getElement(".objects-matches");
                    if(match.length>0){
                        match.forEach(function(m,i){
                            var match_data = new Element("div.match",{
                                "data-object-index": i,
                                "data-correct-index": m.get('data-correct-index'),
                                "tabindex": 2,
                                html: m.get("html")
                            });
                            match_array.push(match_data);
                        });

                        match_array.sort(function() { return 0.5 - Math.random() });

                        match_array.forEach(function(m,i){
                            match_wrapper.adopt(m);
                        });

                        
                    }

                    function match_procedure(draggable, droppable){
                        /*
                        console.log(e);

                        var droppable = e.target,
                            draggable = $(item.selector).getElement(".object-element.dragging .draggable");

                        */
                        

                        var ratio = 1;
                        if(!_touch_device && window._responsive_scaling_ratio!=null && window._responsive_scaling_ratio<1)
                            ratio = window._responsive_scaling_ratio;

                        $(item.selector).getElements(".object-element").removeClass("dragging");
                        $(item.selector).getElements(".draggable").removeClass("dragging");
                        $(item.selector).getElements(".objects").removeClass("dragging");

                        var droppable_current_index = droppable.get("data-dropped-index"); 
                        if(droppable_current_index!=null && droppable_current_index!=""){
                            droppable.getParent(".objects").getElements(".objects-to-match .object-element")[droppable_current_index].removeClass("dragged");
                            droppable.getParent(".objects").getElements(".objects-to-match .object-element")[droppable_current_index].getElement(".draggable").removeClass("dragged");
                            var _o_p = JSON.parse(droppable.getParent(".objects").getElements(".objects-to-match .object-element")[droppable_current_index].getElement(".draggable").get("data-original-position"));
                            droppable.getParent(".objects").getElements(".objects-to-match .object-element")[droppable_current_index].getElement(".draggable").setStyles({
                                left: _o_p.x,
                                top: _o_p.y,
                                visibility: "visible"
                            });
                            droppable.set("data-dropped-index", null);
                        }

                        var draggable_index = droppable.getParent(".objects").getElements(".objects-to-match .draggable").indexOf(draggable); 
                        if( droppable.getParent(".objects").getElement(".objects-matches .match[data-dropped-index='" + draggable_index + "']") ){
                            droppable.getParent(".objects").getElement(".objects-matches .match[data-dropped-index='" + draggable_index + "']").removeClass("dropped");
                            droppable.getParent(".objects").getElement(".objects-matches .match[data-dropped-index='" + draggable_index + "']").set("data-dropped-index",null);
                        }
                        droppable.removeClass("drag-over");
                        droppable.addClass("dropped");
                        droppable.set("data-dropped-index", draggable_index );
                        draggable.setStyle("visibility","hidden");
                        draggable.getParent(".object-element").addClass("dragged");
                        draggable.addClass("dragged");
                        draggable.setStyles({
                            "left":(droppable.getPosition(droppable.getParent(".objects")).x/ratio-2)+"px",
                            "top":(droppable.getPosition(droppable.getParent(".objects")).y/ratio + droppable.getHeight()/2 - draggable.getHeight()/2 - 0)+"px"
                        });
                        //console.log($(item.selector).getElement(".object-element[tabindex=1]"));
                        if($(item.selector).getElement(".object-element[tabindex=1]")){
                            $(item.selector).getElement(".object-element[tabindex=1]").focus();
                        }
                        //alert($(item.selector).getElements(".objects-matches .match").length);
                        //alert($(item.selector).getElements(".objects-matches .match[data-dropped-index]").length);
                        if( $(item.selector).getElements(".objects-matches .match").length == $(item.selector).getElements(".objects-matches .match[data-dropped-index]").length ){
                            //$("check-answers-matching-assessment").set("disabled",null);
                            
                            $("check-answers-matching-assessment") ? $("check-answers-matching-assessment").removeProperty("disabled") : "";
                            
                        }
                    }

                    $(item.selector).getElements(".object-element").addEvent("keypress",function(e){
                        if(e.key == "enter"){
                            if(!$(item.selector).getElement(".objects .objects-matches div.drag-over")){
                                e.target.addClass("dragging");
                                e.target.getElement(".draggable").addClass("dragging");
                                e.target.getParent(".objects").addClass("dragging");

                                if($(item.selector).getElement(".objects .objects-matches div[tabindex=2]")){
                                    $(item.selector).getElement(".objects .objects-matches div[tabindex=2]").focus();
                                }
                            }
                            else{
                                e.target.addClass("dragging");
                                e.target.getElement(".draggable").addClass("dragging");
                                e.target.getParent(".objects").addClass("dragging");
                                //console.log($(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]"));
                                if($(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]")){
                                    //$(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]").fireEvent("keypress",$(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]"));
                                    match_procedure(e.target.getElement(".draggable"), $(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]"));
                                }
                            }
                        }
                    });

                    $(item.selector).getElements(".objects .objects-matches div").addEvent("keypress",function(e){
                        if(e.key == "enter"){
                            if(!$(item.selector).getElement(".object-element.dragging .draggable")){
                                e.target.addClass("drag-over")
                                $(item.selector).getElement(".object-element[tabindex=1]").focus();
                                return;
                            }
                            match_procedure($(item.selector).getElement(".object-element.dragging .draggable") , e.target );
                        }
                    });

                    $(item.selector).getElements(".object-element").addEvent("click",function(e){

                        var target = e.event.currentTarget;

                        if(target == $(item.selector).getElement(".object-element.dragging")){
                            $(item.selector).getElements(".object-element.dragging .draggable").removeClass("dragging");
                            $(item.selector).getElements(".object-element.dragging").removeClass("dragging");
                            return;
                        }
                        
                        if(!$(item.selector).getElement(".objects .objects-matches div.drag-over")) {
                            $(item.selector).getElements(".object-element.dragging .draggable").removeClass("dragging");
                            $(item.selector).getElements(".object-element.dragging").removeClass("dragging");
                            target.addClass("dragging");
                            target.getElement(".draggable").addClass("dragging");
                            target.getParent(".objects").addClass("dragging");
                        } else {
                            target.addClass("dragging");
                            target.getElement(".draggable").addClass("dragging");
                            target.getParent(".objects").addClass("dragging");
                            //console.log($(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]"));
                            if($(item.selector).getElement(".objects .objects-matches div.drag-over")){
                                //$(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]").fireEvent("keypress",$(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]"));
                                match_procedure(target.getElement(".draggable"), $(item.selector).getElement(".objects .objects-matches div.drag-over[tabindex=2]"));
                            }
                        }
                    });

                    $(item.selector).getElements(".objects .objects-matches div").addEvent("click",function(e){
                        
                        if(!$(item.selector).getElement(".object-element.dragging .draggable")){
                            e.target.addClass("drag-over")
                            return;
                        }
                        match_procedure($(item.selector).getElement(".object-element.dragging .draggable") , e.target );
                    });

                    
                    if($(item.selector).getElement(".objects-svg-wrapper")){

                        $(item.selector).getElements(".object-element").forEach(function(ob_el){
                            var new_drag = new Element("div.object-element-drag.draggable");
                            ob_el.adopt(new_drag);

                            var correct_incorrect_element = new Element("div.correct-incorrect-element.fa");
                            ob_el.adopt(correct_incorrect_element);
                        });

                        $(item.selector).getElements(".object-element .draggable").makeDraggable({
                            droppables: $(item.selector).getElements('.objects-matches .match'),
                            onStart:function(draggable){

                                if(draggable.get("data-original-position")==null || draggable.get("data-original-position") == ""){
                                    var original_position = draggable.getPosition(draggable.getParent(".objects"));
                                    draggable.set("data-original-position", JSON.stringify(original_position) );
                                }
                                draggable.getParent(".objects").addClass("dragging");
                                draggable.getParent(".object-element").addClass("dragging");
                                draggable.addClass("dragging");

                            },
                            onEnter:function(element, droppable){
                                if(droppable){
                                    droppable.getParent(".objects").getElements(".objects-matches .match").removeClass("drag-over");
                                    droppable.addClass("drag-over");
                                }
                            },
                            onLeave:function(element, droppable){
                                if(droppable){
                                    droppable.getParent(".objects").getElements(".objects-matches .match").removeClass("drag-over");
                                    droppable.removeClass("drag-over");
                                }
                            },
                            onDrop: function(draggable, droppable) {
                                var correct = false;
                                draggable.getParent(".objects").removeClass("dragging");
                                draggable.getParent(".object-element").removeClass("dragging");
                                draggable.removeClass("dragging");

                                if ($$('.droppable.selected')[0])
                                    $$('.droppable.selected')[0].removeClass('selected');
                                if (droppable) {

                                    match_procedure(draggable, droppable);

                                    /*
                                    var draggable_index = droppable.getParent(".objects").getElements(".objects-to-match .draggable").indexOf(draggable); 
                                    if( droppable.getParent(".objects").getElement(".objects-matches .match[data-dropped-index='" + draggable_index + "']") ){
                                        droppable.getParent(".objects").getElement(".objects-matches .match[data-dropped-index='" + draggable_index + "']").removeClass("dropped");
                                        droppable.getParent(".objects").getElement(".objects-matches .match[data-dropped-index='" + draggable_index + "']").set("data-dropped-index",null);
                                    }
                                    droppable.addClass("dropped");
                                    droppable.set("data-dropped-index", draggable_index );
                                    draggable.setStyle("visibility","hidden");
                                    draggable.getParent(".object-element").addClass("dragged");
                                    draggable.addClass("dragged");
                                    draggable.setStyles({
                                        "left":(droppable.getPosition(droppable.getParent(".objects")).x-5)+"px",
                                        "top":(droppable.getPosition(droppable.getParent(".objects")).y + droppable.getHeight()/2 - draggable.getHeight()/2 - 0)+"px"
                                    });
                                    */
                                    correct=true;
                                    return;
                                    
                                    if (_this.checkAnswer(droppable.getAttribute('data-id'))) {
                                        _this.container.getElement('.message').set('html', 'Correct!').addClass('correct').setStyle('opacity', 1);
                                        draggable.morph({
                                            left: $$('body')[0].getSize().x / 2 + 'px',
                                            top: ($$('.widget-content')[0].getSize().y / 2) + 'px'
                                        });
                                        setTimeout(function() {

                                            _this.container.getElement('.message').morph({'opacity': 0});
                                            _this.nextOption();
                                        }, 1800);
                                        correct = true;
                                    } else {
                                        _this.container.getElement('.message').set('html', 'Incorrect. Try again.').addClass('incorrect').setStyle('opacity', 1);
                                        //setTimeout(function() { _this.container.getElement('.message').morph({'opacity': 0})}, 2000);
                                    }
                                }
                                if (!correct) {
                                    var original_position = JSON.parse(draggable.get("data-original-position"));
                                    console.log(original_position.x+"px");
                                    draggable.morph({
                                        left: original_position.x+"px",
                                        top: original_position.y+"px"
                                    });
                                }
                            },
                        });


                        var canvas_element = new Element("canvas",{
                            width: $$(".widget-content")[0].getWidth(),
                            height: $$(".widget-content")[0].getHeight()
                        });
                        $(item.selector).getElement(".objects-svg-wrapper").adopt(canvas_element);
                        var draggables_to_send  = $(item.selector).getElements(".object-element .draggable");

                        var ctx_ob = canvas_element.getContext('2d');

                        (function(ctx, canvas, draggables, parent_wrapper){
                            function renderLine() {
                                ctx.clearRect(0, 0, canvas_element.getWidth(), 400);
                                draggables.forEach(function(draggable){
                                    //console.log(draggable.getPosition(parent_wrapper));
                                    //console.log(draggable);

                                    //console.log(canvas_element.getWidth() / 2 - ((canvas_element.getWidth() - 700) / 2) + 48, 198);
                                    //console.log(draggable.getPosition(parent_wrapper).x - ((canvas_element.getWidth() - 700) / 2) + 25, draggable.getPosition(parent_wrapper).y - 85);
                                    //console.log(draggable.hasClass("dragging") || draggable.hasClass("dragged"));
                                    var draggable_parent = draggable.getParent();
                                    var deltay = -9;
                                    ctx.beginPath();

                                    var ratio = 1;
                                    if(!_touch_device && window._responsive_scaling_ratio!=null && window._responsive_scaling_ratio<1)
                                        ratio = window._responsive_scaling_ratio;
                                    //ratio = 1;
                                    //ctx.setLineDash([2, 2]);
                                    //ctx.moveTo(canvas_element.getWidth() / 2 - ((canvas_element.getWidth() - 700) / 2) + 48, 198);
                                    //ctx.lineTo(draggable.getPosition(parent_wrapper).x - ((canvas_element.getWidth() - 700) / 2) + 25, draggable.getPosition(parent_wrapper).y - 85);
                                    //console.log(draggable_parent.getPosition().x, draggable_parent.getPosition(parent_wrapper).x, draggable_parent.getPosition(parent_wrapper).y, draggable_parent.getHeight(), "---");
                                    
                                    var _move_to = [
                                        draggable_parent.getPosition(parent_wrapper).x/ratio + draggable_parent.getWidth() - 5 , 
                                        draggable_parent.getPosition(parent_wrapper).y/ratio + draggable_parent.getHeight()/2
                                    ];
                                    var _line_to = [
                                        draggable.getPosition(parent_wrapper).x/ratio  + 5, 
                                        draggable.getPosition(parent_wrapper).y/ratio + draggable.getHeight()/2 - 1
                                    ];
                                    
                                    /*
                                    var _move_to = [
                                        draggable_parent.getPosition(parent_wrapper).x + draggable_parent.getWidth() - 5 , 
                                        draggable_parent.getPosition(parent_wrapper).y + draggable_parent.getHeight()/2
                                    ]
                                    var _line_to = [
                                        draggable.getPosition(parent_wrapper).x  + 5, 
                                        draggable.getPosition(parent_wrapper).y + draggable.getHeight()/2 - 1
                                    ]
                                    */
                                    
                                    ctx.moveTo(_move_to[0], _move_to[1]);
                                    ctx.lineTo(_line_to[0], _line_to[1]);
                                    var color_stroket = draggable.hasClass("dragging") || draggable.hasClass("dragged")?'#41464D':'#D4D6D9';
                                    if(draggable.getParent().hasClass("match-correct")){
                                        color_stroket = "#0C4E0F";
                                    }
                                    if(draggable.getParent().hasClass("match-incorrect")){
                                        color_stroket = "#BC0F00";   
                                    }
                                    ctx.strokeStyle = color_stroket;
                                    ctx.lineWidth = 5;
                                    ctx.stroke();
                                    ctx.closePath();
                                });
                            }

                            setInterval(function() {
                                this.set("width",$$(".widget-content")[0].getWidth());
                                this.set("height",parent_wrapper.getHeight());

                                renderLine();

                            }.bind(canvas), 10);
                        })(ctx_ob, canvas_element, draggables_to_send, $(item.selector).getElement(".objects"));
                        
                    }

                    if (typeof item.next !== 'undefined') {
                        if($(item.selector)) $(item.selector).set('data-next', item.next);
                    }
                    break;
                default:
                    if (typeof item.next !== 'undefined') {
                        if($(item.selector)) $(item.selector).set('data-next', item.next);
                    }
                    break;
            }

        });
        if (this.isEditMode == false) {
            //uncheck multiple choice
            $$('.segment.choices input[type="radio"]').forEach(function (input, index) {
                input.set('checked', false);
            });

            //uncheck final assessment answers
            $$('.segment.final-assessment .answers input[type="radio"]').forEach(function (input, index) {
                input.set('checked', false);
            });
        }
    },
    afterShowElement:function(type, selector, element){
        var $this = this;
        switch(type){
            case 'matching-assessment':
                var _touch_device = 'ontouchstart' in window // works on most browsers 
                                || 'onmsgesturechange' in window; // works on ie10;

                var _mobile_diff = 0;
                
                element.getElements(".draggable").forEach(function(element_drag){
                    var parent_drag = element_drag.getParent(),
                        parent_position = parent_drag.getPosition(element.getElement(".objects"));

                    _mobile_diff = 0;
                    if(_touch_device){
                        //_mobile_diff = -1*(parent_drag.getWidth() + 10 + 10);
                    }
                    var ratio = 1;
                    if(!_touch_device && window._responsive_scaling_ratio!=null && window._responsive_scaling_ratio<1)
                        ratio = window._responsive_scaling_ratio;
                    var _initial_position = {
                        left: parent_position.x/ratio + parent_drag.getWidth() + 10 + _mobile_diff,
                        top: parent_position.y/ratio + parent_drag.getHeight()/ 2 - element_drag.getHeight()/ 2, 
                        x: parent_position.x/ratio + parent_drag.getWidth() + 10 + _mobile_diff,
                        y: parent_position.y/ratio + parent_drag.getHeight()/ 2 - element_drag.getHeight()/ 2,
                    };

                    /*
                    _initial_position.left/= ratio;
                    _initial_position.top/= ratio;
                    _initial_position.x/= ratio;
                    _initial_position.y/= ratio;
                    */

                    console.log(ratio);
                    element_drag.setStyles(_initial_position);
                    element_drag.getParent().getElement(".correct-incorrect-element").setStyles(_initial_position);
                    element_drag.set("data-original-position", JSON.stringify(_initial_position) );
                });

                if($$(".widget-footer .matching-assessment-feedback").length==0){
                   var matching_assessment_feedback = new Element("span.matching-assessment-feedback#matching-assessment-feedback",{
                    html: "1 of 3 tries",
                    "data-tries": 1
                   });
                   matching_assessment_feedback.inject($("reset"),"after");
                }
                else{
                    $$(".widget-footer .matching-assessment-feedback")[0].set("html", "1 of 3 tries");
                    $$(".widget-footer .matching-assessment-feedback")[0].show();
                }

                function matching_assessment_reset(){
                    $this.current_element.getElement(".matching-assessment-header").set("html", $this.matching_assessment_header_text);
                    $this.current_element.getElements(".object-element").removeClass("match-correct");
                    $this.current_element.getElements(".object-element").removeClass("match-incorrect");
                    $this.current_element.getElements(".dragging").removeClass("dragging");
                    $this.current_element.getElements(".dragged").removeClass("dragged");
                    $this.current_element.getElements(".match.dropped").removeClass("dropped");
                    $this.current_element.getElements(".match").set("data-dropped-index",null);

                    $this.current_element.getElements(".draggable").forEach(function(draggable){
                        var original_position = JSON.parse(draggable.get("data-original-position"));
                        draggable.setStyles({
                            left: original_position.x,
                            top: original_position.y,
                            visibility:"visible"
                        });

                    });

                    var next_try = (new Number($("matching-assessment-feedback").get("data-tries")));
                    if(next_try==3){
                        $("check-answers-matching-assessment").dispose();
                        $("matching-assessment-feedback").dispose();
                        $("back").hide();
                        $("try-again-matching-assessment").hide();

                        if($this.current_element.get("data-next")!=null){
                            $("next").show();
                            $("next").set("disabled",null);
                        }
                        return;
                    }
                    next_try+=1;
                    $("matching-assessment-feedback").set("html", next_try + " of 3 tries");
                    $("matching-assessment-feedback").set("data-tries", next_try );
                    $("check-answers-matching-assessment").set("disabled","disabled");
                    $("check-answers-matching-assessment").show();
                    $("try-again-matching-assessment").hide();
                }

                function matching_assessment_check_your_answers(){
                    $("check-answers-matching-assessment").hide();
                    $("try-again-matching-assessment").show();
                    //console.log($this.current_element.getElements(".objects-matches .match").length, $this.current_element.getElements(".objects-matches .match[data-dropped-index]").length , $this.current_element.getElements(".objects-matches .match").length != $this.current_element.getElements(".objects-matches .match[data-dropped-index]").length);
                    if( $this.current_element.getElements(".objects-matches .match").length != $this.current_element.getElements(".objects-matches .match[data-dropped-index]").length ){
                        //
                        $this.current_element.getElement(".matching-assessment-header").set("html", "You must match all elements to check your answers.");
                        
                    } else {
                        var flag_ok = true,
                            count_good = 0,
                            objects = $this.current_element.getElements(".objects-to-match .object-element");
                        
                        $this.current_element.getElements(".objects-matches .match").forEach(function(match){
                            if(flag_ok)
                                flag_ok = match.get("data-dropped-index") == match.get("data-object-index") || (match.get("data-correct-index") ? match.get("data-correct-index").split(",").indexOf(match.get("data-dropped-index")) >= 0 : false);

                            if(match.get("data-dropped-index") == match.get("data-object-index") || (match.get("data-correct-index") ? match.get("data-correct-index").split(",").indexOf(match.get("data-dropped-index")) >= 0 : false)){
                                count_good++;
                                objects[match.get("data-dropped-index")].addClass("match-correct");
                            }
                            else{
                                objects[match.get("data-dropped-index")].addClass("match-incorrect");
                            }
                        });
                        var _current_try = (new Number($("matching-assessment-feedback").get("data-tries")));
                        var _times = {
                            "try_1": "first",
                            "try_2": "second",
                            "try_3": "third"
                        }
                        if(flag_ok){
                            $("check-answers-matching-assessment").hide();
                            $("try-again-matching-assessment").hide();
                            //$("matching-assessment-feedback").dispose();
                            $this.current_element.getElement(".matching-assessment-header").set("html", "You got to " + count_good + " out of " + $this.current_element.getElements(".objects-matches .match").length + " on your " + _times["try_"+_current_try] + " try.");
                            //$("back").show();
                            var next = $this.current_element.get("data-next");
                            if(next!=null && next!=''){
                                $("next").show();
                                $("next").set("disabled",null);
                            }
                        }
                        else{
                            $this.current_element.getElement(".matching-assessment-header").set("html", "You got to " + count_good + " out of " + $this.current_element.getElements(".objects-matches .match").length + " on your " + _times["try_"+_current_try] + " try.");
                            if (_current_try == 3){
                                $("try-again-matching-assessment").hide();
                                var next = $this.current_element.get("data-next");
                                if(next!=null && next!=''){
                                    $("next").show();
                                    $("next").set("disabled",null);
                                }
                            }
                        }
                    }
               }


                if($("check-answers-matching-assessment")==null){

                    var matching_assessment_try_button = new Element("button#try-again-matching-assessment",{
                        html: "Try again"
                    });
                    matching_assessment_try_button.hide();
                    matching_assessment_try_button.inject($("check-answers"),"after");

                    var matching_assessment_button = new Element("button#check-answers-matching-assessment",{
                        html: "Check Answers",
                        disabled: "disabled" 
                    });
                    matching_assessment_button.inject($("check-answers"),"after");

                    

                    matching_assessment_try_button.addEvent("click",matching_assessment_reset);
                    matching_assessment_button.addEvent("click",matching_assessment_check_your_answers);
                }
                else{
                    $("matching-assessment-feedback").set("data-tries",1);
                    $("check-answers-matching-assessment").set("disabled","disabled");
                    $("check-answers-matching-assessment").show();
                }

                $("next").hide();
                $("back").hide();
                //$("check-answers").show();
            break;
            default:
                if($$(".widget-footer .matching-assessment-feedback").length!=0){
                    $$(".widget-footer .matching-assessment-feedback")[0].hide();
                }
        }
    },
    render: function () {
        this.footerEvents();
        this.choicesEvents();

        setTimeout(this.initAccessibleFocus.bind(this), 100);
    },
    isItemVisible: function (item) {
        return item.getStyle('visibility') != 'hidden' && item.getStyle('display') != 'none';
    },
    showElement: function (selector) {
        var currents = $$('.segment').filter(this.isItemVisible);
        this.breadcrumbs.push(currents[0].get('id'));
        currents[0].hide();
        currents[0].removeClass('showed')
        this.current_element = $(selector);
        this.current_element.show();
        this.current_element.addClass('showed');
        if(this.current_element.getElement('legend')){
            this.current_element.getElement('legend').focus()
        }

        var split = selector.split('_');

        this.afterShowElement(split[0] ,selector, this.current_element);

        try {
            document.dispatchEvent(document.resizeSegments)
        } catch(e){
            console.log('no iphone')
        }
    },
    footerEvents: function () {
        var _this = this;
        if($$('#next[disabled]').length > 0)
            document.getElementById('next').setAttribute('disabled','');
        if($$('#check-answers[disabled]').length > 0)
            document.getElementById('check-answers').setAttribute('disabled','');
        if($$('#back[disabled]').length > 0)
            document.getElementById("back").setAttribute('disabled','');
        $('next').addEvent('click', function () {

            $('back').removeProperty('disabled');
            var selector = _this.current_element.get('data-next');
            _this.showElement(selector);
            var next = $(selector).get('data-next');
            console.log( next, next==="" );
            if ((selector.indexOf('sequence') >= 0 || selector.indexOf('final-assessment') >= 0) && selector.indexOf('consequence') == -1){
                if(_this.current_element.getElement('.answers').hasClass('hidden')){
                    $('check-answers').show();
                    $('next').removeProperty('disabled');
                }else{
                    $('check-answers').removeProperty('disabled');
                    $('next').set('disabled', 'disabled');
                }
                $('check-answers').show();
            }else{
                $('check-answers').hide();
            }

            if (next === null || next === "") {
                $('next').set('disabled', 'disabled');
            }

            setTimeout(_this.initAccessibleFocus.bind(_this), 100);
        });
        $('reset').addEvent('click', function () {

            if(!$$('#intro')[0].hasClass('showed')){
                $$('.widget-content > .segment').forEach(function (segmentEl, index) {
                    // clear choices made in multiple choice
                    if (segmentEl.querySelector('.objects')) {
                        matching_assessment_reset(segmentEl);
                    }

                    // clear selected radio inputs
                    if (segmentEl.querySelector('.choice')) {
                        var radioInputEls = segmentEl.querySelectorAll('[type="radio"]');
                        [].slice.call(radioInputEls).forEach(function (radioInputEl) {
                            radioInputEl.set('checked', false);
                        });
                    }
                });

                // reset footer controls
                $$('#next').show();
                $$('#back').show().set('disabled', 'true');
                $$('#check-answers').set('style', null);
                if ($$('#try-again-matching-assessment').length > 0) {
                    $$('#try-again-matching-assessment').destroy();
                }
                if ($$('#check-answers-matching-assessment').length > 0) {
                    $$('#check-answers-matching-assessment').destroy();
                }
                if ($$('#matching-assessment-feedback').length > 0) {
                    $$('#matching-assessment-feedback').destroy();
                }

                var current_selector = $$('.segment')[1].get('id');
                var back_selector = $$('#intro')[0]
                $$('.segment').hide();
                $$('.segment').removeClass('showed');
                _this.current_element = $(back_selector);
                _this.current_element.show();
                _this.current_element.addClass('showed');

                if(_this.current_element.getElement('legend')){
                    _this.current_element.getElement('legend').focus()
                }

                var next = _this.current_element.get('data-next');
                if (next !== null) {
                    $('next').removeProperty('disabled');
                }
                $('check-answers').hide();
                _this.breadcrumbs = []
                $('back').set('disabled', 'disabled');

                try {
                    document.dispatchEvent(document.resizeSegments)
                } catch(e){
                    console.log('no iphone')
                }

                function matching_assessment_reset (segmentEl) {
                    segmentEl = $(segmentEl);
                    segmentEl.getElement(".matching-assessment-header").set("html", _this.matching_assessment_header_text);
                    segmentEl.getElements(".object-element").removeClass("match-correct");
                    segmentEl.getElements(".object-element").removeClass("match-incorrect");
                    segmentEl.getElements(".dragging").removeClass("dragging");
                    segmentEl.getElements(".dragged").removeClass("dragged");
                    segmentEl.getElements(".match.dropped").removeClass("dropped");
                    segmentEl.getElements(".match").set("data-dropped-index",null);

                    segmentEl.getElements(".draggable").forEach(function (draggable) {
                        var original_position = JSON.parse(draggable.get("data-original-position"));
                        if (original_position) {
                            draggable.setStyles({
                                left: original_position.x,
                                top: original_position.y,
                                visibility: "visible"
                            });
                        }
                    });
                }
            }

            setTimeout(_this.initAccessibleFocus.bind(_this), 100);
        });
        $('back').addEvent('click', function () {
            var current_selector = _this.current_element.get('id');
            var back_selector = _this.breadcrumbs[_this.breadcrumbs.length - 1];
            $$('.segment').hide();
            $$('.segment').removeClass('showed');
            _this.current_element = $(back_selector);
            _this.current_element.show();
            _this.current_element.addClass('showed');

            if(_this.current_element.getElement('legend')){
                _this.current_element.getElement('legend').focus()
            }

            var next = _this.current_element.get('data-next');
            if (next !== null) {
                $('next').removeProperty('disabled');
            }
            $('check-answers').hide();
            if ((back_selector.indexOf('sequence') >= 0 || back_selector.indexOf('final-assessment') >= 0) && back_selector.indexOf('consequence') == -1) {
                $('check-answers').show();
            }
            _this.breadcrumbs.pop();
            if (_this.breadcrumbs.length === 0) {
                $('back').set('disabled', 'disabled');
            }


            try {
              document.dispatchEvent(document.resizeSegments)
            } catch(e){
                console.log('no iphone')
            }

            setTimeout(_this.initAccessibleFocus.bind(_this), 100);
        });
        $('check-answers').addEvent('click', function () {
            var text = '';
            var answersContainer = new Element('div.view-answer');

            _this.current_element.getElement('.answers').getChildren().each(function(answer){
                if(answer.getElement('input').checked){
                    if(answer.get('data-selected') == 'true'){
                        text = answer.getElement('label').get('html');
                    }else{
                        var feedback = answer.getParent().getPrevious();
                        if(feedback.get('text').trim()!=""){
                            feedback.set('html', '<div class="feedback-label">Feedback: </div>'+feedback.get('html'));
                            feedback.show();
                        }
                        _this.current_element.getElement('.answers').getChildren().each(function(answ){
                            if(answ.get('data-selected') == 'true'){
                                text = answ.getElement('label').get('html');
                            }
                        });
                        var wrongText = answer.getElement('label').get('html');
                        answersContainer.grab(new Element('div.incorrect', {'html': wrongText}));
                    }
                    answer.getParent().hide();
                    answersContainer.grab(new Element('div.correct', {'html': text}));
                    answersContainer.inject(answer.getParent().getParent().getElement('.question'), 'after');
                }
            });
            _this.current_element.getElement('.answers').addClass('hidden');
            $('check-answers').set('disabled', 'disabled');
            var next = _this.current_element.get('data-next');
            if (next !== null) {
                $('next').removeProperty('disabled');
            }
        });
    },
    choicesEvents: function () {
        var _this = this;
        $$('.choice label').addEvent('click', function () {
            var input = this.getParent().getElement('input');
            input.set('checked', true);
            input.fireEvent('change');
        });
        $$('.choice input').addEvent('change', function () {
            if(this.getParent().getParent().getParent().hasClass('segment')){

            }else{
                var value = this.get('value');
                $('next').removeProperty('disabled');
                _this.current_element.set('data-next', value);
            }
        });
    },
    initAccessibleFocus: function () {
        var _this = this;

        // check if current segment is supported
        var supportedTypes = ['scenario', 'consequence', 'intro'];
        var currentElId = this.current_element.get('id');
        var currentSegmentType = currentElId.split('_')[0];
        var isSupported = supportedTypes.indexOf(currentSegmentType) !== -1;

        if (isSupported) {
            _this.clearTimersOnUserInteraction(function (timers) {
                timers.push(setTimeout(function () {
                    _this.current_element.set('tabindex', '-1').focus();
                }, 0));
            });
        } else {
            console.warn('no supported');
        }
    }
});
