ArgumentMap = new Class({
  Implements: [Options, Events],
  Extends: MetrodigiWidget,
  firstLoad: true,
  // Set initial options here
  options: {
    plusText: '<strong class="questions"><span class="responsive-call-to-action">Click</span> the + button to reveal the next step in the argument map.</strong>',
    nextText: '<span class="responsive-call-to-action">Click</span> the “Next” button to continue to the next part of the argument map.',
    toWholeMapText: '<span class="responsive-call-to-action">Click</span> the “Next” button to see the entire argument map.',
    wholeMapText: 'Use the + and – buttons to zoom in or out on the argument map, and drag the map to pan and follow the flow of logic.',
    resetText: '<span class="responsive-call-to-action">Click</span> the “Reset” button to begin again.',
  },
  currentPage: 0,
  // initialize - widget initialization
  initialize: function (options) {
    this.parent(options);
    var touchEvent = "touchstart";
    if(window.navigator && window.navigator.userAgent && /Android/.test(window.navigator.userAgent)){
      this.clickEvent = touchEvent = "click";
    }

    this.btnNext = this.options.container.getElement('.btn-next');
    this.btnPrevious = this.options.container.getElement('.btn-previous');
    this.btnReset = this.options.container.getElement('.btn-reset');
    this.btnShowConvention = this.options.container.getElement('.btn-showconvention');
    this.btnClose = this.options.container.getElement('.btn-close');
    this.initPlusButton();

    if (this.btnNext) {
      if(this.isTouchDevice()) {
        this.btnNext.addEvent(touchEvent, this.btnNextHandler.bind(this));
      } else {
        this.btnNext.addEvent(this.clickEvent, this.btnNextHandler.bind(this));
      }
      this.btnNext.setAttribute('disabled', 'disabled');
    }
    if (this.btnPrevious) {
      if(this.isTouchDevice()) {
        this.btnPrevious.addEvent(touchEvent, this.btnPreviousHandler.bind(this));
      } else {
        this.btnPrevious.addEvent(this.clickEvent, this.btnPreviousHandler.bind(this));
      }
      this.btnPrevious.hide();
    }
    if (this.btnReset) {
      if(this.isTouchDevice()) {
        this.btnReset.addEvent(touchEvent, this.btnResetHandler.bind(this));
      } else {
        this.btnReset.addEvent(this.clickEvent, this.btnResetHandler.bind(this));
      }
      this.btnReset.hide();
    }
    if (this.btnShowConvention) {
      if(this.isTouchDevice()) {
        this.btnShowConvention.addEvent(touchEvent, this.btnShowConventionHandler.bind(this));
        this.btnClose.addEvent(touchEvent, this.btnCloseHandler.bind(this));
      } else {
        this.btnShowConvention.addEvent(this.clickEvent, this.btnShowConventionHandler.bind(this));
        this.btnClose.addEvent(this.clickEvent, this.btnCloseHandler.bind(this));
      }
    }
    this.showCurrentPage();

    this.firstLoad = false;
  },
  initPlusButton: function () {
    var _this = this;
    this.options.container.getElements('.plus:not(.event-binded)').each(function (item) {

      item.addEvent(_this.clickEvent, _this.btnPlusHandler.bind(_this));

      item.set("role", "button"),
      item.set("tabindex", "0"),
      window.addEvent('keyup', function (e) {

        if ((e.key == "space" || e.key == "enter") && (e.target.get('data-button') == 'plus-btn' || e.target.hasClass("plus"))) {
          e.preventDefault();

          if (!e.target.hasClass("plus")) {
            e.target.getParent('g').getParent('g').getElements('.plus')[0].fireEvent('click', e);
          }
          else {
            e.target.fireEvent('click', e);
          }
        }
      });

      item.addClass("event-binded");
    });

    if (!this.firstLoad && this.options.container.getElements('.plus').length > 0) {
      this.options.container.getElements('.plus')[0].focus();
    }
  },
  btnPlusHandler: function (e) {
      var _this = this;
    e.preventDefault();
    e.stopPropagation();
    var svg = e.target.parentNode.parentNode.parentNode;
    if (e.target.hasClass("text-wrapper") == null) {
      e.target.parentNode.parentNode.destroy();
    }
    else {
      svg = e.target.getParent(".page").getElement("svg");
      if (e.target.getParent(".page").getElement("g .plus") != null)
        e.target.getParent(".page").getElement("g .plus").getParent("g").destroy();
      e.target.hide();
    }


    this.currentStep[this.currentPage]++;
    this.displayMapPart(svg, this.options.data["page" + this.currentPage][this.currentStep[this.currentPage]]);

    if (this.options.data["page" + this.currentPage] == null || this.options.data["page" + this.currentPage][this.currentStep[this.currentPage]] == null)
      return;

    $$(".feedback-text")[0].set("html", "" + this.options.data["page" + this.currentPage][this.currentStep[this.currentPage]][0].text);

    this.initPlusButton();
    if (this.currentStep[this.currentPage] == this.options.data["page" + this.currentPage].length - 1 &&
            this.currentPage != this.currentStep.length - 1) {
      if (this.btnNext) {
        this.btnNext.removeProperty('disabled');
      }
      if (this.currentPage == this.currentStep.length - 2) {
        this.options.container.getElement('.instruction').set('html', this.options.toWholeMapText);
      } else {
        this.options.container.getElement('.instruction').set('html', this.options.nextText);
      }
    } else {
      if (this.btnNext) {
        this.btnNext.setAttribute('disabled', 'disabled');
      }
      if (this.currentStep[this.currentPage] == this.options.data["page" + this.currentPage].length - 1) {
        this.options.container.getElement('.instruction').set('html', this.options.resetText);
      } else {
        this.options.container.getElement('.instruction').set('html', this.options.plusText);
      }
            
    }
    if (((this.currentPage == this.currentStep.length - 2) || (this.currentPage == this.currentStep.length - 1 && !(this.options.entire_map || this.options.entire_map_svg))) &&
            this.currentStep[this.currentPage] == this.options.data["page" + this.currentPage].length - 1) {
      this.btnReset.show();
    }
    this.insertActionText();
  },
  btnShowConventionHandler: function (e) {
    e.preventDefault();
    this.options.container.getElement('.conventionDialog').show();
  },
  btnCloseHandler: function (e) {
    e.preventDefault();
    this.options.container.getElement('.conventionDialog').hide();
  },
  btnNextHandler: function (e) {
    e.preventDefault();
    $$(".linked-layer").hide();
    this.currentPage++;
    if (this.currentPage == this.currentStep.length)
      this.currentPage = this.currentStep.length - 1;
    this.showCurrentPage();

  },
  btnPreviousHandler: function (e) {
    e.preventDefault();
    this.currentPage--;
    if (this.currentPage < 0)
      this.currentPage = 0;
    this.showCurrentPage();
    $$(".linked-layer").hide();
    $$(".linked-layer.linked-layer-page-"+this.currentPage).show();
  },
  btnResetHandler: function (e) {
    e.preventDefault();
    var diagram = this.options.container.getElement('.widget-body .map-diagram'),
            width = this.options.container.getElement(".widget-body").getSize().x - 30,
            height = this.options.container.getElement(".widget-body").getSize().y,
            i = 0;

    diagram.empty();
    if(this.options.pageIndicator) {
      $$(".page-indicator")[0].empty();
    }
    this.currentPage = 0;
    this.createDOM();
    this.initPlusButton();
    this.btnReset.hide();
    this.showCurrentPage();
    this.options.container.getElement('.instruction').set('html', this.options.plusText);

    return;

    this.options.container.getElements("div.page").each(function (p) {
      if (!p.hasClass("entire_map")) {
        p.destroy();
      }
    });
    this.currentPage = 0;
    for (var page in this.options.data) {
      var pageEle = new Element('div.page.' + page).inject(diagram);
      var svg = new Element('svg', {
        //html: '<defs><marker id="markerArrow' + this.currentPage + '" markerWidth="13" markerHeight="13" refx="2" refy="7" orient="auto"><path d="M2,2 L2,10 L8,7 L2,4" fill="#53585f" /></marker></defs>',
        width: width * (!i++ ? 1.1 : (i === 4 ? 1.085 : 1.2)),
        height: height,
        viewBox: "0 0 1050 " + height,
        style: "enable-background:new 0 0 1050 " + height
      }).inject(pageEle);
      
//      var def = new Element("defs",{
//        //html:'<marker id="markerArrow' + this.currentPage + '" markerWidth="13" markerHeight="13" refx="2" refy="7" orient="auto"><path d="M2,2 L2,10 L8,7 L2,4" fill="#53585f" /></marker>'
//      });
//      def.inject(svg);
      

      this.displayMapPart(svg, this.options.data[page][0]);
      this.currentStep[this.currentPage] = 0;
      this.currentPage++;
    }
    this.currentPage = 0;
    this.initPlusButton();
    this.btnReset.hide();
    this.showCurrentPage();
  },
  showCurrentPage: function () {
    this.options.container.getElements('.page').hide();
    this.options.container.getElement('.page' + this.currentPage).show();
    if (!this.btnNext)
      return;
    if (this.options.container.getElement('.box-page' + this.currentPage)) {
      this.options.container.getElements('.page-box').show();
      this.options.container.getElements('.page-box').removeClass("active");
      this.options.container.getElement('.box-page' + this.currentPage).addClass("active");
    } else {
      //this.options.container.getElements('.page-box').hide();
      this.options.container.getElements('.page-box').show();
      this.options.container.getElements('.page-box').removeClass("active");
      this.options.container.getElement('.box-page-last').addClass("active");
    }
    if (this.options.data["page" + this.currentPage] && this.currentStep[this.currentPage] == this.options.data["page" + this.currentPage].length - 1 && this.currentPage != this.currentStep.length - 1) {
      if (this.btnNext) {
        this.btnNext.removeProperty('disabled');
      }
      if (this.currentPage == this.currentStep.length - 2) {
        this.options.container.getElement('.instruction').set('html', this.options.toWholeMapText);
      } else {
        this.options.container.getElement('.instruction').set('html', this.options.nextText);
      }
    } else if (this.currentPage == this.currentStep.length - 1) {
      if (this.btnNext) {
        this.btnNext.setAttribute('disabled', 'disabled');
      }
      this.options.container.getElement('.instruction').set('html', this.options.wholeMapText);

      if (!this.imageMap)
        this.imageMap = new StandardImageMap($$(this.entire_map_container));

    } else {
      if (this.btnNext) {
        this.btnNext.setAttribute('disabled', 'disabled');
      }
      this.options.container.getElement('.instruction').set('html', this.options.plusText);
    }
    if (this.btnPrevious) {
      if (this.currentPage == 0) {
        this.btnPrevious.hide();
      } else {
        this.btnPrevious.show();
      }
    }
    this.insertActionText();
  },
  getSvgText: function (data, group, ind) {
    var label = "";
    switch (data.shape) {
      case "rectangle":
        label = "green rectangle";
        break;
      case "line":
        label = "line";
        break;
      case "ellipse":
        label = "orange ellipse";
        break;
      case "rhombus":
        label = "purple diamond";
        break;
      case "arrow":
        label = "red arrow";
        break;
      case "hexagon":
        label = "red hexagon";
        break;
      case "implicit":
        label = "blue thought bubble";
        break;
      case "plus":
        label = "next element";
    }

    var text = new Element('div', {
      'class': 'text ' + data.shape,
      'aria-label': label + " " + data.text,
      'role': (data.shape === "plus") ? 'button' : 'img',
      'html': data.text,
      id:data.id?data.id:null
    });

    var foreign = new Element('foreignObject', {
      'x': data.fx || data.left,
      'y': data.fy || (data.top - (data.ytimes && data.shape === "implicit" ? (data.ytimes < 1.5 ? 15 * data.ytimes : 25 * data.ytimes) : 0)),
      'width': "200" * (data.xtimes || 1),
      'height': "250" * (data.ytimes || 1)
    }).grab(text);

    var class_to_use = this.checkForClass('.text-wrapper-' + (data.text == "" ? "no-text-" : "") + ind, group, ind);

    var text_svg = new Element('div.text-wrapper.' + data.shape + class_to_use, {
      'html': "<div>" + data.text + "</div>"
    });
    group.getParent(".page").adopt(text_svg);
    
    if(data.linked_layer){
      $$(".linked-layer:not(.linked-layer-page-"+this.currentPage+")").hide();
      $$("#"+data.linked_layer+".linked-layer-page-"+this.currentPage).show();
    }
    

    return foreign;
  },
  checkForClass: function (class_to_use, group, i) {
    if (group.getParent(".page").getElement(class_to_use) != null) {
      return this.checkForClass(class_to_use + "-" + i, group, i);
    }
    else {
      return class_to_use;
    }
  },
  getSvgRectangle: function (data) {
    return new Element('rect', {
      'x': '5',
      'y': "25",
      'width': "190",
      "height": "100",
      'fill': data.fill || "none",
      'stroke': "#70bf41",
      'stroke-width': "3",
      'transform': "translate(" + data.left + "," + data.top + ")",
      //tabindex: "0"
    });
  },
  getSvgEllipse: function (data) {
    return new Element('ellipse', {
      'cx': 102,
      'cy': 70,
      'rx': 100 * (data.xtimes || 1),
      'ry': 70 * (data.ytimes || 1),
      'fill': data.fill || "none",
      'stroke': "#f39019",
      'stroke-width': "3",
      'transform': "translate(" + data.left + "," + data.top + ")",
      //tabindex: "0"
    });
  },
  getSvgRhombus: function (data) {
    return new Element('polygon', {
      'points': "1,100 101,1 202,100, 101,200",
      'fill': "none",
      'stroke': "#777b81",
      'stroke-width': "3",
      'transform': "translate(" + data.left + "," + (data.top - 10) + ")",
      //tabindex: "0"
    });
  },
  getSvgRhombusBig: function (data) {
    return new Element('polygon', {
      'points': "1,170 170,1 340,170, 170,340",
      'fill': "none",
      'stroke': "#777b81",
      'stroke-width': "3",
      'transform': "translate(" + data.left + "," + (data.top - 10) + ")",
      //tabindex: "0"
    });
  },
  getSvgArrow: function (data) {
    return new Element('polygon', {
      'points': "1,30 135,30 135,1 195,75 135,149 135,120 1,120",
      'fill': "none",
      'stroke': "#c82506",
      'stroke-width': "3",
      'transform': "translate(" + data.left + "," + data.top + ") " + "scale(" + (data.xtimes || 1) + "," + (data.ytimes || 1) + ")",
      //tabindex: "0"
    });
  },
  getSvgHexagon: function (data) {
    return new Element('polygon', {
      'points': "100,45 130,60 130,95 100,110 70,95 70,60",
      'fill': "none",
      'stroke': "#c82506",
      'stroke-width': "3",
      'transform': "translate(" + data.left + "," + data.top + ")",
      //tabindex: "0"
    });
  },
  getSvgImplicit: function (data) {
    var group = new Element('g');

    var item = new Element('ellipse', {
      'cx': 102,
      'cy': 80 - (data.ytimes > 1 ? 25 / data.ytimes : 0),
      'rx': 100 * (data.xtimes || 1),
      'ry': 75 * (data.ytimes || 1),
      'fill': data.fill || "none",
      'stroke': "#92c8fb",
      'stroke-width': "2",
      'transform': "translate(" + data.left + "," + data.top + ")",
      //tabindex: "0"
    }).inject(group);

    item = new Element('ellipse', {
      'cx': 46,
      'cy': 147 + (data.ytimes > 1.5 ? 25 * data.ytimes : 0),
      'rx': 20,
      'ry': 14,
      'fill': "#ffffff",
      'stroke': "#92c8fb",
      'stroke-width': "2",
      'transform': "translate(" + data.left + "," + data.top + ")"
    }).inject(group);

    item = new Element('ellipse', {
      'cx': 24,
      'cy': 163 + (data.ytimes > 1.5 ? 25 * data.ytimes : 0),
      'rx': 16,
      'ry': 12,
      'fill': "#ffffff",
      'stroke': "#92c8fb",
      'stroke-width': "2",
      'transform': "translate(" + data.left + "," + data.top + ")"
    }).inject(group);
    return group;
  },

  getSvgImplicitBig: function (data) {
    var group = new Element('g');

    var item = new Element('ellipse', {
      'cx': 102,
      'cy': 85 - (data.ytimes > 1 ? 25 / data.ytimes : 0),
      'rx': 120 * (data.xtimes || 1),
      'ry': 78 * (data.ytimes || 1),
      'fill': data.fill || "none",
      'stroke': "#92c8fb",
      'stroke-width': "2",
      'transform': "translate(" + data.left + "," + data.top + ")",
      //tabindex: "0"
    }).inject(group);

    item = new Element('ellipse', {
      'cx': 46,
      'cy': 161 + (data.ytimes > 1.5 ? 25 * data.ytimes : 0),
      'rx': 20,
      'ry': 14,
      'fill': "#ffffff",
      'stroke': "#92c8fb",
      'stroke-width': "2",
      'transform': "translate(" + data.left + "," + data.top + ")"
    }).inject(group);

    item = new Element('ellipse', {
      'cx': 24,
      'cy': 175 + (data.ytimes > 1.5 ? 25 * data.ytimes : 0),
      'rx': 16,
      'ry': 12,
      'fill': "#ffffff",
      'stroke': "#92c8fb",
      'stroke-width': "2",
      'transform': "translate(" + data.left + "," + data.top + ")"
    }).inject(group);
    return group;
  },
  getSvgPlus: function (data) {
    var group = new Element('g');

    var item = new Element('circle', {
      'cx': 30,
      'cy': 30,
      'r': 25,
      'fill': "none",
      'stroke': "#c82506",
      'stroke-width': "4",
      'transform': "translate(" + data.left + "," + data.top + ")",
      'data-button': 'plus-btn',
      //tabindex: "0"
    }).inject(group);

    item = new Element('line', {
      'x1': 30,
      'y1': 20,
      'x2': 30,
      'y2': 40,
      'stroke': "#c82506",
      'stroke-width': "4",
      'transform': "translate(" + data.left + "," + data.top + ")"
    }).inject(group);

    item = new Element('line', {
      'x1': 20,
      'y1': 30,
      'x2': 40,
      'y2': 30,
      'stroke': "#c82506",
      'stroke-width': "4",
      'transform': "translate(" + data.left + "," + data.top + ")"
    }).inject(group);
    return group;
  },
  getSvgLine: function (data) {
    return new Element('line', {
      'x1': data.left,
      'y1': data.top,
      'x2': data.end_left,
      'y2': data.end_top,
      'marker-end': data.no_tip ? '': 'url(#markerArrow' + this.currentPage + ')',
      'stroke': "#53585f",
      'stroke-dasharray': "10,10",
      'stroke-width': data.width || "3"
    });
  },
  getSvgShape: function (data) {
    switch (data.shape) {
      case "rectangle":
        return this.getSvgRectangle(data);
        break;
      case "ellipse":
        return this.getSvgEllipse(data);
        break;
      case "rhombus":
        return this.getSvgRhombus(data);
        break;
      case "rhombus_big":
        return this.getSvgRhombusBig(data);
        break;
      case "arrow":
        return this.getSvgArrow(data);
        break;
      case "hexagon":
        return this.getSvgHexagon(data);
        break;
      case "implicit":
        return this.getSvgImplicit(data);
        break;
      case "implicit_big":
        return this.getSvgImplicitBig(data);
        break;
      case "plus":
        return this.getSvgPlus(data);
        break;
      case "line":
        return this.getSvgLine(data);
        break;
    }
    return null;

  },
  initSvgExtention: function () {
    var svgtags = ['svg', 'g', 'rect', 'circle', 'ellipse', 'line', 'polygon', 'foreignObject', 'text','defs'];
    var ns = 'http://www.w3.org/2000/svg',
            methods = (function (proto, cls) {
              var hash = {};
              for (var f in proto) {
                if (cls.hasOwnProperty(f)) {
                  hash[f] = proto[f];
                }
              }
              return hash;
            })(Element.prototype, Element);
    svgtags.each(function (tag) {
      Element.Constructors[tag] = function (props) {
        return (Object.append(document.createElementNS(ns, tag), methods).set(props));
      };
    });
  },
  displayMapPart: function (parentEle, data) {
    if (data == null)
      return;
    //console.log(data);
    for (var i = 0; i < data.length; i++) {
      var group = new Element('g').inject(parentEle);
      var shape = this.getSvgShape(data[i]);
      if(shape)
        shape.inject(group);
      this.getSvgText(data[i], group, i).inject(group);

    }
  },
  createDOM: function () {
    if (this.firstLoad) {
      this.initSvgExtention();
    }

    var diagram = this.options.container.getElement('.widget-body .map-diagram'),
            pageIndicator = this.options.container.getElement('.page-indicator'),
            width = this.options.container.getElement(".widget-body").getSize().x - 30,
            height = this.options.container.getElement(".widget-body").getSize().y,
            that = this, i = 0;
    diagram.set('html', '');
    if(pageIndicator)
        pageIndicator.set('html', '');
    this.currentStep = [];
    this.currentPage = 0;

    for (var page in this.options.data) {
      var pageEle = new Element('div.page.' + page).inject(diagram);
      var svg = new Element('svg', {
        //html: '<defs><marker id="markerArrow' + this.currentPage + '" markerWidth="13" markerHeight="13" refx="2" refy="7" orient="auto"><path d="M2,2 L2,10 L8,7 L2,4" fill="#53585f" /></marker></defs>',
        width: 737, //width * (!i++ ? 1.1 : (i===4 ? 1.085 : 1.2)),
        height: height,
        viewBox: "0 0 1050 " + height,
        style: "enable-background:new 0 0 1050 " + height
      }).inject(pageEle);

//      var def = new Element("defs");
//      def.inject(svg);
//
//      var marker = new Element("marker",{
//        id: 'markerArrow' + this.currentPage,
//        markerWidth:13,
//        markerHeight:13,
//        refx:2,
//        refy:7,
//        orient:'auto'
//      });
//      marker.inject(def);
//
//      var path = new Element("path",{
//        d:"M2,2 L2,10 L8,7 L2,4",
//        fill:"#53585f"
//      });
//      path.inject(marker);
      

      if (pageIndicator){
        new Element('div.page-box.box-' + page).inject(pageIndicator);
        }
      this.displayMapPart(svg, this.options.data[page][0]);
      this.currentStep.push(0);
      this.currentPage++;
    }

    if (pageIndicator && (this.options.entire_map || this.options.entire_map_svg))
      new Element('div.page-box.box-page-last').inject(pageIndicator);
      
    if (this.options.entire_map) {
      var pageEle = new Element('div.page.entire_map.page' + this.currentPage).inject(diagram);
      this.entire_map_container = new Element('div.image_container', {
        "data-autoZoom": true,
        "data-show-navigator": true,
        "data-controls": "right",
        tabindex: 0,
        'aria-labelledby': "info"
      }).inject(pageEle);

      var img = new Element('img', {
        src: this.options.entire_map,
        width: 1578,
        height: 3030
      }).inject(this.entire_map_container);
      this.displayMapPart(svg, this.options.entire_map_shapes);

      if (this.options.entire_map_svg) {
        var svg = new Element('svg#info', {
          html: '<defs><marker id="markerArrow' + this.currentPage + '" markerWidth="13" markerHeight="13" refx="2" refy="7" orient="auto"><path d="M2,2 L2,10 L8,7 L2,4" fill="#53585f" /></marker></defs>',
          width: width * (!i++ ? 1.1 : (i === 4 ? 1.085 : 1.2)),
          height: height,
          viewBox: "200 0 2000 1250",
          style: "enable-background:new 200 0 2000 1250"
        }).inject(pageEle);
        this.displayMapPart(svg, this.options.entire_map_svg);
        this.currentStep.push(0);
      }
       this.imageMap = false;
    }

    this.currentPage = 0;

    if (this.firstLoad) {
      var timer;
      window.addEvent('resize', function () {
        window.clearTimeout(timer);
        timer = window.setTimeout(function () {
          var width = that.options.container.getElement(".widget-body").getSize().x - 30;
          if (width > 0) {
            var height = that.options.container.getElement(".widget-body").getSize().y,
                    svg = that.options.container.getElements(".page svg");

            for (var i = 0; i < 4; i++) {
              if(svg && svg[i]) {
                // svg[i].setAttribute("width", width * (!i++ ? 1.1 : (i === 4 ? 1.085 : 1.2)))
                svg[i].setAttribute("width", width * ((i+1) ? 1.1 : (i === 4 ? 1.085 : 1.2)));
                svg[i].setAttribute("height", height);
                svg[i].setAttribute("viewBox", "0 0 1050 " + height);
                svg[i].setAttribute("style", "enable-background:new 0 0 1050 " + height);
              }
            }
          }
        }, 50);
      });
    }
  }
});