try{
    new Promise
}catch(e){
    ( function ( global ) {

        'use strict';

        var Promise, PENDING = {}, FULFILLED = {}, REJECTED = {};

        if ( typeof global.Promise === 'function' ) {
            Promise = global.Promise;
        } else {
            Promise = function ( callback ) {
                var fulfilledHandlers = [],
                  rejectedHandlers = [],
                  state = PENDING,

                  result,
                  dispatchHandlers,
                  makeResolver,
                  fulfil,
                  reject,

                  promise;

                makeResolver = function ( newState ) {
                    return function ( value ) {
                        if ( state !== PENDING ) {
                            return;
                        }

                        result = value;
                        state = newState;

                        dispatchHandlers = makeDispatcher( ( state === FULFILLED ? fulfilledHandlers : rejectedHandlers ), result );

                        // dispatch onFulfilled and onRejected handlers asynchronously
                        wait( dispatchHandlers );
                    };
                };

                fulfil = makeResolver( FULFILLED );
                reject = makeResolver( REJECTED );

                callback( fulfil, reject );

                promise = {
                    // `then()` returns a Promise - 2.2.7
                    then: function ( onFulfilled, onRejected ) {
                        var promise2 = new Promise( function ( fulfil, reject ) {

                            var processResolutionHandler = function ( handler, handlers, forward ) {

                                // 2.2.1.1
                                if ( typeof handler === 'function' ) {
                                    handlers.push( function ( p1result ) {
                                        var x;

                                        try {
                                            x = handler( p1result );
                                            resolve( promise2, x, fulfil, reject );
                                        } catch ( err ) {
                                            reject( err );
                                        }
                                    });
                                } else {
                                    // Forward the result of promise1 to promise2, if resolution handlers
                                    // are not given
                                    handlers.push( forward );
                                }
                            };

                            // 2.2
                            processResolutionHandler( onFulfilled, fulfilledHandlers, fulfil );
                            processResolutionHandler( onRejected, rejectedHandlers, reject );

                            if ( state !== PENDING ) {
                                // If the promise has resolved already, dispatch the appropriate handlers asynchronously
                                wait( dispatchHandlers );
                            }

                        });

                        return promise2;
                    }
                };

                promise[ 'catch' ] = function ( onRejected ) {
                    return this.then( null, onRejected );
                };

                return promise;
            };

            Promise.all = function ( promises ) {
                return new Promise( function ( fulfil, reject ) {
                    var result = [], pending, i, processPromise;

                    if ( !promises.length ) {
                        fulfil( result );
                        return;
                    }

                    processPromise = function ( i ) {
                        promises[i].then( function ( value ) {
                            result[i] = value;

                            if ( !--pending ) {
                                fulfil( result );
                            }
                        }, reject );
                    };

                    pending = i = promises.length;
                    while ( i-- ) {
                        processPromise( i );
                    }
                });
            };

            Promise.race = function ( promises ) {
                return new Promise( function ( fulfil, reject ) {
                    promises.forEach( function ( promise ) {
                        promise.then( fulfil, reject );
                    });
                });
            };

            Promise.resolve = function ( value ) {
                return new Promise( function ( fulfil ) {
                    fulfil( value );
                });
            };

            Promise.reject = function ( reason ) {
                return new Promise( function ( fulfil, reject ) {
                    reject( reason );
                });
            };
        }

        // TODO use MutationObservers or something to simulate setImmediate
        function wait ( callback ) {
            setTimeout( callback, 0 );
        }

        function makeDispatcher ( handlers, result ) {
            return function () {
                var handler;

                while ( handler = handlers.shift() ) {
                    handler( result );
                }
            };
        }

        function resolve ( promise, x, fulfil, reject ) {
            // Promise Resolution Procedure
            var then;

            // 2.3.1
            if ( x === promise ) {
                throw new TypeError( 'A promise\'s fulfillment handler cannot return the same promise' );
            }

            // 2.3.2
            if ( x instanceof Promise ) {
                x.then( fulfil, reject );
            }

            // 2.3.3
            else if ( x && ( typeof x === 'object' || typeof x === 'function' ) ) {
                try {
                    then = x.then; // 2.3.3.1
                } catch ( e ) {
                    reject( e ); // 2.3.3.2
                    return;
                }

                // 2.3.3.3
                if ( typeof then === 'function' ) {
                    var called, resolvePromise, rejectPromise;

                    resolvePromise = function ( y ) {
                        if ( called ) {
                            return;
                        }
                        called = true;
                        resolve( promise, y, fulfil, reject );
                    };

                    rejectPromise = function ( r ) {
                        if ( called ) {
                            return;
                        }
                        called = true;
                        reject( r );
                    };

                    try {
                        then.call( x, resolvePromise, rejectPromise );
                    } catch ( e ) {
                        if ( !called ) { // 2.3.3.3.4.1
                            reject( e ); // 2.3.3.3.4.2
                            called = true;
                            return;
                        }
                    }
                }

                else {
                    fulfil( x );
                }
            }

            else {
                fulfil( x );
            }
        }

        // export as node module
        if ( typeof module !== 'undefined' && module.exports ) {
            module.exports = Promise;
        }

        // or as AMD module
        else if ( typeof define === 'function' && define.amd ) {
            define( function () { return Promise; });
        }

        global.Promise = Promise;

    }( typeof window !== 'undefined' ? window : this ));
}

var ua = window.navigator.userAgent;
var Android = !!ua.match(/Android/i);
var iOS = !!ua.match(/iPhone/i);
var webkit = !!ua.match(/WebKit/i);
var iOSSafari = iOS && webkit && !ua.match(/CriOS/i);
var isSafari = typeof navigator !== 'undefined' && /Version\/[\d\.]+.*Safari/.test(navigator.userAgent);

AssessableTable = new Class( {
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    rd: null,
    data: {},
    settings: {},
    contentMaxHeight: 200,
    draggableSelected: null,
    attempt: 1,
    rowWidthsPresetting: [],
    initialized: false,

    initialize: function (options) {
        var that = this;
        document.widgetType = 'assessableTable';
        var presentationText = $('presentation-instruction-text');
        var challengeText = $('challenge-instruction-text');

        this.parent(options);
        this.data = this.options.data;
        this.settings = this.options.options;
        this.attempt = 1;
        this.challengeAssessableText = "Navigate to the first concept below the table and drag it to the correct blank cell. Match each concept to a blank cell until you have dragged all concepts to their correct location. If you want to start over, select the start over button.";
        this.presentationAssessableText = "Study the table by navigating through the columns, rows, and cells. When you’re ready to test yourself, select the button labeled Check Your Understanding. You will be taken to a second screen that contains the column and row headers that appeared in the first screen. Some cells from the first screen will now be blank."
        if (this.isEditMode) {
            //set instructions placeholders
            presentationText.setAttribute('placeholder', presentationText.getAttribute('data-placeholder'))
            challengeText.setAttribute('placeholder', challengeText.getAttribute('data-placeholder'))

            this.renderTableEdit();
            this.enableInstructionText();

        } else {
            $$('body')[0].grab(new Element('#instructions-tooltip.visually-hidden', {
                text: "Select an option from the list, and submit your answer."
            }))
            
            if (!this.initialized) {
                $$('body').addEvent('keydown', function(e){
                    var wasTabPressed = e.code == 9 || e.which == 9 || e.keyCode == 9;
                    var key = wasTabPressed? 'tab': 'notab'

                    document.lastKeyPressed = {
                       key : key,
                       shift : e.shift
                    }
                })

                
                $$('*').addEvent('focusin',function(e){
                    // prevent a11y menu appears
                    var wasByKeyboard = window.lastClick < window.lastKey;
                    if (!wasByKeyboard) {
                        $$('#bottom-table .content').floatingTipsHide();
                        return;
                    }

                    e.stopPropagation();
                    var target = $(e.target)
                    var parent = target.getParent()

                    // hide dropdown and submit answer button for any assessable item 
                    // that does not currently have tab focus
                    var dragContainerEls = $$('.start-drag');
                    if (dragContainerEls.indexOf(parent) !== -1) {
                        dragContainerEls.splice(dragContainerEls.indexOf(parent), 1);
                    }
                    dragContainerEls.forEach(function (el, index) {
                        el.getChildren('button, select')
                            .set('tabindex', -1)
                            .addClass('visually-hidden');
                    });

                    if(parent.hasClass('start-drag')){
                        if(document.previousFocused == 'tryAgainAction'){
                            setTimeout(function(){
                                try{
                                    $$('.floating-tip-wrapper')[0].remove()
                                }
                                catch(e){
                                }
                            },0)
                            document.previousFocused = 'button'
                            return
                        }
                        if (!target.hasClass('redips-drag')) {
                            if (document.previousFocused == 'not-allowed') {
                                return
                            } else {
                                if (target.tagName == 'button') document.previousFocused = 'button'
                                if (target.tagName == 'select') document.previousFocused = 'select'
                            }

                        } else {
                            document.previousFocused = 'redips'
                            parent.getChildren().set('tabindex', 0)
                        }
                        parent.getChildren().removeClass('visually-hidden')
                    }else{
                        document.previousFocused = 'not-allowed'
                    }

                })
                $$('*').addEvent('focusout',function(e){
                    e.stopPropagation()
                    var target = $(e.target)
                    var parent = target.getParent()
                    if(parent.hasClass('start-drag')){
                        setTimeout(function(){
                            if(document.activeElement.tagName != 'SELECT' &&
                                document.activeElement.tagName != 'BUTTON' &&
                                document.activeElement.tagName != 'DIV'){
                                // hide a11y control
                                parent.getChildren('button, select')
                                    .set('tabindex', -1)
                                    .addClass('visually-hidden');
                            }
                        },0)

                        if(target.hasClass('redips-drag')){
                            if(document.previousFocused != 'button') return
                        }
                        else if(target.tagName =='BUTTON'){
                            if(document.previousFocused != 'redips' && document.previousFocused != 'select')
                                return
                        }
                        else if(target.tagName == 'SELECT') {
                            if(document.previousFocused != 'button') return
                        }
                    }
                })
            }

            that.createAssessableText();
            switch(this.settings.startMode) {
                case 'presentation':
                    this.renderTablePresentation();
                    break;

                case 'challenge':
                    this.renderTableChallenge();
                    break;
            }
            
            if (!this.initialized) {
                this.bindActionsOnPreview();
            }
        }

        if (!this.initialized) {
            window.addEvent('resize', function () {
                that.resizeDraggables();
                that.updateAssessmentAreaHeight();

                that.fixTableCaptionPositionOnSafari();
            });
        }

        this.updateAssessmentAreaHeight();
        this.initTinyMCE();
        
        this.initialized = true;

        // fix intro line font size on android device
        if (Android) {
            $$('body').addClass('is-android-device');
        }
    },

    fixTableCaptionPositionOnSafari: function () {
        if (isSafari) {
            // HACK: position caption on top of the table
            // fix https://metrodigi.atlassian.net/browse/INTQ3-1722
            $$('#top-table-caption').setStyle('display', 'table-header-group');
            $$('#top-table-caption').setStyle('margin-bottom', '0');
            $$('#top-table-caption > div').setStyle('padding-bottom', '10px');
            $$('#top-table-caption > div').setStyle('width', $$('#top-table-caption').getSize()[0].x);
        }
    },

    //MD Framework METHODS
    customPostMessages: function (message, path) {
        var that = this;

        switch (message.data.method) {
            case 'setting-change':
                settingUpdated = message.data.updated;
                newSettings = JSON.parse(message.data.settings);
                this.settings = newSettings;

                this.saveDataOptions().then(function (response) {
                    that.updateDataStructure(settingUpdated);

                }, function (error) {
                    console.warn(error);
                });

                break;

            case 'add-content':
                target = message.data.target;
                content = message.data.content;
                this.addContent(target, content);

                break;

            case 'add-text':
                target = message.data.target;
                content = message.data.content;
                this.addText(target, content);

                break;

            case 'delete-content':
                target = message.data.target
                this.deleteContent(target)

                break;
        }
    },

    saveRequestPromise: function (request) {
        var that = this;

        return new Promise(function (resolve, reject) {
            var formData = new FormData();
            var xhr = new XMLHttpRequest();

            request.path = '';
            request = JSON.stringify(request);
            formData.append('savedata', request);
            formData.append('widget_id', that.widget_id);

            xhr.open('POST', that.root + 'api/index.php/save/');
            xhr.onload = function () {
                if (xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);

                    resolve('Saved!');

                } else {
                    reject(xhr.status + ' ' + xhr.responseText)
                }
            };

            xhr.send(formData);
        });
    },
    cleanUpTinyContent: function(_content) {
        //cleanup html
        var _doc = (new DOMParser()).parseFromString('<div class="dom_wrapper">'+_content+'</div>','text/html');
        Array.prototype.slice.call(_doc.querySelectorAll('body *.tiny-mce-inlince-placeholder')).forEach(function(theEl){
            if(theEl && theEl.parentElement)
                theEl.parentElement.removeChild(theEl)
        });
        // Array.prototype.slice.call(_doc.querySelectorAll('body [data-mce-bogus]')).forEach(function(theEl){
        //     var _p = theEl.parentElement;
        //     if(_p){
        //         if(theEl.childNodes.length > 0 && _p){
        //             Array.prototype.slice.call( theEl.childNodes ).forEach( function(theChild) {
        //                 _p.appendChild(theChild);
        //             });
        //         }
        //         _p.removeChild(theEl);
        //         if( _p.childNodes.length == 0 && _p.parentElement) {
        //             _p.parentElement.removeChild(_p);
        //         }
        //     }
        // });
        //title = (new XMLSerializer()).serializeToString(_doc.querySelector('body > *.dom_wrapper'));
        _content = (_doc.querySelector('body > *.dom_wrapper'))? _doc.querySelector('body > *.dom_wrapper').innerHTML : '';
        //end cleanup html

        return _content;
    },
    saveDataOptions: function () {
        var presentationText = $('presentation-instruction-text');
        var challengeText = $('challenge-instruction-text');
        var presentationTextString = this.cleanUpTinyContent(presentationText.get('html'));
        var challengeTextString = this.cleanUpTinyContent(challengeText.get('html'));
        this.settings.presentationInstruction = presentationTextString;
        this.settings.challengeInstruction = challengeTextString;
        
        var request = {
            method: 'mdDataByID',
            selector: '#md-widget-data-options',
            variable_name: 'options',
            path: '',
            options: {
                json: this.settings
            }
        };

        return this.saveRequestPromise(request);
    },

    saveData: function () {
        var request = {
            method: 'mdDataByID',
            selector: '#md-widget-data',
            variable_name: 'data',
            path: '',
            options: {
                json: this.data
            }
        };

        return this.saveRequestPromise(request);
    },

    //COMMON METHODS
    enableInstructionText: function () {
        var that = this;

        this.saveTimer = null;

        presentationText = $('presentation-instruction-text');
        challengeText = $('challenge-instruction-text');

        presentationText.set('contenteditable', 'true').set('data-md-editable', 'md-content-editable').show();
        challengeText.set('contenteditable', 'true').set('data-md-editable', 'md-content-editable').show();

        presentationText.addEvent('input', function (e) {
            that.settings.presentationInstruction = presentationText.get('html');

            clearTimeout(that.saveTimer);
            that.saveTimer = setTimeout(function () {
                that.saveDataOptions();
            }, 500);
        });

        challengeText.addEvent('input', function (e) {
            that.settings.challengeInstruction = challengeText.get('html');

            clearTimeout(that.saveTimer);
            that.saveTimer = setTimeout(function () {
                that.saveDataOptions();
            }, 500);
        });
    },

    updateDataStructure: function (settingUpdated) {
        var that = this;

        if (settingUpdated.setting === 'rowsLabel') {
            if (settingUpdated.value) {
                this.data.each(function (row, index) {
                    row.columns.unshift({
                        id: 0,
                        type: 'text',
                        content: '',
                        isAssessable: false
                    });
                })
            } else {
                this.data.each(function (row, index) {
                    row.columns.shift();
                })
            }
        }

        newRowsNumber = this.settings.rows;
        newColumnsNumber = this.settings.columns;
        currentRowsNumber = this.data.length;
        currentColumnsNumber = this.data[0].columns.length;

        //Add rows
        if (currentRowsNumber < newRowsNumber) {
            for (var i = currentRowsNumber; i < newRowsNumber; i++) {

                newRow = {
                    id: (i+1),
                    columns: []
                }
                for (var j = 1; j <= currentColumnsNumber; j++) {
                    var type = 'empty';
                    if (this.settings.rowsLabel && j === 1) {
                        type = 'text';
                    }
                    newRow.columns.push({
                        id: j,
                        type: type,
                        content: '',
                        isAssessable: false
                    });
                }

                this.data.push(newRow);
            }
        }

        //Delete rows
        if (currentRowsNumber > newRowsNumber) {
            for (var i = currentRowsNumber; i > newRowsNumber; i--) {
                this.data.pop();
            }
        }

        //Add columns
        if (currentColumnsNumber < newColumnsNumber) {
            columnsToAdd = newColumnsNumber - currentColumnsNumber;

            this.data.each( function (row, index){
                for (var i = currentColumnsNumber; i < newColumnsNumber; i++) {
                    if (index === 0) {
                        row.columns.push({
                            id: (i+1),
                            type: 'text',
                            content: '',
                            isAssessable: false
                        });
                    } else {
                        row.columns.push({
                            id: (i+1),
                            type: 'empty',
                            content: '',
                            isAssessable: false
                        });
                    }
                }
            });
        }

        //Delete columns
        if (currentColumnsNumber > newColumnsNumber) {
            this.data.each( function (row, index){
                for (var i = currentColumnsNumber; i > newColumnsNumber; i--) {
                    row.columns.pop();
                }
            });
        }

        //Change col width
        columnWidth = 100 / newColumnsNumber
        columnWidth = columnWidth.toFixed(2);

        titleRow = this.data[0];
        titleRow.columns.each( function (column, index) {
            var cWidth = columnWidth + '%';
            if(!that.settings.rowsLabel && that.rowWidthsPresetting != null && that.rowWidthsPresetting.length > 0){
                cWidth = that.rowWidthsPresetting[index];
            }
            column.width = cWidth;
        })

        this.saveData().then(
            function (response) {
                that.renderTableEdit();
                that.updateColumnsWidth();
            }, function (error) {
                console.warn(error);

            }
        );
    },

    mediaLoaderPromise: function (ratio) {
        var _ratio = ratio | 1
        return new Promise(function (resolve, reject) {
            var images = $$('img');
            var videos = $$('video');

            var mediaInterval = setInterval(function () {
                if (images.length === 0 && videos.length === 0) {
                    clearTimeout(mediaInterval);
                    $('top-table').style.height = $('top-table').getHeight() * _ratio + 'px'
                    resolve({
                        'height': $('top-table').getHeight()
                    });
                }

                images.each(function (img, index) {

                    if (img.naturalHeight > 0) {
                        images.splice(index, 1);
                    }

                });

                videos.each(function (video, index) {

                    if (video.readyState === 4) {
                        videos.splice(video, 1);
                    }

                });

            }, 5);
        });

    },

    updateAssessmentAreaHeight: function () {

        if (this.isEditMode) {
            return false;
        }

        //table container
        assessmentArea = $('assessment-area');
        introLine = $('intro-line');

        introLineHeight = 0;
        presentationInstructionHeight = 0;
        challengeInstructionHeight = 0;
        footerHeight = 40;

        if (introLine) {
            introLineHeight = introLine.getHeight();
        }

        //padding = 25px
        subtract = introLineHeight + footerHeight + 25;
        assessmentArea.setStyle('height', 'calc(100vh - ' + subtract + 'px)');
    },

    bindActionsOnPreview: function() {
        var that = this;
        var checkUnderstanding = $$('.check-understanding')[0];
        var showAnswers = $$('.show-answers')[0];
        var tryAgain = $$('.try-again')[0];
        var checkAnswers = $$('.check-answers')[0];
        var startOver = $$('.start-over')[0];
        var feedback = $('challenge-feedback');

        if (that.options.options.startMode === 'presentation') {
            checkUnderstanding.addEventListener('keydown', function (event) {
                if (event.keyCode !== 13 && event.keyCode !== 32) return;

                event.preventDefault();
                event.stopPropagation();

                that.options.options.keyboardUser = true;
                that.renderTableChallenge();
                that.setAssessableText(that.challengeAssessableText);
                that.setFocusInit();
            });
        }

        checkUnderstanding.addEvent("click", function (event) {
            event.preventDefault();
            that.options.options.keyboardUser = false;

            that.renderTableChallenge();
            that.setAssessableText(that.challengeAssessableText);
            that.setFocusInit();
        });

        startOver.addEvent("click", function (event) {
            event.preventDefault();
            that.initialize();

            // clear feedback
            $$('#challenge-feedback')[0].empty();
        });

        showAnswers.addEvent("click", function () {
            that.renderTablePresentation();
            that.setFocusInit();
        });

        tryAgain.addEvent("click", function () {
            document.previousFocused = 'tryAgainAction'
            that.showFeedback('clean');
            that.draggableSelected = null;

            that.attempt = that.attempt + 1;
            that.renderTableChallenge();
        });

        checkAnswers.addEvent("click", function () {
            var tryAgain = $$('.try-again')[0];
            var startOver = $$('.start-over')[0];

            this.hide();

            $('top-table').addClass('checked');

            var ok = $$('#top-table td.ok').length;
            var total = $$('#top-table td.is-assessable').length;

            var args = {
                'ok': ok,
                'total': total,
                'currentTry': that.attempt,
                'maxAttempts': that.settings.maxAttempts
            }

            that.showFeedback('end-assessment-delayed', args);

            if (ok === total) {
                startOver.show();

            } else {

                if (that.attempt < that.settings.maxAttempts) {
                    tryAgain.show();
                    feedback.setAttribute('tabindex', 0);
                    
                    setTimeout(function (){
                        tryAgain.focus();
                    }, 3500);
                } else {
                    startOver.show();
                    feedback.setAttribute('tabindex', 0);
                    
                    setTimeout(function (){
                        startOver.focus();
                    }, 3500);
                }
            }

        });
    },
    setFocusInit: function () {
        if($$("#intro-line")[0]){
            $$("#intro-line")[0].focus();
        }else{
            if($$(".accessibility-instructions")[0]){
               $$(".accessibility-instructions")[0].focus(); 
            }   
        }

        if (this.options.options.keyboardUser) {
            setTimeout(function focusFirstAssessableItem () {
                var firstAssessableItem = $$('#bottom-table .redips-drag')[0];
                if (firstAssessableItem) {
                    firstAssessableItem.focus();
                }
            }, 350);
        }
    },
    updateFooter: function (mode) {
        var footer = $$('#footer');
        var buttons = $$('#footer button');
        var checkUnderstanding = $$('.check-understanding')[0];
        var showAnswers = $$('.show-answers')[0];
        var tryAgain = $$('.try-again')[0];
        var checkAnswers = $$('.check-answers')[0];
        var startOver = $$('.start-over')[0];
        var createTable = $$('.create-table')[0];
        var defineAssessableCells = $$('.define-assessable-cells')[0];

        buttons.hide();
        buttons.removeClass('active');

        switch (mode) {
            case 'create':
                footer.addClass('edit');
                createTable.addClass('active');
                createTable.show();
                defineAssessableCells.show();

                break;
            case 'define':
                footer.addClass('edit');
                defineAssessableCells.addClass('active');
                createTable.show();
                defineAssessableCells.show();

                break;
            case 'presentation':
                checkUnderstanding.show();

                break;
            case 'challenge':
                if (this.settings.showAnswersButton == true) {
                    showAnswers.show();
                }

                if (this.settings.assessmentMode === 'inmediate') {
                    startOver.show();

                } else {

                    if (this.attempt <= this.settings.maxAttempts) {
                        checkAnswers.show();
                        checkAnswers.setAttribute('disabled', 'disabled');
                    } else {
                        startOver.show();
                    }

                }

                break;
        }
    },

    renderTopTable: function (mode) {
        var assessmentArea = $('assessment-area');
            assessmentArea.removeClass('edit define presentation challenge');
            assessmentArea.addClass(mode);
            assessmentArea.set('html', '');

        var tableContainer = new Element('div', {
            id: 'table-container'
        });

        var topTable = new Element('table', {
            id: 'top-table'
        });

        var topTableCaption = new Element('caption', {
            id: 'top-table-caption',
            tabindex: -1,
            'aria-hidden': true
        })

        var topTableHead = new Element('thead', {
            id: 'top-table-head'
        });

        var topTableBody = new Element('tbody', {
            id: 'top-table-body'
        });

        assessmentArea.grab(tableContainer);
        tableContainer.grab(topTable);

        topTable.grab(topTableCaption);
        topTable.grab(topTableHead);
        topTable.grab(topTableBody);
    },

    renderBottomTable: function () {
        var tableContainer = $('table-container');

        var bottomTable = new Element('table', {
            id: 'bottom-table'
        });
        bottomTable.set('role','presentation');
        tableContainer.grab(bottomTable);
    },

    renderCell: function (args) {
        var element = 'td';
        var classes = 'cell redips-mark';
        var content = args.content.trim();
        var draggableClass = '';
        var placeholder = '';

        if (args.rowsLabelEnable) {
            if (args.row === 0 && args.column === 0) {
                element = 'th';
                classes = 'title empty redips-mark resizable';
                content = '';

            } else {
                if (args.row === 0) {
                    element = 'th';
                    classes = 'title redips-mark resizable';

                    if (content.length === 0) {
                        content = '';
                        placeholder = 'Title';
                    }
                }

                if (args.column === 0) {
                    classes = 'title redips-mark';

                    if (content.length === 0) {
                        content = '';
                        placeholder = 'Title';
                    }
                }
            }
        } else {

            if (args.row === 0) {
                element = 'th';
                classes = 'title redips-mark resizable';

                if (content.length === 0) {
                    content = '';
                    placeholder = 'Title';
                }
            }
        }

        switch (args.type) {
            case 'text':
                content = content;
                break;

            case 'image':
                content = '<img src="' + content + '" />';
                classes = classes + ' media';
                break;

            case 'audio':
                content = '<audio controls="controls" src="' + content + '"></audio>';
                classes = classes + ' media';
                break;

            case 'video':
                content = '<video controls="controls" src="' + content + '"></video>';
                classes = classes + ' media';
                break;

            case 'empty':
                content = '';
                classes = classes + ' add-content';
                break;

            case 'is-assessable':
                content = '';
                classes = 'cell is-assessable';
                break;

            case 'iframe':
                var audioClass = (content.match(/mediaplayer.pearsoncmg.com/) && content.match(/audio/))? 'pearson-audio' : ''; 
                
                content = '<iframe class="' + audioClass + '" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="' + content + '"></iframe>';
                classes = classes + ' iframe';
        }

        if (args.isDraggable) {
            draggableClass = 'redips-drag';
        }
        var tabIndex = -1;
        content = '<div tabindex="'+ tabIndex +'" class="content ' + draggableClass + '" data-placeholder="' + placeholder + '" >' + content + '</div>';

        var options = {
            class: classes,
            'data-row': args.row,
            'data-column': args.column,
            'data-type': args.type,
            'styles': {
                'width': args.width
            },
            html: content
        };
        switch(element){
            case 'th':
            options.scope = 'col';
            break;
        }

        var cell = new Element(element, options);

        return cell;
    },

    startChallenge: function() {
        var that = this;

        this.rd = REDIPS.drag;
        this.rd.dropMode = 'single';
        this.rd.scroll.speed = 50;
        this.rd.scroll.bound = 10;
        this.rd.init('table-container');
        window.assessableTableInstance = this.rd;

        this.rd.event.dropped = this.onDropped.bind(this);
        this.rd.event.droppedBefore = this.onDroppedBefore.bind(this);
        this.rd.event.relocateAfter = this.relocateAfter.bind(this);
        this.rd.event.beforeMove = function () {
            if ((!window._current_scale || Android)) {
                return;
            }
            var dragged = that.rd.obj;
            var stackingContextBCR = document.querySelector('#table-container').getBoundingClientRect();
            // fix drag behavior on mobile
            dragged.setStyle('transform', 'translateY(-' + stackingContextBCR.top / (window._current_scale) + 'px) translateX(-' + stackingContextBCR.left / (window._current_scale) + 'px)');
        }
        this.rd.event.finish = function (a, b, c, d) {
            var dragged = that.rd.obj;
            dragged.setStyle('transform', '');
        }
        this.rd.event.moved = function () {
            var dragged = that.rd.obj;

            dragged.setStyle('opacity', 0.9)
        }
        $('bottom-table-container')
          .adopt(new Element('div#help-text.visually-hidden', { html: "Select an option from the list and submit your answer."}))
          .adopt(new Element('div[aria-live="assertive"]',{
              html: '<div class="visually-hidden"></div>'
          }))
        this.nextDraggable();

        setTimeout(function () {
            // resize draggables
            window.fireEvent('resize');
        }, 0);
    },

    relocateAfter: function (dragged, target) {
        var that = this;

        if (!dragged || !target) {
            return false;
        }

        var targetRow = target.getAttribute('data-row');
        var targetColumn = target.getAttribute('data-column');
        var draggedRow = dragged.getAttribute('data-row');
        var draggedColumn = dragged.getAttribute('data-column');
        var checkAnswers = $$('.check-answers')[0];
        var draggables = $$('#bottom-table .start-drag');

        if (this.settings.columnsAsCategories) {
            targetRow = draggedRow;
        }

        function removeSelectedOption () {
            if (!that.options.options.columnsAsCategories) {
                //remove correct option
                $('bottom-table').getElements('select').getElement('[data-row=' + target.get('data-row') + '][data-column=' + target.get('data-column') + ']').map(function(option){
                    var parent  = option.getParent()
                    option.remove();
                })
            }
        }

        if (this.settings.assessmentMode === 'inmediate') {
            if (targetRow === draggedRow && targetColumn === draggedColumn) {
                removeSelectedOption();

                dragged.setStyle('width', '');
                dragged.setStyle('height', '');
                dragged.set('tabindex', -1);
                this.draggableSelected.setStyle('width', '0');

                target.addClass('ok dropped');
                target.setAttribute('tabindex', -1);

                this.showFeedback('correct');

                if (!this.nextDraggable()) {
                    this.endAssessment();

                } else {
                    that.shiftCellsBottomTable();
                }
            } else {

                var contentDiv = new Element('div', {
                    class: 'content',
                    tabindex: -1
                });

                dragged.removeClass('first-try');
                this.showFeedback('incorrect');

                target.getElements('div.content').each(function (content, index) {
                    if (content.getChildren().length === 0) {
                        content.dispose();
                    }
                });

                var previousCellContent;

                target.getElements('div.content').each(function (el) {
                    if (!el.classList.contains('redips-drag')) {
                        previousCellContent = el.clone();
                        el.dispose();
                    }
                });

                this.rd.relocate(target, this.draggableSelected);
                //if bug appears: settimeout 100 to swapping childnodes
                var _draggable = this.draggableSelected
                _draggable.insertBefore(_draggable.childNodes[2],(_draggable.childNodes[0]))
                target.grab(contentDiv);

                if (previousCellContent) {
                    previousCellContent.inject(contentDiv);
                }
            }
        } else {
            removeSelectedOption();

            dragged.setStyle('width', '');
            dragged.setStyle('height', '');

            if (targetRow === draggedRow && targetColumn === draggedColumn) {
                target.addClass('ok dropped');
            } else {
                target.addClass('fail dropped');
            }

            target.setAttribute('tabindex', -1);

            if (!this.nextDraggable()) {
                this.endAssessment();

                if (this.settings.assessmentMode === 'delayed') {
                    checkAnswers.removeAttribute('disabled');
                    checkAnswers.focus();
                }
            } else {

                that.shiftCellsBottomTable();

                try {
                    var nextFocusEl = $$('#bottom-table .redips-drag')[0];

                    if (!nextFocusEl.parentElement.contains(document.activeElement)) {
                        nextFocusEl.focus();
                    }

                    nextFocusEl.parentElement.getChildren('select, button').set('tabindex', '0');
                } catch (e) {}
            }
        }
        setTimeout(function(){
            $$('#top-table-body .redips-drag').set('tabindex',-1)
        },100)
    },

    shiftCellsBottomTable: function () {
        var that = this;
        var bottomTableCells = $$('#bottom-table td');
        var emptyCells = 0;

        this.draggableSelected = null;

        bottomTableCells.each(function (cell, index) {
            fromCell = cell;
            fromCellHasContent = fromCell.getChildren().length;

            if (fromCellHasContent) {
                toCell = bottomTableCells[index - emptyCells];
                that.rd.relocate(fromCell, toCell);

            } else {
                emptyCells++;

            }

        });
    },

    showFeedback: function (message, args, dont_focus) {
        var that = this;
        var feedback = $('challenge-feedback');
        var feedbackText = '';

        feedback.removeClass('correct incorrect clean end-assessment-inmediate end-assessment-delayed');
        feedback.addClass(message);
        autoHide = true;

        switch (message) {
            case 'clean':
                feedbackText = '';
                break;

            case 'correct':
                feedbackText = 'Correct!';
                break;

            case 'incorrect':
                feedbackText = 'Incorrect! Try again.';
                break;

            case 'end-assessment-inmediate':
                feedbackText = 'You completed the challenge. You got ' + args.ok + ' out of ' + args.total + ' on your first try.';
                autoHide = false;
                break;

            case 'end-assessment-delayed':
                feedbackText = 'Try ' + args.currentTry + ' of ' + args.maxAttempts + '. You have ' + args.ok + ' correct.';
                autoHide = false;
                break;
        }

        feedback.set('html', feedbackText);
        
        // on ios the feedback never appears
        if (iOSSafari) {
            feedback.setStyle('position', 'absolute');
            feedback.setStyle('bottom', '0');
        }

        var leaveFeedbackTime = 2500
        if(message != "clean"){
            if(message == 'correct'){
                leaveFeedbackTime = 1000;
            }else{
                leaveFeedbackTime = 2000;
            }
            feedback.setAttribute('tabindex', 0);
            feedback.focus();
        }

        clearTimeout(this.feedbackTimer);

        if (autoHide) {
            this.feedbackTimer = setTimeout(function (){
                feedback.set('html', '');
                feedback.setAttribute('tabindex', -1);

                feedback.setStyle('position', '');
                feedback.setStyle('bottom', '');

                if(typeof $$('#bottom-table .start-drag')[0] != "undefined"){
                    if(!dont_focus) {
                        var $firstRedipsDrag = $$('#bottom-table .start-drag .redips-drag')[0];

                        $firstRedipsDrag.focus();

                        if (!that.options.options.keyboardUser) {
                            // hide accessible dropdown menu
                            $firstRedipsDrag.getNext('select').addClass('visually-hidden');
                            $firstRedipsDrag.getNext('button').addClass('visually-hidden');
                        }
                    }
                }
            }, leaveFeedbackTime);
        }else{
            this.feedbackTimer = setTimeout(function (){
                $$(".start-over")[0].focus();
            }, 4500);
        }
    },

    onDroppedBefore: function (target) {
        var that = this;
        var targetRow = target.getAttribute('data-row');
        var targetColumn = target.getAttribute('data-column');
        var dragged = this.rd.obj;
        var draggedRow = dragged.getAttribute('data-row');
        var draggedColumn = dragged.getAttribute('data-column');

        dragged.setStyle('opacity', 1);

        if (target.hasClass('start-drag')) {
            return false;
        }

        if (this.settings.columnsAsCategories) {
            //force to be equal (target and dragged rows id) allowing to drop at any row in the correct column
            targetRow = draggedRow;
        }

        if (this.settings.assessmentMode === 'inmediate') {

            if (targetRow === draggedRow && targetColumn === draggedColumn) {
                target.addClass('ok');
                dragged.setStyle('width', '');
                dragged.setStyle('height', '');
                dragged.getParent().setStyle('width', '0');
                this.showFeedback('correct', null, true);
            } else {

                dragged.removeClass('first-try');
                this.showFeedback('incorrect', null , true)

                return false;
            }

        } else {
            dragged.setStyle('width', '');
            dragged.setStyle('height', '');
            // dragged.getParent().setStyle('width', '0');
            var parent = dragged.getParent()
            if(!parent.classList.contains('dropped'))  parent.remove()

            if (targetRow === draggedRow && targetColumn === draggedColumn) {
                target.addClass('ok');
                target.removeClass('fail');
            } else {
                target.addClass('fail');
                target.removeClass('ok');
            }

            var currentCell = dragged.parentElement;

            if (
                !currentCell.classList.contains('start-drag') && 
                currentCell.tagName.toUpperCase() === 'TD'
            ) {
                var currentRow = currentCell.getAttribute('data-row');
                var currentColumn = currentCell.getAttribute('data-column');

                if (currentRow !== targetRow || currentColumn !== targetColumn) {
                    // apply outline styles
                    currentCell.classList.remove('dropped');
                }
            }
        }

        if (dragged.hasClass('media')) {
            target.addClass('media');
        }

    },

    onDropped: function (target) {
        var that = this;
        var pos = this.rd.getPosition();
        var checkAnswers = $$('.check-answers')[0];
        var nextAvailable = this.nextDraggable();
        var assessableCells = $$('#top-table cell.is-assessable');

        target.addClass('dropped');

        if (!nextAvailable) {
            this.endAssessment();

            if (this.settings.assessmentMode === 'delayed') {
                checkAnswers.removeAttribute('disabled');
            }

            var assessmentArea = $('assessment-area');
            var topTableContainer = $('top-table-container');
            topTableContainerHeight = assessmentArea.getHeight();
            topTableContainer.setStyle('height', topTableContainerHeight);

        } else {

            if (pos[0] === 0 && pos[3] === 1) {
                var bottomTableCells = $$('#bottom-table td');
                var bottomTableContainerHeight = $('bottom-table-container').getHeight() - 30;
                var bottomTableAssessables = $$('#bottom-table td .content');
                var bottomTableCellsNumberPerRow = Number($('bottom-table').getAttribute('data-columns'));
                var bottomTableAssessablesNumber = bottomTableAssessables.length;
                var emptyCells = 0;

                bottomTableCells.each(function (cell, index) {
                    fromCell = cell;
                    fromCellHasContent = fromCell.getChildren().length;

                    if (fromCellHasContent) {
                        toCell = bottomTableCells[index - emptyCells];
                        that.rd.relocate(fromCell, toCell, 'animate');

                    } else {
                        emptyCells++;
                    }
                });

            }

        }
        setTimeout(function(){
            $$('#top-table-body .redips-drag').set('tabindex',-1)
        },100)
    },

    nextDraggable: function() {
        var draggables = $$('#bottom-table div.redips-drag');
        var nextAvailable = false;
        $$('.start-drag select, .start-drag button').set('tabindex', -1)

        if (draggables.length) {
            draggables[0].show();

            nextAvailable = true;

            if (this.settings.assessmentMode == 'inmediate') {
                this.fitContent();
            }
            try {
                document.dispatchEvent(document.resizeDraggable)
            } catch(e){
                console.log('no iphone')

            }
        }

        return nextAvailable;
    },

    endAssessment: function() {
        var assessmentMode = this.settings.assessmentMode;

        switch (assessmentMode) {
            case 'inmediate':

                var onDropTotal = $$('#top-table .cell.dropped').length;
                var onDropFirstTry = $$('#top-table .cell .first-try').length;

                var args = {
                    'ok': onDropFirstTry,
                    'total': onDropTotal
                }
                this.showFeedback('end-assessment-inmediate', args);

                break;
        }
        $$('#top-table')[0].set('role', 'presentation')
    },

    enableAccessibility: function(mode) {
        var that = this;
        var widgetIntroLine = $('intro-line');

        if (widgetIntroLine) {
            widgetIntroLine.setAttribute('tabindex', 0);
        }

        switch (mode) {
            case 'presentation':
                $$('#top-table .redips-mark').each(function (cell, index) {
                    if (!cell.hasClass('empty')) {
                        //cell.setAttribute('tabindex', 0);
                    }
                });

                break;

            case 'challenge':
                function getMenuOptions (row, column) {
                    var headerRow = that.data[0].columns;
                    var headerTexts = headerRow.map(function (headerCell, index) {
                        // remove whitespace from start of string
                        return getCellText(headerCell).replace(/^\s\s*/, '');
                    });

                    if (that.options.options.columnsAsCategories) {
                        // columns headers
                        return headerRow.map(function (headerCell, index) {
                            // TODO: cambiar row
                            return '<option data-row="' + row + '" data-column="' + index + '">' + headerTexts[index] + '</option>';
                        });
                    }

                    var menuOptions = [];

                    // fill menuOptions
                    that.data.slice(1).forEach(function (row, rowIndex) {
                        row.columns.forEach(function (cell, cellIndex) {
                            if (cell.isAssessable) {
                                var optionLabel = []
                                
                                row.columns.each(function (column, index) {
                                    // avoid current assessable cell
                                    if (index === cellIndex) return;

                                    var label = '';

                                    if (headerTexts[index]) {
                                        label += headerTexts[index] + ': ';
                                    }

                                    label += getCellText(column);

                                    optionLabel.push(label)
                                });
                                var option = '<option data-row="' + (rowIndex + 1) + '" data-column="' + cellIndex + '">' + optionLabel.join(' | ') + '</option>';
                                menuOptions.push(option);
                            }
                        });
                    });

                    return menuOptions;
                }

                function getCellText (cell) {
                    // get cell text
                    if (cell.type == 'text') {
                        return new Element('div', {html: cell.content}).get('text');
                    }

                    if (cell.type == 'empty') {
                        // TODO:
                        return '';
                    }

                    if (cell.type == 'iframe') {
                        var src = cell.content;
                        var n = src.lastIndexOf('/');
                        var final_src = src.substring(n + 1);
                        var text = '';

                        if (window.accessibility_data && window.accessibility_data.images) {
                            window.accessibility_data.images.each(function (image) {
                                if (image.src === final_src) {
                                    text = image.alt;
                                }
                            })
                        }

                        return text;
                    }

                    console.warn('unknown cell.type: ', cell.type);
                    return '';
                    // return cellText = col.alt; // if type == image
                }

                function hideAssessableMenu(wrapper){
                    var children = wrapper.getChildren('button,select');

                    children.addClass('visually-hidden');
                    children.set('tabindex', -1);
                    $$('#bottom-table .content').floatingTipsHide();
                }

                function SetHideAssessableMenu(e){
                    var wrapper = $(e.target.parentNode);
                    if(e.target.tagName == 'P') wrapper = $(e.target.parentNode.parentNode);
                    hideAssessableMenu(wrapper);
                }

                function submitAnswer(e){
                  e.stopPropagation();

                  var selectInput = this.previousSibling;

                  if (selectInput.selectedIndex > -1) {
                    $(selectInput).set('selected-index', selectInput.selectedIndex)
                  } else{
                    selectInput.selectedIndex = $(selectInput).get('selected-index');
                  }

                  hideAssessableMenu($(e.target.parentNode))

                  var _this = selectInput.options[selectInput.selectedIndex]
                  var row = _this.getAttribute('data-row');
                  var col = _this.getAttribute('data-column');
                  var query  = 'td[data-row=' + row + '][data-column=' +  col + ']';
                  var cell = $$('#top-table>tbody')[0].getElement(query);

                  that.draggableSelected = selectInput.parentElement;
                  that.rd.relocate(selectInput.parentElement,  cell, 'animation');
                }

                // add accessible dropdown menu to each draggable
                $$('#bottom-table .start-drag').each(function (draggable, index) {
                    var cellDataEl = draggable.querySelector('div');
                    var menu = new Element('select.assessable-controls.visually-hidden', {
                        styles: {
                            maxWidth: that.options.options.assessmentMode === 'inmediate' ? '250px' : '100%'
                        },
                        'aria-label':  'Select an option from the list and submit your answer.',
                        html: getMenuOptions(cellDataEl.get('data-row'), cellDataEl.get('data-column')),
                        'tabindex': (index == 0 ? index : -1)
                    })
                    var menuSubmitButton = new Element('button.assessable-controls.visually-hidden', {
                      'aria-label':  'Submit answer',
                      html: "Submit answer",
                      'tabindex': (index == 0 ? index : -1)
                    })

                    draggable.getElement('.redips-drag').addEvent('click', SetHideAssessableMenu)
                    draggable.getElement('.redips-drag').addEvent('contextmenu', SetHideAssessableMenu)
                    draggable
                      .getElement('.redips-drag')
                      .set('tabindex',0)
                      .set('aria-describedby','help-text')
                      .getParent()
                      .adopt(menu)
                      .adopt(menuSubmitButton);

                    menu.set('selected-index', 0);
                    menuSubmitButton.addEventListener('click', submitAnswer);
                });

                var ariaTextbyRow = new Array($$('#top-table tr').length);
                for (i = 0; i < ariaTextbyRow.length; i++) {
                    ariaTextbyRow[i] =  new Array(Math.ceil(($$('#top-table td').length + $$('#top-table th').length)/$$('#top-table tr').length));
                }

                $$('#top-table .redips-mark').each(function (cell, index) {
                    cell.setAttribute('tabindex', -1);
                    ariaTextbyRow[cell.getAttribute('data-row')][cell.getAttribute('data-column')] = cell
                });
                $$('#top-table .is-assessable').each(function (cell, index) {
                    var row = cell.getAttribute('data-row');
                    var column = cell.getAttribute('data-column');
                    var divTemporal = new Element('div');
                    var columnTitle = '';
                    var rowTitle = '';
                    var columnContent = '';
                    var rowContent = '';
                    var label = '';
                    var extraLabel = '';
                    for (i = 0; i < ariaTextbyRow[row].length; i++) {
                        if (typeof ariaTextbyRow[row][i] != "undefined"){
                            extraLabel += " row " + ariaTextbyRow[row][i].getAttribute('data-row');
                            extraLabel += " and column " + (parseInt(ariaTextbyRow[row][i].getAttribute('data-column'))+1);
                            extraLabel += " " + ariaTextbyRow[row][i].innerText;
                        }
                    }
                    columnContent = that.data[0].columns[column].content;
                    divTemporal.set('html', columnContent);
                    columnTitle = divTemporal.get('text');

                    if (that.settings.rowsLabel === true) {
                        rowContent = that.data[row].columns[0].content;
                        divTemporal.set('html', rowContent);
                        rowTitle = divTemporal.get('text');

                        label = label + 'Row ' + rowTitle + ' column ' + columnTitle + ' blank for' + extraLabel;
                    } else {
                        label = label + 'Row ' + row + ' column ' + columnTitle + ' blank for' + extraLabel;
                    }

                    cell.addEvent('keypress', function (e) {
                        if (e.key == 'enter' || e.key == 'space') {
                            if (!that.draggableSelected) {
                                $$('#bottom-table .start-drag').some(function (draggable, index) {
                                    if (draggable.getChildren().length) {
                                        that.draggableSelected = draggable;
                                        return true;
                                    }
                                });
                            }

                            that.rd.relocate(that.draggableSelected, cell, 'animation');
                        }
                    });
                });

                break;
        }
    },

    createAssessableText: function (text) {
        // var widgetContent = $$(".widget-content")[0];
        // var hiddenLabel = new Element("div.accessibility-instructions.invisible[tabindex=0]");
    },

    setAssessableText: function (text) {
        // if (!this.isEditMode) {
        //     var hiddenLabel = $$(".accessibility-intructions")[0];
        //     hiddenLabel.set('text', text);
        // }
    },

    //PRESENTATION
    cellHighlightingON: function (e) {
        var that = this;
        
        eventTarget = $(e.target).getParent('td');
        if (!eventTarget) {
            eventTarget = e.target;
        }

        row = eventTarget.getAttribute('data-row');
        column = eventTarget.getAttribute('data-column');

        cells = $$('#top-table .cell');
        cells.removeClass('highlighted');

        if (this.settings.rowHighlighting) {
            rowSelector = '#top-table .cell[data-row="' + row + '"]';
            $$(rowSelector).addClass('highlighted');

        }

        if (this.settings.columnsHighlighting) {
            columnSelector = '#top-table .cell[data-column="' + column + '"]';
            $$(columnSelector).addClass('highlighted');

        }
    },

    cellHighlightingOFF: function () {
        cells = $$('#top-table .cell');
        cells.removeClass('highlighted');
    },

    renderTablePresentation: function (visibility, ratio) {
        var that = this;
        that.setAssessableText(that.presentationAssessableText);
        var challengeFeedback = $('challenge-feedback');
        challengeFeedback.hide();

        this.renderTopTable('presentation');

        var topTableCaption = $('top-table-caption');
        if (this.settings.presentationInstruction.trim().length) {
            topTableCaption.set('html', this.settings.presentationInstruction);
            topTableCaption.set('aria-hidden', 'false');
            topTableCaption.set('tabindex', '0');
        }

        var topTable = $('top-table');
        topTable.set('role', 'presentation');
        var topTableHead = $('top-table-head');
        var topTableBody = $('top-table-body');

        if (visibility === 'hidden') {
            topTable.setStyle('opacity', 0);
        }

        var isRowsLabel = this.settings.rowsLabel;

        //fill top table
        this.data.each(function (row, rowIndex) {
            var options = that.getRowOptions(rowIndex);
            var tr = new Element('tr', options);

            row.columns.each(function (column, columnIndex) {
                var args = {
                    row: rowIndex,
                    column: columnIndex,
                    type: column.type,
                    width: column.width,
                    content: column.content,
                    isDraggable: false,
                    rowsLabelEnable: that.settings.rowsLabel
                };
                cell = that.renderCell(args);

                tr.grab(cell);
            });

            if (rowIndex === 0) {
                topTableHead.grab(tr);
            } else {
                topTableBody.grab(tr);
            }
        });

        var titles = $$('#top-table .title');
        titles.each(function (title, index) {
            if (Number(title.getAttribute('data-row')) === 0){
                title.setAttribute('scope', 'col');
            } else {
                title.setAttribute('scope', 'row');
            }
        });

        if (that.settings.rowHighlighting || that.settings.columnsHighlighting) {
            var cells = $$('#top-table .cell');
            var topTable = $('top-table');

            cells.addEvent('mouseenter', that.cellHighlightingON.bind(that));
            topTable.addClass('highlight');

            topTable.addEvent('mouseleave', that.cellHighlightingOFF);
        }

        this.updateFooter('presentation');

        this.enableAccessibility('presentation');

        if (visibility === "hidden") {
            var checkUnderstanding = $$('.check-understanding')[0];
            checkUnderstanding.hide();
        }
        
        return this.mediaLoaderPromise(ratio);
        
    },

    //CHALLENGE
    shuffle: function (o) {
        for (var j, x, i = o.length; i; j = parseInt(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);

        return o;
    },

    renderTableChallenge: function (ratio) {
        var that = this;
        //render presentation table to obtain it's final/visual height after all media render
        this.renderTablePresentation('hidden', ratio).then(function (response) {
            var topTableHeight = Number(response.height) - 28;
            var challengeFeedback = $('challenge-feedback');
            challengeFeedback.show();

            that.renderTopTable('challenge');
            that.renderBottomTable();

            var topTable = $('top-table');
            //topTable.setStyle('height', topTableHeight);

            var bottomTable = $('bottom-table');
            var topTableContainer = new Element('div', {
                id: 'top-table-container'
            });
            var bottomTableContainer = new Element('div', {
                id: 'bottom-table-container',
                class: 'redips-noautoscroll'
            });

            topTableContainer.wraps(topTable);
            bottomTableContainer.wraps(bottomTable)

            var topTableCaption = $('top-table-caption');
            topTableCaption.set('aria-hidden', 'true');
            topTableCaption.set('tabindex', '-1');
            if (that.settings.challengeInstruction.trim().length) {
                topTableCaption.set('html', that.settings.challengeInstruction);
                topTableCaption.show();

            }

            var topTableHead = $('top-table-head');
            var topTableBody = $('top-table-body');
            var bottomTable = $('bottom-table');

            that._assessableCells = [];

            //fill top table
            that.data.each(function (row, rowIndex) {
                var options = that.getRowOptions(rowIndex);
                var tr = new Element('tr', options);

                row.columns.each(function (column, columnIndex) {
                    var type = column.type;
                    var args = {
                        row: rowIndex,
                        column: columnIndex,
                        type: column.type,
                        width: column.width,
                        content: column.content,
                        isDraggable: false,
                        rowsLabelEnable: that.settings.rowsLabel
                    };

                    if (column.isAssessable) {

                        var assessableArgs = {
                            row: rowIndex,
                            column: columnIndex,
                            type: column.type,
                            width: column.width,
                            content: column.content,
                            isDraggable: true,
                            rowsLabelEnable: that.settings.rowsLabel
                        };

                        draggable = that.renderCell(assessableArgs);
                        that._assessableCells.push(draggable);

                        args.type = 'is-assessable';
                    }

                    cell = that.renderCell(args);
                    tr.grab(cell);
                });

                if (rowIndex === 0) {
                    topTableHead.grab(tr);
                } else {
                    topTableBody.grab(tr);
                }
            });

            //randomize assessable cells
            that._assessableCells = that.shuffle(that._assessableCells);

            //fill bottom table
            if (that.settings.assessmentMode === 'inmediate') {
                var tr = new Element('tr');

                bottomTable.addClass('inmediate');

                that._assessableCells.each(function (cell, index) {
                    td = new Element('td');
                    td.addClass('start-drag');

                    rowIndex = cell.getAttribute('data-row');
                    columnIndex = cell.getAttribute('data-column');

                    content = cell.getElement('div');
                    content.addClass('first-try');
                    content.setAttribute('data-row', rowIndex);
                    content.setAttribute('data-column', columnIndex);

                    if (cell.hasClass('media')) {
                        content.addClass('media');
                    }

                    content.hide();
                    td.grab(content);
                    content.setAttribute('aria-label', 'Concept to fill in a blank: '+ content.innerText +'. Tab to the select menu');
                    tr.grab(td);
                });
                
                bottomTable.grab(tr);

            } else {
                var tr = new Element('tr');
                var cellNumber = 0;
                var nextRowValue = Math.round(that._assessableCells.length / 2);

                if (nextRowValue == 1) {
                    nextRowValue = 2;
                }

                bottomTable.addClass('delayed');
                bottomTable.setAttribute('data-columns', nextRowValue);

                that._assessableCells.each(function (cell, index) {
                    td = new Element('td');
                    td.addClass('start-drag');

                    rowIndex = cell.getAttribute('data-row');
                    columnIndex = cell.getAttribute('data-column');

                    content = cell.getElement('div');
                    content.setAttribute('data-row', rowIndex);
                    content.setAttribute('data-column', columnIndex);

                    if (cell.hasClass('media')) {
                        content.addClass('media');
                    }

                    td.grab(content);
                    content.setAttribute('aria-label', 'Concept to fill in a blank: '+ content.innerText +'.  Tab to the select menu');

                    if (cellNumber ===  nextRowValue) {

                        tr.grab(td);
                        bottomTable.grab(tr);

                        tr = new Element('tr');
                        cellNumber = 0;
                    }

                    cellNumber++;
                    tr.grab(td);
                    
                });
                bottomTable.grab(tr);

            }

            // init tooltips
            $$('#bottom-table .content').floatingTips({
                position: 'right',
                showOn: 'focus',
                hideOn: 'focusout',
                content: function() { return $('instructions-tooltip'); },
                html: true,
            })

            that.resizeDraggables();

            that.setAssessableText(that.challengeAssessableText);
            that.updateFooter('challenge');
            that.enableAccessibility('challenge');
            that.startChallenge();
        });

        that.fixTableCaptionPositionOnSafari();
    },

    /**
     * Update bottom table cells width and height.
     */
    resizeDraggables: function () {
        var that = this;
        var biggerCell = 0;
        var draggables = $$('#bottom-table .content');
        var rowsNumber = 1;

        if (!that._assessableCells || 
            that._assessableCells.length === 0 || 
            draggables.length === 0) return;

        // remove previous height
        draggables.setStyle('height', null);

        if (that.settings.assessmentMode === 'delayed') {
            var columnsNumber = Math.round(that._assessableCells.length / 2);

            var cellsContainer = $$('#bottom-table td');
            var columnWidth = 100 / columnsNumber;

            columnWidth = columnsNumber === 1? 50 : columnWidth;
            draggableWidth = Number(cellsContainer[0].getSize().x) - 10;
            draggables.setStyle('width', draggableWidth);

            draggables.each(function (draggable, index) {
                biggerCell = draggable.getHeight() > biggerCell ? draggable.getHeight() : biggerCell;
            });

            rowsNumber = 2;
        } else {
            draggables.each(function (draggable, index) {
                draggable.show();
                biggerCell = draggable.getHeight() > biggerCell ? draggable.getHeight() : biggerCell;

                if (index !== 0) {
                    draggable.hide();
                }
            });
        }

        biggerCell = biggerCell > that.contentMaxHeight ? that.contentMaxHeight : biggerCell;
        draggables.setStyle('height', biggerCell);

        that.fitContent();
    },

    fitContent: function () {
        var that = this;
        var draggables = $$('#bottom-table .content');
        var draggableScrollHeight = 0;
        var draggableHeight = 0;

        draggables.each(function (draggable, index) {
            draggable.removeClass('fit-0 fit-1 fit-2');

            draggable.show();
            draggableScrollHeight = draggable.getScrollHeight();
            draggableHeight = draggable.getHeight();

            if ((draggableScrollHeight > draggableHeight) && (draggable.hasClass('media') === false)) {
                var fitOptions = 0;
                var fitInterval = setInterval(function (){
                    draggable.removeClass('fit-0 fit-1 fit-2');

                    draggable.addClass('fit-' + fitOptions++);
                    draggableScrollHeight = draggable.getScrollHeight();

                    if (draggableScrollHeight <= draggableHeight) {
                        clearTimeout(fitInterval);
                    }

                    if (fitOptions === 3) {
                        clearTimeout(fitInterval);
                    }

                }, 10);
            }

            if (that.settings.assessmentMode === 'inmediate' && index !== 0) {
                draggable.hide();
            }

        });
    },

    updateColumnsWidth: function (totalWidth) {
        var that = this;

        $$('.redips-mark.title.resizable').each(function (item, index) {
            currentWidth = item.getStyle('width');
            if (parseInt(currentWidth, 10) < 5) {
                currentWidth = '5%'
                // set minimum width
                item.setStyle('width', currentWidth);
            }
            that.data[0].columns[index].width = that.rowWidthsPresetting[index] = currentWidth;
        });
        this.saveData().then(function (response) {
            console.log('saved!');

        }, function (error){
            console.warn(error);

        })
    },

    renderTableEdit: function () {
        var that = this;

        this.renderTopTable('edit');

        var topTableHead = $('top-table-head');
        var topTableBody = $('top-table-body');

        var topTableCaption = $('top-table-caption');
            topTableCaption.hide();

        //fill top table
        this.data.each(function (row, rowIndex){
            var options = that.getRowOptions(rowIndex);
            var tr = new Element('tr', options);

            row.columns.each(function (column, columnIndex) {
                var args = {
                    row: rowIndex,
                    column: columnIndex,
                    type: column.type,
                    width: column.width,
                    content: column.content,
                    isDraggable: false,
                    rowsLabelEnable: that.settings.rowsLabel
                };
                if(that.rowWidthsPresetting == null || that.rowWidthsPresetting.length == 0 || that.rowWidthsPresetting[columnIndex] == null){
                    that.rowWidthsPresetting[columnIndex] = column.width;
                }

                cell = that.renderCell(args);

                tr.grab(cell);
            });

            if (rowIndex === 0) {
                topTableHead.grab(tr);

            } else {
                topTableBody.grab(tr);
            }
        });

        //set instrunction text
        if (this.settings.presentationInstruction.trim().length) {
            var presentationText = $('presentation-instruction-text');

            presentationText.set('html', this.settings.presentationInstruction);
        }

        if (this.settings.challengeInstruction.trim().length) {
            var challengeText = $('challenge-instruction-text');

            challengeText.set('html', this.settings.challengeInstruction);
        }
        var maxWidthtable = $('top-table').getSize().x-5;

        //footer
        this.updateFooter('create');

        var $topTableHeadCells = $$('#top-table-head .redips-mark.title');
        var totalTitles = $topTableHeadCells.length;

        $topTableHeadCells.each(function (item, index) {
            if (index != totalTitles) {
                var cellIndex = index;
                var nextCellIndex = index + 1;
                var cell = item;
                var nextCell = cell.getNext();
                var handleRight = new Element('div.handle-right.handle', {
                    html: '',
                    styles: {
                        left: '100%',
                        right: 'auto',
                        transform: 'translateX(-100%)'
                    }
                });

                handleRight.inject(cell);

                new Drag(handleRight, {
                    modifiers: {
                        x: 'left',
                        y: false
                    },
                    limit: {
                        x: [0, 800]
                    },
                    stopPropagation: true,
                    onStart: function () {
                        refreshColsWidth();
                    },
                    onDrag: function (el, event) {
                        var cursorLeft = event.client.x + el.getBoundingClientRect().width;

                        if (
                            cursorLeft < cell.getPosition().x ||
                            cursorLeft > nextCell.getBoundingClientRect().right
                        ) {
                            // avoid drag other columns
                            return;
                        }

                        var tableWidth = $$('#top-table')[0].getSize().x;
                        var remainingCellsWidth = 0;
                        var newCellWidth = cursorLeft - cell.getPosition().x;

                        $topTableHeadCells.each(function (item, index) {
                            if (cellIndex === index || nextCellIndex === index) {
                                return;
                            }
                            remainingCellsWidth += item.getSize().x;
                        });

                        var newNextCellWidth = tableWidth - remainingCellsWidth - newCellWidth;
                        cell.setStyle('width', pxToPorcentage(newCellWidth, tableWidth));
                        nextCell.setStyle('width', pxToPorcentage(newNextCellWidth, tableWidth));
                    },
                    onComplete: function (el) {
                        // fix draggable position
                        el.setStyles({
                            left: '100%',
                            top: '0'
                        });

                        that.updateColumnsWidth();
                        refreshColsWidth();
                    }
                });

                function pxToPorcentage (px, tableWidth) {
                    if (!tableWidth) {
                        tableWidth = $$('#top-table')[0].getSize().x;
                    }
                    return ((px * 100) / tableWidth) + '%';
                }

                function refreshColsWidth () {
                    $topTableHeadCells.each(function (item, index) {
                        var columnWidth = item.getSize().x;
                        item.setStyle('width', pxToPorcentage(columnWidth));
                    });
                }
            }
        });

        //bind events
        this.bindActionsEdit();
    },

    renderTableDefineAssessableCells: function () {
        var that = this;

        this.renderTopTable('define');

        var topTableHead = $('top-table-head');
        var topTableBody = $('top-table-body');

        var topTableCaption = $('top-table-caption');
            topTableCaption.hide();

        //fill top table
        this.data.each(function (row, rowIndex) {
            var options = that.getRowOptions(rowIndex);
            var tr = new Element('tr', options);

            row.columns.each(function (column, columnIndex) {
                var columnStart = 0;
                var args = {
                    row: rowIndex,
                    column: columnIndex,
                    type: column.type,
                    width: column.width,
                    content: column.content,
                    isDraggable: false,
                    rowsLabelEnable: that.settings.rowsLabel
                };

                cell = that.renderCell(args);

                if (that.settings.rowsLabel) {
                    columnStart = 1;
                }

                if (rowIndex > 0 && columnIndex >= columnStart) {
                    overlay = new Element('div.overlay', {
                        'data-assessable': column.isAssessable
                    });

                    if (column.isAssessable) {
                        cell.addClass('is-assessable');
                        overlay.set('html', '<i class="fa fa-check-circle"></i>');
                    } else {
                        overlay.set('html', '<i class="fa fa-circle-o"></i>');
                    }

                    cell.grab(overlay);
                }

                tr.grab(cell);
            });

            if (rowIndex === 0) {
                topTableHead.grab(tr);
            } else {
                topTableBody.grab(tr);
            }
        });

        //footer
        this.updateFooter('define');

        //bind events
        this.bindActionsDefine();
    },

    showAddContent: function (e) {

        eventTarget = e.target
        if (eventTarget.hasClass('content')) {
            eventTarget = eventTarget.getParent()
        }

        target = {row: eventTarget.getAttribute('data-row'), column: eventTarget.getAttribute('data-column')}
        if (parent && parent != window) {
            parent.postMessage({
                method: 'show-add-content',
                target: target
            }, '*');
        }
    },

    showEditContent: function (e) {
        var that = this
        var eventTarget = e.target.getParent();

        target = {
            row: eventTarget.getAttribute('data-row'),
            column: eventTarget.getAttribute('data-column')
        };
        type = eventTarget.getAttribute('data-type');
        content = this.data[target.row].columns[target.column].content;

        method = 'show-add-content';
        if (type === 'text') {
            method ='show-edit-text';
        }

        if (parent && parent !== window) {
            parent.postMessage({
                method: method,
                content: content,
                target: target
            }, '*');
        }
    },

    showDeleteContent: function (e) {
        var eventTarget = e.target.getParent();

        target = {row: eventTarget.getAttribute('data-row'), column: eventTarget.getAttribute('data-column')}

        if (parent && parent != window) {
            parent.postMessage({
                method: 'show-delete-content',
                target: target
            }, '*');
        }
    },

    addContent: function (target, content) {
        var that = this;

        var currentContent = this.data[target.row].columns[target.column]

        var newContent = {
            id: currentContent.id,
            type: content.type,
            content: content.path
        }

        this.data[target.row].columns[target.column] = newContent;

        this.saveData().then(
            function (response){
                that.renderTableEdit();

            }, function (error){
                console.warn(error);

            }
        );

        if(content.type == 'image'){
            this.sendPostMessageToAccesibilityImages('add-image');
        }
    },

    sendPostMessageToAccesibilityImages: function(type){
        if(type == 'add-image' || type == 'remove-image'){
            parent.postMessage({
                method: 'reload-accessibilty'
            }, '*');
        }
    },

    addText: function (target, content) {
        var that = this;

        var currentContent = this.data[target.row].columns[target.column]

        var newContent = {
            id: currentContent.id,
            type: 'text',
            content: content
        }

        this.data[target.row].columns[target.column] = newContent;

        this.saveData().then(
            function (response){
                that.renderTableEdit();

            }, function (error){
                console.warn(error);

            }
        );
    },

    deleteContent: function (target) {
        var that = this;

        var currentContent = this.data[target.row].columns[target.column];

        var emptyContent = {
            id: currentContent.id,
            type: 'empty',
            content: '',
            isAssessable: false
        };

        this.data[target.row].columns[target.column] = emptyContent;

        this.saveData().then(
            function (response) {
                that.renderTableEdit();

            }, function (error) {
                console.warn(error);

            }
        );    
        if(currentContent.type == 'image'){
            this.sendPostMessageToAccesibilityImages('remove-image');
        }
    },

    editTitle: function (e) {
        var that = this;
        
        if (!e) return

        var text = e.target.get('html');
        var eventTarget = e.target.getParent();

        titleRow = eventTarget.getAttribute('data-row');
        titleColumn = eventTarget.getAttribute('data-column');

        this.data[titleRow].columns[titleColumn].content = text;

        clearTimeout(this.saveTimer);
        this.saveTimer = setTimeout(function () {
            that.saveData();
        }, 500);
    },

    toggleAssessableCell: function (target, isAssessable) {
        var that = this;

        isAssessable = (isAssessable === 'true') ? false : true;

        this.data[target.row].columns[target.column].isAssessable = isAssessable;

        this.saveData().then(
            function (response) {
                that.renderTableDefineAssessableCells();

            }, function (error) {
                console.warn(error);

            }
        );
    },

    bindActionsEdit: function () {
        var that = this;

        $$('.add-content').each(function (item, index) {
            item.addEvent('click', that.showAddContent);
        });

        $$('.title .content').each(function (title, index) {
            if (title.getParent().hasClass('empty') === false) {
                title.set('contenteditable', 'true').set('data-md-editable', 'md-content-editable');

                title.addEvent('input', that.editTitle.bind(that));
            }
        });

        $$('.create-table').addEvent('click', function (e) {
            that.renderTableEdit();
        })

        $$('.define-assessable-cells').addEvent('click', function (e) {
            that.renderTableDefineAssessableCells();
        });

        $$('td.cell').each(function (cell, index) {
            if (!cell.hasClass('add-content')) {
                var row = cell.getAttribute('data-row');
                var column = cell.getAttribute('data-column');
                var type = cell.getAttribute('data-type');

                var actionButtons = new Element('div.actions');
                var containerButtons = new Element('div.buttons');
                var overlayButtons = new Element('div.overlay');

                editIcon = new Element('span.edit-content', {
                    'html': '<i class="fa fa-pencil"></i>',
                    'data-row': row,
                    'data-column': column,
                    'data-type': type
                });
                deleteIcon = new Element('span.delete-content', {
                    'html': '<i class="fa fa-times"></i>',
                    'data-row': row,
                    'data-column': column
                });

                containerButtons.grab(editIcon);
                containerButtons.grab(deleteIcon);

                actionButtons.grab(containerButtons);
                actionButtons.grab(overlayButtons);

                cell.grab(actionButtons);

                //bind click
                editIcon.addEvent('click', that.showEditContent.bind(that));
                deleteIcon.addEvent('click', that.showDeleteContent);
            }
        });

        this.initTinyMCE();
    },

    bindActionsDefine: function () {
        var that = this;

        $$('td.cell .overlay').each(function (cell, index) {

            cell.addEvent('click', function (e) {
                eventTarget = e.target.getParent()

                target = {
                    row: eventTarget.getAttribute('data-row'),
                    column: eventTarget.getAttribute('data-column')
                };
                isAssessable = cell.getAttribute('data-assessable');

                that.toggleAssessableCell(target, isAssessable);
            });
        });
    },

    initTinyMCE: function (e) {
        var that = this;
        tinymce.remove();

        tinymce.init({
            selector: ".md-edit-mode [contenteditable='true'], .md-edit-mode [data-md-editable='md-content-editable']",
            inline: true,
            plugins: "charmap bdesk_photo codeTag codesample stixFormat placeholder advlist positionfix",
            toolbar: 'undo redo | bold italic superscript subscript codeTag stixFormat bullist numlist | charmap codesample bdesk_photo indent outdent | alignleft aligncenter alignright',
            menubar: false,
            forced_root_block: 'div',
            formats: {
                StixFormat: {
                    inline: 'ins',
                    classes: 'stix-format'
                }
            },
            setup: function (editor) {
                editor.addCommand('afterImageUpload', function (ui, v) {
                    that.loadImagesTinyMCE();
                    that.notifyMediaUpdate();
                });
                editor.on('change', function(e) {
                    $(this.getElement()).fireEvent('input', [null, this.getElement()])
                });
            }
        });
    },
    loadImagesTinyMCE : function () {
        var tinymceImages = $$('.tinymce-image');

        tinymceImages.each(function (image, index) {
            var imageData = image.getAttribute('data-img');
                image.src = imageData;
        });
    },
    notifyMediaUpdate: function () {
        if (parent && parent != window) {
            parent.postMessage({
                method: 'reload-accessibilty'
            }, '*');
        }
    },
    getRowOptions: function(rowIndex) {
        // var options = {};
        // if(rowIndex == 0){
        //     options.scope = 'row';
        // }

        return {};
    }
});


/*
 ---
 description: Class for creating floating balloon tips that nicely appears when hovering an element.

 license: MIT-style

 authors:
 - Lorenzo Stanco

 requires:
 - core/1.3: '*'

 provides: [FloatingTips]

 ...
 */

var FloatingTips = new Class({

    Implements: [Options, Events],

    options: {
        position: 'top',
        fixed: false,
        center: true,
        content: 'title',
        html: false,
        balloon: true,
        arrowSize: 6,
        arrowOffset: 6,
        distance: 3,
        motion: 6,
        motionOnShow: true,
        motionOnHide: true,
        showOn: 'mouseenter',
        hideOn: 'mouseleave',
        hideOnTipOutsideClick: false,
        discrete: false,
        showDelay: 0,
        hideDelay: 0,
        className: 'floating-tip',
        identifier: '',
        offset: { x: 0, y: 0 },
        fx: { 'duration': 'short' }
    },

    /**
     * Array containing the elements which have a Tip applied by this instance
     */
    networkMembers: [],

    initialize: function(elements, options) {
        this.setOptions(options);
        var s = this;
        this.boundShow = (function() {
            var element = this;
            s.show(element);
            if (s.options.discrete) s.networkMembers.filter(function(item) {
                return item !== element;
            }).invoke('floatingTipsHide');
        });
        this.boundHide = (function() { s.hide(this); });
        if (!['top', 'right', 'bottom', 'left', 'inside'].contains(this.options.position)) this.options.position = 'top';
        if (elements) this.attach(elements);
        return this;
    },

    attach: function(elements) {
        var s = this;
        $$(elements).each(function(e) {
            s.networkMembers.include(e);
            if (e.retrieve('floatingtip_hasevents')) { return; }
            var evs = { };
            s.options.showOn && (evs[s.options.showOn] = s.boundShow);
            s.options.hideOn && (evs[s.options.hideOn] = s.boundHide);
            e.addEvents(evs);
            e.store('floatingtip_hasevents', true);
            e.store('floatingtip_object', s);
        });
        return this;
    },

    detach: function(elements) {
        var s = this;
        var evs = { };
        evs[this.options.showOn] = this.boundShow;
        evs[this.options.hideOn] = this.boundHide;
        $$(elements).each(function(e) {
            s.networkMembers.erase(e);
            s.hide(e);
            e.removeEvents(evs);
            e.eliminate('floatingtip_hasevents');
            e.eliminate('floatingtip_object');
        });
        return this;
    },

    show: function(element) {
        var old = element.retrieve('floatingtip');
        if (old) if (old.getStyle('opacity') != 0) { clearTimeout(old.retrieve('timeout')); return this; }
        var tip = this._create(element);
        if (tip == null) return this;
        element.store('floatingtip', tip);
        this._animate(tip, 'in');
        element.store('floatingtip_visible', true);
        this.fireEvent('show', [tip, element]);
        return this;
    },

    hide: function(element) {
        var tip = element.retrieve('floatingtip');
        if (!tip) return this;
        this._animate(tip, 'out');
        element.store('floatingtip_visible', false);
        this.fireEvent('hide', [tip, element]);
        return this;
    },

    toggle: function(element) {
        if (element.retrieve('floatingtip_visible')) return this.hide(element);
        else return this.show(element);
    },

    _create: function(elem) {
        var o = this.options;
        var oc = o.content;
        var opos = o.position;

        if (oc == 'title') {
            oc = 'floatingtitle';
            if (!elem.get('floatingtitle')) elem.setProperty('floatingtitle', elem.get('title'));
            elem.set('title', '');
        }

        var cnt = (typeof(oc) == 'string' ? elem.get(oc) : oc(elem));
        var cwr = new Element('div').addClass(o.className).setStyle('margin', 0);
        var tip = new Element('div')
          .addClass(o.className + '-wrapper')
          .addClass('position-' + this.options.position)
          .setStyles({ 'margin': 0, 'padding': 0 })
          .adopt(cwr);
        if (o.identifier.length > 0) {
            tip.addClass(o.identifier);
        }

        if (cnt) {
            if (o.html) {
                if (o.html_adopt) cwr.adopt(cnt);
                else cwr.set('html', typeof(cnt) == 'string' ? cnt : cnt.get('html'));
            } else {
                cwr.set('text', cnt);
            }
        } else {
            return null;
        }

        var body = document.id(document.body);
        tip.setStyles({ 'position': (o.fixed ? 'fixed' : 'absolute'), 'opacity': 0, 'top': 0, 'left': 0 }).inject(body);

        // Z-index "copied" after tip injecting, because of webkit bug: https://bugs.webkit.org/show_bug.cgi?id=15562
        cwr.setStyle('position', 'relative'); // Position
        tip.setStyles({ 'z-index': cwr.getStyle('z-index') });
        cwr.setStyle('position', null); // Reset position

        if (o.balloon && !Browser.ie6) {

            var trg = new Element('div').addClass(o.className + '-triangle').setStyles({ 'margin': 0, 'padding': 0 });
            var trgSt = { 'border-color': cwr.getStyle('background-color'), 'border-width': o.arrowSize, 'border-style': 'solid','width': 0, 'height': 0 };

            switch (opos) {
                case 'inside':
                case 'top'   : trgSt['border-bottom-width'] = 0; break;
                case 'right' : trgSt['border-left-width'  ] = 0; trgSt['float'] = 'left'; cwr.setStyle('margin-left', o.arrowSize); break;
                case 'bottom': trgSt['border-top-width'   ] = 0; break;
                case 'left'  : trgSt['border-right-width' ] = 0;
                    if (Browser.ie7) { trgSt['position'] = 'absolute'; trgSt['right'] = 0; } else { trgSt['float'] = 'right'; }
                    cwr.setStyle('margin-right', o.arrowSize); break;
            }

            switch (opos) {
                case 'inside': case 'top': case 'bottom':
                trgSt['border-left-color'] = trgSt['border-right-color'] = 'transparent';
                trgSt['margin-left'] = o.center ? tip.getSize().x / 2 - o.arrowSize : o.arrowOffset; break;
                case 'left': case 'right':
                trgSt['border-top-color'] = trgSt['border-bottom-color'] = 'transparent';
                trgSt['margin-top'] = o.center ?  tip.getSize().y / 2 - o.arrowSize : o.arrowOffset; break;
            }

            // Firefox triangle pixelation fix (https://brettstrikesback.com/de-pixelating-the-css-triangle/)
            if (Browser.firefox || Browser.name == 'firefox') {
                trgSt['-moz-transform'] = 'scale(1.01)';
                trgSt['transform'] = 'scale(1.01)';
            }

            trg.setStyles(trgSt).inject(tip, (opos == 'top' || opos == 'inside') ? 'bottom' : 'top');

        }

        var tipSz = tip.getSize(), trgC = elem.getCoordinates();
        var offsetOption = ('function' === typeof(o.offset) ? Object.merge({ x: 0, y: 0 }, o.offset(elem)) : o.offset);
        var pos = { x: trgC.left + offsetOption.x, y: trgC.top + offsetOption.y };

        if (opos == 'inside') {
            tip.setStyles({ 'width': tip.getStyle('width'), 'height': tip.getStyle('height') });
            elem.setStyle('position', 'relative').adopt(tip);
            pos = { x: o.offset.x, y: o.offset.y };
        } else {
            switch (opos) {
                case 'top'   :  pos.y -= tipSz.y + o.distance; break;
                case 'right' :  pos.x += trgC.width + o.distance; break;
                case 'bottom':  pos.y += trgC.height + o.distance; break;
                case 'left'  :  pos.x -= tipSz.x + o.distance; break;
            }
        }

        if (o.center) {
            switch (opos) {
                case 'top' : case 'bottom': pos.x += (trgC.width / 2 - tipSz.x / 2); break;
                case 'left': case 'right' : pos.y += (trgC.height / 2 - tipSz.y / 2); break;
                case 'inside':
                    pos.x += (trgC.width / 2 - tipSz.x / 2);
                    pos.y += (trgC.height / 2 - tipSz.y / 2); break;
            }
        }

        tip.set('morph', o.fx).store('position', pos);
        tip.setStyles({ 'top': pos.y, 'left': pos.x });

        if (o.hideOnTipOutsideClick) {
            var documentClickHandler = null;
            documentClickHandler = function(event) {
                var eventTarget = document.id(event.target);
                if (elem && elem !== eventTarget && !elem.contains(eventTarget)) {
                    this.hide(elem);
                } else if (!elem) {
                    document.removeEvent('click', documentClickHandler);
                }
            }.bind(this);
            document.addEvent('click', documentClickHandler);
            tip.addEvent('click', function(event) { event.stopPropagation(); });
        }

        return tip;
    },

    _animate: function(tip, d) {

        clearTimeout(tip.retrieve('timeout'));
        tip.store('timeout', (function(t) {

            var o = this.options, din = (d == 'in');
            var m = { 'opacity': din ? 1 : 0 };

            if ((o.motionOnShow && din) || (o.motionOnHide && !din)) {
                var pos = t.retrieve('position');
                if (!pos) return;
                switch (o.position) {
                    case 'inside':
                    case 'top'   : m['top']  = din ? [pos.y - o.motion, pos.y] : pos.y - o.motion; break;
                    case 'right' : m['left'] = din ? [pos.x + o.motion, pos.x] : pos.x + o.motion; break;
                    case 'bottom': m['top']  = din ? [pos.y + o.motion, pos.y] : pos.y + o.motion; break;
                    case 'left'  : m['left'] = din ? [pos.x - o.motion, pos.x] : pos.x - o.motion; break;
                }
            }

            t.morph(m);
            if (!din) t.get('morph').chain(function() { this.dispose(); }.bind(t));

        }).delay((d == 'in') ? this.options.showDelay : this.options.hideDelay, this, tip));

        return this;

    }

});

Elements.implement({

    floatingTips: function(options) {
        new FloatingTips(this, options);
        return this;
    }

});

Element.implement({

    floatingTips: function(options) {
        new FloatingTips($$(this), options);
        return this;
    },

    floatingTipsShow: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.show(this);
        return this;
    },

    floatingTipsHide: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.hide(this);
        return this;
    },

    floatingTipsToggle: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.toggle(this);
        return this;
    }

});

Element.Properties.floatingTips = {
    get: function(){
        return this.retrieve('floatingtip_object');
    }
};
