/*
---

script: Popup.js

description: Provides delegators for popups and popovers

requires:
 - Behavior/Delegator
 - More/Mask
 - More/Elements.From
 - More/Element.Position
 - More/Element.Delegation
 - More/Element.Shortcuts

provides: [ShowPopup, Popover]

...
*/
(function(){

	var displayed;
	var show = function(el, pos, options, originalEl){
		options = options || {};
		if (options.mask == null) options.mask = true;
		var modal;
		if (options.mask) {
			modal = new Mask(document.body, {
				destroyOnHide: true
			}).show();
			modal.addEvent('hide', function(){
				el.destroy();
				displayed = false;
				if(originalEl) { originalEl.fireEvent('popupHidden'); };
			});
			modal.addEvent('click', function(){
				modal.hide();
			});
			el.addEvent('click:relay(.close)', function(){
				modal.hide();
			});
		} else {
			el.addEvent('click:relay(.close)', function(){
				el.destroy();
				displayed = false;
			});
		}
		displayed = true;
		el.inject(document.body, 'top').show();
		var ret = el.position(pos || {});
		
		//If reflowable book, then use fixedPos, and keep position of popup fixed.
		if(options.fixedPos) {
			setTimeout(function(){
				var top= '100px';
				var left= '100px';
				var elSize = el.getSize()
				if(options.pageHeight) {
					top = ((options.pageHeight/2) - (elSize.y/2)) + 'px';
				}
				if(options.pageWidth) {
					left = ((options.pageWidth/2) - (elSize.x/2)) + 'px';
				}
				el.setStyles({
					'position': 'fixed',
					'top': top,//(el.getPosition().y - window.scrollY) + "px",
					'left': left
				});
			},1);
		}
		return ret;
	};

	Delegator.register('click', 'ShowPopup', {

		require: ['target'],
		defaults: {
			mask: true
		},
		handler: function(event, link, api){
			if (displayed) return;
			var target = link.getElement(api.get('target'));
			event.preventDefault();
			if (!target) api.fail('Could not find target popup element: ', api.get('target'));
			targetAPI = new BehaviorAPI(target, 'data-modal');
			var t = target.clone(true, true);
			api.getBehavior().apply(t);
			var options = {
				mask: api.getAs(Boolean, 'mask'), 
				fixedPos: api.getAs(Boolean, 'fixedPos'),
				pageWidth: api.getAs(Number, 'pageWidth'),
				pageHeight: api.getAs(Number, 'pageHeight')
			} //mask, fixedPos,
			show(t, true, options, target);
			target.fireEvent('popupVisible',{original:target,clone:t});
		}

	});

	Delegator.register('click', 'Popover', {
		defaults: {
			template: '<div class="popover {position}"><div class="arrow"></div><div class="inner"><h3 class="title">{title}</h3><div class="content"><p>{alt}</p> <a class="btn close primary right">Close</a></div></div></div>',
			mask: true,
			position: 'auto'
		},
		handler: function(event, link, api){
			if (displayed) return;
			event.preventDefault();
			var template,
					templateElement = api.get('templateElement');
			if (templateElement) template = element.getElement(templateElement).get('html');
			if (!template) template = api.get('template');

			var pos = api.get('position');
			if (pos == 'auto'){
					if (link.getParent('.column1')) {
							pos = 'right';
					} else {
							pos = 'left'
					}
			};

			var position, edge;
			switch(pos){
				case 'above':
					position = 'centerTop';
					edge = 'centerBottom'
					break;
				case 'below':
					position = 'centerBottom';
					edge = 'centerTop'
					break;
				case 'left':
					position = 'centerLeft';
					edge = 'centerRight'
					break;
				case 'right':
					position = 'centerRight';
					edge = 'centerLeft'
					break;
			}

			var content = Elements.from(template.substitute({
				title: link.get('title'),
				alt: link.get('alt'),
				position: pos
			}))[0];

			var options = {
				mask: api.getAs(Boolean, 'mask'), 
				fixedPos: api.getAs(Boolean, 'fixedPos'),
				pageWidth: api.getAs(Number, 'pageWidth'),
				pageHeight: api.getAs(Number, 'pageHeight')
			}
			var coords = show(content, {
				relativeTo: link,
				position: position,
				edge: edge,
				returnPos: true
			}, options);
			if (pos == 'right') {
				delete coords.left;
				coords.right = 75;
			} else {
				coords.left = 75;
			}
			content.setStyles(coords);
		}
	});

})();