/*
---

script: Quiz.js

description: Provides the quizes for the epub.

requires:
 - More/String.QueryString
 - Core/Element.Event
 - Behavior/BehaviorAPI

provides: [flashlog]

...
*/

var Quiz = {
	showMessage: function(isSuccess, el){
		var quizEl = el.getParent(".quiz-list");
		var msg = isSuccess?'Correct! You answered correctly. Good job.':'Sorry! That is not the correct answer.';
		if(quizEl) {
			var quizElParent = quizEl.getParent();
			//REmove if already has
			if(quizElParent.getElements('.inline-message')) {
				quizElParent.getElements('.inline-message').destroy();
			}
			var cls = isSuccess?'quiz-correct':'quiz-incorrect';
			var msgEl = new Element("span", {'class':"inline-message epub__inline-message " + cls + " epub__"+cls});
			msgEl.set('text', msg);
			quizElParent.adopt(msgEl);
			setTimeout(function(){msgEl.destroy()}, 3000);
		} else {
			if(isSuccess) {
				flash.success(msg, 10);
			} else {
				flash.error(msg, 10);
			}
		}
	},
	Full: new Class({
		Implements: [Options, Events],
		options: {
/*

			onIncomplete: function(count){
				flash.warning('Remaining questions: ' + count);
			},
			onValidate: function(count){
				if (count) flash.error('You have ' + count + ' incorrect answer' + (count > 1 ? 's' : '') + '.');
				else flash.success('Nice work! You got all questions correct!');
			},

*/
			onCorrect: function(el){
				Quiz.showMessage(true, el);
			},
			onIncorrect: function(el){
				Quiz.showMessage(false, el);	
			}
		},
		initialize: function(el, options){
			this.setOptions(options);
			this.element = document.id(el);
			this.startup();
			this.attach();
		},
		startup: function(){
			this.element.getElements('[data-trigger*=selectOne]').each(function(el){
				var input = el.getElement('input');
				var api = new BehaviorAPI(el, 'selectone');
				if (input.checked) {
					el.getElements(api.get('targets')).each(function(target){
						if (target.contains(el)) target.addClass(api.get('class'));
					});
				}
			});
		},
		attach: function(){
			this.element.getElements('input, select').addEvent('change', this.validate.bind(this));
		},
		validate: function(e){
			var target = e.target;
			if (e.target.get('tag') == 'select') target = e.target.getSelected()[0];

			if (target.get('value') == 'correct') this.fireEvent('correct', target);
			else this.fireEvent('incorrect', target);

			var values = this.element.toQueryString().parseQueryString(),
			    incomplete = 0,
			    incorrect = 0;
			Object.each(values, function(v, k){
				if (!v) incomplete++;
				if (v != 'correct') incorrect++;
			});
			if (incomplete) {
				this.fireEvent('incomplete', [incomplete, values]);
			} else {
				this.fireEvent('validate', [incorrect, values]);
				if (!incorrect) this.fireEvent('success');
			}
		}
	})
};

Behavior.addGlobalFilter('Quiz', {
	setup: function(element, api){
		return new Quiz.Full(element);
	}
});