/*
---

script: SideBar.js

description: Provides the TOC UI.

requires:
 - Core/DomReady
 - More/Element.Shortcuts
 - Core/Fx.Transitions
 - Fx.Scrollability
 - More/URI

provides: [TOC]

...
*/

var TOC = new Class({
	Implements: [Options, Events],
	options: {
		selected: null
	},
	initialize: function(options){
		this.setOptions(options);
		this.element = new Element('div.hidden.toc-container').inject(document.body);
		this.element.addEvent('click:relay(a.close)', this.hide.bind(this));
	},
	hide: function(){
		if (this.hidden) return;
		this.element.hide();
		this.hidden = true;
	},
	show: function(){
		if (!this.hidden) return;
		if (!this.retrieved) {
			this.nav = this.getNav();
		}
		this.element.setStyles({
			opacity: 0,
			display: 'block'
		});
		this.select(this.options.selected);
		this.element.setStyles({
			opacity: 1
		});
		this.hidden = false;
	},
	hidden: true,
	toggle: function(){
		if (this.hidden) this.show();
		else this.hide();
	},
	getNav: function(){
		if (this.retrieved) return;
		var xmlhttp = new XMLHttpRequest();
		xmlhttp.open("GET","toc.html",false);
		xmlhttp.send();
		txt = xmlhttp.responseText;
		this.element.set('html', txt);
		this.retrieved = true;
		this.chapters = this.element.getElement('.chapters');
		this.fx = new Fx.Scrollability(this.chapters, {
			duration: 0
		});
	},
	select: function(selected){
		if (selected) {
			var targets = this.chapters.getElements('a[href=' + selected + ']');
			if (targets.length<=0) return;
			targets.each(function(target) {
				target.getParent().addClass('selected');
				var chapter;
				if (target.getParent('dd.contents, dd.figures')) chapter = target.getParent('dd.contents, dd.figures').getPrevious('dt');
				else chapter = target.getParent('dt');
				if (chapter) this.fx.toElement(chapter.addClass('selected'));
			}.bind(this));
			//Scrolling into view
			targets[0].getParent().scrollIntoView();
		}
	}
});


window.onload = (function(){
	if (document.body.hasClass('no-toc')) return;
	//NOTE: ADDED AS TOC WAS GETTING ADDED IN EVERY PAGE - Nachiket
	if (!document.body.hasClass('toc')) return;

	var selected = $(document.body).getAttribute('data-toc-page-name');
	var toc = new TOC({
		selected: selected || new URI().get('file')
	});

	new Element('a', {
		'class': 'tocLink',
		text: 'TOC',
		events: {
			click: function(e){
				e.stop();
				toc.toggle();
			}
		}
	}).inject(document.body, 'top');
	document.body.addEvent('click', function(e){
		if (!e.target.getParent('.nav') && !toc.hidden) toc.hide();
	});
});