var md = md || {};
md.widgets = md.widgets || {};

md.widgets.Accordion = new Class({
	Implements: [Events, Options],
	options: {
		mode: 'accordion',
		tabs: []
	},
	initialize: function (el, options) {
		this.el = el;
		this.setOptions(options);
		this['render-' + this.options.mode]();
	},
	'render-tabs': function () {
		var header = new Element('div', { 'class': 'header' }),
			content = new Element('div', { 'class': 'content' }),
			titles,
			bodies;

		titles = this.options.tabs.map(function (tab, i) {
			var titleEl = new Element('div', {
					'class': 'tab-title' + (i === 0 ? ' active' : ''),
					'data-index': i
				})
				.addEvent('click', function (e) {
					var el = $(e.event.currentTarget);

					// remove any active classes.
					this.el.getElements('.tab-title, .tab-content').removeClass('active');

					// Add active class to the title.
					el.addClass('active');

					// Add active class to the content.
					this.el.getElements('.tab-content')[el.get('data-index')].addClass('active');
				}.bind(this));

			titleEl.adopt(new Element('h5', {'text': tab.title}));

			return titleEl;
		}.bind(this));

		bodies = this.options.tabs.map(function (tab, i) {
			return new Element('div', { 'class': 'tab-content' + (i === 0 ? ' active' : ''), html: tab.content });
		});

		header.adopt(titles);
		content.adopt(bodies);

		this.el.addClass('accordion-widget').empty().adopt(header, content);
	},
	'render-accordion': function () {
		var accordionItems = this.options.tabs.map(function (tab, i) {
			var wrapper = new Element('div', { 'class': 'accordion-item' + (i === 0 ? ' active' : '') }),
				title = new Element('div', { 'class': 'accordion-title', text: tab.title }),
				contentWrapper = new Element('div', { 'class': 'accordion-content-wrapper' }),
				content = new Element('div', { 'class': 'accordion-content', html: tab.content });

			title.addEvent('click', function (e) {

				this.el.getElements('.accordion-item').removeClass('active');
				$(e.target).getParent('.accordion-item').addClass('active');

			}.bind(this));

			contentWrapper.adopt(content);
			return wrapper.adopt(title, contentWrapper);
		}.bind(this));

		this.el.addClass('accordion-widget').empty().adopt(accordionItems);
	}
});
