/*
---
script: script: metrodigi-comicbook.js
description: Comicbook page script
copyright: 
authors: [Nachiket Patel]

requires: [md.animation.Transition]

provides: [md.widgets.ComicBook]
...
*/
var md = md || {};
md.widgets = md.widgets || {};
md.widgets.AbstractWidget = new Class({
	Implements: [Options, Events],

	initialize:function(el, options){
		this.el = el;
		this.setOptions(options);
	},
	toElement: function(){
		return this.el;
	}
});

md.widgets.CanvasAnimation = new Class({
	initialize: function(canvasEl, values) {
		this.el = canvasEl;
		// Grab our context
    	this.context = canvasEl.getContext('2d');
    
	    // Make sure we have a valid defintion of requestAnimationFrame
	    this.requestAnimationFrame =
	            
	            function(callback) {
	                return setTimeout(callback, 16);
	            };
	    this.values = values;
	},
	getRequestAnimationFrame: function(){
		return window.requestAnimationFrame ||
	            window.webkitRequestAnimationFrame ||
	            window.mozRequestAnimationFrame ||
	            window.msRequestAnimationFrame ||
	            window.oRequestAnimationFrame;
	},
	render: function() {
        // Clear the canvas
		this.context.fillStyle="#FFFFFF";
        this.context.fillRect(0, 0, $(this).width, $(this).height);
        
        // Draw the square
		this.context.fillStyle=this.values.borderColor;
        this.context.fillRect(0, 0, this.values.width, this.values.height);
        this.context.clearRect(this.values.borderWidth, this.values.borderWidth,
        	this.values.width - this.values.borderWidth*2, this.values.height - this.values.borderWidth*2);
        
        // Redraw
        this.getRequestAnimationFrame()(this.render.bind(this));
    },
    animate: function(prop, val, duration) {
		// The calculations required for the step function
		var start = new Date().getTime();
		var end = start + duration;
		var current = this.values[prop];
		var distance = val - current;

		var step = function() {
			// Get our current progres
			var timestamp = new Date().getTime();
			var progress = Math.min((duration - (end - timestamp)) / duration, 1);

			// Update the obj's property
			this.values[prop] = current + (distance * progress);

			// If the animation hasn't finished, repeat the step.
			if (progress < 1) this.getRequestAnimationFrame()(step);
		}.bind(this);

		// Start the animation
		return step();
	},

	toElement: function(){
		return this.el;
	}
});

md.widgets.helpers = md.widgets.helpers || {};
md.widgets.helpers.ComicPanelWrapper = new Class({
	Extends: md.widgets.AbstractWidget,
	initialize: function(container, app, options){
		this.container = container;
		this.app = app;
		this.parent(container, options);

		this._createHider('right', 'left');
		//Adding Bottom Last, so bottom will be on Top, and it will have Extra border
		this._createHider('bottom', 'top');

		//Hide Bottom Divs extra border
		this._createBorderHider();
	},
	_createHider: function(type, borderType) {
		var prop = type+'HiderEl';
		var left = (borderType=='top') ? 0: $(this.app).getWidth();
		var top = (borderType=='top') ? $(this.app).getHeight():0;

		this[prop] = new Element('div', {'class':'hider hider-' + type});
		this[prop].setStyles({
			position: 'absolute',
			width: $(this.app).getWidth() + "px",
			height: $(this.app).getHeight() + "px",
			left: left,
			top: top,
			'z-index': 9999,
			'background-color': this.options.appColor
		});
		this[prop].setStyle('border-'+borderType , this.options.borderWidth + 'px solid ' + this.options.borderColor);
		$(this).adopt(this[prop]);

		this[type+'Fx'] = new md.animation.Transition(this[prop], {
			properties: this.app.slide||this.app.fade?['-webkit-transform']: []
		});

		this[prop].addEvent('click', function(e){
			e.stop();
			this.fireEvent("hiderClicked");
		}.bind(this));
	},
	_createBorderHider: function(){
		this.borderHiderEl = new Element('div');
		this.borderHiderEl.setStyles({
			width: $(this.app).getWidth(),
			height: this.options.borderWidth + 4,
			top: - (this.options.borderWidth + 2),
			position: 'absolute',
			'z-index': 2000,
			'background-color': this.options.appColor
		});
		//Add to Bottom hider
		this.bottomHiderEl.adopt(this.borderHiderEl);
	},
	set: function(x, y, width, height) {
		x = x - this.options.borderWidth;
		y = y - this.options.borderWidth;
		width = width + (this.options.borderWidth*2);

		this.rightFx.setValue({'-webkit-transform':'translate3d('+ -x +'px,0,0)'});
	    this.bottomFx.setValue({'-webkit-transform':'translate3d(0,'+ -y +'px,0)'});

	    setTimeout(function(){
	    	this.borderHiderEl.setStyles({'left':(width+0.15)+'px'});
	    }.bind(this), 300);
	}
})

md.widgets.ComicBook = new Class({
	Extends: md.widgets.AbstractWidget,
	current: null,
	currentPoint: 0,
	initialSize: null,
	currentTimeout: null,
	panelMode:false,
	options: {
		borderColor: "#cccccc",
		borderWidth: 2,
		points: [],
		padding: 10,
		transition: "slide",
		fadeToColor: "#000000",
		autoPlay: false,
		autoPlayInterval: 5000,
		kenBurns: false,
		classWrapper: 'eyeframe-wrapper',
		classPositioner: 'eyeframe-positioner',
		autoStart: false,
		autoStartDelay: 100,
		jumpToNext: true,
		nextPage: null,
		lastFrameAnchor: null,
		appColor: '#fff',
		defaultPageHeight: 1024,
	},
	createHiders: function(){
		var imgWrapper = $(this).getElement('.' + this.options.classPositioner);
		this.wrapperHelper = new md.widgets.helpers.ComicPanelWrapper(imgWrapper, this, this.options);
		this.wrapperHelper.addEvent('hiderClicked', function(){
			this.cleanUp();
		}.bind(this));
	},
	initialize: function(imageEl, options) {
		this.inEditor = window.parent && window.parent.Lindgren !== undefined;
		var el = this.createDOM(imageEl);
		this.parent(el, options);
		if($(this).getHeight()==0) {
			$(this).setStyle('height', '100%');
		}
		//var load = function() {
			//Try until size is higher than 0.
		var setEl = function(){
			this.elSize = this.el.getSize();
			console.log("Height: " + this.elSize.y);
			if(this.elSize.y < this.options.defaultPageHeight/2 || this.elSize.y > this.options.defaultPageHeight*1.3 ) {
				console.log("Height still wrong, trying again");
				var delayHandle = setEl.delay(5);
			} else {
				console.log("Clear timeout");
				clearTimeout(delayHandle);
				this._init(imageEl, options);
			}
		}.bind(this);
		setEl();
		//}.bind(this);

		// if(imageEl.complete) {
		// 	console.log("Image loaded already");
		// 	load.delay(5);
		// } else {
		// 	imageEl.addEvent('load', function(){
		// 		console.log("Image loaded event in comicbook init");
		// 		load.delay(5);
		// 	}.bind(this));
		// }
	},
	_init: function(imageEl, options){

		console.log("El Size: " +  this.elSize.x + "," +this.elSize.y );
		//support kenburns as transition.
		if(this.options.transition == "kenburns") {
			this.options.kenBurns = true;
			this.options.transition = "crossfade";
		}
		this.slide = this.options.transition == "slide";
		this.fade = (this.options.transition == "fade") || (this.options.transition == "crossfade");
		this.crossfade = this.options.transition == "crossfade";

		//create Hiders for bottom & right borders
		this.createHiders();

		this.points = this.options.points;
		this.imgWrapper = $(this).getElement('.'+this.options.classWrapper);
		this.imgWrapper.setStyles({
			'height': this.elSize.y, 'width': this.elSize.x,
			//Hardware Acc
			"-webkit-transform": 'translate3d(0,0,0)'
		});

		// this.canvasEl = $(this).getElement('canvas');
		// this.canvasEl.setAttribute('height', this.elSize.y);
		// this.canvasEl.setAttribute('width', this.elSize.x);
		// this.canvasFx = new md.widgets.CanvasAnimation(this.canvasEl, {
		// 	width: this.elSize.x, height:this.elSize.y, borderWidth: this.options.borderWidth, borderColor: this.options.borderColor});
		// this.canvasFx.render();

	    this.wrapperFx = new md.animation.Transition(this.imgWrapper, {
			properties: this.slide||this.fade?['height', 'width', 'border']: []
		});

		this.img = $(this).getElement('.' +this.options.classWrapper + ' img');
		this.img.setStyles({
			'height': this.elSize.y, 'width': this.elSize.x,
			"-webkit-transform-origin-x": 0,
			"-webkit-transform-origin-y": 0
		});
		this.initialSize = this.img.getSize();
	    this.imgFx = new md.animation.Transition(this.img, {
			properties: this.slide?['-webkit-transform', '-webkit-filter']: ['opacity']
		});

	    if(this.options.kenBurns) {
	    	this.kenBurnsEl = new Element('div', 'ken-burns-wrapper');
	    	this.kenBurnsEl.replaces(this.img);
	    	this.kenBurnsEl.adopt(this.img);
	    }

	    if(this.crossfade) {
	    	this.otherImg = this.img.clone();
	    	this.otherImgFx = new md.animation.Transition(this.otherImg, {
				properties: this.slide?['-webkit-transform', '-webkit-filter']: ['opacity']
			});
			this.otherImg.setStyle('opacity','0');
			this.otherImg.inject(this.img, 'after');
	    }


	    this.imgPositioner = $(this).getElement('.' + this.options.classPositioner);
	    this.imgPositioner.setStyles({
	    	'height': this.elSize.y, 'width': this.elSize.x
	    });
		this.positionerFx = new md.animation.Transition(this.imgPositioner, {
			properties: this.slide||this.fade?['-webkit-transform']: []
		});

		// Handle jumping to the next page (continuous panels mode).
		if (this.options.jumpToNext) {
				var currentPage = this.inEditor ? Number(window.parent.Lindgren.core.currentPage) : parseInt(document.body.get('id').substr(4), 10),
				nextPage    = currentPage + 1;

			// Check the page number stored in local storage.  If it matches the current page number than we are in continuous panel mode
			// and set autoStart to true.
			if (currentPage === Number(localStorage.continuouspanels)) {
				this.options.autoStart = true;
			}

			// Store a reference to the next page number so that we can put it in local storage when all the panels have been viewed.
			this.nextPage = nextPage;

			// In the editor.
			if (!this.inEditor) {
				// In a book.
				// Set the last frame anchor to a link to the next book page.
				this.options.lastFrameAnchor = this.options.nextPage;
			} else {
				// Set the last frame anchor to call a Lindgren method to actually change the page.
				//this.options.lastFrameAnchor = 'javascript:window.parent.Lindgren.core.changePageTo(' + nextPage + ')';
			}

			// Remove any previously stored local storage data to prevent eyeframes from initiating continuous panels mode when
			// not appropriate.
			delete localStorage.continuouspanels;
		}

	    this.cleanUp(true);

	    var mask = new Mask(this.imgWrapper, { style: { opacity: 0 } });

	   	var anchorOverlay = new Element('a', {
	   		'href': this.options.lastFrameAnchor,
	   		'styles': {
	   			'display':'block',
	   			'width':'100%',
	   			'height':'100%',
	   			'-webkit-tap-highlight-color': 'rgba(0,0,0,0)'
	   		}
	   	});
	   	$(mask).adopt(anchorOverlay);
	    mask.show();

	    $(anchorOverlay).addEvent('click', function(e){
			// If last frame and nextPage is set in options, goto the next page.
			if (this.options.nextPage && this.currentPoint == this.points.length) {
				// Save the next page number in local storage to enable continuous panels for the next page.
				localStorage.continuouspanels = this.nextPage;
				return;
			}
	    	
	    	e.stop();
	    	this._clicked(e);
	    }.bind(this));

	    // Clicking away from a panel closes it.
	    $(this).addEvent('click', function(e){
	    	this.cleanUp();
	    }.bind(this));

	    if(this.options.autoStart) {
	    	this.next.delay(this.options.autoStartDelay,this);
	    }
	},
	createDOM: function(imageEl) {
		//remove styles which can cause script to perform wrong
		imageEl.setStyles({
			'max-width': 'initial',
			'max-height': 'initial'
		});
		var positionerEl = new Element('div', {'class': this.options.classPositioner});
		var wrapperEl = new Element('div', {'class': this.options.classWrapper});

		//var canvasEl = new Element('canvas', {'class':'wrap-canvas', 'style':'position: absolute'});
		wrapperEl.wraps(imageEl);
		//wrapperEl.adopt(canvasEl);
		positionerEl.wraps(wrapperEl);
		var appEl = positionerEl.getParent();
		appEl.setStyles({
			'background-color': this.options.appColor,
			'overflow': 'hidden'
		});
		return appEl;
	},
	setBgColor: function(){
		var bgColor = this.fade && !this.crossfade;
		this.imgWrapper.setStyle("background-color", bgColor?this.options.fadeToColor:"transparent");
	},
	clearBgColor: function(){
		this.imgWrapper.setStyle("background-color", null);
	},
	setCurrent: function(current){
		this.current=current;
	},
	_clicked: function(e){
		e.stop();
		this.next();
		//Clear autostart if not first slide
		if(this.currentPoint!=1) {
			this.cleanupTimeout();
		}
	},
	next: function(){
		//Clear if timer is set
		if(this.currentTimeout) {
			this.cleanupTimeout();
		}

		if(this.currentPoint > this.points.length) {
			return;
		} else if(this.currentPoint == this.points.length) {
			this.currentPoint = 0;
			this.cleanUp();
			return;
		}
		this.setTo(this.points[this.currentPoint]);
		this.currentPoint++;	
		this.autoPlayIfRequired();
	},
	cleanupTimeout: function(){
		if(this.currentTimeout) {
			clearTimeout(this.currentTimeout);
			this.currentTimeout = null;
		}
	},
	autoPlayIfRequired: function(){
		if(this.options.autoPlay) {
			this.currentTimeout = this.next.bind(this).delay(this.options.autoPlayInterval);
		}
	},
	_setFxMode: function(direct) {
		this.wrapperFx.setDirect(direct);
		this.positionerFx.setDirect(direct);
		this.imgFx.setDirect(direct);
		if(this.crossfade) {
			this.otherImgFx.setDirect(direct);
		}
	},
	cleanUp: function(fxMode){
		if (!this.fade || this.crossfade) this.clearBgColor();
		this.cleanupTimeout();
		this.cleanUpKenBurns();
		this._setFxMode(fxMode);
		this.setTo(
			{ height: this.initialSize.y , imageTop: 0, imageLeft: 0, width: this.initialSize.x, reset: true },
			function(){
				this._setFxMode(false);
				this.setBgColor();
			}.bind(this)
		);
		this.panelMode = false;
		this.current=null;
		this.currentPoint=0;
	},
	cleanUpKenBurns: function(){
		if(this.options.kenBurns) {
			this.kenBurnsEl.removeClass('kenBurnsIn');
			this.kenBurnsEl.removeClass('kenBurnsOut');
		}
	},
	setTo: function(frame, callback){
		this._action(frame, callback);
	},
	_action: function(frame, callback){
		this.panelMode = true;
		//Can be -1 for reset 
		var point = this.points.indexOf(frame);

		//this.imgFx.setValue({'-webkit-filter':'blur(2px)'});
		var slideData = this.calculateSlideData(frame);

		//this.canvasFx.animate('width', slideData.width, 400);
		//this.canvasFx.animate('height', slideData.height, 400);

		this.wrapperHelper.set(slideData.containerWidth-slideData.width, slideData.containerHeight-slideData.height,
			slideData.width, slideData.height);
		//this.wrapperFx.setValue({'height': slideData.height, 'width': slideData.width });
	    this.positionerFx.setValue({'-webkit-transform':'translate3d('+ slideData.leftPos +'px,'+ slideData.topPos +'px,0)'}, 
	    function(){}.bind(this));//{'top': topPos, 'left': leftPos });
	
		var performImageAnim= function(imgFx){
			var imgAnim = 'translate3d('+ slideData.imageLeft +'px,'+ slideData.imageTop +'px,0) scale('+ slideData.ratio +')';
	    	imgFx.setValue({'-webkit-transform':imgAnim}, function(){
	    		//Final callback for frame anim done.
	    		if(callback)  { callback(); }
	    	}.bind(this));	
		}.bind(this);
		
		var switchImgObjects = function() {
			var tmpFx = this.imgFx;
			var tmpImg = this.img;

			this.imgFx = this.otherImgFx;
			this.img = this.otherImg;

			this.otherImgFx = tmpFx;
			this.otherImg = tmpImg;
			this.otherImgFx.setValue({'opacity':'0'});
		}.bind(this);

	    if(this.fade) {
	    	if(this.crossfade) {
	    		performImageAnim(this.otherImgFx);
	    		this.otherImgFx.setValue({'opacity': '1'}, function(){
	    			switchImgObjects();
	    		}.bind(this));
    			//this.otherImgFx.setValue({'opacity':'1'});
	    	};
	    	this.imgFx.setValue({'opacity': '0'}, function(){
	    		if(!this.crossfade) {
	    			this.imgFx.setValue({'opacity':'1'});	
	    			performImageAnim(this.imgFx);
	    		}
			}.bind(this));
	   	} else {
	   		performImageAnim(this.imgFx);
	   	}

	   	//if comic mode
	   	if(point>=0) {
	   		this.imgWrapper.setStyles({'border': this.options.borderWidth + "px solid " + this.options.borderColor});
	   	} else {
	   		this.imgWrapper.setStyles({'border': "0px solid " + this.options.borderColor});
	   	}
   		//If not reset frame and kenburns then peform kenburns
	   	if(this.options.kenBurns && point>=0) {
			this.cleanUpKenBurns();
			this.kenBurnsEl.addClass(point%2?'kenBurnsOut':'kenBurnsIn');
		}
	    this.setCurrent(frame);
	},
	calculateSlideData: function(frame){
		var containerSize = $(this).getSize();
		var imgSize = this.img.getSize();

		var padding = this.options.padding;
		var borderWidth = this.options.borderWidth*2;
		var width = -1;
		var height = -1;
		var ratio = 1;
		if(frame.reset) {
			borderWidth = 0;
			padding = 0;
		}

		var leftPos = padding;
		var topPos = padding;
		
		//frame.width = frame.width + this.options.borderWidth;
		width = containerSize.x - (padding*2) - (borderWidth);
		height = containerSize.y - (padding*2) - (borderWidth);

		var widthRatio = width/frame.width;
		var heightRatio = height/frame.height;

		if(widthRatio < heightRatio) {
			ratio = widthRatio;
			height = frame.height * ratio;
			topPos = (containerSize.y - height - borderWidth)/2;
		} else {
			ratio = heightRatio;
			width = frame.width*ratio;
			leftPos = (containerSize.x - width - borderWidth)/2;
		}

		var imgRatioSize = {x: imgSize.x*ratio, y: imgSize.y*ratio};
		var imageTop = (imgRatioSize.y* -frame.imageTop / imgSize.y);
		var imageLeft = (imgRatioSize.x* -frame.imageLeft / imgSize.x);

		var slideData = {
			width: width,
			height: height,
			ratio: ratio,
			leftPos: leftPos,
			topPos: topPos,
			imageTop: imageTop,
			imageLeft: imageLeft,
			containerWidth: containerSize.x,
			containerHeight: containerSize.y
		};
		return slideData;
	}
});
