/*
---
script: script: metrodigi-css3.js
description: CSS3 animation support
copyright: 
authors: [Nachiket Patel]

requires: [Core/Class.Extras, Core/Element.Style, Core/Element.Event, Core/Fx.Tween]

provides: [md.animation.Transition]
...
*/

var md = md || {};
md.animation = md.animation || {};

md.animation.Transition = new Class({
	Implements: [Options, Events],
	duration: -1,
	_direct: false,
	transitionTimings: {
		'linear'		: '0,0,1,1',
		'expo:in'		: '0.71,0.01,0.83,0',
		'expo:out'		: '0.14,1,0.32,0.99',
		'expo:in:out'	: '0.85,0,0.15,1',
		'circ:in'		: '0.34,0,0.96,0.23',
		'circ:out'		: '0,0.5,0.37,0.98',
		'circ:in:out'	: '0.88,0.1,0.12,0.9',
		'sine:in'		: '0.22,0.04,0.36,0',
		'sine:out'		: '0.04,0,0.5,1',
		'sine:in:out'	: '0.37,0.01,0.63,1',
		'quad:in'		: '0.14,0.01,0.49,0',
		'quad:out'		: '0.01,0,0.43,1',
		'quad:in:out'	: '0.47,0.04,0.53,0.96',
		'cubic:in'		: '0.35,0,0.65,0',
		'cubic:out'		: '0.09,0.25,0.24,1',
		'cubic:in:out'	: '0.66,0,0.34,1',
		'quart:in'		: '0.69,0,0.76,0.17',
		'quart:out'		: '0.26,0.96,0.44,1',
		'quart:in:out'	: '0.76,0,0.24,1',
		'quint:in'		: '0.64,0,0.78,0',
		'quint:out'		: '0.22,1,0.35,1',
		'quint:in:out'	: '0.9,0,0.1,1'
	},
	options: {
		transition: 'sine:in:out',
		properties: 'all',
		duration: 400,
		durationUnit: 'ms'
	},
	initialize: function(element, options){
		this.el = element;
		this.setOptions(options); 

		this.setProps();
	},
	setProps: function(){
		//Set styling
		var props = typeOf(this.options.properties)=='array'?this.options.properties.join(','):this.options.properties;
		if(props.length<=0) {
			return;
		}

		this.el.setStyle('-webkit-transition-property', props);
		this.el.setStyle('transition-property', props);

		var duration = this.options.duration + this.options.durationUnit;
		this.el.setStyle('-webkit-transition-duration', duration);
		this.el.setStyle('transition-duration', duration);
		
		var transitionFunc = this.transitionTimings[this.options.transition];
		if(!transitionFunc) {
			throw("unable to find transition " + this.options.transition);
		}

		var timingVal = 'cubic-bezier('+transitionFunc+')';
		this.el.setStyle('-webkit-transition-timing-function', timingVal);
		this.el.setStyle('transition-timing-function', timingVal);
		this.duration = this.options.duration;
	},
	cleanupProps: function(){
		this.el.setStyles({
			'-webkit-transition-timing-function': null,
			'transition-timing-function': null,
			'-webkit-transition-duration': null,
			'transition-duration': null,
			'-webkit-transition-property': null,
			'transition-property': null
		});
		this.duration = 0;
	},
	toElement: function(){
		return this.el;
	},
	setDirect: function(direct){
		if(direct) {
			this.cleanupProps();
		} else {
			this.setProps();
		}
		this.direct = direct;
	},
	setValue: function(valueMap, callback){
		$(this).setStyles(valueMap);
		if(callback) {
			callback.delay(this.duration);
		}
	}
}); 