/*
---
script: metrodigi-flash.js

description: Allows user to show/manage flash message 

requires: 
	- Core/DomReady
	- Core/Element.Event
  
provides: [md.util.Flash]
...
*/
var md = md || {};
md.util = md.util || {};

md.util.Flash = new Class({
	Implements: [Options, Events],
	//DEFAULT OPTIONS
	options: {
		containerSelector:'body', //Will use first element
		type:'info', // One of 'error', 'success', 'info', 'warning'
		time: 5000,
		position: 'top' // One of 'top', 'center', 'bottom',
		// width: 'auto'
	},
	initialize:function(options){
		this.setOptions(options);
	}, 
	show: function(msg, type){
		if(!type) {
			type= this.options.type;
		}
		if (this.flashDiv) this.destroy();
		
		this.flashDiv = new Element('div', {
			'class': 'alert-message flash'
			,'styles': { 'width':this.options.width }
		}).inject($$(this.options.containerSelector)[0]);
		
		this.flashDiv.addClass(type);
		this.flashDiv.show().innerHTML += '<p>' +  msg + '</p>';
		
		if(this.options.position == 'center') {
			this._center(this.flashDiv);
		}
		clearTimeout(this.flashTimer);
		this.flashTimer = this.destroy.bind(this).delay(this.options.time);
	},
	_center: function(div) {
		// div.setStyles({
		//   'left': '50%',
		//   'top': '50%',
		//   'position':'absolute',
		//   'margin-left': - div.getComputedSize().width/2,
		//   'margin-top': - div.getComputedSize().height/2
		// });
	},
	destroy: function(){
		if(this.flashDiv) {
			this.flashDiv.destroy();
    		this.flashDiv = null;
		}
	}
})