/*
---

script: FlashCards.js

description: Provides delegators for popups and popovers

requires:
 - Behavior/Behavior

provides: [FlashCards]

...
*/
var md = md || {};
md.widgets = md.widgets || {};
md.widgets.FlashCards = new Class({
    Implements: [Options],
    initialize: function (container, options) {
        this.el = $(container);
        this.reflowable = document.body.hasClass('book-type-reflowable') && !(window.parent && window.parent.Lindgren);
        this.questions = options.questionSet || [];
        this.options = options;
        this.render();
        this.wire();
    },
    swap: function (e) {
        e.stop();

        // Swap each .card's children.
        this.el.getElements('.card').forEach(function (card) { card.insertBefore(card.children[1], card.children[0]); });
    },
    toggle: function (e) {
        e.stop();

        this.el.getElements('.card.active').toggleClass('show');
        e.target.hasClass('show') ? e.target.removeClass('show').addClass('hide') : e.target.removeClass('hide').addClass('show');
    },
    next: function (e) {
        e.stop();

        var currentCard = this.el.getElement('.card.active'),
            nextCard    = currentCard.getNext('.card') || this.el.getElement('.card:first-of-type');

        this.reset(currentCard);
        currentCard.removeClass('active').removeClass('show');
        nextCard.addClass('active');
    },
    prev: function (e) {
        e.stop();

        var currentCard = this.el.getElement('.card.active'),
            prevCard    = currentCard.getPrevious('.card') || this.el.getElement('.card:last-of-type');

        this.reset(currentCard);
        currentCard.removeClass('active');
        prevCard.addClass('active');
    },
    reset: function (card) {
        card.removeClass('show');
        var toggle = this.el.getElement('.toggle');
        if (toggle.hasClass('hide')) toggle.removeClass('hide').addClass('show');
    },
    render: function () {
        var cardTemplate = function (q, i) { return '<div class="card' + (i === 0 ? ' active' : '') + '"><div class="header">' + q.term + '</div><div class="definition">' + q.definition + '</div></div>' },
            // Here we set up the cards container. It's html is the question template with the HTML image tags (without closing slash) turned into XHTML image tags (with closing slash).
            cards    = new Element('div', { 'class': 'cards', html: this.questions.map(cardTemplate).join('').replace(/(<img src="[^"]*")/ig, function (match) { return match + '/'; }), styles: { height: parseInt(this.options.height, 10) - 70 } }),
            controls = new Element('div', { 'class': 'controls', html: [
                '<div><a class="prev"></a></div>',
                '<div><a class="next"></a></div>',
                '<div><a class="show toggle"></a></div>',
                '<div><a class="swap"></a></div>'
            ].join('') });

        this.el.empty().adopt(cards, controls);

        this.loadImages = this.el.getElements('img').length;

        // If this is a reflowable and the card contains images, we need to introduce some hacks to work around iBooks bugs.
        if (this.reflowable && this.loadImages > 0) {
            // If we add the loaded class right away to the widget in a reflowable the contained images will not be visible, so instead
            // we wait until all the images have loaded and some additional time based on the number of top-level DOM elements and then
            // add the loaded class.
            this.el.getElements('img').addEvent('load', function (e) {
                this.loadImages -= 1;
                if (this.loadImages === 0) setTimeout(function () { this.el.addClass('loaded'); }.bind(this), Math.max(document.querySelectorAll('body > *').length / 4 * 100, 300));
            }.bind(this));
        } else {
            // If this is not a reflowable or there are no images, we can add the loaded class right away.
            this.el.addClass('loaded');
        }
    },
    wire: function () {
        this.el.addEvent('click:relay(.controls .swap)'   , this.swap.bind(this))
               .addEvent('click:relay(.controls .toggle)' , this.toggle.bind(this))
               .addEvent('click:relay(.controls .next)'   , this.next.bind(this))
               .addEvent('click:relay(.controls .prev)'   , this.prev.bind(this));
    }
});
