/*
---
script: metrodigi-extras.js

description: Misc components

requires: [Core/Core]


provides: [md.util.StepperElement, md.util.LinearElementStepper]

...
*/
var md = md || {};
md.util = md.util || {};
md.util.StepperElement = new Class({

	initialize: function(el, startPos, endPos, steps){
		this.el = el;
		this.startPos = startPos;
		this.endPos = endPos;
		this.steps = steps;

		this.el.setPosition(startPos);
		this.xStep = (endPos.x - startPos.x) / steps;
		this.yStep = (endPos.y - startPos.y) / steps;
	},
	toElement: function() {
		return this.el;
	},
	moveLinearTo: function(step) {
		var newPos = {
			x: this.startPos.x + (this.xStep*step),
			y: this.startPos.y + (this.yStep*step)
		}
		this.el.setPosition(newPos);
	}
})
md.util.LinearElementStepper = new Class({
	Implements: [Options, Events],
	initialize:function(modelArray, steps, options){
		this.stepperElements = [];
		this.steps = steps;
		this.setOptions(options);
		modelArray.each(function(model) {
			this.stepperElements.push(
				new md.util.StepperElement(model.el, model.startPos, model.endPos, steps)
			);
		}.bind(this));
		this.setOptions(options);
	},
	moveTo: function(step) {
		this.stepperElements.each(function(stepper) {
			stepper.moveLinearTo(step);
		})
	}
});
md.util.OnScreenConsole = new Class({
	Implements: [Options, Events],
	initialize: function(options) {
		this.setOptions(options);
		this.setupDOM();
		window.onerror = function(e){
			this.log(e);
		}.bind(this);
		console.log = function(msg, el, el2) {
			this.log(msg, el, el2);
		}.bind(this);
	},
	setupDOM: function(){
		this.el = new Element("div", {
			'styles': {
				'border': '1px solid #999',
				'background-color': 'rgba(222,222,222,0.6)',
				'padding': '10px',
				'position': 'absolute',
				'width': '350px',
				'height': '200px',
				'overflow-y': 'auto'
			}
		});
		this.el.setStyles({"left": '100px', "top": '100px'});
		this.el.makeDraggable();
		document.body.adopt(this.el);

		this.containerEl = new Element('div', {style: 'width: 100%'});
		$(this).adopt(this.containerEl);
	},
	log: function(msg, el, el2) {
		this.containerEl.adopt(new Element('div', {'class':'msg-item', 'html':msg + ", " + el}));
	},
	toElement: function(){
		return this.el;
	}
})