/*
---
script: metrodigi-notes.js

description: Provides notes popdown functionality on bible

requires: [mootools.touch, mootools.drag]

provides: [md.BibleNotes]

...
*/

var md = md || {};
md.BibleNotes = new Class({
	Implements: [Options],
	
	options: {
		startsWith: "c",
		separator: "_",
		useParent: true,
		wrapWithDiv: true
	},
	
	initialize: function(notes, options){
		this.setOptions(options);
		
		Array.each(notes, function(note){

			if(note.starting.chapter > note.ending.chapter){
				if(console.error){
					console.error("starting chapter can not be greater than ending chapter", note);
				}
				return;
			}
			
			var startNodeId = this.options.startsWith + note.starting.chapter + this.options.separator + note.starting.verse;
			var startNode = $(startNodeId);
			var startNodeParent;
			
			var endNodeId = this.options.startsWith + note.ending.chapter + this.options.separator + note.ending.verse;
			var endNode = $(endNodeId);
			var endNodeParent;
		
			if(startNode == null || startNode == undefined || endNode == null || endNode == undefined){
				console.error ? console.error("start or end node not available, start=", startNode, ", end=", endNode) : console.log("start or end node not available", "start=", startNode, ", end=", endNode);
				return;
			}
			
			if(this.options.useParent){
				endNodeParent = endNode.parentNode;
				startNodeParent = startNode.parentNode;
			}
		
			var notesLink = new Element("a", {
				href: 'javascript:',
				html: note.linkText
			});
			//notesLink.injectAfter(endNode);
			endNodeParent.appendChild(notesLink);
			
			var wrapper;
			
			var toolTip = new Element("div", {'class': "tooltip"});
			
			var toolTipClose = new Element("div", {'class': "close", title: "Close"});
			toolTipClose.injectBottom(toolTip);
			
			var title = new Element("span", {'class': "title"}).injectBottom(toolTip);
			title.innerHTML = note.title;
			
			var content = new Element("div", {'class': "content"}).injectBottom(toolTip);
			content.innerHTML = note.contents;

			notesLink.addEvent("click", function(e){
				e.stop();
				toolTip.show();
				if(wrapper){
					wrapper.addClass("active");
				}
			});
			
			toolTipClose.addEvent("click", function(e){
				e.stop();
				toolTip.hide();
				
				if(wrapper){
					wrapper.removeClass("active");
				}
			});
			
			//pa.previousElementSibling;
			if(this.options.wrapWithDiv){
				var preNode = startNodeParent.previousElementSibling;
				wrapper = new Element("div", {'class': "wrapper"});
				
				if(preNode.id == "c" + note.starting.chapter){
					wrapper.injectBefore(preNode);					
				}else{
					wrapper.injectBefore(startNodeParent);
				}
				
				
				for(chapter= note.starting.chapter; chapter<= note.ending.chapter; chapter++){
					var startVerse = note.starting.verse, endVerse = 0;
					if(chapter != note.ending.chapter){
						endVerse = 999;
					}else{
						endVerse = note.ending.verse;
					}
					
					for(verse = startVerse; verse <= endVerse; verse++){
						var nodeId = this.options.startsWith + chapter + this.options.separator + verse;
						var node = $(nodeId);
						var nodeParent;

						if(node != null && node != undefined){
							if(this.options.useParent){
								nodeParent = node.parentNode;
							}
							
							var prev = nodeParent.previousElementSibling;
							if(verse == 1){
								if(prev != wrapper) {
									prev.injectBottom(wrapper);
								}
							}else{
								var tag = prev.tagName.toLowerCase();
								if(tag != "div" && tag != "p"){
									prev.injectBottom(wrapper);
								}
							}
							nodeParent.injectBottom(wrapper);
						}
					}
				}
				
				toolTip.injectBottom(wrapper);
			}else{
				toolTip.injectAfter(endNodeParent);
			}
		}.bind(this));
	}
});