/*
---
script: metrodigi-remote-media.js

description: Provides Remote Media widgets. 

requires: [Core/Core]

provides: [md.widgets.RemoteMedia]
...
*/

var md= md || {};
md.widgets = md.widgets || {};
md.widgets.RemoteMedia = new Class({
    Implements:[Options],
    options: {
        controls : 'show',
        height   : 'auto',
        width    : '300px'
    },
    initialize: function (el, options) {
        this.el = el;
        this.setOptions(options);
        this.render();
    },
    getElOptions: function () {
        var common = {
                controls : this.options.controls === 'show',
                preload  : this.options.autoPreload === 'true' ? 'auto' : 'none',
                src      : this.options.url,
                width    : this.options.width
            },
            content = this.makeSource();

        switch (this.options.type) {
            case 'audio' :
                return Object.merge(common, {
                    html : content + this.options.fallbackText
                });
            case 'video' :
                var fb        = this.options.fallbackType,
                    fbContent = fb === 'text'       ? this.options.fallbackText :
                                fb === 'poster'     ? this.makeFallbackImage()
                                /* fb === 'none' */ : '';

                return Object.merge(common, {
                    height : this.options.height,
                    html   : content + fbContent,
                    poster : this.options.poster
                });
        }
    },
    getMediaType: function (url) {
        var pieces    = url.split('.'),
            extension = pieces[pieces.length - 1];

        switch (extension) {
            case 'mp3'  : return 'audio/mpeg';
            case 'm4v'  :
            case 'mp4'  : return 'video/mp4';
            case 'ogg'  : return 'audio/ogg';
            case 'ogv'  : return 'video/ogg';
            case 'webm' : return 'video/webm';
            default     : return this.options.type === 'video' ? 'video/mp4' : 'audio/mpeg';
        }
    },
    makeSource: function () {
        var url = this.options.fallbackUrl;
        return url ? '<source src="' + url + '" type="' + this.getMediaType(url) + '" />' : '';
    },
    makeFallbackImage: function () {
        return '<img src="' + this.options.poster + '" alt="' + this.options.fallbackText + '" />';
    },
    render: function () {
        var media = new Element(this.options.type, this.getElOptions());
        this.el.empty().adopt(media);
        this.showFallback(media);
    },
    showFallback: function (mediaEl) {
        var needsFallback = [this.options.url, this.options.fallbackUrl].filter(function (x) { return x; }).map(this.getMediaType, this).map(function (type) { return mediaEl.canPlayType(type); }).every(function (canPlay) { return canPlay === ''; });
        // If the browser needs a fallback, replace the media element with its last child node (could be text.)
        if (needsFallback) mediaEl.parentElement.replaceChild(mediaEl.childNodes[mediaEl.childNodes.length - 1], mediaEl);
    }
});
