/*
---
script: metrodigi-share.js

description: Provides Share widgets. 

requires: [Core/Core]

provides: [md.widgets.ShareWidget]
...
*/

var md= md || {};
md.widgets = md.widgets || {};
md.widgets.ShareWidget = new Class({
	Implements:[Options],
	URL_MAP: {
		'facebook': 'http://www.facebook.com/sharer/sharer.php?u=#url',
		'twitter': 'https://twitter.com/intent/tweet?text=#url',
		'google': 'https://plus.google.com/share?url=#url'
	},
	options: {
		services: ['facebook', 'google', 'twitter']
	},
	
	//"new md.widgets.ShareWidget($('51240a0c0e50b'), 'http://www.metrodigi.com', { services: ["facebook","google","twitter"] })"
	initialize: function(ele, url, options){
		ele.empty();
		this.setOptions(options);
		this.el = new Element('div', {
			'class':"share-widget"
		});

		this.options.services.each(function(service){
			//create share URL		
			var finalUrl = this.URL_MAP[service].replace('#url', url);
			var serviceEl = new Element('a', {
				//text: service.capitalize(),
				target: '_blank',
				href: finalUrl
			});
			var liEl = new Element('li', {'class': 'service-'+service});
			liEl.adopt(serviceEl);
			this.el.adopt(liEl);

		}.bind(this));
		this.el.adopt(new Element('span', {style: 'clear: both'}));
		//Inject in given Element
		ele.adopt(this);
	},
	toElement: function(){
		return this.el;
	}
});