/*
---
script: metrodigi-storage.js

description: Allows storing data into Local or Session storage

requires: 
	- Core/DomReady
	- Core/Element.Event
  
provides: [md.storage]
...
*/
var md = md || {};
md.storage = md.storage || {};
md.storage.MemoryStorage = new Class({
	data: null,
	initialize: function(){
		this.data = {};
	},
	setItem: function(key, value){
		this.data[key] = value;
	},
	getItem: function(key){
		return this.data[key];
	}
});

md.storage.Local = new Class({
	Implements: [Options, Events],
	//DEFAULT OPTIONS
	options: {
		//DEPERECATED
		session:false,
		storage: null //Either memory, session, local
	},
	MAP: {
		memory: new md.storage.MemoryStorage(),
		session: window.sessionStorage,
		local: window.localStorage
	},
	initialize:function(name, options){
		if($type(name) != "string") {
			throw('name must be string, found: ' + key);
		}
		this.name = name;
		this.setOptions(options);
		if(this.options.storage) {
			this.storage = this.MAP[this.options.storage];
		} else {
			//DEPRECATED SUPPORT
			if(this.options.session) {
				this.storage = window.sessionStorage;
			} else {
				this.storage = window.localStorage;
			}
		}
	},
	save:function(key, value) {
		var obj = this._get();
		obj[key] = value;
		this._persist(obj);
	},
	remove: function(key) {
		var obj = this._get();
		delete obj[key];
		this._persist(obj);
	},
	get: function(key) {
		var obj = this._get();
		if(obj==undefined || obj == null) { obj = {}; }
		return obj[key];
	},
	has: function(key) {
		var val = this.get(key);
		return !(val==null || val ==undefined);
	},
	getAll: function(){
		return this._get();
	},
	clear: function(){
		this._persist({});
	},
	_get: function(){
		var item = this.storage.getItem(this.name)
		if(!item) {
			return {};
		}
		var resp = JSON.parse(item);
		return resp || {};
	},
	_persist: function(obj) {
		this.storage.setItem(this.name, JSON.stringify(obj));
	}
})