/*
---
script: metrodigi-widgets.js

description: Provides HTML widgets. 
             1> TextSizeWidget- Widget for changing size of Text

requires: 
 - Core/Core
 - Drag.Scroll

provides: [md.widgets.TextSizeWidget, md.widgets.Tabs, md.widgets.Timeline]
...
*/
var md = md || {};
md.widgets = md.widgets || {};
md.widgets.TimeSequence = new Class({
    // INVALID_TAGS: ['AUDIO', 'VIDEO', 'IMG', 'BR', 'HR'],
    Implements:[Options],
    options: {
        snap: 25,
        snapXOffset: 200,
        contentContainer: null,
        displayTolerance: 50
    },
    points: null,
    snapped: false,
    displayed: false, //Decides whether content is displaying or not.
    maxWidth: 0,
    initialize: function(el, options){
        this.el = $(el);
        this.setOptions(options);

        var elX = this.el.getPosition().x;
        this.points = this.el.getChildren().map(function(blockEl){
            return blockEl.getPosition({relativeTo: this.el}).x - elX - this.options.snapXOffset;
        }.bind(this));
        console.log('points: ', this.points);
        this.maxWidth = this.points[this.points.length-1];

        var startVal=0;
        var self = this;
        this.drag = new Drag(el, {
            onStart: function(dragEl){
                startVal = dragEl.getPosition().x;
            },
            onDrag: function(dragEl, e){
                //console.log('draggin ' + dragEl.getPosition().x, e);
                var left = dragEl.getPosition().x;
                // if(left>0) {
                //     console.log('setting drag to 0', left);
                //     dragEl.setPosition({x: 0});
                //     return;
                // }
                left = Math.abs(left);
                var starting = Math.abs(startVal - left);


                var snap = self.options.snap;
                var snapToVal = self.getSnapValue(left);
                console.log('snap to: ', snapToVal);
                if(starting>snap && left > (snapToVal - snap)  && left < (snapToVal + snap)) {
                    console.log('snapping')
                    dragEl.setPosition({x: -snapToVal});
                    if(!self.snapped) {
                        //self.showContent(snapToVal);
                        self.snapped = true;
                    }
                } else {
                    if(self.snapped) {
                        //self.hideContent();
                        self.snapped = false;
                    }
                }

                var displayTolerance = self.options.displayTolerance;                
                if(starting>displayTolerance && left > (snapToVal - displayTolerance)  && left < (snapToVal + displayTolerance)) {
                    console.log('displaying..')
                    if(!self.displayed) {
                        self.showContent(snapToVal);
                        self.displayed = true;
                    }
                } else {
                    if(self.displayed) {
                        self.hideContent();
                        self.displayed = false;
                    }
                }
            },
            onComplete: function(dragEl) {

            },
            modifiers: {y: false},
            limit: {x: [-self.maxWidth, 0]}
        });

        this.hideContent(false);
    },
    getSnapValue: function(val){
        var returnPoint = null;
        val = val-this.options.snap;
        this.points.each(function(point) {
            if(!returnPoint && val<point) {
                returnPoint = point;
            }
        });
        return returnPoint;
    },
    showContent: function(val){
        if(this.options.contentContainer) {
            this.hideContent(true);
            this.options.contentContainer.getChildren()[this.points.indexOf(val)].fade('in');
        }
    },
    hideContent: function(fade) {
        if(this.options.contentContainer) {
            var children = this.options.contentContainer.getChildren();
            // if(fade) {
                children.fade('out');
            // } else {
                //children.hide();
            // }
        }
    }
});
            

            