ClickToReveal = new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    options: {
        data: [],
        totalSteps: 2,
        assessment: true,
        zoom: true,
        stepText: []
    },

    canvas : null,
    selectedElement: null,
    globalColor: '#C37981',
    globalStrokeColor: '#000000',
    globalShadowColor: '#000000',
    currentStep: 0,
    attempts: 3,
    totalPosibilities: 0,
    itexts: [],
    canvasOriginalPositions : [],
    showUnderstanding: false,
    lastTextSize: 14,
    isOptionPressed: false,
    edgedetection: 5,


    initialize: function(options) {
        var that = this;        
        this.challengeAssessableText = "Navigate to the first concept";
        this.presentationAssessableText = "Study the table";

        var footer_buttons = ''
            +'<button id="exit">Exit</button>'
            +'<button id="reset" class="" disabled="disabled">Reset</button>'
            +'<button id="start-over">Start Over</button>'
            +'<button id="try">Keep Trying</button>'
            +'<button class="grayed-1-rat grayed-rat" id="previous" disabled="disabled">Previous</button>'
            +'<button class="grayed-2-rat grayed-rat" id="next">Next</button>'
            +'<button id="check">Check Answers</button>'
            +'<button id="understanding">Check Your Understanding</button>'
            ;
        $$('.widget-footer.gray-footer')[0].set('html', footer_buttons);

        // Hide the checking game buttons
        $('exit').addClass('hide-class');
        $('understanding').addClass('hide-class');
        $('check').addClass('hide-class');
        $('try').addClass('hide-class');
        $('start-over').addClass('hide-class');
        $('exit').addClass('hide-class');

        this.setOptions(options);
        // Set the options value easier to get in the future
        if(this.options.data){
            this.options.totalSteps = this.options.data.totalSteps || 2;
            this.options.data.stepText.each(function(el){
                that.options.stepText.push(el);
            });
            this.options.assessment = this.options.data.assessment;
            this.options.zoom = this.options.data.zoom;
            this.options.data = this.options.data.data;
        }else{
            this.options.totalSteps = 2;
            this.options.data = null;
            this.options.stepText = ['',''];
            this.options.assessment = true;
            this.options.zoom = true;
        }
        this.options.accessibility_text = options.data != null && options.data.accessibility_text != null ? options.data.accessibility_text : [];

        // Set the canvas for fabricjs lib
        this.canvas = new fabric.Canvas('canvas', { width: 672, height: 495 });

        // Prevent elements of getting outside of canvas
        this.canvas.observe("object:moving", function(e){
            //alert("oval moving");
            var obj = e.target;
            // if object is too big ignore

            var halfw = obj.getWidth() / 2;
            var halfh = obj.getHeight() / 2;
            var bounds = {
                tl: {x: halfw, y:halfh},
                br: {x: obj.canvas.width , y: obj.canvas.height }
            };

            // top-left corner
            if(obj.top < bounds.tl.y || obj.left < bounds.tl.x){
                obj.top = Math.max(obj.top, halfh);
                obj.left = Math.max(obj.left , halfw)
            }

            // bot-right corner
            if(obj.top + halfh > bounds.br.y || obj.left + halfw > bounds.br.x ){
                obj.top = Math.min(obj.top, 495 - halfh);
                obj.left = Math.min(obj.left, 672 - halfw);
            }

        });

        this.createCustomFigures();

        this.parent(this.options);

        // Sync with server the totalSteps
        this.sendPostMessages('initial-steps', { totalSteps: this.options.totalSteps } );


        // Add the events for the buttons in preview mode
        $('next').addEvent('click', function() {
            if(that.currentStep < that.options.totalSteps -1) {
                that.nextStep();
                $('previous').removeProperty('disabled');
                $('reset').removeProperty('disabled');

                that.setAssessableText(that.challengeAssessableText);
                //that.setFocusInit();

                if(that.currentStep == that.options.totalSteps -1) {
                    // $('next').hide();
                    $('next').setProperty('disabled', 'disabled');

                    //$('reset').focus();
                    if(that.showUnderstanding && that.options.assessment){
                        $('understanding').removeClass('hide-class');
                    }
                }
                if(that.currentStep == that.options.totalSteps) {
                    // $('previous').show();
                    // $('reset').hide();
                    that.canvas.setZoom(1);
                    that.exitPanning();
                    that.canvas.renderAll();
                }
            }
            $$('.upper-canvas')[0].set('tabindex',-1).focus()
            that.chetAccessibilityText();
        });

        $('previous').addEvent('click', function() {

            that.setAssessableText(that.challengeAssessableText);
            //that.setFocusInit();

            if(that.currentStep == that.options.totalSteps -1) {
                $('next').removeClass('hide-class');
                $('understanding').addClass('hide-class');
                $('previous').removeClass('hide-class');
                $('reset').removeClass('hide-class');
                $$('.zoom-controls-container').removeClass('hide-class');
            }

            if(that.currentStep > 0) {
                that.previousStep();
                $('next').removeProperty('disabled');

                if(that.currentStep == 0) {
                    $('previous').setProperty('disabled', 'disabled');
                    $('reset').setProperty('disabled', 'disabled');
                }
            }
            $$('.upper-canvas')[0].set('tabindex',-1).focus()
            that.chetAccessibilityText();
        });

        $('reset').addEvent('click', function(e) {
            $('next').removeProperty('disabled');
            that.currentStep = 0;
            that.renderStepElements();
            $('next').focus();
            $('previous').setProperty('disabled', 'disabled');
            $('reset').setProperty('disabled', 'disabled');
            that.canvas.setZoom(1);
            that.exitPanning();
            that.canvas.renderAll();
        });

        $('understanding').addEvent('click', function() {
            $$('.zoom-controls-container').addClass('hide-class');
            $('previous').addClass('hide-class');
            $('reset').addClass('hide-class');
            $('exit').removeClass('hide-class');
            $('check').removeClass('hide-class').setProperty('disabled', 'disabled');
            this.addClass('hide-class');
            that.startUnderstanding();
        });

        $('check').addEvent('click', function() {
            that.checkAnswers();
        });

        $('try').addEvent('click', function() {
            this.addClass('hide-class');
            $('check').removeClass('hide-class');
            $('check').setProperty('disabled', 'disabled');
            that.canvas.add(that.itexts.shift());
            var text = 'Place the item at right on the figure.';
            if($('intro-line')){
                $('intro-line').set('html', '<p>'+text+'</p>');
            }
            that.canvas.renderAll();
        });

        $('start-over').addEvent('click', function() {
            this.addClass('hide-class');
            var toRemove = [];
            that.canvas.getObjects().each(function(el){
                if(el.type == "customRect" || el.type == "roundRect" || el.type == "customEllipse" || el.type == "customTriangle" || el.type == "customPolygon" || el.type == "customGroup" || el.type == "customImage"){
                    el.isTaken = false;
                }
                if(el.type == "group"){
                    toRemove.push(el);
                }else if(el.type == "customText"){
                    el.visible = true;
                }
            });

            toRemove.each(function(el){
                that.canvas.remove(el);
            });

            that.itexts = [];
            that.canvas.renderAll();
            that.attempts = 3;
            $('understanding').click();
        });

        $('exit').addEvent('click', function() {
            location.reload();
        });

        // load from JSON data and wait for the font loading
        setTimeout(function(){
            that.canvas.loadFromJSON(that.options.data, function(){
                that.canvas.getObjects().each(function (el) {
                    if (el.type == "customLine") {
                        el.addHeads();
                    }else{
                        el.set({
                            borderColor: 'lightgray',
                            cornerColor: 'green',
                            cornerSize: 6,
                            transparentCorners: false
                        })
                    }
                    that.canvasOriginalPositions.push({'left': el.getLeft(),'top': el.getTop()});
                });
                
                if(that.isEditMode){                    
                    that.lockCanvas(false);
                }else{                    
                    that.lockCanvas(true);
                }

                if(that.isTextContained()){
                    that.showUnderstanding = true;
                }

                if(that.currentStep == that.options.totalSteps -1) {
                    $('next').setProperty('disabled', 'disabled');
                    $('next').addClass('hide-class');
                    if(that.showUnderstanding){
                        if(that.options.assessment){
                            $('understanding').removeClass('hide-class');
                        }
                        $$('.zoom-controls-container').addClass('hide-class');
                    }
                    if(that.options.totalSteps > 1){
                        $('previous').removeClass('hide-class');
                    }else{
                        $('previous').addClass('hide-class');
                    }
                    $('reset').addClass('hide-class');
                }
            });
        },150);

        if(!this.isEditMode){
            this.canvas.on('mouse:up', function(e){
                if(e.target && e.target.type == "group"){
                    that.selectedElement = e.target;
                    if(!e.target.locked){
                        var contained = false;
                        that.canvas.getObjects().each(function(el){
                            if((e.target.isContainedWithinObject(el) || e.target.intersectsWithObject(el)) && el.type != "helperTriangle" && el.type != "helperCircle" && el.type != "customText" && el.type != "group" && el.type != "customLine" && !el.isTaken){
                                e.target.lockMovementX = true;
                                e.target.lockMovementY = true;
                                e.target.locked = true;
                                e.target.getObjects()[0].fill = null;
                                e.target.getObjects()[0].strokeWidth = 0;
                                e.target.originX = 'center';
                                e.target.originY = 'center';
                                contained = true;
                                el.isTaken = true;
                                e.target.left = el.getCenterPoint().x;
                                e.target.top = el.getCenterPoint().y;
                            }
                        });
                        if(!contained){
                            var clon = e.target;
                            clon.top = clon.height/2;
                            clon.left = $('canvas').width - 5 - e.target.width;
                            that.canvas.remove(e.target);
                            that.canvas.add(clon);
                        }else{
                            that.showNextAnswer();
                        }
                    }
                }
                that.canvas.renderAll();
            });
            if(that.options.zoom) {
                var zoom = new Element('div.zoom-controls-container');
                $$('.widget-body').grab(zoom);
                zoom.grab(new Element('button.zoom-button', {'html': '+', 'data-action': 'zoom-in', 'aria-label': 'Zoom in'}));
                zoom.grab(new Element('button.zoom-button', {'html': '-', 'data-action': 'zoom-out', 'aria-label': 'Zoom out'}));
                zoom.grab(new Element('button.zoom-button', {'html': 'r', 'data-action': 'zoom-reset', 'aria-label': 'Reset'}));

                // Zoom buttons events
                $$('.zoom-button').addEvent('click', function(){
                    if(this.get('data-action') == 'zoom-in' && that.canvas.getZoom() < 2){
                        that.canvas.setZoom(that.canvas.getZoom()+0.2);
                    }else if(this.get('data-action') == 'zoom-out'){
                        if(that.canvas.getZoom() > 1){
                            that.canvas.setZoom(that.canvas.getZoom()-0.2);
                        }
                        if(that.canvas.getZoom() == 1){
                            that.exitPanning();
                            that.canvas.renderAll();
                        }
                    }else if(this.get('data-action') == 'zoom-reset'){
                        that.canvas.setZoom(1);
                        that.exitPanning();
                        that.canvas.renderAll();
                    }
                });
            }
            this.panning();
        }else{
            this.initKeyboard();
            this.sendPostMessages('show-panel', {});
        }

        setTimeout(function(){
            that.chetAccessibilityText();
        },500);
        that.createAssessableText();

        // enable medium editor on #introductory-line
        this.initMediumEditor();
    },
    chetAccessibilityText: function(){
        var that = this;
        if(that.options.accessibility_text!=null && that.options.accessibility_text.length > 0 && that.options.accessibility_text[that.currentStep]!=null && that.options.accessibility_text[that.currentStep]!='')
            that.setAccessibleDescription(that.options.accessibility_text[that.currentStep]);
    },
    setAccessibleDescription: function(text){
        var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;

        if (isFirefox) {
            if($('image-description') == null ){
                var img_description = new Element('p#image-description');
                img_description.inject($$('.canvas-container canvas')[0]);
            } else {
                var currentDescription = $('image-description').get('text');
                $('image-description').dispose();
                var img_description = new Element('p#image-description',{html:currentDescription});
                img_description.inject($$('.canvas-container')[0],"after");
            }

            if($('image-description') != null ){
                $('image-description').set('html', text);
                $('canvas').set('tabindex', 0);
                $('canvas').set('aria-describedby',"image-description" );
                // setTimeout(function(){
                //     $('canvas').focus();
                // }, 500);
            }
        } else {
            if($('image-description') == null ){
                var img_description = new Element('p#image-description');
                img_description.inject($$('.canvas-container')[0]);
            }

            if($('image-description') != null ){
                $('image-description').set('html', text);
                $('canvas').set('tabindex', 0);
                // $('canvas').set('aria-describedby',"image-description" );

            }
        }
            

    },
    panning: function(){
        var that = this;
        var mouseDownOutsideObject = false;
        var mouseXStart = [];
        var mouseYStart = [];
        var mouseXOrig = 0;
        var mouseYOrig = 0;

        var getBackground = function() {
            return {
                'left': 0,
                'top': 0,
                'height': that.canvas.getHeight(),
                'width': that.canvas.getWidth()
            };
        }

        // Register mouse down event handler
        this.canvas.on('mouse:down', function(event){
            if(that.canvas.getZoom() > 1){
                if (event.offsetX == undefined) {
                    event.e.offsetX = event.e.pageX-that.canvas._offset.left;
                    event.e.offsetY = event.e.pageY-that.canvas._offset.top;
                }

                mouseXOrig = event.e.offsetX;
                mouseYOrig = event.e.offsetY;

                // Ignore if mouse is not on background
                var background = getBackground();
                if (mouseXOrig < background.left
                    || mouseXOrig > background.left + (background.width * that.canvas.getZoom())
                    || mouseYOrig < background.top
                    || mouseYOrig > background.top + (background.height * that.canvas.getZoom())) {
                    return;
                }

                mouseDownOutsideObject = true;

                var objects = that.canvas.getObjects();

                for (var i = 0; i < objects.length; i++){
                    mouseXStart[i] = objects[i].left;
                    mouseYStart[i] = objects[i].top;
                }
            }
        });

        // Register mouse up event handler
        this.canvas.on('mouse:up', function(e){
            if(that.canvas.getZoom() > 1){
                mouseDownOutsideObject = false;
            }
        });

        // Register mouse move event handler
        this.canvas.on('mouse:move', function(event){
            if(that.canvas.getZoom() > 1){
                if (mouseDownOutsideObject) {
                    var background = getBackground();
                    background.selectable = true;
                    var mouseXNew = event.e.pageX - that.canvas._offset.left;
                    var mouseYNew = event.e.pageY - that.canvas._offset.top;

                    var mouseXDelta = (mouseXNew - mouseXOrig);
                    var mouseYDelta = (mouseYNew - mouseYOrig);

                    var borderWidth = 200;

                    if (background.left + mouseXDelta <= borderWidth
                        && background.top + mouseYDelta <= borderWidth
                        && background.left + background.width + mouseXDelta >= that.canvas.getWidth() - borderWidth
                        && background.top + background.height + mouseYDelta >= that.canvas.getHeight() - borderWidth) {
                        var objects = that.canvas.getObjects();

                        for (var i = 0; i < objects.length; i++) {
                            objects[i].setLeft(mouseXDelta + mouseXStart[i]);
                            objects[i].setTop(mouseYDelta + mouseYStart[i]);
                            objects[i].setCoords();
                        }
                        that.canvas.renderAll();
                    }
                    background.selectable = false;
                }
            }
        });
    },

    exitPanning: function(){
        var that = this;
        this.canvas.getObjects().each(function(e, i){
            if(e.type != 'helperTriangle' && e.type != 'helperCircle'){
                e.setTop(that.canvasOriginalPositions[i].top);
                e.setLeft(that.canvasOriginalPositions[i].left);
                if(e.type == 'customLine'){
                    e.circle1.set({'left': e.path[0][1], 'top': e.path[0][2]}).setCoords();
                    e.circle2.set({'left': e.path[1][3], 'top': e.path[1][4]}).setCoords();
                    e.arrow1.set({'left': e.path[0][1], 'top': e.path[0][2]}).setCoords();
                    e.arrow2.set({'left': e.path[1][3], 'top': e.path[1][4]}).setCoords();
                }
            }
        });
    },

    isTextContained: function(){
        var that = this;
        var isContained = false;
        this.canvas.getObjects().each(function(el){
            if(el.type == "customText") {
                that.canvas.getObjects().each(function (other) {
                    if (el.isContainedWithinObject(other) && other.type != "customText" && other.type != "customLine" && other.type != "helperTriangle" && other.type != "customCircle" && other.type != "group") {
                        isContained = true;
                    }
                });
            }
        });
        return isContained;
    },

    getTexts: function(){
        var that = this;
        var cont = 1;
        this.canvas.getObjects().each(function(el){
            if(el.type == "customText"){
                var clon = el.clone();
                clon.top = clon.height/2;
                clon.left = $('canvas').width - 5 - clon.width;
                clon.originX = 'center';
                clon.originY = 'center';

                var rect = new fabric.Rect({
                    left: clon.left,
                    top: clon.top,
                    fill: '#DCDEE0',
                    width: clon.getWidth() + 15,
                    height: clon.getHeight() + 15,
                    originX: 'center',
                    originY: 'center',
                    ry: 6,
                    rx: 6,
                    stroke: "#54585f",
                    strokeWidth: 3
                });
                var isContained = false;
                that.canvas.getObjects().each(function(other){
                    if((el.isContainedWithinObject(other) || el.intersectsWithObject(other)) && other.type != "customText" && other.type != "customLine" && other.type != "helperTriangle" && other.type != "customCircle" &&other.type != "group"){
                        other.id = cont;
                        isContained = true;
                    }
                });

                if(isContained){
                    that.itexts.push(new fabric.Group([rect, clon], {
                        top: rect.height/2,
                        hasControls: false,
                        lockMovementX: false,
                        lockMovementY: false,
                        editable: false,
                        id: cont
                    }));
                    el.visible = false;
                    el.hasContainer = true;
                }
            }
            cont++;
        });
        this.itexts = this.shuffleText(this.itexts);
        this.totalPosibilities = this.itexts.length;
    },

    startUnderstanding: function(){
        this.getTexts();
        this.showNextAnswer();
    },

    shuffleText: function(array) {
        var counter = array.length, temp, index;

        // While there are elements in the array
        while (counter > 0) {
            // Pick a random index
            index = Math.floor(Math.random() * counter);

            // Decrease counter by 1
            counter--;

            // And swap the last element with it
            temp = array[counter];
            array[counter] = array[index];
            array[index] = temp;
        }

        return array;
    },

    showNextAnswer: function() {
        var text = 'Place the item at right on the figure.';
        if($('intro-line')){
            $('intro-line').set('html', '<p>'+text+'</p>');
        }

        if(this.itexts.length > 0){
            this.canvas.add(this.itexts.shift());
            this.canvas.renderAll();
        }else{
            $('check').removeProperty('disabled')
            text = 'You\'ve placed all items. When you’re ready, click “Check Answers.”';
            if($('intro-line')){
                $('intro-line').set('html', '<p>'+text+'</p>');
            }
        }
    },

    checkAnswers: function(){
        var that = this;
        var count = 0;
        var toRemove = [];

        this.canvas.getObjects().each(function(el){
            if(el.type == "group"){
                that.canvas.getObjects().each(function(other){
                    if(other.type != "group" && other.type != 'customText' && (el.intersectsWithObject(other) || el.isContainedWithinObject(other))){
                        if(el.id != other.id && (other.type == 'customRect' || other.type == 'roundRect' || other.type == 'customCircle' || other.type == 'customTriangle' || other.type == 'customEllipse' || other.type == 'customPolygon' || other.type == 'customGroup')){
                            var clon = el;
                            clon.top = clon.height/2;
                            clon.left = $('canvas').width - 5 - clon.width;
                            clon.lockMovementX = false;
                            clon.lockMovementY = false;
                            clon.locked = false;
                            clon.getObjects()[0].fill = '#DCDEE0';
                            clon.getObjects()[0].strokeWidth = 3;
                            toRemove.push(el);
                            that.itexts.push(clon);
                            other.isTaken = false;
                            el.isTaken = false;
                            count++;
                            that.canvas.renderAll();
                        }
                    }
                });
            }
        });
        
        if(count > 0){
            if(this.attempts > 1){
                toRemove.each(function(el){
                    that.canvas.remove(el);
                });
                this.attempts--;
                var text = 'You got '+(this.totalPosibilities - count)+' of '+this.totalPosibilities+' correct. Click "Keep Trying" to continue. You have '+this.attempts+' more attempts.';
                if($('intro-line')){
                    $('intro-line').set('html', '<p>'+text+'</p>');
                }
                $('try').removeClass('hide-class');
                $('check').addClass('hide-class');
            }else{
                var text = 'Sorry, you did not re-create the figure. Here it is again. <br/> Click “Start Again” to repeat this exercise.'
                if($('intro-line')){
                    $('intro-line').set('html', '<p>'+text+'</p>');
                }
                $('check').addClass('hide-class');
                $('start-over').removeClass('hide-class');

                var roveFromCanvas = [];

                that.canvas.getObjects().each(function(el){
                    if(el.type == "group"){
                        roveFromCanvas.push(el);
                    }else if(el.type == "customText"){
                        el.visible = true;
                    }
                });

                roveFromCanvas.each(function(el){
                    that.canvas.remove(el);
                });
                that.canvas.renderAll();
            }
        }else{
            var att = 'third';
            if(this.attempts == 2){
                att = 'second';
            }else if(this.attempts == 3){
                att = 'first';
            }
            var text = 'Great job! You re-created the figure on your '+ att +' attempt! <br/> Click "Start Again" if you want to repeat this exercise.';
            if($('intro-line')){
                $('intro-line').set('html', '<p>'+text+'</p>');
            }
            $('check').addClass('hide-class');
            $('start-over').removeClass('hide-class');
        }
    },

    save: function(){
        var objects = [];
        // Save and invert the order of the elements stack to keep the z-index right
        this.canvas.toJSON().objects.each(function(obj) {
            if(obj && obj.type != "helperCircle" && obj.type != "helperTriangle") {
                if (obj.type == 'customImage') {
                    var currentURL = window.location.href.split('index.html?')[0]
                    var regexURL = new RegExp(currentURL, 'g')
                    obj.src = obj.src.replace(regexURL, '')
                }

                objects.push(obj);
            }
        });
        
        this.options.data = JSON.stringify({objects: objects});
        this.saveRequest({method: 'mdData', options: {'json': {data: this.options.data, totalSteps: this.options.totalSteps, stepText: this.options.stepText, assessment: this.options.assessment, zoom: this.options.zoom, accessibility_text: this.options.accessibility_text!=null?this.options.accessibility_text:[]}}});
    },

    // If is edit mode
    bindEditMode: function() {
        var that = this;

        // Sync with server if assessment and/or zoom are enabled
        this.sendPostMessages('initialize-options', { assessment: this.options.assessment, zoom: this.options.zoom } );

        $$('.widget-footer').addClass('hide-class');

        $('canvas').setStyle('border', 'dashed');

        if($('intro-line')){
            var intTimerID = null;
            $('intro-line').addEvent('keyup', handleIntroLineChange);
            $('intro-line').addEvent('input', handleIntroLineChange);

            function handleIntroLineChange (e) {
                if (intTimerID != null) {
                    clearTimeout(intTimerID);
                }
                intTimerID = setTimeout(function() {
                    that.options.stepText[that.currentStep] = e.target.get('html');
                    that.save();
                }, 500);
            }
        }

        /**
         *  Set the events for the canvas in fabricjs
         */

        // On moving events for the dots and arrows in the lines
        this.canvas.on('object:moving', function (e) {
            var p = e.target;

            p.setCoords(); //Sets corner position coordinates based on current angle, width and height
            that.canvas.forEachObject(function (targ) {
                activeObject = that.canvas.getActiveObject();

                if (targ === activeObject || targ.type == 'helperTriangle' || targ.type == 'helperCircle') return;

                if (Math.abs(activeObject.oCoords.tr.x - targ.oCoords.tl.x) < that.edgedetection && intersectedLines(activeObject.oCoords.tr.y, activeObject.oCoords.br.y, targ.oCoords.tl.y, targ.oCoords.bl.y)) {
                    activeObject.left = targ.left - activeObject.getWidth()/2 - targ.getWidth()/2;
                }
                if (Math.abs(activeObject.oCoords.tl.x - targ.oCoords.tr.x) < that.edgedetection && intersectedLines(activeObject.oCoords.tr.y, activeObject.oCoords.br.y, targ.oCoords.tl.y, targ.oCoords.bl.y)) {
                    activeObject.left = targ.left + activeObject.getWidth()/2 + targ.getWidth()/2;
                }
                if (Math.abs(activeObject.oCoords.br.y - targ.oCoords.tr.y) < that.edgedetection && intersectedLines(activeObject.oCoords.bl.x, activeObject.oCoords.br.x, targ.oCoords.tl.x, targ.oCoords.tr.x)) {
                    activeObject.top = targ.top - activeObject.getHeight()/2 - targ.getHeight()/2;
                }
                if (Math.abs(targ.oCoords.br.y - activeObject.oCoords.tr.y) < that.edgedetection && intersectedLines(activeObject.oCoords.bl.x, activeObject.oCoords.br.x, targ.oCoords.tl.x, targ.oCoords.tr.x)) {
                    activeObject.top = targ.top + activeObject.getHeight()/2 + targ.getHeight()/2;
                }
            });

            function intersectedLines(p1, p2, p3, p4) {
                if(p1 >= p3 && p1<=p4 || p2>=p3 && p2<=p4 || p3>=p1 && p3<=p2 || p4>=p1 && p4<=p2) {
                    return true;
                }
                return false;
            }

            /**
             * Moving for Lines
             */
            // move line
            if(p.type == 'customLine'){
                var oldCenterX = p.path[1][1];
                var oldCenterY = p.path[1][2];

                var deltaX = p.left - oldCenterX;
                var deltaY = p.top - oldCenterY;

                p.circle1.set({'left': p.path[0][1] + deltaX, 'top': p.path[0][2] + deltaY}).setCoords();
                p.circle2.set({'left': p.path[1][3] + deltaX, 'top': p.path[1][4] + deltaY}).setCoords();
                p.arrow1.set({'left': p.path[0][1] + deltaX, 'top': p.path[0][2] + deltaY}).setCoords();
                p.arrow2.set({'left': p.path[1][3] + deltaX, 'top': p.path[1][4] + deltaY}).setCoords();
                p.point.set({'left': p.path[1][1], 'top': p.path[1][2]}).setCoords();

                p.path[0][1] = p.path[0][1] + deltaX;
                p.path[0][2] = p.path[0][2] + deltaY;
                p.path[1][1] = p.left;
                p.path[1][2] = p.top;
                p.path[1][3] = p.path[1][3] + deltaX;
                p.path[1][4] = p.path[1][4] + deltaY;

                p.pathOffset.x = p.path[1][1];
                p.pathOffset.y = p.path[1][2];
            }

            // move circle or triangle or point
            if(p.type == 'helperTriangle' || p.type == 'helperCircle'){
                if(p.type == 'helperTriangle'){
                    p.line.path[0][1] = p.line.arrow1.left;
                    p.line.path[0][2] = p.line.arrow1.top;
                    p.line.path[1][3] = p.line.arrow2.left;
                    p.line.path[1][4] = p.line.arrow2.top;
                    p.line.circle1.set({'left': p.line.arrow1.left, 'top': p.line.arrow1.top});
                    p.line.circle2.set({'left': p.line.arrow2.left, 'top': p.line.arrow2.top});
                }else if(p.type == 'helperCircle') {
                    if(p.line.point === p){
                        p.line.path[1][1] = p.getLeft();
                        p.line.path[1][2] = p.getTop();
                        p.line.pathOffset.x = p.line.path[1][1];
                        p.line.pathOffset.y = p.line.path[1][2];
                    }else{
                        p.line.path[0][1] = p.line.circle1.left;
                        p.line.path[0][2] = p.line.circle1.top;
                        p.line.path[1][3] = p.line.circle2.left;
                        p.line.path[1][4] = p.line.circle2.top;
                        p.line.arrow1.set({'left': p.line.circle1.left, 'top': p.line.circle1.top});
                        p.line.arrow2.set({'left': p.line.circle2.left, 'top': p.line.circle2.top});
                    }
                }
                p.line.setCoords();
                if (p.line.isCurve){
                    // Get angle
                    if (p === p.line.arrow1) {
                        dy = p.line.path[0][2] - p.line.path[1][2];
                        dx = p.line.path[0][1] - p.line.path[1][1];
                        theta = Math.atan2(dy, dx) * 180 / Math.PI;

                        p.set('angle', theta - 270);
                    } else if (p === p.line.arrow2) {
                        dy = p.line.path[1][4] - p.line.path[1][2];
                        dx = p.line.path[1][3] - p.line.path[1][1];
                        theta = Math.atan2(dy, dx) * 180 / Math.PI;

                        p.set('angle', theta - 270);
                    } else if (p === p.line.point) {
                        p.line.getAngle();
                    }
                }else{
                    // Get angle
                    dy = p.line.path[0][2] - p.line.path[1][4];
                    dx = p.line.path[0][1] - p.line.path[1][3];
                    theta = Math.atan2(dy, dx) * 180 / Math.PI;

                    p.line.arrow1.set('angle', theta - 270);
                    p.line.arrow2.set('angle', theta - 90);

                    p.line.path[1][1] = (p.line.path[0][1] + p.line.path[1][3]) / 2;
                    p.line.path[1][2] = (p.line.path[0][2] + p.line.path[1][4]) / 2;
                }
                p.line.pathOffset.x = p.line.path[1][1];
                p.line.pathOffset.y = p.line.path[1][2];
                p.line.left = p.line.path[1][1];
                p.line.top = p.line.path[1][2];

                // Set border size
                if(p.line.isCurve){
                    //console.log(p.line.point);
                    //p.line.width = Math.abs(p.line.path[0][1] - p.line.path[1][3] + p.line.path[1][2]);
                    //p.line.height = Math.abs(p.line.path[0][2] - p.line.path[1][4] + p.line.path[1][1]);
                }else{
                    p.line.width = Math.abs(p.line.path[0][1] - p.line.path[1][3]);
                    p.line.height = Math.abs(p.line.path[0][2] - p.line.path[1][4]);
                }
            }
        });

        // Save on mouse up
        this.canvas.on('mouse:up', function(options) {
            that.canvas.getObjects().each(function(el){
                if(el.type == "customLine" || el.type == "helperCircle" || el.type == "helperTriangle"){
                    el.selectable = true;
                }
            });
            that.save();
        });

        // Send message to server on mouse down
        this.canvas.on('mouse:down', function(options) {
            if(!options.target){
                that.canvas.getObjects().each(function(el){
                    if(el.type == "customLine" || el.type == "helperCircle" || el.type == "helperTriangle"){
                        el.selectable = false;
                    }
                });
            }
            if(options.target){
                if(options.target.type == "helperCircle" || options.target.type == "helperTriangle") {
                    that.canvas.setActiveObject(options.target.line);
                }else if(options.target.type != "customLine") {
                    if(that.isOptionPressed){
                        that.selectedElement = options.target;
                        if(!that.selectedElement.lockMovementX){
                            that.cloneFigure(true);
                        }
                    }
                }
            }
            that.sendObjectsToServer(options);
        });

        this.canvas.on('before:selection:cleared', function(options){
            that.canvas.getObjects().each(function(el){
                if(el.type == "customLine"){
                    if(el.isCurve){
                        el.point.visible = false;
                    }
                    el.circle1.visible = false;
                    el.circle2.visible = false;
                }
            });
        });

        this.canvas.on('object:selected', function(options){
            that.hideAllDotsFromLinesAndArrows();
            if(options.target.type == "customLine"){
                if(options.target.isCurve){
                    options.target.point.visible = true;
                }
                if(!options.target.isArrow){
                    options.target.circle1.visible = true;
                    options.target.circle2.visible = true;
                }else{
                    if(options.target.heads == 1){
                        options.target.circle2.visible = true;
                    }
                }
            }else if(options.target.type == "helperTriangle"){
                if(options.target.line.isCurve){
                    options.target.line.point.visible = true;
                }
                if(!options.target.line.isArrow){
                    options.target.line.circle1.visible = true;
                    options.target.line.circle2.visible = true;
                }else{
                    if(options.target.line.heads == 1){
                        options.target.line.circle2.visible = true;
                    }
                }
            }
        });
    },

    hideAllDotsFromLinesAndArrows: function(){
        this.canvas.getObjects().each(function(el){
            if(el.type == "customLine"){
                if(el.isCurve){
                    el.point.visible = false;
                }
                el.circle1.visible = false;
                el.circle2.visible = false;
            }
        });
    },

    // Send the objects state to the server for properties visualization in the side bar
    sendObjectsToServer: function(options){
        var target = options.target;

        if (target) {
            switch(target.type){
                case "customText":
                    this.sendPostMessages('object-selected', {
                        type: target.type, options: {
                            'fontFamily': target.fontFamily,
                            'fontStyle': target.fontStyle,
                            'fontSize': target.fontSize,
                            'shadow': target.shadow,
                            'textAlign': target.textAlign,
                            'fill': target.fill,
                            'textDecoration': target.textDecoration
                        }
                    });
                    break;
                case "customRect": case "customEllipse": case "customPolygon": case "customGroup": case "customTriangle":
                this.sendPostMessages('object-selected',{
                        type: target.type, options: {
                            'fill': target.type == 'customGroup' ? target.getObjects()[0].fill : target.fill,
                            'stroke': target.stroke,
                            'strokeWidth': target.strokeWidth,
                            'shadow': target.type == 'customGroup' ? target.getObjects()[0].shadow : target.shadow
                        }
                    });
                break;
                case "roundRect":
                    this.sendPostMessages('object-selected', {
                        type: target.type, options: {
                            'fill': target.fill,
                            'stroke': target.stroke,
                            'strokeWidth': target.strokeWidth,
                            //'shadow': target.shadow,
                            'shadow': target.type == 'customGroup' ? target.getObjects()[0].shadow : target.shadow,
                            'radius': target.rx
                        }
                    });
                    break;
                case "customLine":
                    this.sendPostMessages('object-selected', {
                        type: target.type, options: {
                            'fill': target.fill,
                            'stroke': target.stroke,
                            'strokeWidth': target.strokeWidth,
                            'shadow': target.shadow,
                            'strokeDashArray': target.strokeDashArray[0] == 1 ? 'normal' : target.strokeDashArray[0] == 7 ? 'dashed' : 'dotted',
                            'isArrow': target.isArrow,
                            'isCurve': target.isCurve,
                            'head': target.heads
                        }
                    });
                    break;
                // For arrow edges
                case "helperTriangle":
                    target = target.line;
                    this.sendPostMessages('object-selected', {
                        type: target.type, options: {
                            'fill': target.fill,
                            'stroke': target.stroke,
                            'strokeWidth': target.strokeWidth,
                            'shadow': target.shadow,
                            'strokeDashArray': target.strokeDashArray[0] == 1 ? 'normal' : target.strokeDashArray[0] == 7 ? 'dashed' : 'dotted',
                            'isArrow': target.isArrow,
                            'isCurve': target.isCurve,
                            'head': target.heads
                        }
                    });
                    break;
                // For line edges
                case "helperCircle":
                    target = target.line;
                    this.sendPostMessages('object-selected', {
                        type: target.type, options: {
                            'fill': target.fill,
                            'stroke': target.stroke,
                            'strokeWidth': target.strokeWidth,
                            'shadow': target.shadow,
                            'strokeDashArray': target.strokeDashArray[0] == 1 ? 'normal' : target.strokeDashArray[0] == 7 ? 'dashed' : 'dotted',
                            'isArrow': target.isArrow,
                            'isCurve': target.isCurve,
                            'head': target.heads
                        }
                    });
                    break;
                case "customImage":
                    this.sendPostMessages('object-selected', {
                        type: target.type, options: {
                            'shadow': target.shadow
                        }
                    });
                case "group":
                    this.sendPostMessages('object-selected', {
                        type: target.type, options: {}
                    });
                default:
                }
            this.selectedElement = target;
        } else {
            this.sendPostMessages('unselected', {});
            this.selectedElement = null;
        }
    },

    /**
     *  Create custom figures for new objects properties like:
     *      step,
     *      isArrow and heads in the lines
     *      Allows to save and load those properties.
     */
    createCustomFigures: function(){
        var that = this;

        //Custom Text
        fabric.CustomText = fabric.util.createClass(fabric.IText, {
            type: 'customText',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step });
            }
        });
        fabric.CustomText.fromObject = function (object, callback) {
            var _enlivenedObjects;
            fabric.util.enlivenObjects(object.objects, function (enlivenedObjects) {
                delete object.objects;
                _enlivenedObjects = enlivenedObjects;
            });
            return new fabric.CustomText(_enlivenedObjects, object);
        };

        //Custom Group
        fabric.CustomGroup = fabric.util.createClass(fabric.Group, {
            type: 'customGroup',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step });
            }
        });
        fabric.CustomGroup.fromObject = function (object, callback) {
            var _enlivenedObjects;
            fabric.util.enlivenObjects(object.objects, function (enlivenedObjects) {
                delete object.objects;
                _enlivenedObjects = enlivenedObjects;
            });
            return new fabric.CustomGroup(_enlivenedObjects, object);
        };

        // Custom Rect
        fabric.CustomRect = fabric.util.createClass(fabric.Rect, {
            type: 'customRect',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step });
            }
        });
        fabric.CustomRect.fromObject = function (object, callback) {
            return new fabric.CustomRect(object, callback);
        };

        // Round Rect
        fabric.RoundRect = fabric.util.createClass(fabric.Rect, {
            type: 'roundRect',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step });
            }
        });
        fabric.RoundRect.fromObject = function (object, callback) {
            return new fabric.RoundRect(object, callback);
        };

        // Custom Ellipse
        fabric.CustomEllipse = fabric.util.createClass(fabric.Ellipse, {
            type: 'customEllipse',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step});
            }
        });
        fabric.CustomEllipse.fromObject = function (object, callback) {
            return new fabric.CustomEllipse(object, callback);
        };

        // Custom Triangle
        fabric.CustomTriangle = fabric.util.createClass(fabric.Triangle, {
            type: 'customTriangle',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step});
            }
        });
        fabric.CustomTriangle.fromObject = function (object, callback) {
            return new fabric.CustomTriangle(object, callback);
        };

        // Custom Polygon
        fabric.CustomPolygon = fabric.util.createClass(fabric.Polygon, {
            type: 'customPolygon',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step });
            }
        });
        fabric.CustomPolygon.fromObject = function (object) {
            return new fabric.CustomPolygon(object.points, object, true);
        };

        //Custom Image
        fabric.CustomImage = fabric.util.createClass(fabric.Image, {
            type: 'customImage',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
                options && this.set('step', options.step);
            },

            setStep: function(step) {
                this.set('step', step);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), { step: this.step });
            }
        });
        fabric.CustomImage.fromObject = function (object, callback) {
            //fabric.Image.fromObject(object, callback);
            fabric.util.loadImage(object.src, function(img) {
                var oImg = new fabric.CustomImage(img);
                oImg._initConfig(object);
                oImg._initFilters(object);
                callback(oImg);
            });
        };
        fabric.CustomImage.fromURL = function(url, callback, imgOptions) {
            fabric.util.loadImage(url, function(img) {
                callback(new fabric.CustomImage(img, imgOptions));
            }, null, imgOptions && imgOptions.crossOrigin);
        };
        fabric.CustomImage.async = true;

        // Helper Circle
        fabric.HelperCircle = fabric.util.createClass(fabric.Circle, {
            type: 'helperCircle',
            lockScalingX: true,
            lockScalingY: true,
            lockRotation: true,
            hasBorders: false,
            hasControls: false,
            originX: 'center',
            originY: 'center',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
            },

            toObject: function() {
                return null;
            }
        });

        // Helper Triangle
        fabric.HelperTriangle = fabric.util.createClass(fabric.Triangle, {
            type: 'helperTriangle',
            lockScalingX: true,
            lockScalingY: true,
            lockRotation: true,
            hasBorders: false,
            hasControls: false,
            centeredRotation: true,
            originX: 'center',
            originY: 'center',

            initialize: function(element, options) {
                this.callSuper('initialize', element, options);
            },

            toObject: function() {
                return null;
            }
        });

        // Custom Line
        fabric.CustomLine = fabric.util.createClass(fabric.Path, {
            type: 'customLine',
            lockScalingX: true,
            lockScalingY: true,
            lockRotation: true,
            hasBorders: true,
            hasControls: false,
            perPixelTargetFind: true,
            originX: 'center',
            originY: 'center',
            isArrow: false,
            isCurve: false,
            heads: 0,
            borderColor: 'green',
            cornerSize: 6,
            transparentCorners: false,

            initialize: function(element, options, json) {
                this.callSuper('initialize', element, options);
                options && this.set('heads', options.heads);
                options && this.set('isArrow', options.isArrow);
                options && this.set('isCurve', options.isCurve);
                options && this.set('step', options.step);

                var circle1 = new fabric.HelperCircle({left: this.path[0][1], top: this.path[0][2], radius: 3, strokeWidth: 3, stroke: this.stroke, fill: this.stroke, visible: false});
                var circle2 = new fabric.HelperCircle({left: this.path[1][3], top: this.path[1][4], radius: 3, strokeWidth: 3, stroke: this.stroke, fill: this.stroke, visible: false});
                var arrow1 = new fabric.HelperTriangle({left: this.path[0][1], top: this.path[0][2], width: 15, height: 15, fill: this.stroke});
                var arrow2 = new fabric.HelperTriangle({left: this.path[1][3], top: this.path[1][4], width: 15, height: 15, fill: this.stroke});
                var point = new fabric.HelperCircle({left: this.path[1][1], top: this.path[1][2], radius: 4, strokeWidth: 4, stroke: this.stroke, fill: this.stroke, visible: false});

                circle1.line = circle2.line = arrow1.line = arrow2.line = point.line = this;
                this.circle1 = circle1;
                this.circle2 = circle2;
                this.arrow1 = arrow1;
                this.arrow2 = arrow2;
                this.point = point;

                this.getAngle();
            },

            getAngle: function (){
                if(this.isCurve){
                    dy1 = this.path[0][2] - this.path[1][2];
                    dx1 = this.path[0][1] - this.path[1][1];
                    theta1 = Math.atan2(dy1, dx1) * 180 / Math.PI;

                    dy2 = this.path[1][4] - this.path[1][2];
                    dx2 = this.path[1][3] - this.path[1][1];
                    theta2 = Math.atan2(dy2, dx2) * 180 / Math.PI;

                    this.arrow1.set('angle', theta1 - 270);
                    this.arrow2.set('angle', theta2 - 270);
                }else{
                    dy = this.path[1][4] - this.path[0][2];
                    dx = this.path[1][3] - this.path[0][1];
                    theta = Math.atan2(dy, dx) * 180/Math.PI;

                    this.arrow1.set('angle', theta - 90);
                    this.arrow2.set('angle', theta - 270);
                }
            },

            addHeads: function () {
                this.canvas.add(this.arrow1);
                this.canvas.add(this.arrow2);
                this.canvas.add(this.circle1);
                this.canvas.add(this.circle2);
                this.canvas.add(this.point);

                this.showHeadsOnCreate();
            },

            addHeadsOnCreate: function () {
                this.canvas.add(this.arrow1);
                this.canvas.add(this.arrow2);
                this.canvas.add(this.circle1);
                this.canvas.add(this.circle2);
                this.canvas.add(this.point);

                this.showHeads();
            },

            showHeadsOnCreate: function() {
                this.hideHeads();

                if(this.heads == 1) {
                    this.arrow1.visible = true;
                } else if(this.heads == 2) {
                    this.arrow1.visible = true;
                    this.arrow2.visible = true;
                }
            },

            showHeads: function() {
                this.hideHeads();

                if(this.heads == 0) {
                    if(that.isEditMode) {
                        this.circle1.visible = true;
                        this.circle2.visible = true;
                    }
                } else if(this.heads == 1) {
                    if(that.isEditMode) {
                        this.circle2.visible = true;
                    }
                    this.arrow1.visible = true;
                } else if(this.heads == 2) {
                    this.arrow1.visible = true;
                    this.arrow2.visible = true;
                }
            },

            hideHeads: function() {
                this.circle1.visible = false;
                this.circle2.visible = false;
                this.arrow1.visible = false;
                this.arrow2.visible = false;
            },

            showDots: function(state) {
                if(state){
                    if(!this.isArrow){
                        this.circle1.visible = true;
                    }
                    if(this.heads < 2){
                        this.circle2.visible = true;
                    }
                }else{
                    this.circle1.visible = false;
                    this.circle2.visible = false;
                }
            },

            setHeads: function(heads) {
                this.heads = heads;
                this.showHeads();
            },

            setStep: function(step) {
                this.circle1.set('step', step);
                this.circle2.set('step', step);
                this.arrow1.set('step', step);
                this.arrow2.set('step', step);
                this.point.set('step', step);
                this.set('step', step);
            },

            setStroke: function(color) {
                this.circle1.setStroke(color);
                this.circle1.setFill(color);
                this.circle2.setStroke(color);
                this.circle2.setFill(color);
                this.arrow1.setFill(color);
                this.arrow2.setFill(color);
                this.point.setStroke(color);
                this.point.setFill(color);
                this.callSuper('setStroke', color);
            },

            setShadow: function(shadow) {
                this.circle1.setShadow(shadow);
                this.circle2.setShadow(shadow);
                this.arrow1.setShadow(shadow);
                this.arrow2.setShadow(shadow);
                this.point.setShadow(shadow);
                this.callSuper('setShadow', shadow);
            },

            remove: function() {
                this.canvas.remove(this.arrow1);
                this.canvas.remove(this.arrow2);
                this.canvas.remove(this.circle1);
                this.canvas.remove(this.circle2);
                this.canvas.remove(this.point);
                this.canvas.remove(this);
            },

            sendToBack: function() {
                this.circle1.sendToBack();
                this.circle2.sendToBack();
                this.arrow1.sendToBack();
                this.arrow2.sendToBack();
                this.point.sendToBack();
                this.callSuper('sendToBack', this);
            },

            bringToFront: function() {
                this.circle1.bringToFront();
                this.circle2.bringToFront();
                this.arrow1.bringToFront();
                this.arrow2.bringToFront();
                this.point.bringToFront();
                this.callSuper('bringToFront', this);
            },

            toObject: function() {
                return fabric.util.object.extend(this.callSuper('toObject'), {step: this.step, isArrow: this.isArrow, isCurve: this.isCurve, heads: this.heads});
            }

        });
        fabric.CustomLine.fromObject = function (object) {
            return new fabric.CustomLine(object.path, object);
        };
    },

    // Receive messages from server and take actions
    customPostMessages: function(message) {
        switch(message.data.method){
            case "addFigure":
                this.drawFigure(message.data.figure);
                this.save();
                break;
            case "addImage":
                this.drawImage(message.data.data);
                this.save();
                break;
            case "customText": case "customRect": case "roundRect": case "customEllipse": case "customTriangle": case "customPolygon": case "customGroup": case "customLine": case "customImage":
                this.changeAttribute(message);
                break;
            case "delete":
                this.removeFigure();
                break;
            case "backwards": case "forwards":
                this.changeZIndex(message.data.method);
                break;
            case "lockCanvas":                
                this.lockCanvas(message.data.state);
                break;
            case "steps":
                this.manageSteps();
                break;
            case "current-step":
                this.currentStep = message.data.current;
                this.renderStepElements();
                break;
            case "clone":
                this.cloneFigure();
                break;
            case "hide":
                if(this.selectedElement != null ){
                    this.selectedElement.setStep(this.currentStep);
                    this.save();
                    this.renderStepElements();
                }
                break;
            case "restore-step":
                this.restoreStep(message.data.current);
                break;
            case "delete-step":
                this.deleteStep(message.data.current);
                break;
            case "alignment":
                this.alignObjects(message.data.attr);
                break;
            case "assessment":
                this.assessment(message.data.value);
                break;
            case "zoom":
                this.zoom(message.data.value);
                break;
            case "async-data-updated":
                this.options.accessibility_text = message.data.data.accessibility_text;
                break;
        }
    },

    // Draw a fabricjs figure depending of the selected type
    drawFigure: function(type){
        this.hideAllDotsFromLinesAndArrows();
        switch(type){
            case "text":
                // Add a text object onto canvas
                this.selectedElement = new fabric.CustomText("Text", {
                    left: 335,
                    top: 250,
                    fontSize: this.lastTextSize,
                    fill: this.globalStrokeColor,
                    fontFamily: 'HelveticaNeueETW01-55Rg',
                    fontStyle: 'normal',
                    textAlign: 'left',
                    textDecoration: 'none',
                    originX: 'center',
                    originY: 'center',
                    borderColor: 'lightgray',
                    cornerColor: 'green',
                    cornerSize: 6,
                    transparentCorners: false
                });
                this.canvas.add(this.selectedElement);
                break;
            case "rectangle":
                // Add a rectangle object onto canvas
                this.selectedElement = new fabric.CustomRect({
                    left: 335,
                    top: 250,
                    fill: this.globalColor,
                    width: 125,
                    height: 75,
                    stroke: "#000000",
                    strokeWidth: 1,
                    originX: 'center',
                    originY: 'center',
                    borderColor: 'lightgray',
                    cornerColor: 'green',
                    cornerSize: 6,
                    transparentCorners: false
                });
                this.canvas.add(this.selectedElement);
                break;
            case "round-rect":
                // Add a round rectangle object onto canvas
                this.selectedElement = new fabric.RoundRect({
                    left: 335,
                    top: 250,
                    fill: this.globalColor,
                    width: 125,
                    height: 75,
                    ry: 10,
                    rx: 10,
                    stroke: "#000000",
                    strokeWidth: 1,
                    originX: 'center',
                    originY: 'center',
                    borderColor: 'lightgray',
                    cornerColor: 'green',
                    cornerSize: 6,
                    transparentCorners: false
                });
                this.canvas.add(this.selectedElement);
                break;
            case "ellipse":
                // Add an ellipse object onto canvas
                this.selectedElement = new fabric.CustomEllipse({
                    fill: this.globalColor,
                    rx: 50,
                    ry:35,
                    left: 335,
                    top: 250,
                    stroke: "#000000",
                    strokeWidth: 1,
                    originX: 'center',
                    originY: 'center',
                    borderColor: 'lightgray',
                    cornerColor: 'green',
                    cornerSize: 6,
                    transparentCorners: false
                });
                this.canvas.add(this.selectedElement);
                break;
            case "triangle":
                // Add a triangle object onto canvas
                this.selectedElement = new fabric.CustomTriangle({
                    width: 100,
                    height: 73,
                    fill: this.globalColor,
                    left: 335,
                    top: 250,
                    stroke: "#000000",
                    strokeWidth: 1,
                    originX: 'center',
                    originY: 'center',
                    borderColor: 'lightgray',
                    cornerColor: 'green',
                    cornerSize: 6,
                    transparentCorners: false
                });
                this.canvas.add(this.selectedElement);
                break;
            case "star":
                // Create the star coordinates
                var points = [{x: 75, y: 0}, {x: 94, y: 52}, {x: 150, y: 52}, {x: 107, y: 84}, {x: 126, y: 135},
                                {x: 75, y: 102}, {x: 24, y: 135}, {x: 43, y: 84}, {x: 0, y: 52}, {x: 56, y: 52}];
                // Add a polygon object  onto canvas
                this.selectedElement = new fabric.CustomPolygon(points, {
                    left: 335,
                    top: 250,
                    fill: this.globalColor,
                    stroke: "#000000",
                    strokeWidth: 1,
                    shadow: null,
                    originX: 'center',
                    originY: 'center',
                    borderColor: 'lightgray',
                    cornerColor: 'green',
                    cornerSize: 6,
                    transparentCorners: false
                });
                this.canvas.add(this.selectedElement);
                break;
            case "callout":
                // create an ellipse object
                var ellipse = new fabric.Ellipse({ rx: 50, ry:35, left: 300, top:225, stroke: "#000000", strokeWidth: 1 });
                // create a triangle object
                var triangle = new fabric.Triangle({width: 50, height: 70, left: 312, top: 322, angle: 233, stroke: "#000000", strokeWidth: 1});
                // create a little ellipse object to hide the ellipse stroke
                var littleEllipse = new fabric.Ellipse({rx: 15, ry:7, left: 339, top: 276, angle: 143});
                // create a group object
                this.selectedElement = new fabric.CustomGroup([ triangle, ellipse, littleEllipse ], {
                    left: 330,
                    top: 260,
                    fill: this.globalColor,
                    originX: 'center',
                    originY: 'center',
                    borderColor: 'lightgray',
                    cornerColor: 'green',
                    cornerSize: 6,
                    transparentCorners: false
                });
                // "add" the group onto canvas
                this.canvas.add(this.selectedElement);
                break;
            case "line":
                // create a line object
                this.selectedElement = new fabric.CustomLine('M 390 247 Q 335 266.5 280 286', {
                    stroke: this.globalStrokeColor,
                    strokeWidth: 3,
                    fill: '',
                    strokeDashArray: [1, 0],
                    heads: 0,
                    isArrow: false,
                    isCurve: false
                });
                this.canvas.add(this.selectedElement);
                this.selectedElement.addHeadsOnCreate();
                break;
            case "arrow":
                // create an arrow object
                this.selectedElement = new fabric.CustomLine('M 390 247 Q 335 266.5 280 286', {
                    stroke: this.globalStrokeColor,
                    strokeWidth: 3,
                    fill: '',
                    strokeDashArray: [1, 0],
                    heads: 1,
                    isArrow: true,
                    isCurve: false
                });
                this.canvas.add(this.selectedElement);
                this.selectedElement.addHeadsOnCreate();
                break;
            default:
        }

        // Set the focus to the new object
        this.canvas.setActiveObject(this.selectedElement);
        var options = {};
        options.target = this.selectedElement;
        this.sendObjectsToServer(options);
    },

    // Add an image object to the canvas
    drawImage: function(data){
        var that = this;
        var path = (data.source_type == 'internet')? data.source_value : data.source_relative
        fabric.CustomImage.fromURL(path, function(oImg){
            that.selectedElement = oImg;
            that.selectedElement.set({
                left: 335,
                top: 250,
                originX: 'center',
                originY: 'center',
                borderColor: 'lightgray',
                cornerColor: 'green',
                cornerSize: 4,
                transparentCorners: false
            });
            if(that.canvas.add(that.selectedElement)){
                that.save();
            }
            if(that.canvas.getWidth() < that.selectedElement.getWidth() || that.canvas.getHeight() < that.selectedElement.getHeight()){
                var ratioCanvas = that.canvas.getHeight() / that.canvas.getWidth();
                var ratioImage = that.selectedElement.getHeight() / that.selectedElement.getWidth();
                var percents = {'width': 10 * that.canvas.getWidth() / 100, 'height': 10 * that.canvas.getHeight() / 100};

                if(ratioCanvas < ratioImage){
                    that.selectedElement.scaleToWidth(that.canvas.getWidth() - percents.width );
                    that.selectedElement.scaleToHeight(that.canvas.getHeight() - percents.height) * that.canvas.getWidth() / (that.selectedElement.getWidth() - percents.height);
                } else {
                    that.selectedElement.scaleToHeight(that.canvas.getHeight() - percents.height);
                    that.selectedElement.scaleToWidth(that.canvas.getWidth() - percents.width) * that.canvas.getHeight() / (that.selectedElement.getHeight() - percents.width);
                }
            }

            // Set the focus to the new object
            that.canvas.setActiveObject(that.selectedElement);
            var options = {};
            options.target = that.selectedElement;
            that.sendObjectsToServer(options);
        });
        this.canvas.renderAll();
    },

    // Change the attributes or properties of an object
    changeAttribute: function(message){
        switch(message.data.method){
            /**
             *  If is a customGroup is different form other objects
             *  because a group is a bunch of objects and not all have the same treatment
             */
            case "customGroup":
                switch(message.data.attr){
                    case "strokeWidth":
                        this.selectedElement.getObjects()[0].strokeWidth = parseInt(message.data.value);
                        this.selectedElement.getObjects()[1].strokeWidth = parseInt(message.data.value);
                        break;
                    case "stroke":
                        this.selectedElement.getObjects()[0].stroke = message.data.value;
                        this.selectedElement.getObjects()[1].stroke = message.data.value;
                        break;
                    case "fill":
                        this.selectedElement.getObjects()[0].fill = message.data.value;
                        this.selectedElement.getObjects()[1].fill = message.data.value;
                        this.selectedElement.getObjects()[2].fill = message.data.value;
                        this.selectedElement.fill = message.data.value;
                        break;
                    case "shadow":
                        if(message.data.value == 0){
                            if(this.selectedElement.getObjects()[0].shadow == null){
                                this.selectedElement.getObjects()[0].setShadow({color: this.globalShadowColor, blur: 10, offsetX: 5, offsetY: 5});
                                this.selectedElement.getObjects()[1].setShadow({color: this.globalShadowColor, blur: 10, offsetX: 5, offsetY: 5});
                            }
                        }else{
                            this.selectedElement.getObjects()[0].setShadow(null);
                            this.selectedElement.getObjects()[1].setShadow(null);
                        }
                        break;
                    case "shadow-color":
                        this.selectedElement.getObjects()[0].setShadow({ color: message.data.value, blur: 10, offsetX: 5, offsetY: 5});
                        this.selectedElement.getObjects()[1].setShadow({color: message.data.value, blur: 10, offsetX: 5, offsetY: 5});
                        break;
                    default:
                }
                break;
            default:
                // The rest of the objects are treated in the same way
                switch(message.data.attr){
                    case "radius":
                        this.selectedElement.rx = parseInt(message.data.value);
                        this.selectedElement.ry = parseInt(message.data.value);
                        break;
                    case "strokeWidth":
                        this.selectedElement.setStrokeWidth(parseInt(message.data.value));
                        break;
                    case "stroke":
                        this.selectedElement.setStroke(message.data.value);
                        break;
                    case "fill":
                        this.selectedElement.setFill(message.data.value);
                        break;
                    case "fontWeight":
                        message.data.value == 'bold' ? this.selectedElement.fontFamily = 'HelveticaNeueETW01-75Bd' : this.selectedElement.fontFamily = 'HelveticaNeueETW01-55Rg';
                        break;
                    case "fontStyle":
                        this.selectedElement.fontStyle = message.data.value;
                        break;
                    case "fontSize":
                        this.selectedElement.setFontSize(message.data.value);
                        this.lastTextSize = message.data.value;
                        break;
                    case "textDecoration":
                        this.selectedElement.textDecoration = message.data.value;
                        break;
                    case "textAlign":
                        this.selectedElement.textAlign = message.data.value;
                        break;
                    case "lineStyle":
                        if(message.data.value == "normal") {
                            this.selectedElement.strokeDashArray = [1, 0];
                        } else if(message.data.value == "dashed") {
                            this.selectedElement.strokeDashArray = [7, 7];
                        } else {
                            this.selectedElement.strokeDashArray = [2, 5];
                        }
                        break;
                    case "curve":
                        this.selectedElement.isCurve = message.data.value;
                        if(message.data.value) {
                            this.selectedElement.point.set({'left': this.selectedElement.path[1][1], 'top': this.selectedElement.path[1][2]});
                            this.selectedElement.point.visible = true;
                        }else{
                            this.selectedElement.path[1][1] = (this.selectedElement.path[0][1] + this.selectedElement.path[1][3])/2;
                            this.selectedElement.path[1][2] = (this.selectedElement.path[0][2] + this.selectedElement.path[1][4])/2;
                            this.selectedElement.pathOffset.x = this.selectedElement.path[1][1];
                            this.selectedElement.pathOffset.y = this.selectedElement.path[1][2];
                            this.selectedElement.left = this.selectedElement.path[1][1];
                            this.selectedElement.top = this.selectedElement.path[1][2];
                            this.selectedElement.point.visible = false;
                        }
                        break;
                    case "type":
                        if(this.selectedElement) {
                            this.selectedElement.setHeads(message.data.value);
                        }
                        break;
                    case "shadow":
                        if(message.data.value == 0) {
                            if(this.selectedElement.shadow == null){
                                this.selectedElement.setShadow({color: this.globalShadowColor, blur: 10, offsetX: 5, offsetY: 5});
                            }
                        } else {
                            this.selectedElement.setShadow(null);
                        }
                        break;
                    case "shadow-color":
                        this.selectedElement.setShadow({color: message.data.value, blur: 10, offsetX: 5, offsetY: 5});
                        break;
                    default:
                }
        }
        this.save();
        this.canvas.renderAll();
    },

    // Change the z-index of an object
    changeZIndex: function(action) {
        switch (action) {
            case "backwards":
                this.selectedElement.sendToBack();
                break;
            case "forwards":
                this.selectedElement.bringToFront();
                break;
        }
        this.save();
    },

    // If state == true no actions can be applied to the objects
    lockCanvas: function(state){
        var that = this;
        this.canvas.getObjects().each(function(item){
            item.lockMovementX = state;
            item.lockMovementY = state;
            item.type == 'helperCircle' || item.type == 'helperTriangle' || item.type == 'customLine' ? item.hasControls = false : item.hasControls = !state;
            if(!that.isEditMode){
                item.selectable = !state;
            }
            if(item.type == "customLine"){
                item.showDots(!state);
            }
        });

        this.isEditMode ? this.currentStep = this.options.totalSteps -1 : this.currentStep = 0;                

        if(this.isEditMode){            
            if($('intro-line') && state){
                $('intro-line').set('contenteditable', true);
            }else if($('intro-line') && !state){
                $('intro-line').set('contenteditable', false);
            }
        }

        this.selectedElement = null;
        this.canvas.selection = !state;
        this.canvas.deactivateAll();
        this.renderStepElements();
    },

    // If this option is selected the objects in this step will be visible in all steps
    restoreStep: function(step){
        this.canvas.getObjects().each(function(el){
            if(el.step == step){
                el.step = -1;
            }
        });
        this.save();
        this.renderStepElements();
    },

    // If this option is selected the objects in this step will be visible in all steps
    // and the elements in the next steps will be moved to the previous step
    deleteStep: function(step){
        this.canvas.getObjects().each(function(el){
            if(el.step == step){
                el.step = -1;
            }
        });
        this.canvas.getObjects().each(function(el){
            if(el.step > step){
                el.step--;
            }
        });
        this.options.totalSteps -= 1;
        this.options.stepText.splice(step, 1);
        this.save();
        this.renderStepElements();
    },

    // Clone an object and set the focus to the new one
    cloneFigure: function(isDefaultPosition){
        var clone = this.selectedElement.type == "customImage" ? fabric.util.object.clone(this.selectedElement) : this.selectedElement.clone();
        if(typeof isDefaultPosition == 'undefined'){
            clone.left+=10;
            clone.top+=10;
        }
        clone.set({
            borderColor: 'lightgray',
            cornerColor: 'green',
            cornerSize: 6,
            transparentCorners: false
        });

        this.canvas.add(clone);

        if(typeof isDefaultPosition == 'undefined') {
            this.selectedElement = clone;
            this.canvas.setActiveObject(clone);
        }else{
            this.selectedElement.bringToFront();
        }
        this.canvas.renderAll();
        this.save();
    },

    // Add a step to options.totalSteps
    manageSteps: function(){
        this.options.totalSteps += 1;
        if(this.options.stepText[this.options.totalSteps-1] == 'Click “Check Your Understanding” to try re-creating the figure.'){
            this.options.stepText[this.options.totalSteps-1] = '';
        }
        this.options.stepText.push('Click “Check Your Understanding” to try re-creating the figure.');
        this.save();
    },

    // Remove an object from the canvas
    removeFigure: function(){
        if(this.selectedElement.type == 'customGroup'){
            this.canvas.remove(this.selectedElement)
        }else{
            this.selectedElement.remove();
        }
        this.selectedElement = null;
        this.sendPostMessages('unselected', {});
        this.save();
        this.canvas.renderAll();
    },

    // Set visibility to the object depending of the current step
    renderStepElements: function(){
        var that = this;
        this.canvas.getObjects().each(function(el){
            if(el.step >= that.currentStep){
                if(el.type != "helperCircle" && el.type != "helperTriangle"){
                    el.visible = false;
                    if(el.type == "customLine"){
                        el.hideHeads();
                    }
                }
            }else{
                if(el.type != "helperCircle" && el.type != "helperTriangle"){
                    el.visible = true;
                    if(el.type == "customLine") {
                        el.showHeadsOnCreate();
                    }
                }
            }
        });
        this.canvas.deactivateAll();
        this.selectedElement = null;
        if($('intro-line')) {
            if(this.currentStep == this.options.totalSteps-1 && !this.options.assessment){
                $('intro-line').set('html', '');
            }else{
                if (isHTML(this.options.stepText[this.currentStep])) {
                    $('intro-line').set('html', this.options.stepText[this.currentStep]);
                } else {
                    $('intro-line').set('html', '<p>'+this.options.stepText[this.currentStep]+'</p>');
                }
            }
        }
        this.canvas.renderAll();

        // source: https://stackoverflow.com/questions/15458876/check-if-a-string-is-html-or-not
        function isHTML (str) {
            var a = document.createElement('div');
            a.innerHTML = str;
            for (var c = a.childNodes, i = c.length; i--; ) {
                if (c[i].nodeType == 1) return true; 
            }
            return false;
        }
    },

    // Enable / Disable Assessment mode
    assessment: function(value){
        this.options.assessment = value;
        this.save();
    },

    // Enable / Disable Zoom mode
    zoom: function(value){
        this.options.zoom = value;
        this.save();
    },

    // Align objects of a group
    alignObjects: function(action){
        var that = this;
        switch (action){
            // Vertical alignment
            case "v-left":
                var pos = 1000000;
                var elWidth = 0;
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    if(pos > el.getLeft()){
                        pos = el.getLeft();
                        elWidth = el.getWidth()/2
                    }
                });
                this.canvas.getActiveGroup().getObjects().each(function(el){
                        el.setLeft(pos - (elWidth - (el.getWidth()/2)));
                });
                this.canvas.renderAll();
                break;
            case "v-center":
                var leftBorder = 1000000;
                var rightBorder = -1000000;
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    if(leftBorder > (el.getLeft() - el.getWidth()/2)){
                        leftBorder = el.getLeft() - el.getWidth()/2;
                    }
                    if(rightBorder < (el.getLeft() + (el.getWidth()/2))){
                        rightBorder = el.getLeft() + (el.getWidth()/2);
                    }
                });
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    el.setLeft((leftBorder + rightBorder)/2);
                });
                this.canvas.renderAll();
                break;
            case "v-right":
                var pos = -1000000;
                var elWidth = 0;
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    if(pos < el.getLeft()){
                        pos = el.getLeft();
                        elWidth = el.getWidth()/2
                    }
                });
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    el.setLeft(pos + (elWidth - (el.getWidth()/2)));
                });
                this.canvas.renderAll();
                break;
            // Horizontal alignment
            case "h-up":
                var pos = 1000000;
                var elHeight = 0;
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    if(pos > el.getTop()){
                        pos = el.getTop();
                        elHeight = el.getHeight()/2
                    }
                });
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    el.setTop(pos - (elHeight - (el.getHeight()/2)));
                });
                this.canvas.renderAll();
                break;
            case "h-center":
                var topBorder = 1000000;
                var bottomBorder = -1000000;
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    if(topBorder > (el.getTop() - el.getHeight()/2)){
                        topBorder = el.getTop() - el.getHeight()/2;
                    }
                    if(bottomBorder < (el.getTop() + (el.getHeight()/2))){
                        bottomBorder = el.getTop() + (el.getHeight()/2);
                    }
                });
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    el.setTop((topBorder + bottomBorder)/2);
                });
                this.canvas.renderAll();
                break;
            case "h-down":
                var pos = -1000000;
                var elHeight = 0;
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    if(pos < el.getTop()){
                        pos = el.getTop();
                        elHeight = el.getHeight()/2
                    }
                });
                this.canvas.getActiveGroup().getObjects().each(function(el){
                    el.setTop(pos + (elHeight - (el.getHeight()/2)));
                });
                this.canvas.renderAll();
                break;
        }
    },

    initKeyboard: function() {
        var that = this;
        document.onkeydown = function(event) {
            var key = window.event ? window.event.keyCode : event.keyCode;
            switch(key) {
                //backspace and delete
                case 8: case 46:
                    if(event.target.id != 'intro-line'){
                        event.preventDefault();
                        if(that.selectedElement != null){
                            if(that.selectedElement.lockMovementX){
                                if(that.currentStep != that.options.totalSteps -1){
                                    that.selectedElement.setStep(that.currentStep);that.save();
                                    that.renderStepElements();
                                }
                            }else{
                                that.removeFigure();
                            }
                        }
                    }
                    break;
                // option or alt
                case 18:
                    event.preventDefault();
                    that.isOptionPressed = true;
                    break;
                // arrows key
                case 37:
                    if(event.target.id != 'intro-line'){
                        event.preventDefault();
                        if(that.selectedElement != null){
                            if(!that.selectedElement.lockMovementX){
                                that.selectedElement.setLeft(that.selectedElement.getLeft()-1);
                                if(that.selectedElement.type == 'customLine'){
                                    moveLine();
                                }
                            }
                        }
                    }
                    break;
                case 38:
                    if(event.target.id != 'intro-line'){
                        event.preventDefault();
                        if(that.selectedElement != null){
                            if(!that.selectedElement.lockMovementX){
                                that.selectedElement.setTop(that.selectedElement.getTop()-1);
                                if(that.selectedElement.type == 'customLine'){
                                    moveLine();
                                }
                            }
                        }
                    }
                    break;
                case 39:
                    if(event.target.id != 'intro-line'){
                        event.preventDefault();
                        if(that.selectedElement != null){
                            if(!that.selectedElement.lockMovementX){
                                that.selectedElement.setLeft(that.selectedElement.getLeft()+1);
                                if(that.selectedElement.type == 'customLine'){
                                    moveLine();
                                }
                            }
                        }
                    }
                    break;
                case 40:
                    if(event.target.id != 'intro-line'){
                        event.preventDefault();
                        if(that.selectedElement != null){
                            if(!that.selectedElement.lockMovementX){
                                that.selectedElement.setTop(that.selectedElement.getTop()+1);
                                if(that.selectedElement.type == 'customLine'){
                                    moveLine();
                                }
                            }
                        }
                    }
                    break;
            }
            function  moveLine(){
                var p = that.selectedElement;
                var oldCenterX = p.path[1][1];
                var oldCenterY = p.path[1][2];

                var deltaX = p.left - oldCenterX;
                var deltaY = p.top - oldCenterY;

                p.circle1.set({'left': p.path[0][1] + deltaX, 'top': p.path[0][2] + deltaY}).setCoords();
                p.circle2.set({'left': p.path[1][3] + deltaX, 'top': p.path[1][4] + deltaY}).setCoords();
                p.arrow1.set({'left': p.path[0][1] + deltaX, 'top': p.path[0][2] + deltaY}).setCoords();
                p.arrow2.set({'left': p.path[1][3] + deltaX, 'top': p.path[1][4] + deltaY}).setCoords();
                p.point.set({'left': p.path[1][1], 'top': p.path[1][2]}).setCoords();

                p.path[0][1] = p.path[0][1] + deltaX;
                p.path[0][2] = p.path[0][2] + deltaY;
                p.path[1][1] = p.left;
                p.path[1][2] = p.top;
                p.path[1][3] = p.path[1][3] + deltaX;
                p.path[1][4] = p.path[1][4] + deltaY;

                p.pathOffset.x = p.path[1][1];
                p.pathOffset.y = p.path[1][2];
            }

            that.save();
            that.canvas.renderAll();
        };

        // for option or alt release key, this way clone on drag is not available
        document.onkeyup = function(event) {
            var key = window.event ? window.event.keyCode : event.keyCode;
            switch(key) {
                // option or alt
                case 18:
                    event.preventDefault();
                    that.isOptionPressed = false;
                    break;
            }
        };
    },

    // Reset the whole widget
    reset: function() {
        window.location.reload();
    },
    // Go to the next step
    nextStep: function() {
        this.currentStep++;
        this.renderStepElements();
    },
    // Previous step
    previousStep: function() {
        this.currentStep--;
        this.renderStepElements();
    },
    createAssessableText: function () {
        var widgetContent = $$(".MetrodigiWidget")[0];
        var hiddenLabel = new Element("div.accessibility-intructions.invisible");
        hiddenLabel.inject(widgetContent,'top');
    },
    setAssessableText: function (text) {
        if (!this.isEditMode) {
            var hiddenLabel = $$(".accessibility-intructions")[0];
            hiddenLabel.set('text', text);
            //hiddenLabel.set('tabindex', 0);
        }
    },
    setFocusInit: function () {
        if($$("#intro-line")[0]){
            $$("#intro-line")[0].focus();
        }else{
            if($$(".accessibility-intructions")[0]){
               $$(".accessibility-intructions")[0].focus();
            }
        }
    }
});
