Collage = new Class({
    Implements: [Options, Events],

    // Set initial options here
    options: {},
		lastActive:null,
    // initialize - widget initialization
    initialize: function(options) {        
    	this.setOptions(options);
        this.overlay = $$('.overlay')[0];
        this.collage = $$('.collage')[0];
        this.images = this.collage.children;
        this.transitioning = false;

        $$('.collage-image').addEvent('click', this.showOverlay.bind(this));
        $$('.collage-image').addEvent('keypress', this.showOverlayKeyPress.bind(this));
        this.overlay.addEvent('click', this.hideOverlay.bind(this));
        this.overlay.addEvent('keypress', this.hideOverlayKeyPress.bind(this));
        $$('.Collage .widget-header').addEvent('click', this.hideOverlay.bind(this));
        
        Array.each(this.images, function(e, i) {
            var pos = (i === 0) ? 'first' : (i === 1) ? 'second' : (i === 2) ? 'third' : (+i + 1) + 'th';
            $$(e)[0].getElement('img').setProperty("tabindex", 0);
            $$(e)[0].getElement('img').setProperty("alt", $$(e)[0].getElement('p').get('html').replace(/(<([^>]+)>)/ig,""));
            $$(e)[0].getElement('i').setProperty("tabindex", 0);
            $$(e)[0].getElement('i').setProperty("aria-label", 'explore ' + pos + ' image');
            $$(e)[0].getElement('i').setProperty("aria-hidden", 'true');
        });
        
        this.overlay.set("tabindex",0);
        

    },
    addTransitionState: function() {
        this.transitioning = true;
    },
    removeTransitionState: function() {
        this.transitioning = false;
    },
    showOverlay: function(e) {
        var el = e.target.hasClass('collage-image') ? e.target : e.target.getParent('.collage-image');
				this.lastActive = e.target;
        this.overlay.set('html', '').set('data-image', Math.abs(el.get("class").replace(/collage\-image/g, "")));
        
        var p_wrapper = new Element('div.p-wrapper').inject(this.overlay);
        var img_wrapper = new Element('div.img-wrapper').setStyles({
            left: el.getStyle('left'),
            top: el.getStyle('top')
        }).inject(this.overlay);

        var img = new Element('img', { 
            'tabindex': 0,
            src: el.getElement('img').get('src'),
            alt: el.getElement('img').get('alt') 
        }).inject(img_wrapper);
        var img_x = new Element('button.close', { 
            html: 'X',
            'aria-label': 'Close'
        }).inject(img_wrapper);        
        
        new Element('p', {
            html: el.getElement('p').get('html'),
            'aria-label': el.getElement('p').get('html'),
            'tabindex': 0
        }).inject(p_wrapper);

        this.overlay.show();
        this.addTransitionState();

        setTimeout(function() { this.overlay.addClass('active'); p_wrapper.getElement('p').focus(); }.bind(this), 100);
        setTimeout(function() { this.removeTransitionState(); }.bind(this), 1000);
    },
    showOverlayKeyPress:function(e,i){
    	
	    if(e.key=="enter" || e.key=="space")
	    	e.target.click();
    },
    hideOverlay: function() {
        if (this.transitioning) return;

        this.overlay.removeClass('active');
        this.addTransitionState();

        setTimeout(function() {
            this.removeTransitionState();
            this.overlay.hide();
            this.lastActive.focus();
        }.bind(this), 1000);
    },
    hideOverlayKeyPress:function(e){
    		if(e.key=="enter" || e.key=="space"){
	    		e.target.click();
    		}
    },
    // render - updates the widget display
    render: function() {
        for (var i = 0; i < this.images.length; i++) {
            this.images[i].setStyles({
                left: ( (i + 1) % 3 * 33) % 100 + '%',
                top: (Math.round( i / 3 ) * 30) + '%'
            });
        };
    }
});