/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
 */
var conceptMap = function (el, datasource, theme, svgheight) {

    window.addEvent("mousemove", function () {
        document.getElement("body").addClass("remove-outline");
    })
        .addEvent("keyup", function (e) {
            if (e.key == "tab") {
                document.getElement("body").removeClass("remove-outline");
            }
        });

    navigator.browserInfo = (function () {
        var N = navigator.appName, ua = navigator.userAgent, tem;
        var M = ua.match(/(opera|chrome|safari|firefox|msie)\/?\s*(\.?\d+(\.\d+)*)/i);
        if (M && (tem = ua.match(/version\/([\.\d]+)/i)) != null) M[2] = tem[1];
        M = M ? [M[1], M[2]] : [N, navigator.appVersion, '-?'];
        return M;
    })();

    var margin = {top: 20, right: 20, bottom: 20, left: 20},
        width = 735 - margin.right - margin.left,
        height = svgheight - margin.top - margin.bottom,
        aspect = width / height,
        duration = 1000,
        markerRadius = 3,
        markerRadiusActive = 10,
        markerRadiusRoot = 3,
        closeNodeColor = "#fff",
        themeColor = "#EE0025",
        linkColor = "#888888",
        defaultOffsetx = 10,
        defaultOffsety = -5,
        defaultTextWidth = 200,
        defaultTextHeight = 40,
        data = datasource,
        plusSign = "m6.101,0.865l0,-1.756c0,-0.236 -0.088,-0.44 -0.263,-0.616c-0.172,-0.173 -0.379,-0.259 -0.616,-0.259l-3.506,0l0,-3.504c0,-0.239 -0.086,-0.445 -0.259,-0.617c-0.174,-0.174 -0.378,-0.261 -0.616,-0.261l-1.755,0c-0.237,0 -0.442,0.087 -0.616,0.261c-0.173,0.172 -0.259,0.378 -0.259,0.617l0,3.505l-3.505,0c-0.24,0 -0.445,0.086 -0.617,0.259c-0.175,0.175 -0.261,0.379 -0.261,0.616l0,1.756c0,0.236 0.086,0.441 0.261,0.616c0.172,0.172 0.377,0.258 0.617,0.258l3.505,0l0,3.506c0,0.239 0.086,0.444 0.259,0.616c0.174,0.175 0.378,0.263 0.616,0.263l1.755,0c0.237,0 0.442,-0.088 0.616,-0.263c0.173,-0.172 0.259,-0.377 0.259,-0.616l0,-3.506l3.506,0c0.237,0 0.444,-0.086 0.616,-0.258c0.175,-0.176 0.263,-0.38 0.263,-0.617z",
        minusSign = "m6.078,0.845l0,-1.741c0,-0.234 -0.087,-0.438 -0.26,-0.611c-0.171,-0.172 -0.375,-0.257 -0.611,-0.257l-10.434,0c-0.237,0 -0.441,0.085 -0.612,0.257c-0.173,0.174 -0.258,0.377 -0.258,0.611l0,1.741c0,0.234 0.085,0.438 0.258,0.611c0.171,0.171 0.375,0.256 0.612,0.256l10.434,0c0.235,0 0.44,-0.085 0.611,-0.256c0.173,-0.173 0.26,-0.376 0.26,-0.611z",
        buttonOuter = "m35.31928,10.13713c0,0.941 -0.77,1.71101 -1.711,1.71101l-67.334,0c-0.941,0 -1.711,-0.77001 -1.711,-1.71101l0,-20.166c0,-0.941 0.77,-1.711 1.711,-1.711l67.333,0c0.94099,0 1.711,0.77 1.711,1.711l0,20.166l0.001,0z",
        i = 0,
        buttonInnerPath = "m-33.72572,11.27814c-0.629,0 -1.141,-0.512 -1.141,-1.14101l0,-20.166c0,-0.629 0.512,-1.141 1.141,-1.141l67.333,0c0.629,0 1.141,0.512 1.141,1.141l0,20.167c0,0.629 -0.512,1.141 -1.141,1.141l-67.333,0l0,-0.001z",
        iconColor = "#A7A9AC",
        root = {};

    var tree = d3.layout.tree()
        .size([height, width]);

    if (navigator.browserInfo[0] == "MSIE") {
        viewbox = '';
    }
    else {
        viewbox = '0 0 ' + width + ' ' + height;
    }

    var svg = d3.select(el).append("svg")
        .attr("width", width)
        .attr("height", height)
        .attr("viewBox", viewbox)
        // set background for development
        // .style("background-color","lightgreen")
        .attr("preserveAspectRatio", "xMidYMid")
        .append("g")
        .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

    d3.select(el).append("div")
        .attr("id", "textContainer")
        // .attr("role", "list")
        .style("position", "fixed");
    d3.select(el).style("position", "relative");

    var gradient = svg.append("svg:defs")
        .append("svg:linearGradient")
        .attr("id", "buttontextgradient")
        .attr("x1", "100%")
        .attr("x2", "100%")
        .attr("y1", "0%")
        .attr("y2", "100%")
        .attr("spreadMethod", "pad");

    gradient.append("svg:stop")
        .attr("offset", "0%")
        .attr("stop-color", "#FBFBFB")
        .attr("stop-opacity", 1);

    gradient.append("svg:stop")
        .attr("offset", "100%")
        .attr("stop-color", "#F1F1F1")
        .attr("stop-opacity", 1);

    var resize = function () {

        var targetWidth = parseInt($('container').getComputedStyle('width'));
        if (isNaN(targetWidth)) {
            targetWidth = 700;
        }
        d3.select('svg').attr("width", targetWidth);
        d3.select('svg').attr("height", targetWidth / aspect);
        document.getElementById('textContainer').style.webkitTransform = "scale(" + targetWidth / width + "," + targetWidth / width + ")";
    };

    window.addEventListener("resize", resize);
    root = data;
    root.x0 = root.coord.x;
    root.y0 = root.coord.y;

    function collapse(d) {
        if (d.children) {
            d._children = d.children;
            d._children.forEach(collapse);
            d.children = null;
        }
    }

//   do not collapse for development
    // root.children.forEach(collapse);
    // collapse(root);

    window.tree_is_updated = false;

    update(root);

    elementTree(root);
    $$('[data-type="node"]').forEach(function (el) {
        if (+el.get('data-parentid') > 0) {
            $('element-tree-node' + el.get('data-parentid')).grab(el, 'top');
        }
        else {
            // console.log('ROOT');
        }
    });
    $$('ul.tree').forEach(function (ul) {
        var parent_li = $$('[data-type="node"][data-id="node' + ul.get('data-nodeid') + '"]')[0];
        parent_li.grab(ul);
        ul.getChildren().setStyles({
            'margin-top': '-' + parent_li.getStyle('top'),
            'margin-left': '-' + parent_li.getStyle('left')
        });
    });
    $$('[data-type="connection"]').forEach(function (el) {
        var parent_li = $('element-tree-node' + el.get('data-nodeid'));
        if (!parent_li) {
            $$('[data-type="node"][data-id="node' + el.get('data-nodeid') + '"]').grab(
                new Element('ul.tree', {
                    id: 'element-tree-node' + el.get('data-nodeid'),
                    'data-nodeid': el.get('data-nodeid')
                })
            );
            parent_li = $('element-tree-node' + el.get('data-nodeid'));
        }
        parent_li.grab(el);
        el.setStyles({
            'margin-top': '-' + parent_li.getParent().getStyle('top'),
            'margin-left': '-' + parent_li.getParent().getStyle('left')
        });
    });
    window.click_root = function (e) {
        click(root);
        document.getElementById('buttonStart').blur();
    }
    $$('div[data-type="node"][data-parentid="0"]').grab(new Element('button#buttonStart.start', {
        html: 'Start',
        tabindex: 0,
        events: {
            click: window.click_root
        }
    }));
    window.tree_is_updated = true;

    click(root);

    function elementTree(d) {
        // console.log('d', d.id);
        var list = null;
        if (d.children) {
            // console.log('children', d.children);
            list = new Element('ul.tree', {
                id: 'element-tree-node' + d.id
            });
            d.list = list;
            d.children.forEach(elementTree);
        }
        if (list) {
            list.set('data-nodeid', d.id);
            if (d.parent && d.parent.list) {
                d.parent.list.appendChild(list);
            }
            else {
                // console.log(d.id, 'root');
                document.getElementById("textContainer").appendChild(list);
            }
        }
    }

    function click(d) {

        if (d.parent) {
            if (d.children) {
                d._children = d.children;
                d.children = null;
            } else {
                d.children = d._children;
                d._children = null;
            }
        } else {
            if (d.children) {
                //COMMENT THESE THREE LINES TO TAKE SCREENSHOT AND SET ALL "duration" VARS TO 0
                d.children.forEach(collapse);
                collapse(d);
                d.children = null;
            } else {
                d.children = d._children;
                d._children = null;
            }
        }
        update(d);
    }

    window.global_click = click;

    function update(source) {

        var nodes = tree.nodes(root).reverse(),
            links = tree.links(nodes);

        var node = svg.selectAll("g.node")
            .data(nodes, function (d) {
                return d.id || (d.id = ++i);
            });

        var nodeEnter = node.enter().append("g")
            .attr("class", function (d) {
                window.global_svg_object = d;
                var classname = "";
                if (d.nodeclass) {
                    classname = "node depth" + d.depth + " nid" + d.id + " " + d.nodeclass;
                } else {
                    classname = "node depth" + d.depth + " nid" + d.id;
                }
                if (d.connector) {
                    // console.log('D.CONNECTOR', d);
                    classname = "connector " + classname;
                }
                return classname;
            })
            .attr("transform", function (d) {
                return "translate(" + d.coord.y + "," + d.coord.x + ")";
            })
            .on("click", click);

        // if (!$$(".connection").length) {
        svg.selectAll(".connector")
            .append("g")
            .attr('class', 'connection');
        // }

        svg.selectAll('.connector')
            .attr("data-connection-x", function (d) {
                if (d.connector && d.connector.x) {
                    return d.connector.x;
                } else {
                    return defaultOffsetx;
                }
            })
            .attr("data-connection-y", function (d) {
                if (d.connector && d.connector.y) {
                    return d.connector.y;
                } else {
                    return defaultOffsety;
                }
            })
            .attr("data-connection-width", function (d) {
                if (d.connector.dim && d.connector.dim.width) {
                    return d.connector.dim.width;
                } else {
                    return defaultTextWidth;
                }
            })
            .attr("data-connection-height", function (d) {
                if (d.connector.dim && d.connector.dim.height) {
                    return d.connector.dim.height;
                } else {
                    return defaultTextHeight;
                }
            })
            .attr('data-connection-class', function (d) {
                return d.connector.class;
            })
            .attr('data-connection-text', function (d) {
                return d.connector.description;
            });

        nodeEnter.selectAll('.connection')
            .append("path")
            .attr("d", function (d) {
                if (d.connector.path1) {
                    return d.connector.path1;
                }
            })
            .style("stroke-dasharray", ("3,3"))
            .attr("fill", "none")
            .attr("stroke", "black");

        nodeEnter.selectAll('.connection')
            .append("path")
            .attr("d", function (d) {
                if (d.connector.path2) {
                    return d.connector.path2;
                }

            })
            .style("stroke-dasharray", ("3,3"))
            .attr("stroke", "black");


        nodeEnter.append("circle")
            .attr("r", markerRadius)
            .attr("stroke-width", 0)
            .style("fill", iconColor);


        //   the pointer
        nodeEnter.append('path')
            .attr("fill", iconColor)
            .attr("d", function (d) {
                if (d.parent) {
                    return plusSign;
                }
            })
            .attr("class", function (d) {
                if (!d._children && !d.children) {
                    return "terminal";
                } else {
                    return "pointer";
                }
            });

        nodeEnter.select("path.terminal")
            .remove();

        if ($$(".outerbutton").length == 0) {
            svg.selectAll(".depth0")
                .append("path")
                .attr("fill", "#C0C0C0")
                .attr("d", function (d) {
                    return buttonOuter;
                })
                .attr("class", "outerbutton")
                .style("display", "none");

            svg.selectAll(".depth0")
                .append("path")
                .attr("d", function (d) {
                    return buttonInnerPath;
                })
                .attr("fill", "url(#buttontextgradient)")
                .attr("class", "innerbutton")
                .style("display", "none");

            svg.selectAll(".depth0")
                .append("text")
                .style("cursor", "pointer")
                .attr("class", "buttontext")
                .attr("dx", -17)
                .attr("dy", 4)
                .style("font-weight", "bold")
                .style("display", "none")
                .text("Start");
        }

        // inject data into node for text elements
        nodeEnter
            .attr("data-parentid", function (d) {
                return d.parent ? d.parent.id : 0;
            })
            .attr("data-coord-x", function (d) {
                return d.coord.x;
            })
            .attr("data-coord-y", function (d) {
                return d.coord.y;
            })
            .attr("data-text-x", function (d) {
                if (d.coord && d.coord.x) {
                    return (d.coord.x + d.offset.y + margin.top) + "px";
                } else {
                    return defaultOffsetx + "px";
                }
            })
            .attr("data-text-y", function (d) {
                if (d.coord && d.coord.y) {
                    return (d.coord.y + d.offset.x + margin.left) + "px";
                } else {
                    return defaultOffsety + "px";
                }
            })
            .attr("data-text-width", function (d) {
                if (d.dim && d.dim.w) {
                    return d.dim.w + "px";
                } else {
                    return defaultTextWidth + "px";
                }
            })
            .attr("data-text-height", function (d) {
                if (d.dim && d.dim.h) {
                    return d.dim.h + "px";
                } else {
                    return defaultTextHeight + "px";
                }
            })
            .attr("data-definition", function (d) {
                if (d.definition) {
                    return d.definition.definition;
                }
            })
            .attr("data-class", function (d) {
                if (d.class) {
                    return d.class;
                }
            })
            .attr("data-nodeid", function (d) {
                return d.id;
            })
            .attr("data-connector", function (d) {
                return d.connector ? d.id : -1;
            })
            .attr("data-text-title", function (d) {
                return d.title;
            });

        // Transition nodes to their new position.
        var nodeUpdate = node.transition()
            .duration(duration)
            .attr("transform", function (d) {
                return "translate(" + d.coord.y + "," + d.coord.x + ")";
            })


        nodeUpdate.select("circle")
            .attr("r", function (d) {
                if (!d._children && !d.children) {
                    return markerRadius;
                } else if (!d.parent) {
                    return markerRadiusRoot;

                } else {
                    return markerRadiusActive;
                }
            });

        nodeUpdate.select("path.pointer")
            .attr("d", function (d) {
                var markerSize;
                if (!d.parent) {
                    var markerSize = markerRadiusRoot - 5;
                } else {
                    var markerSize = markerRadiusActive - 4;
                }
                if (!d._children) {

                    return minusSign;
                } else {

                    return plusSign;
                }
            })
            .style("stroke-width", 0)
            .style("fill", "white");

        nodeUpdate.selectAll(function () {
            return this.getElementsByTagName("foreignObject");
        })
            .style("color", '#000000');

        nodeUpdate.selectAll("text.buttontext")
            .attr("dx", function (d) {
                if (d._children) {
                    return -17;
                } else {
                    return -18;
                }
            })
            .text(function (d) {
                if (d._children) {
                    if ($$('button.start').length > 0) {
                        $$('button.start')[0].set('html', 'Start');
                    }
                    return "Start"
                } else {
                    if ($$('button.start').length > 0) {
                        $$('button.start')[0].set('html', 'Reset');
                    }
                    return "Reset"
                }
            })

        // Transition exiting nodes to the parent's new position.
        // var nodeExit = node.exit().transition()
        //     // .duration(duration)
        //     .attr("transform", function(d) { return "translate(" + d.coord.y + "," + d.coord.x + ")"; })
        //     .remove();

        var nodeExit = node.exit().remove();

        nodeExit.select("circle")
            .attr("r", markerRadius);

        nodeExit.selectAll(function () {
            return this.getElementsByTagName("foreignObject");
        })
            .style("color", '#ffffff');

        // create text overlays
        var overlayText = function (el) {
            // console.log(el.get('data-nodeid'), el.getParent());
            var textbox = $$('[data-type="node"][data-id="node' + el.get('data-nodeid') + '"]')[0];

            if (!textbox) {
                var _tag = el.getAttribute("data-parentid") == 0 ? 'div' : 'li';
                var textbox = new Element(_tag, {
                    html: el.getAttribute("data-text-title"),
                    class: el.getAttribute("data-class"),
                    'data-type': 'node',
                    'data-parentid': el.getAttribute("data-parentid"),
                    styles: {
                        "position": "absolute",
                        "height": el.getAttribute("data-text-height"),
                        "width": el.getAttribute("data-text-width"),
                        "top": el.getAttribute("data-text-x"),
                        "left": el.getAttribute("data-text-y")
                    }
                });
            }
            textbox.removeClass('hide-node');
            if (el.getAttribute("data-definition")) {
                textbox.addClass("definition");
                textbox.setAttribute("data-definition", el.getAttribute("data-definition"));
            }
            if (navigator.browserInfo[0] == "Chrome") {
                textbox.setStyle("font-size", "12px");
            }
            else if (navigator.browserInfo[0] == "Safari") {
                textbox.setStyle("font-size", "11px");
            }
            textbox.setAttribute("data-id", "node" + el.getAttribute("data-nodeid"));
            if (!window.tree_is_updated) {
                document.getElementById("textContainer").appendChild(textbox);
            }

        };
        // document.getElementById("textContainer").innerHTML = "";
        $$('[data-type="node"], [data-type="connection"]').addClass('hide-node');

        $$("svg g.node").forEach(overlayText);
        $$('h2').addClass("themeColor");

        // add an icon to notes with a definition

        if (!window.initialized_flag) {


            d3.select("#textContainer").selectAll(".definition p, .definition h2")
                .append("span")
                .style("color", themeColor)
                .attr("class", "offscreen")
                .html("no one single perspective is used to explain all human behavior and processes.")

            d3.select("#textContainer").selectAll(".definition p, .definition h2")
                .append("span")
                .style("display", "inline-block")
                .style("padding-left", "3px")
                .style("font-family", "'hssCustom', sans-serif")
                .style("background-color", "white")
                .attr("aria-label", "more info")
                .attr("role", "button")
                .attr("class", "themeColor")
                .html(" &#xe608;");

            window.initialized_flag = true;
        }


        var defs = $$('.definition');

        defs.forEach(function (el, i) {
            var popup = $$('div.popdef[data-id="' + el.getAttribute("data-id") + '"]')[0];
            if (!popup) {
                var popup = new Element('div', {
                    id: el.getAttribute("data-id"),
                    class: "popdef",
                    html: el.getAttribute("data-definition"),
                    styles: {
                        position: "absolute",
                        "z-index": "0",
                        width: "150px",
                        padding: "5px",
                        "background-color": "white",
                        visibility: "hidden"
                    }
                });
                var arrow = new Element("div", {
                    class: "arrow"
                })
                popup.appendChild(arrow);
            }
            if (!window.tree_is_updated) {
                document.getElementById("textContainer").appendChild(popup);
            }

            if (el.getElement('h2')){

                el.getElement('h2').addEvent('mouseover', function (e) {
                    e = e || window.event;
                    var target = e.target || e.which;
                    if (target.getAttribute('data-type') != 'node') {
                        target = target.closest('[data-type="node"]');
                    }
                    if (el.hasClass('hide-node') || target.getAttribute('data-id') != el.getAttribute('data-id')) {
                        return false;
                    }
                    var scaleFactor = parseInt($('container').getDimensions().width) / width;
                    var popupy = (window.getHeight() - e.page.y < 150) ? (((e.page.y - document.querySelector("#" + el.getAttribute("data-id")).clientHeight) - 30) / scaleFactor) + "px" : ((e.page.y + 10 * 0) / scaleFactor) + "px";
                    var popupx = (e.page.x < 85) ? (20 / scaleFactor) + "px" : ((e.page.x - 85) / scaleFactor) + "px";
                    if (el.getElement("h2 .themeColor") != null) {
                        popupx = el.getElement("h2 .themeColor").getPosition().x + 17 + 15 * scaleFactor;
                    }
                    var popdevclass = (e.page.y > 150) ? "top" : "bottom";
                    document.querySelector("#" + el.getAttribute("data-id"))
                        .setStyle("z-index", "1000")
                        .setStyle("visibility", "visible")
                        .setStyle("top", popupy)
                        .setStyle("left", popupx)
                        .addClass(popdevclass);
                    e.stop();
                    e.stopPropagation();
                    return false;
                });
                el.getElement('h2').addEvent('mouseout', function (e) {
                    document.querySelector("#" + el.getAttribute("data-id"))
                        .setStyle("z-index", "0")
                        .setStyle("visibility", "hidden");
                    e.stopPropagation;
                });


            }




        });


        // make popups work on click for touch devices
        defs.onclick = function () {
            this.onmouseover.call(this);
            d3.event.stopPropagation;
        }
        $$(".popdef").addEvent('click', function () {
            el.setStyle("visibility", "hidden");
            d3.event.stopPropagation;
        })

        var conns = $$('.connector');

        conns.forEach(function (el, i) {
            if (el.getAttribute("data-connection-text")) {
                var connectorText = $$('[data-type="connection"][data-nodeid="' + el.get('data-nodeid') + '"]')[0];
                if (!connectorText) {
                    connectorText = new Element('li', {
                        class: "connection",
                        html: el.getAttribute("data-connection-text"),
                        'data-type': 'connection',
                        'data-nodeid': el.get('data-nodeid'),
                        'data-parentid': el.get('data-parentid'),
                        'data-connector': el.get('data-connector'),
                        styles: {
                            position: "absolute",
                            width: el.getAttribute("data-connection-width") + "px",
                            height: el.getAttribute("data-connection-height") + "px",
                            top: (parseInt(el.getAttribute("data-coord-x")) + parseInt(el.getAttribute("data-connection-y"))) + margin.top + "px",
                            left: (parseInt(el.getAttribute("data-coord-y")) + parseInt(el.getAttribute("data-connection-x"))) + margin.left + "px",
                            padding: "5px",
                            "background-color": "white"
                        }
                    });
                }
                connectorText.removeClass('hide-node');
                if (el.getAttribute("data-connection-class")) {
                    connectorText.addClass(el.getAttribute("data-connection-class"));
                }
                if (navigator.browserInfo[0] == "Chrome") {
                    connectorText.setStyle("font-size", "12px");
                }
                else if (navigator.browserInfo[0] == "Safari") {
                    connectorText.setStyle("font-size", "11px");
                }
                if (!window.tree_is_updated) {
                    document.getElementById("textContainer").appendChild(connectorText);
                }
            }
        });

        nodeEnter.selectAll("g").forEach(function (el, i) {
            var textNode = document.querySelector("[data-id=node" + el.parentNode.getAttribute("data-nodeid") + "]");
            textNode.style.opacity = 0;
            textNode.tween('opacity', 1);

            //SET LIKE THIS LINE TO TAKE SCREENSHOT
//          textNode.style.opacity = 1;
//          //textNode.tween('opacity',1);

        })

        // Update the links… bind the data to the path
        var link = svg.selectAll("path.link")
            .data(links, function (d) {
                return d.target.id;
            });

        // Enter any new links at the parent's previous position.
        link.enter().insert("path", "g")
            .attr("class", "link")
            .attr("d", function (d) {
                var p = 'M' + source.y0 + ',' + source.x0 + 'L' + source.y0 + ',' + source.x0;
                return p;
            })
            .style("stroke", linkColor)
            .style("stroke-width", 2)
            .style("fill", "none");

        // Transition links to their new position.

        link.transition()
            .duration(duration)
            .attr("d", function (d) {
                var joints = '';
                var path;
                if (d.target.joint) {
                    d.target.joint.forEach(function (e) {
                        joints = joints + 'L' + e.y + ',' + e.x;
                    });
                    path = 'M' + d.source.y0 + ',' + d.source.x0 + joints + 'L' + d.target.coord.y + ',' + d.target.coord.x;
                } else {
                    path = 'M' + d.source.y0 + ',' + d.source.x0 + 'L' + d.target.coord.y + ',' + d.target.coord.x;
                }
                return path;
            });

        // Transition exiting nodes to the parent's new position.
        link.exit().transition()
            .duration(duration)
            .attr("d", function (d) {
                var p = 'M' + source.y0 + ',' + source.x0 + 'L' + source.y0 + ',' + source.x0;
                return p;
            })
            .remove();

        // Stash the old positions for transition.
        nodes.forEach(function (d) {
            d.x0 = d.coord.x;
            d.y0 = d.coord.y;
        });


    }  // close update()

    //resize();


} // close conceptMap()


// keyboard navigation
window.kbd_cm_focus_element = null;
$$('body').addEvent('keydown', function (e) {
    // console.log('KEY', e.code);
    var key_captured = false;
    var shift = e.event.shiftKey;
    if (e.which == 13 || e.code == 13 || e.which == 39 || e.code == 39) {  // ENTER || RIGHT
        if (kbd_cm_focus_element) {
            global_click(kbd_cm_focus_element);
        }
        else {
            global_click(global_svg_object);
            kbd_cm_focus_element = global_svg_object;
        }

        if (kbd_cm_focus_element.children) {
            kbd_cm_focus_element = global_svg_object;
        }
        key_captured = true;
    }
    else if (e.which == 37 || e.code == 37) {  // LEFT
        if (kbd_cm_focus_element && kbd_cm_focus_element.parent) {
            kbd_cm_focus_element = kbd_cm_focus_element.parent;
        }
        else if (kbd_cm_focus_element && !kbd_cm_focus_element.parent) {
            global_click(kbd_cm_focus_element);

            if (kbd_cm_focus_element.children) {
                kbd_cm_focus_element = global_svg_object;
            }
        }
        key_captured = true;
    }
    else if (e.which == 38 || e.code == 38 || ( (e.which == 9 || e.code == 9) && shift )) {   // shift-TAB || UP
        var current_id = kbd_cm_focus_element.id;
        var siblings = kbd_cm_focus_element.parent.children;
        var target_sibling = null;
        for (var i = 0; i < siblings.length; i++) {
            if (siblings[i].id == current_id) {
                target_sibling = siblings[i - 1];
                if (!target_sibling) {
                    target_sibling = siblings[siblings.length - 1];
                }
                break;
            }
        }
        ;
        kbd_cm_focus_element = target_sibling;
        key_captured = true;
    }
    else if (e.which == 9 || e.code == 9 || e.which == 40 || e.code == 40) {   // TAB || DOWN
        var current_id = kbd_cm_focus_element.id;
        var siblings = kbd_cm_focus_element.parent.children;
        var target_sibling = null;
        for (var i = 0; i < siblings.length; i++) {
            if (siblings[i].id == current_id) {
                target_sibling = siblings[i + 1];
                if (!target_sibling) {
                    target_sibling = siblings[0];
                }
                break;
            }
        }
        ;
        kbd_cm_focus_element = target_sibling;
        key_captured = true;
    }

    $$('[data-focus]').removeProperty('data-focus');
    if (kbd_cm_focus_element) {
        $$('g[data-nodeid="' + kbd_cm_focus_element.id + '"]').set('data-focus', 1);
    }

    if (key_captured) {
        return false;
    }
});

Element.implement({
    closest: function (selector) {
        var matches = $$(selector);
        var cur = this;
        while (cur && !matches.contains(cur)) {
            cur = cur.getParent();
        }
        return cur;
    }
});