ElectionMap = new Class({
    Implements: [Options, Events],
    options: {
        years: [],
        colors: ['#42A46A', '#8A78AC', '#C28D51', '#CD8680', '#61B1ED'],
        color_neutral: '#D9CFB5',
        adjustments: {}
    },
    data: {
        candidates: [],
        votes: {},
        total: []
    },
    initialize: function(options) {

				
				
        var _this = this;
        $$('.mapcontainer path').setStyle('fill', _this.options.color_neutral);
        $$('.mapcontainer path').setStyle('stroke-width', '0.50px');
        $$('.mapcontainer path').setStyle('stroke', _this.options.color_neutral);
        // create slider knob actions
        $$('.slider .knob').addEvent('mousedown', function() {
            this.addClass('mousedown');
        });
        $$('body, .slider .knob').addEvent('mouseup', function() {
            $$('body, .slider .knob').removeClass('mousedown');
        });

        this.setOptions(options);

        this.year = this.options.years[0];
				
				
        $$('.year-start').set('html', this.options.years[0]);
        $$('.year-end').set('html', this.options.years[this.options.years.length - 1]);
				

				this.current_step = this.options.years.indexOf(parseInt(window.name));
				try{
						if(window.frameElement.getAttribute("data-start")){
							this.current_step = window.frameElement.getAttribute("data-start");	
						}
				}catch (error){}

        _this.slider = new Slider($$('.slider')[0], $$('.slider .knob')[0], {
            snap: true,
            steps: this.options.years.length - 1,
            range: [1, this.options.years.length],
						initialStep: this.current_step + 1,
            onChange: function(intStep) {
								_this.sliderChange(intStep);
            }
        });
        for (var i = 0; i < this.options.years.length; i++) {
            new Element('li', {
                html: this.options.years[i]
            }).inject($$('.year-labels')[0]);
        }
        ;

        this.render();
    },
		
    addStateLines: function(passes) {
        // passes are used to render X times more, once seems too faint
        $$('.state-path').destroy();

        for (j = 0; j < passes; j++) {
            for(i=0;i<state_lines.states.length; i++){
								if(typeof $$('svg.year-'+this.year+' path[data-state="'+state_lines.states[i]+'"]').get('data-original-fill') != "undefined"){
									color = $$('svg.year-'+this.year+' path[data-state="'+state_lines.states[i]+'"]').get('data-original-fill')[0];
									
								}
                
								d3.select('svg.year-' + this.year)
									.insert('path')
									.attr('class', 'state-path')
									.attr('stroke', '#000')
									.attr('stroke-width', '0.5px')
									.attr('path-color', color)
									.attr('d', state_lines[state_lines.states[i]])
            }
        }
    },
    sliderChange: function(intStep) {
        $$('.circle-loser').destroy();
        this.current_step = intStep - 1;
        this.year = this.options.years[intStep - 1];
        this.render();
    },
    processData: function() {

        this.data = {
            candidates: [],
            votes: {},
            total: []
        };
        for (var prop in json_data[this.year]) {
            if (prop == 'Total') {
                this.data.total = json_data[this.year][prop];
            }
            else if (prop.length == 2) {
                this.data.votes[prop] = [];
                for (var i = 0; i < json_data[this.year][prop].length; i++) {
                    this.data.votes[prop].push(this.parseNumber(json_data[this.year][prop][i]));
                }
                ;
            }
            else if (prop == 'For President:') {
                this.data.candidates = json_data[this.year][prop].slice(0);
            }
            else if (prop == 'colors') {
                this.data.colors = json_data[this.year][prop].slice(0);
            }
            else {
                console.warn('Data mismatch', prop);
            }
        }
        for (var i = 0; i < this.data.candidates.length; i++) {
            if (!this.lookupCandidateData(this.data.candidates[i])) {
                console.warn('Could not find match for "' + this.data.candidates[i] + '"');
                this.data.candidates[i] = [this.data.candidates[i], '', 0];
                this.data.candidates[i][3] = 1;
            }
            else {
                this.data.candidates[i] = this.lookupCandidateData(this.data.candidates[i]);
                this.data.candidates[i][2] = parseInt(('' + this.data.candidates[i][2]).replace(/,/g, '').replace(/\./g, ''));
                this.data.candidates[i][3] = 1;
            }
        }
				
    },
    lookupCandidateData: function(candidate_name) {
        for (var i = 0; i < candidates[this.year].length; i++) {
            if (candidates[this.year][i][0] == candidate_name) {
                return candidates[this.year][i];
            }
        }
        ;
        return false;
    },
    styleStates: function() {
        var el, elements_strings, selector, max_value;
        for (var state in this.data.votes) {
            if (!states[state]) {
                console.warn('Did not find element for state:', state);
            }
            else {
                elements_strings = [];
                for (var i = 0; i < states[state].length; i++) {
                    elements_strings.push('svg.year-' + this.year + ' #' + states[state][i]);
                }
                ;
                selector = elements_strings.join(',');
                el = $$(selector);
                if (!el) {
                    console.warn('Did not find element for state:', state);
                }
                else {

                    /*Ticket BRND-135*/
                    color = this.options.color_neutral;

                    min_value = this.arrayMin(this.data.votes[state]);
                    max_value = this.arrayMax(this.data.votes[state]);
                    //console.log(max_value + ' ' + min_value);

                    if (this.data.candidates[this.data.votes[state].indexOf(max_value)][3] === 1) {

                        bubble_color = this.data.colors[this.data.votes[state].indexOf(min_value)]
                        if (min_value == max_value) {
                            if (this.data.votes[state].indexOf(min_value) == 0) {
                                bubble_color = this.data.colors[1];
                            }
                        }

                        color = this.data.colors[this.data.votes[state].indexOf(max_value)];
                        if (state == 'ND' && this.year == '1892') {
                            color = '#65DC65';
                        }

                        max_data_position = this.data.votes[state].indexOf(max_value);
                        this.data.votes[state].splice(max_data_position, 1);



                        this.textLabel(max_value, this.data.votes[state], state, selector, bubble_color);

                    }
										el.set('fill', color);
										el.set('data-original-fill', color);
                    el.setStyle('fill', color);
                    el.setStyle('stroke-width', '0.25px');
                    //el.setStyle('stroke', color);
                    //el.setStyle('opacity', '0.5');
                }
            }
        }
    },
    popupateDataTables: function() {
        var row,
                total_votes = 0,
                total_popular_votes = 0;

        // Candidates table
        $$('#candidates tbody')[0].empty();
        for (var i = 0; i < this.data.candidates.length; i++) {

            row = new Element('tr');

            var st = (this.data.candidates[i][3] === 1) ? '<i class="fa fa-check"></i>' : '';

            (new Element('td').adopt(new Element('span.check.active.checked', {
                html: st,
                'data-color': this.data.colors[i],
                'data-candidate': i
            }).setStyle(
                    'background-color', this.data.colors[i]
                    ))).inject(row);
            new Element('td', {
                html:
                        '<span class="cell-header" style="color: ' + this.data.colors[i] + ';">' +
                        this.data.candidates[i][1] + '</span><span>' + this.data.candidates[i][0] + '</span>'
            }).inject(row);
            row.inject($$('#candidates tbody')[0]);
        }
        ;

        // Votes table

        for (var prop in json_data[this.year]) {
            if (prop.length == 2) {
                this.data.votes[prop] = [];
                for (var i = 0; i < json_data[this.year][prop].length; i++) {
                    this.data.votes[prop].push(this.parseNumber(json_data[this.year][prop][i]));
                }
                ;
            }
        }

        $$('#votes tbody')[0].empty();
        for (var i = 0; i < this.data.candidates.length; i++) {
            if (this.data.candidates[i][0] !== 'Other') {
                row = new Element('tr');
                new Element('td.candidate', {
                    html: this.data.candidates[i][1]
                }).setStyle(
                        'color', this.data.colors[i]
                        ).inject(row);
                new Element('td.votes', {
                    html: this.totalVotes(i)
                }).inject(row);
                new Element('td.popular-votes', {
                    html: this.numberWithCommas(this.data.candidates[i][2])
                }).inject(row);
                row.inject($$('#votes tbody')[0]);
            }
        }
        ;
        for (var i = 0; i < this.data.total.length; i++) {
            if (this.data.candidates[i][0] !== 'Other')
                total_votes += this.data.total[i];
        }
        ;
        $$('#votes .total')[0].set('html', total_votes);
        for (var i = 0; i < this.data.total.length; i++) {
            if (this.data.candidates[i][0] !== 'Other')
                total_popular_votes += this.parseNumber(this.data.candidates[i][2]);
        }
        ;
        $$('#votes .total-popular-vote')[0].set('html', this.numberWithCommas(total_popular_votes));
    },
    totalVotes: function(candidate_index) {
        var total = 0;
        for (var state in this.data.votes) {

            total += this.parseNumber(this.data.votes[state][candidate_index]);
        }
        return total;
    },
    textLabel: function(label_winner, other_votes, state, selector, color) {

        var bbox, center, offset = {
            "LA": {
                x: -15,
                y: 0
            },
            "CA": {
                x: -10,
                y: 0
            },
            "MI": {
                x: 18,
                y: 12
            },
            "MA": {
                x: 16,
                y: 14
            },
            "ID": {
                x: 0,
                y: 20
            },
            "NV": {
                x: 5,
                y: -10
            },
            "AK": {
                x: -50,
                y: -75
            },
            "HI": {
                x: -86,
                y: -70
            },
            "AZ": {
                x: 5,
                y: 0
            },
            "OK": {
                x: 15,
                y: 0
            },
            "MN": {
                x: -5,
                y: 0
            },
            "KY": {
                x: 10,
                y: 0
            },
            "WV": {
                x: -2,
                y: 3
            },
            "SC": {
                x: 5,
                y: 0
            },
            "VA": {
                x: 10,
                y: 5
            },
            "DE": {
                x: 45,
                y: 12
            },
            "MD": {
                x: 50,
                y: 20
            },
            "NJ": {
                x: 45,
                y: 10
            },
            "VT": {
                x: -30,
                y: -25
            },
            "CT": {
                x: 85,
                y: 0
            },
            "NY": {
                x: 3,
                y: 3
            },
            "RI": {
                x: 33,
                y: 0
            },
            "NH": {
                x: -40,
                y: -35
            },
            "MS": {
                x: 3,
                y: 0
            }
        };

        var vertical_losers = {
            "NY": true,
            "ME": true,
            "CA": true,
            "MI": true,
            "AL": true,
            "VA": true,
            "MN": true,
        };

        if (!d3.select(selector).node()) {
            console.warn('Could not find node for element selector:', selector);
            return false;
        }

        bbox = d3.select(selector).node().getBBox(),
                center = [bbox.x + bbox.width / 2, bbox.y + bbox.height / 2];

        pre_label = '';
        added_label_padding = 0;
        reduced_buble_padding = 0;



        if (typeof show_state_labels[state] != "undefined") {
            pre_label = state + '  ';//show_state_labels[state][0];
            added_label_padding = 10;
        }

        top_buble_padding = 0;


        other_votes_sum = other_votes.reduce(function(prev, cur) {
            return prev + cur;
        });


        if (other_votes[0] > 0 || other_votes[1] > 0 || other_votes[2] > 0) {

            reduced_buble_padding = 10;

            if (vertical_losers[state]) {

                circle_pos_x_caculations = center[0] * 3 + added_label_padding + (offset[state] ? offset[state].x : 0);
                circle_pos_y_caculations = center[1] * 3 - 50 + (offset[state] ? offset[state].y : 0);

                text_pos_x_caculations = center[0] * 3 + added_label_padding + (offset[state] ? offset[state].x : 0);
                text_pos_y_caculations = center[1] * 3 - 45 + (offset[state] ? offset[state].y : 0);

                reduced_buble_padding = 0;
                top_buble_padding = 5;

            } else {

                circle_pos_x_caculations = center[0] * 3 + 13 + added_label_padding + (offset[state] ? offset[state].x : 0);
                circle_pos_y_caculations = center[1] * 3 - 41 + (offset[state] ? offset[state].y : 0);

                text_pos_x_caculations = center[0] * 3 + 12 + added_label_padding + (offset[state] ? offset[state].x : 0);
                text_pos_y_caculations = center[1] * 3 - 37 + (offset[state] ? offset[state].y : 0);


            }

            /* exceptions in data */
            if (state == 'CA' && this.year == '1892') {
                color = this.data.colors[1];
            }
            if ((state == 'OH' && this.year == '1892') || (state == 'MI' && this.year == '1892')) {
                color = this.data.colors[0];
            }
            if (state == 'AL' && this.year == '1960') {
                color = this.data.colors[0];
            }
            if (other_votes[0] == 0 && typeof other_votes[1] != "undefined") {
                other_votes.splice(0, 1);
                color = this.data.colors[2];
            }


            for (i = 0; i < other_votes.length; i++) {
                if (other_votes[i] > 0) {

                    if (i > 0) {

                        circle_pos_x_caculations = circle_pos_x_caculations - (20 * i);
                        text_pos_x_caculations = text_pos_x_caculations - (20 * i);
                        reduced_buble_padding = 20;
                        if (state == 'ND' && this.year == '1892') {
                            color = this.data.colors[0];
                        }
                    }

                    d3.select('svg.year-' + this.year)
                            .insert('circle')
                            .attr('class', 'circle-loser')
                            .attr('fill', color)
                            .attr('r', '8')
														.attr('data-color', color)
                            .attr('cx', circle_pos_x_caculations)
                            .attr('cy', circle_pos_y_caculations);

                    d3.select('svg.year-' + this.year)
                            .insert('text')
                            .text(other_votes[0])
                            .attr('class', 'state-label loser')
                            .attr('font-family', 'HelveticaNeueETW01-55Rg')
                            .attr('data-state', state)
                            .attr('text-anchor', 'middle')
                            .attr('fill', 'state-label loser')
														.attr('data-color', color)
                            .attr('x', text_pos_x_caculations)
                            .attr('y', text_pos_y_caculations);

                }


            }

        }
				
				d3.select('svg.year-' + this.year)
					.insert('text')
					.text(pre_label + label_winner)//label
					.attr('class', 'state-label')
					.attr('font-family', 'HelveticaNeueETW01-55Rg')
					.attr('data-state', state)
					.attr('x', center[0] * 3 - 7 - reduced_buble_padding + (offset[state] ? offset[state].x : 0))
					.attr('y', center[1] * 3 - 37 + top_buble_padding + (offset[state] ? offset[state].y : 0));
					
				/*	
				
				if(this.year > 1800){
					
					d3.select('svg.year-' + this.year)
					.insert('text')
					.text(pre_label + label_winner)//label
					.attr('class', 'state-label')
					.attr('font-family', 'HelveticaNeueETW01-55Rg')
					.attr('data-state', state)
					.attr('x', center[0] * 3 - 7 - reduced_buble_padding + (offset[state] ? offset[state].x : 0))
					.attr('y', center[1] * 3 - 37 + top_buble_padding + (offset[state] ? offset[state].y : 0));

					
				}else{
				
						if(pre_label){
							d3.select('svg.year-' + this.year)
							.insert('text')
							.text(pre_label + label_winner)//label
							.attr('class', 'state-label')
							.attr('font-family', 'HelveticaNeueETW01-55Rg')
							.attr('data-state', state)
							.attr('x', center[0] * 3 - 7 - reduced_buble_padding + (offset[state] ? offset[state].x : 0))
							.attr('y', center[1] * 3 - 37 + top_buble_padding + (offset[state] ? offset[state].y : 0));
								
								
						}else{
							d3.select('svg.year-' + this.year)
								.insert('text')
								.text(label_winner)//label
								.attr('class', 'state-label')
								.attr('font-family', 'HelveticaNeueETW01-55Rg')
								.attr('data-state', state)
								.attr('x', center[0] * 3 - 7 - reduced_buble_padding + (offset[state] ? offset[state].x : 0))
								.attr('y', center[1] * 3 - 37 + top_buble_padding + (offset[state] ? offset[state].y : 0));
							
						}
				
				}*/

        
				
				
        
        // add hover information
        $$(selector)
				.set('data-state', state)
				.set('data-votes', label_winner)
				.set('title', state + ': ' + label_winner);
    },
    render: function() {
        _this = this;
        $$('.widget-body svg').hide();
        $$('.widget-body svg.year-' + this.year).show();
        $$('.state-label').destroy();
        this.processData();
        this.styleStates();
				this.addStateLines(2);
        this.popupateDataTables();

        if (this.tips) {
            this.tips.detach('.shape');
            this.tips = null;
            $$('.tip-wrap').destroy();
        }
        this.tips = new Tips('.shape[title]', {
            onShow: function(tip, el) {
                tip.getElement('.tip-title').set('html', el.get('data-state') + ': ' + el.get('data-votes'));
                tip.show();
            }
        });
        $$('body, .check').addEvent('click', function() {
            _this.clickCheck(this.getAttribute('data-candidate'), this);
        });

        this.adjustments();
    },
    adjustments: function() {
        if (this.options.adjustments) {
            for (var state in this.options.adjustments) {
                $$('text[data-state="' + state + '"]')[0]
                        .set('x', this.options.adjustments[state].x)
                        .set('y', this.options.adjustments[state].y);
            }
        }
    },
    numberWithCommas: function(x) {
        if (isNaN(x)) {
            return '&mdash;'
        }
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    },
    removeElementFromArray: function(arrayName, arrayElement) {


    },
    arrayMax: function(array) {
        return Math.max.apply(Math, array);
    },
    arrayMin: function(array) {
        return Math.min.apply(Math, array);
    },
    parseNumber: function(string) {
        if (isNaN(string) || string == "") {
            return 0;
        }
        return parseInt(string);
    },
		
    clickCheck: function(candidate_pos, el) {
				
				if(el.get('data-color') !== null){
					color = el.get('data-color');
					activeSVG = $$('svg.year-'+this.year)[0];
					relatedStates = activeSVG.getElements('path[fill="'+color+'"]').get('data-state');
					
					if(el.hasClass('checked')){
						
							for(i =0; i < relatedStates.length; i++){
								$$('text[data-state="'+relatedStates[i]+'"]:not([fill="state-label loser"])').hide();
							}
							activeSVG.getElements('path[fill="'+color+'"]').setStyle('fill', '#D9CFB5');
							activeSVG.getElements('circle[fill="'+color+'"]').hide();
							activeSVG.getElements('text[data-color="'+color+'"]').hide();
							activeSVG.getElements('path[path-color="'+color+'"]').hide();
							
						el.removeClass('checked');
						el.setStyle('color', color);
					}else{
						
						for(i =0; i < relatedStates.length; i++){
							$$('text[data-state="'+relatedStates[i]+'"]:not([fill="state-label loser"])').show();
						}
						
						activeSVG.getElements('path[fill="'+color+'"]').setStyle('fill', color);
						activeSVG.getElements('circle[fill="'+color+'"]').show();
						activeSVG.getElements('text[data-color="'+color+'"]').show();
						activeSVG.getElements('path[path-color="'+color+'"]').show();
						
						el.setStyle('color', '#FFF');	
						el.addClass('checked');
					}
					
					
				}
				
				
    },
    renderColor: function() {
        $$('.widget-body svg').hide();
        $$('.widget-body svg.year-' + this.year).show();
        $$('.state-label').destroy();
        this.styleStates();
        this.popupateDataTables();
    }
});