DocumentWidget = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
    },
    hasImage: false,
    hasText: false,

    initialize: function(options) {
        this.setOptions(options);
		_this = this;

        // Disable contenteditables
        $$('[contenteditable=true]').set('contenteditable', false);

		this.parent({
            container: options.container
        });

		this.triggerElements = this.options.container.getElements('.document-controls a');
		this.docContainers = this.options.container.getElements('.doc-container');

		this.triggerElements.addEvent('click', function(e) {
		 	e.preventDefault();
			_this.toggleView(e.target)
            return false;
        });

    },
	toggleView : function(element){
		if(!element.hasClass('active')){
			if(element.getParent('.active') == null){
				if(!element.hasClass('doc-control')){
					element = element.getParent('.doc-control');
				}
				this.triggerElements.removeClass('active')
				element.addClass('active');

                if(element.hasClass('doc-thumb')) {
                    $$('.document-image').set('active', true);
                    $$('.document-text').set('active', false);
                } else {
                    $$('.document-image').set('active', false);
                    $$('.document-text').set('active', true);
                }
			}
		}

	},

	bindEditMode: function() {
        var _this = this;
        this.hasImage = this.container.get("data-has-image");
        this.hasText = this.container.get("data-has-text");

        // Enable contenteditables
        $$('[contenteditable]').set('contenteditable', true);

        if (parent && parent != window) {
            parent.postMessage({
                method: "settings-widget-mode",
                hasImage: this.hasImage,
                hasText: this.hasText
            }, "*");
        }

        var intTimerID = null;

        var placeholder = Elements.from('<div class="md-placeholder" data-md-editable="md-placeholder-image"><span class="md-placeholder-caption"></span></div>')[0];
        var currentimage = $$(".document-image img");
        if(currentimage!=null && currentimage.length>0){
            currentimage[0].inject(placeholder);
            placeholder.set("data-md-placeholder-has-content",true);
        }

        placeholder.addEvent('click', function(e) {
            var iframe_parent = window.parent;
            var that = _this,
                el = e.target,
                parent = el.getParent('.document-image'),
                have_content = el.get('data-md-placeholder-has-content');

            if(iframe_parent && iframe_parent!=window){
                iframe_parent.postMessage({
                    method:"show-media-popup",
                    media_type:"image",
                    have_content:have_content && have_content=="true"?true:false
                },"*");
            }
            else{
                var src = prompt('Please enter the image URL');
                if (!src || src.trim() == '') {
                    return;
                }
                that.saveImageFile(src,index);
            }
        }.bind(this));

        $$(".document-image").empty();
        $$(".document-image").adopt(placeholder);

        $$('.document-text').addEvent("change", _this.saveEntry());
        $$('.document-text').addEvent("paste", _this.saveEntry());
        $$('.document-text').addEvent("keyup", function(ev) {

            if (intTimerID != null) {
                clearTimeout(intTimerID);
            }
            intTimerID = setTimeout(function() {
                _this.saveEntry();
            }, 500);
        });
    },

    saveEntry: function() {
        this.saveRequestProcedure(this.options.container, {
            method: "setHTML",
            content_set:[
                {
                    selector:".document-text:eq(0)",
                    html:$$('.document-text')[0].get("html")
                }
            ]
        });
    },

    postMessageReceived: function(message) {
    	var _this = this;
    	switch (message.data.method) {
            case "show-media-popup":

                switch(message.data.media_type){
                    case "image":
                        if(message.data.data.source_type!="computer")
                            _this.saveImageFile(message.data.data.source_value,message.data.data.source_type)
                        else
                            _this.saveImageFile(message.data.data.source_relative,message.data.data.source_type)
                        break;
                }
                break;
    		case "toogleImage":
    			_this.hasImage = message.data.has_image;
                _this.alterWidgetDom();
                break;
			case "toogleText":
				_this.hasText = message.data.has_text;
                _this.alterWidgetDom();
                break;
    		case "toggleHTML":
                _this.saveRequestProcedure(null, {
                    method: "toggleHTML",
                    selector: message.data.wrapper,
                    elementID: message.data.elementID,
                    toggle: "" + message.data.value
                }, null, function() {
                    document.location.reload();
                });
                break;
    	}
    },

    saveImageFile:function(src,action){
        var that = this;
        var iframe = '<img src="'+src+'"/>';
        var have_content = $$('[data-md-editable="md-placeholder-image"]').get('data-md-placeholder-has-content');

        if(action=="delete"){
            that.saveRequestProcedure(null, {
                method: 'rm',
                target: '.document-image img',
            }, null, function(data) {
                window.location.reload();
            });
            return;
        }

        that.saveRequestProcedure(null, {
            method: have_content && have_content=="true"?"attr":'appendHtml',
            target: '.document-image',
            html: iframe,
            attributes:{
                src:src
            },
            selector:'.document-image img',
        }, null, function(data) {
            window.location.reload();
        });
    },

    alterWidgetDom: function() {
    	_this = this;

		this.saveRequestProcedure(null, {
            method: "attr",
            selector: "#document",
            attributes: {
            	"data-has-image": +_this.hasImage,
                "data-has-text": +_this.hasText
            }
        }, null, function() {
            document.location.reload();
        });
    }


});