/**
 * Created by germanmontes on 30/09/14.
 */
var Document =  new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
        data: []
    },
    assets:[
        "../_framework/document-v2/modal/assets/css/simplemodal.css",
        "../_framework/document-v2/modal/simple-modal.js",
        "../_framework/document-v2/table-filter/FilterTable.js",
    ],
    xmlType: '',
    
    initialize: function(options) {
        /*
        this.xmlType = $(options.container).get('data-xml-type');

        this.zoom = $(options.container).get('data-zoom');
        this.checkbox_mode = $(options.container).get('data-checkbox') || false;
        this.scalemarker = $(options.container).get('data-scalemarker') || false;
        this.scalemarker_source = $(options.container).get('data-scalemarker-source') || false;
        this.reveal_direction = $(options.container).get('data-reveal-direction') || 'ltr';
        options.extra = ["data-checkbox","data-scalemarker","data-scalemarker-type","data-scalemarker-source","data-reveal-direction"];
         */

        this.parent(options);

        
    },

    convertToHTML:function(content){
        var pattern, re;
        //replace html to safe text for input
        pattern = '&quot;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '"');

        pattern = '&amp;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '&');

        pattern = "&#039;";
        re = new RegExp(pattern, "g");
        content = content.replace(re, "'");

        pattern = '&lt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '<');

        pattern = '&gt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '>');

        return content;
    },

    customPostMessages: function (message) {
       switch(message.method){
            case "data-change":
                this.render();
                break;
       }
    },

    render: function() {
        var _this = this;
        if(this.options.data){
            $$(".widget-body").empty();
            this.options.data.forEach(function(entry,index){
                

                if(entry.Content && entry.Content!=""){
                    var content_wrapper = new Element("div.content-wrapper",{
                        html: _this.convertToHTML(_this.convertToHTML(entry.Content))
                    });

                    $$(".widget-body").adopt(content_wrapper);

                }

                if(entry.Title && entry.Title!=""){
                    var document_wrapper = new Element("div.document-wrapper");

                    var document_button = new Element("div.document-button",{
                        html: "Read the Document",
                        "data-title": entry.Title,
                        "data-url": entry.Document
                    });

                    var document_title = new Element("div.document-title",{
                        html: entry.Title
                    });

                    document_wrapper.adopt(document_button);
                    document_wrapper.adopt(document_title);

                    $$(".widget-body").adopt(document_wrapper);
                }

                if(entry["Search?"]!="" && entry["Search?"] && entry.Document!=""){

                    var document_wrapper = new Element("div.document-wrapper");

                    var document_button = new Element("div.document-search-button",{
                        html: "Search Entire Course Document Library",
                        "data-title": "Search Entire Course Document Library",
                        "data-url": entry.Document
                    });

                    document_wrapper.adopt(document_button);
                    
                    $$(".widget-body").adopt(document_wrapper);
                }

            });

            this.addEvents();
        }
    },

    addEvents:function(){
        var that = this;
        this.options.container.getElements(".document-button").addEvent("click",function(){
            var SM = new SimpleModal({"width":600});
                /*
                SM.addButton("Action button", "btn primary", function(){
                    this.hide();
                });
                */
                SM.addButton("Close", "btn");
                SM.show({
                  "model":"modal",
                  "title":this.get("data-title"),
                  "contents":"<iframe width='100%' height='400' src='"+this.get("data-url")+"'></iframe>"
                });
        });

        this.options.container.getElements(".document-search-button").addEvent("click",function(){
            
                var _this = this;
                var myRequest = new Request({
                    url: this.get("data-url"),
                    method: 'get',
                    onSuccess: function(e){
                        var documents = JSON.parse(e);

                        var table_wrapper = new Element("table.table-content");
                        var entry_dom = new Element("tr",{
                            html: "<th>Author</th>"+
                                  "<th>Ttile</th>"+
                                  "<th>Keywords</th>"
                        });
                        var table_header = new Element("thead");
                        table_header.adopt(entry_dom);
                        table_wrapper.adopt(table_header);

                        var table_body = new Element("tbody");
                        table_wrapper.adopt(table_body);

                        documents.Documents.forEach(function(entry,index){
                            var entry_dom = new Element("tr",{
                                "data-url": entry.link,
                                "data-title": entry.title,
                                html: "<td>"+entry.author+"</td>"+
                                      "<td>"+entry.title+"</td>"+
                                      "<td>"+entry.keywords+"</td>"
                            });
                            table_body.adopt(entry_dom);
                        });

                        var w_wrapper = new Element("div");

                        /*
                        var search_wrapper = new Element("div.search-wrapper",{
                            html:"<input type='text' placeholder='Search Entire Course Document Library' />"
                        });

                        w_wrapper.adopt(search_wrapper);
                        */

                        var table_container = new Element("div.table-container");
                        table_container.adopt(table_wrapper);
                        w_wrapper.adopt(table_container);

                        var SM = new SimpleModal({
                            "width":600,
                             onAppend:function(){
                               new FilterTable({filterClass: 'table-content', placeholder: "Search Entire Course Document Library"});  
                               
                               $$(".table-content tbody tr td").addEvent("click",function(e){
                                    var parent = this.getParent();
                                    $$(".table-container")[0].empty();
                                    $$(".simple-modal-header h1")[0].set("html",parent.get("data-title"));
                                    $$(".table-container")[0].set("html","<iframe width='100%' height='300' src='"+parent.get("data-url")+"'></iframe>");
                               });
                             }
                        });
                        /*
                        SM.addButton("Action button", "btn primary", function(){
                            this.hide();
                        });
                        */
                        SM.addButton("Close", "btn");
                        SM.show({
                          "model":"modal",
                          "title":_this.get("data-title"),
                          "contents":w_wrapper.get("html")
                        });

                        
                    }
                }).send();
        });
    }

});