DragDropMap = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    // Set initial options here
    options: {
        
    },
    // initialize - widget initialization
    initialize: function(options) {
        this.parent(options);
        this.btnReset = this.options.container.getElement('.btn-reset');
        this.btnCheckAnswers = this.options.container.getElement('.btn-checkanswers');
        this.btnCheckAgain = this.options.container.getElement('.btn-checkagain');
        this.btnShowConvention = this.options.container.getElement('.btn-showconvention');
        this.btnClose = this.options.container.getElement('.btn-close');
        
        //Add events
        if(this.isTouchDevice()) {
            this.btnReset.addEvent('touchstart', this.btnResetHandler.bind(this));
            this.btnCheckAnswers.addEvent('touchstart', this.btnCheckAnswersHandler.bind(this));
            this.btnCheckAgain.addEvent('touchstart', this.btnCheckAgainHandler.bind(this));
            this.btnShowConvention.addEvent('touchstart', this.btnShowConventionHandler.bind(this));
            this.btnClose.addEvent('touchstart', this.btnCloseHandler.bind(this));
        } else {
            this.btnReset.addEvent(this.clickEvent, this.btnResetHandler.bind(this));
            this.btnCheckAnswers.addEvent(this.clickEvent, this.btnCheckAnswersHandler.bind(this));
            this.btnCheckAgain.addEvent(this.clickEvent, this.btnCheckAgainHandler.bind(this));
            this.btnShowConvention.addEvent(this.clickEvent, this.btnShowConventionHandler.bind(this));
            this.btnClose.addEvent(this.clickEvent, this.btnCloseHandler.bind(this));
        }

        this.btnReset.hide();
        this.btnCheckAgain.hide();
        this.btnCheckAnswers.setAttribute('disabled', 'disabled');
        this.makeItemDraggable(this.options.container);

        window.addEvent('resize', function() {
            $$('.answers')[0].set('style', '');
        });
        setTimeout(function() {
            $$('.answers')[0].set('style', '');
        }, 400);
    },
    makeItemDraggable: function(parentEle) {
        var _this=this;

        var make_draggable_options = {
            container:this.options.draggableContainer?this.options.draggableContainer:null,
            droppables: ".droppable",
            onDrag: function(draggable,event) {
                
                event.preventDefault();
                draggable.addClass("dragging");
                draggable.setAttribute("aria-grabbed", true);
                if(_this.options.draggableOnDrag){
                    _this.options.draggableOnDrag(event,draggable);
                }
            },
            onDrop: function(draggable, droppable, event) {

                if(droppable==null){
                    if(_this.options.container.getElement('.widget-body .map-diagram [data-id="'+draggable.get("data-id")+'"]')!=null)
                        _this.options.container.getElement('.widget-body .map-diagram [data-id="'+draggable.get("data-id")+'"]').dispose();
                    _this.options.container.getElement('.widget-body .answers [data-id="'+draggable.get("data-id")+'"]').show();
                }

                event.preventDefault();
                draggable.removeClass("dragging");
                draggable.setAttribute("aria-grabbed", false);
                _this.dropHandler(draggable, droppable);
            }
        };
        parentEle.getElements(".draggable").makeDraggable(make_draggable_options);
        parentEle.getElements(".draggable").addEvent('keyup', function(e) {
            switch (e.key) {
                case 'enter':
                case 'space':
                    $$('.draggable.selected').removeClass('selected');
                    e.target.addClass('selected');
                    if(_this.btnCheckAnswers.get("disabled")!="" && parentEle.getElements(".droppable:not(.dropped)").length>0){
                        parentEle.getElements(".droppable:not(.dropped)")[0].focus();
                    }
                    document.body.getElementById('reader-only').set('html', 'You have selected ' + e.target.get("aria-label") + '. Now select a drop area on the map to place the item. You are currently on ' +  document.activeElement.get("aria-label") + ' button');
                    break;
                case 'tab':
                    e.target.focus();
                    break;
                default:
                    break;
            }
            return false;
        }).
        addEvent(this.clickEvent, function(e) {
            
            $$('.draggable.selected').removeClass('selected');
            e.target.addClass('selected');
            if (_this.btnCheckAnswers.get("disabled")!="" && parentEle.getElements(".droppable:not(.dropped)").length>0) {
                parentEle.getElements(".droppable:not(.dropped)")[0].focus();
            }
            document.body.getElementById('reader-only').set('html', 'You have selected ' + e.target.get("aria-label") + '. Now select a drop area on the map to place the item. You are currently on ' +  document.activeElement.get("aria-label") + ' button');
            return false;
        });
        parentEle.getElements(".droppable").set('tabindex', 0);
        parentEle.getElements(".droppable").addEvent('keyup', function(e) {
            if ($$('.draggable.selected').length < 1) {
                return;
            }
            switch (e.key) {
                case 'enter':
                case 'space':
                    if ($$('.draggable.selected').length < 1) {
                        return;
                    }
                    _this.dropHandler($$('.draggable.selected')[0], e.target);
                    if (_this.btnCheckAnswers.get("disabled")!="" && parentEle.getElements(".draggable:not(.dropped)").length>0) {
                        parentEle.getElements(".draggable:not(.dropped)")[0].focus();
                    }
                    document.body.getElementById('reader-only').set('html', 'You have dropped the ' + e.target.getElements(".answer)").get("aria-label") + ' drag object into the ' + e.target.get("aria-label") + ' You are currently on ' + document.activeElement.get("aria-label") + ' button');
                    break;
                default:
                    break;
            }
            return false;
        }).
        addEvent(this.clickEvent, function(e) {
            _this.dropHandler($$('.draggable.selected')[0], e.target);
            if (_this.btnCheckAnswers.get("disabled")!="" && parentEle.getElements(".draggable:not(.dropped)").length>0) {
                parentEle.getElements(".draggable:not(.dropped)")[0].focus();
            }
            document.body.getElementById('reader-only').set('html', 'You have dropped the ' + e.target.getElements(".answer)").get("aria-label") + ' drag object into the ' + e.target.get("aria-label") + ' You are currently on ' + document.activeElement.get("aria-label") + ' button');
        });
    },
    dropHandler: function(draggable, droppable) {
       var _this=this;
       draggable = _this.options.container.getElement('.widget-body .answers [data-id="'+draggable.get("data-id")+'"]');
       if (droppable == null) {
            draggable.setStyles({
                left: "auto",
                top: "auto"
            });
            return;
        }
        if (!draggable.hasClass("nodragg")) {
            if (droppable.getElement(".draggable") != null) {
                _this.resetSingleAnswer(droppable);
            }
            
            if(_this.options.container.getElement('.widget-body .map-diagram [data-id="'+draggable.get("data-id")+'"]')!=null){
                _this.options.container.getElement('.widget-body .map-diagram [data-id="'+draggable.get("data-id")+'"]').getParent(".drop-box").removeClass("dropped");
                _this.options.container.getElement('.widget-body .map-diagram [data-id="'+draggable.get("data-id")+'"]').getParent(".drop-box").empty();
            }
            _this.options.container.getElement('.widget-body .answers [data-id="'+draggable.get("data-id")+'"]').hide();
            _this.options.container.getElements(".answer").removeClass("correct").removeClass("incorrect");
            _this.options.container.getElements(".check-answer").set("html", "");
            _this.options.container.getElements(".feedback").set("html", "");
            var check_answer = new Element('div.check-answer').inject(droppable);
            var answer_container = new Element('div.answer-container').inject(droppable);
            var newDrag = draggable.clone();
            newDrag.setStyles({
                left: "auto",
                top: "auto",
                position: "static",
                display:"block"
            });
            newDrag.set('tabindex', 0);
            newDrag.inject(answer_container);
            var parent=draggable.parentElement.parentElement;
            
            if (parent && parent.hasClass("droppable")){
                parent.set("html", "");
                parent.removeClass("dropped");
            } else {
                draggable.setStyles({
                    left: "auto",
                    top: "auto",
                    display: "none"
                }).addClass("dropped");
            }   
            droppable.addClass("dropped");
            _this.makeItemDraggable(droppable);
            
            if (_this.options.container.getElements('.droppable .answer').length==_this.options.answers.length){
                _this.btnCheckAnswers.removeProperty('disabled');
                _this.btnCheckAgain.removeProperty('disabled');
                _this.btnCheckAnswers.focus();
            } else {
                _this.btnCheckAnswers.setAttribute('disabled', 'disabled');
                _this.btnCheckAgain.setAttribute('disabled', 'disabled');
            }
        }
        $$('.draggable.selected').removeClass('selected'); 
    },
    resetSingleAnswer: function(droppableEle){
        if (droppableEle.getElement(".answer") != null) {
            var answerId = droppableEle.getElement(".answer").getAttribute("data-id");
            var resetAnswer = this.container.getElements('.draggable[data-id="' + answerId + '"]');
            resetAnswer.show().removeClass("dropped");
            droppableEle.set("html", "");
            droppableEle.removeClass("dropped");
        }   
    },
    btnShowConventionHandler: function(e){
        e.preventDefault();
        this.options.container.getElement('.conventionDialog').show();
        this.options.container.getElement('.conventionDialog').focus();
        this.options.container.getElement('.conventionDialog').set('aria-hidden', false);
        document.body.getElementById('reader-only').set('html', 'Map conventions window is showing');
    },
    btnCloseHandler: function(e){
        e.preventDefault();
        this.options.container.getElement('.conventionDialog').hide();
        this.options.container.getElement('.conventionDialog').set('aria-hidden', true);
        document.body.getElementById('reader-only').set('html', 'Map conventions window has closed');
    },
    btnResetHandler: function(e) {
        e.preventDefault();
        $$(".feedback")[0].set("html","");
        $$(".reset-msg")[0].hide();
        $$(".reset-msg-perfect")[0].hide();
        $$('.draggable.selected').removeClass('selected');
        this.options.container.getElements(".check-answer").set("html", "");
        this.options.container.getElements(".feedback").set("html", "");
        this.options.container.getElements(".droppable").set("html", "");
        this.options.container.getElements(".reset-msg").hide()
        this.options.container.getElements(".reset-msg-perfect").hide();
        this.options.container.getElements(".dropped").removeClass("dropped");
        this.options.container.getElements(".answer").show();
        this.btnCheckAnswers.setAttribute('disabled', 'disabled');
        this.btnCheckAnswers.show();
        this.btnReset.hide();
        this.btnCheckAgain.hide(); 
    },
    btnCheckAnswersHandler: function(e) {
        e.preventDefault();
        this.checkAnswers();
    },
    btnCheckAgainHandler: function(e) {
        e.preventDefault();
        this.checkAnswers();
    },
    checkAnswers: function () {
        var correctAnswer=0;
        this.options.container.getElements(".map-item").each(function(q){
            var answerEle = q.getElement(".answer");
            if (answerEle){
                var accept = q.getAttribute("data-accept");
                if(accept!=null && accept!=""){
                    accept = accept.split(",");
                }
                else{
                    accept=null;
                }

                if ((accept==null && q.getAttribute("data-answer")==answerEle.getAttribute("data-id")) || (accept!=null && accept.indexOf(answerEle.getAttribute("data-original-pos")+"")!=-1)){
                    answerEle.addClass("correct");
                    q.getElement(".check-answer").set("html", "<img src='../_framework/drag-drop-map-v1/images/quiz-check-mark@2x.png'/>");
                    q.getElement(".check-answer").setAttribute("label", "correct");
                    correctAnswer++;
                } else {
                    answerEle.addClass("incorrect");
                    q.getElement(".check-answer").set("html", "<img src='../_framework/drag-drop-map-v1/images/quiz-x-mark@2x.png'/>");
                    q.getElement(".check-answer").setAttribute("label", "incorrect");
                }
            }
        });
        var feedback="You completed the challenge. You got " + correctAnswer + " out of " + this.options.answers.length + " correct.";
        this.options.container.getElements(".feedback").set("html", feedback);
        if (correctAnswer == this.options.answers.length) { 
            this.options.container.getElements(".reset-msg-perfect").show();
            this.options.container.getElements(".reset-msg").hide();
        } else {
            this.options.container.getElements(".reset-msg").show();
            this.options.container.getElements(".reset-msg-perfect").hide();
        }
        this.btnCheckAnswers.hide();
        this.btnReset.show();
        this.btnCheckAgain.show();
    },
    getRightArrow: function(type) {
        if (type == "left") {
            return "&#8592;";
        } else if (type == "right") {
            return "&#8594;";
        }
        return "";
    },
    getDownArrow: function(type) {
        if (type == "up") {
            return "&#8593;";
        } else if (type == "down") {
            return "&#8595;";
        }
        return "";
    },
    getArrowCode:function(type){
        if (type == "left") {
            return "&#8592;";
        } else if (type == "right") {
            return "&#8594;";
        } else if (type == "up") {
            return "&#8593;";
        } else if (type == "down") {
            return "&#8595;";
        } else if (type == "right-dashed"){
            return "&#8674;";
        } else if (type == "left-dashed"){
            return "&#8672;";
        } else if (type == "up-dashed"){
            return "&#8673;";
        } else if (type == "down-dashed"){
            return "&#8675;";
        }
        return "";
    },
    getSvgShape: function(shape) {
        var html='';
        var baseWidth = 210;
        var baseHeight = 180;
        var baseScaleFactor = 0.7;
        switch (shape) {
        case "rectangle":
            html='<svg role="button" aria-label="green rectangle drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '" width="' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><rect x="5" y="20" width="190" height="110" fill="none" stroke="#70bf41" stroke-width="3"/></svg>';
            break;
        case "filledRectangle":
            html='<svg role="button" aria-label="green rectangle drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '" width="' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><rect x="5" y="20" width="190" height="110" fill="#70bf41" stroke="#70bf41" stroke-width="3"/></svg>';
            break;
        case "ellipse":
            html='<svg role="button" aria-label="orange ellipse drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '"' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><ellipse cx="102" cy="80" rx="100" ry="70" fill="none" stroke="#f39019" stroke-width="3"/></svg>';
            break;
        case "rhombus":
            html='<svg role="button" aria-label="purple diamond drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '"' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><polygon points="1,80 101,1 202,80, 101,162" fill="none" stroke="#777b81" stroke-width="3"/></svg>';
            break;
        case "arrow":
            html='<svg role="button" aria-label="red arrow drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '"' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><polygon points="2,80 60,1 60,30 195,30 195,130 60,130 60,158" fill="none" stroke="#c82506" stroke-width="3"/></svg>';
            break;
        case "arrow_large":
            html='<svg role="button" aria-label="red arrow drop area" viewBox="0 0 ' + baseWidth + ' ' + (baseHeight) + '" "' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor  + 10) + 'px"><polygon points="2,80 60,1 60,30 207,30 207,130 60,130 60,158" fill="none" stroke="#c82506" stroke-width="3"/></svg>';
            break;
        case "hexagon":
            html='<svg role="button" aria-label="red hexagon drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '"' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><polygon points="25,45 105,1 185,45 185,130, 105,169 25,130" fill="none" stroke="#c82506" stroke-width="3"/></svg>';
            break;
        case "implicit":
            html='<svg role="button" aria-label="blue thought bubble drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '"' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><ellipse cx="102" cy="80" rx="100" ry="75" fill="#ffffff" stroke="#92c8fb" stroke-width="3"/><ellipse cx="46" cy="147" rx="20" ry="14" fill="#ffffff" stroke="#92c8fb" stroke-width="3"/><ellipse cx="24" cy="163" rx="16" ry="12" fill="#ffffff" stroke="#92c8fb" stroke-width="3"/></svg>';
            break;
        case "implicit_right":
            html='<svg role="button" aria-label="blue thought bubble drop area" viewBox="0 0 ' + baseWidth + ' ' + baseHeight + '"' + (baseWidth * baseScaleFactor) + 'px" height="' + (baseHeight * baseScaleFactor) + 'px"><ellipse cx="102" cy="80" rx="100" ry="75" fill="#ffffff" stroke="#92c8fb" stroke-width="3"/><ellipse cx="152" cy="147" rx="20" ry="14" fill="#ffffff" stroke="#92c8fb" stroke-width="3"/><ellipse cx="164" cy="163" rx="16" ry="12" fill="#ffffff" stroke="#92c8fb" stroke-width="3"/></svg>';
            break;
        }
        return html;
        
    },
    createDOM: function() {
        var original_positions = [];
        var reverse_positions = [];
        var initial_array = [];
        var answers = this.options.container.getElement('.widget-body .answers');
        var diagram = this.options.container.getElement('.widget-body .map-diagram');

        for (var i = 0; i < this.options.answers.length; i++) {
            initial_array[this.options.answers[i]] = i;
        }
        
        this.options.answers = this.options.answers.sort(function() {return 0.5 - Math.random()});

        for (var i = 0; i < this.options.answers.length; i++) {
            original_positions[initial_array[this.options.answers[i]]] = i;
            reverse_positions[i] = initial_array[this.options.answers[i]];
        }



        for (var i = 0; i < this.options.answers.length; i++) {
            answer_container = new Element('div.answer-container').inject(answers);
            answer = new Element('div.answer.draggable', {
                'data-id': i,
                'data-original-pos': reverse_positions[i],
                tabindex: 0,
                "role": "button",
                html: this.options.answers[i],
                "aria-label": this.options.answers[i].slice(0,-1)
            }).inject(answer_container);
            var text_length = answer.get('html').length;
            if (text_length > 60) {
                answer.addClass('long-text');
            }
            if (text_length > 75) {
                answer.addClass('longer-text');
            }
            if (text_length > 90) {
                answer.addClass('longest-text');
            }
       }
       var _this = this;
       setTimeout(function(){
            _this.options.container.getElements('.widget-body .answer-container').each(function(item){
               item.setStyles({
                    width: item.getElement(".answer").getWidth()+2
               });
           });
       },100);
       
       for (var i = 0; i < this.options.row; i++) {
           for (var j = 0; j < this.options.col; j++){
                var dataId = "item"+i+"_"+j;
                if (this.options.data[dataId]) {
                    var rightArrow = "";
                    var downArrow = "";
                    var leftArrow = "";
                    var upArrow = "";
                    var downRightArrow = "";
                    if(this.options.data[dataId].arrow){
                        if(this.options.data[dataId].arrow.indexOf(",")>=0){
                            var arrows_config = this.options.data[dataId].arrow.split(",");
                            Array.each(arrows_config,function(arrow_to_use,i){
                                arrow_to_use = arrow_to_use.trim();                                

                                switch(i){
                                    case 0:
                                        leftArrow = _this.getArrowCode(arrow_to_use);
                                    break;
                                    case 1:
                                        upArrow = _this.getArrowCode(arrow_to_use);
                                    break;
                                    case 2:
                                        rightArrow = _this.getArrowCode(arrow_to_use);
                                    break;
                                    case 3:
                                        downArrow = _this.getArrowCode(arrow_to_use);
                                    break;
                                    case 4:
                                        downRightArrow = _this.getArrowCode(arrow_to_use);
                                    break;
                                }
                            })
                        } else {
                            rightArrow = this.getRightArrow(this.options.data[dataId].arrow);
                            downArrow = this.getDownArrow(this.options.data[dataId].arrow);
                        }
                    }

                    var svgShape = this.getSvgShape(this.options.data[dataId].shape);

                    var label = "";
                    switch (this.options.data[dataId].shape) {
                      case "rectangle":
                        label = "conclusion or decision";
                        break;
                      case "eclipse":
                        label = "reason supporting a claim";
                        break;
                      case "rhombus":
                        label = "recognition of the need to decide";
                        break;
                      case "arrow":
                        label = "objection or counterargument";
                        break;
                      case "hexagon":
                        label = "abandonment of a line of reasoning";
                        break;
                      case "implicit":
                        label = "blue thought bubble";
                        break;
                    }
                    if(this.options.data[dataId].text==null){
                        item = new Element('div.map-item.'+this.options.data[dataId].shape, {
                            'data-id': dataId,
                            'data-answer': original_positions[this.options.data[dataId].answer],
                            'data-accept': this.options.data[dataId].accept?this.options.data[dataId].accept:"",
                            html: '<div class="drop-box droppable" aria-live="polite" aria-dropeffect="move" aria-label="drop area '+label+ ' ' +this.options.data[dataId].description+'" role="button"></div><div class="shape-item"  >' + svgShape + '</div><div class="arrow-right">' + rightArrow + '</div><div class="arrow-down">' + downArrow + '</div><div class="arrow-left">' + leftArrow + '</div><div class="arrow-up">' + upArrow + '</div><div class="arrow-down-right">' + downRightArrow + '</div>'
                        }).inject(diagram);
                    }
                    else{
                        item = new Element('div.map-item.'+this.options.data[dataId].shape, {
                            'data-id': dataId,
                            'data-answer': this.options.data[dataId].answer,
                            html: '<div class="drop-box " aria-live="polite" aria-dropeffect="move" aria-label="drop area '+label+ ' ' +this.options.data[dataId].description+'" role="button"><div class="static-text"><div>'+this.options.data[dataId].text+'</div></div></div><div class="shape-item"  >' + svgShape + '</div><div class="arrow-right">' + rightArrow + '</div><div class="arrow-down">' + downArrow + '</div><div class="arrow-left">' + leftArrow + '</div><div class="arrow-up">' + upArrow + '</div><div class="arrow-down-right">' + downRightArrow + '</div>'
                        }).inject(diagram);
                    }

                } else {
                    item = new Element('div.map-item').inject(diagram);
                }
                
           }
           item = new Element('br').inject(diagram);
       }   
    }   
    
});