Experiment = new Class({
    Implements: [Options, Events],

    options: {
    },

    currentSlide: 1,

    initialize: function(options) {
        this.setOptions(options);
        this.container = this.options.container;

        this.button_prev = this.options.container.getElement('button.previous');
        this.button_next = this.options.container.getElement('button.next');
        this.button_reset = this.options.container.getElement('button.reset');
        this.start_experiment = this.options.container.getElement('footer button.start-experiment');

        this.initializeDOM();

        this.body = this.options.container.getElement('.widget-body');

        this.render();
    },

    initializeDOM: function() {
        var  _this = this;
        
        // Add element events
        if (this.button_next) {
            this.button_next.addEvent('click', function() {
                _this.next();
                this.blur();
                return false;
            });
        }
        if (this.button_prev) {
            this.button_prev.addEvent('click', function() {
                _this.previous();
                this.blur();
                return false;
            });
        }
        if (this.button_reset) {
            this.button_reset.addEvent('click', function() {
                _this.reset();
                this.blur();
                return false;
            });
        }
    },

    getSlideId: function(element) {
        var classes = element.get('class').split(' ');
        for (var i = 0; i < classes.length; i++) {
            if (classes[i].substr(0,6) == 'slide-') {
                return classes[i].substr(6);
            }
        };
        return null;
    },

    // Reset the whole widget
    reset: function() {
        this.currentSlide = 1;

        this.render();
    },

    // Next slide
    next: function() {
        this.currentSlide = this.nextSlide;

        this.render();
    },

    // Previous slide
    previous: function() {
        this.currentSlide = this.prevSlide;

        this.render();
    },

    shuffle: function(o) {
        for(var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
        return o;
    },

    // Expandable images behavior
    expandableImages: function() {
        var img, wrapper,
            _this = this,
            images = this.container.getElements('img.expandable');
        for (var i = 0; i < images.length; i++) {
            img = images[i];
            wrapper = new Element('div.img-wrapper').wraps(img);
            var button = new Element('button.expand-img', {
                html: 'Enlarge Image',
                'data-src': img.get('src')
            }).addEvent('click', function() {
                new Element('img', {
                    src: this.get('data-src')
                }).inject(new Element('section.overlay.img-overlay').inject(_this.body).show());
                _this.container.addClass('img-overlay');
            }).inject(wrapper);
        };
        _this.container.addEvent('click:relay(.close-img-overlay)', function() {
            _this.container.getElements('.overlay.img-overlay').destroy();
            _this.container.removeClass('img-overlay');
        });
    },

    // Update the widget display
    render: function() {
        var slide;

        $$('.active').removeClass('active');
    	$$('.slide-' + this.currentSlide).addClass('active');

        slide = this.options.container.getElement('article.slide-' + this.currentSlide);
        this.nextSlide = slide.get('data-next-slide');
        this.prevSlide = slide.get('data-prev-slide');

        this.button_prev.show();
        this.button_next.show();
        this.button_reset.hide();
        if (this.start_experiment) {
            this.start_experiment.hide();
        }
        this.button_prev.removeProperty('disabled');
        this.button_next.removeProperty('disabled');
        if (!this.nextSlide || slide.get('data-next-locked')) {
            this.button_next.set('disabled', 'disabled');
        }
        if (!this.prevSlide) {
            this.button_prev.set('disabled', 'disabled');
        }
        if (!this.nextSlide && !this.prevSlide) {
            this.button_prev.hide();
            this.button_next.hide();
            if (this.start_experiment) {
                this.start_experiment.show();
            }
        }
    }
});