FillInApplication = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {},
    current_section: 'survey',
    current_topic: '',
    current_question: 0,
    show_results: false,
    skip_to_question: 0,
    show_selector_next: false,
    // initialize - widget initialization
    initialize: function (options) {
        var _this = this;
        this.parent(options);
        this.number_of_questions = options.data.types.length;
        
        // remove the WEditor DOM on preview mode
        if (!this.isEditMode) {
            var lookForWeditorInterval = setInterval(function (){
                if ($$("div.mdwysiwyg").length) {
                    $$("div.mdwysiwyg").dispose();
                }

                clearTimeout(lookForWeditorInterval);
            }, 500); 
        }

        this.widget_body = this.options.container.getElement('.widget-body');
        this.home_btn = this.options.container.getElement('.btn-home');
        this.next_btn = this.options.container.getElement('.btn-next');
        this.prev_btn = this.options.container.getElement('.btn-prev');
        this.print_btn = this.options.container.getElement('.btn-print');

        // Add events
        this.home_btn.addEvent('click', function () {
            if (confirm('Are you sure you want to reset? All your progress will be lost.')) {
                _this.reset();
            }
        });

        this.next_btn.addEvent('click', function () {
            _this.next();
        });
        this.prev_btn.addEvent('click', function () {
            _this.previous();
        });
        this.print_btn.addEvent('click', function () {
            _this.print();
        });
        this.render();
    }, // end initialize()

    next: function () {
        if (this.show_results) {
            this.current_section = 'results';
        } else {
            if (this.current_question < this.options.data[this.current_topic].length - 1) {
                this.current_question++;
            } else {
                this.current_section = 'results';
            }
        }
        this.render();
        $$('.notes')[0].focus();
    }, // end next

    previous: function () {
        if (this.show_selector_next) {
            this.current_question = 6;
            this.skip_to_question = 0;
            this.show_selector_next = false;
        }
        if (this.current_section == 'survey') {
            this.current_question--;
        } else {
            this.current_section = 'survey';
            if (this.skip_to_question > 0) {
                this.show_selector_next = true;
            }
        }
        this.render();
    }, // end previous

    reset: function () {
        this.options.data[this.current_topic].each(function (question) {
            question.answer = "";
        });
        this.current_question = 0;
        this.current_section = 'survey';
        current_topic = 'types';
        this.current_topic = 'types';
        this.render();
    }, // end reset

    print: function () {
        win = window.open();
        self.focus();
        win.document.open();
        win.document.write(this.result);
        win.document.close();
        win.print();
        win.close();
    }, // end print()

    render: function () {
        var _this = this;

        // Empty body
        this.widget_body.set('html', '');
        this.current_topic = 'types';
        switch (this.current_section) {
            case 'survey':
                var question = this.options.data[this.current_topic][this.current_question];
                this.options.container.getElement('.info').set('html', question.info);
                this.options.container.getElement('.question strong').set('html', question.question);
                var textarea = new Element('textarea.answer', {
                    value: _this.options.data[_this.current_topic][_this.current_question].answer,
                    events: {
                        keyup: function () {
                            if (this.get('value')) {
                                _this.options.data[_this.current_topic][_this.current_question].answer = this.get('value');
                                _this.next_btn.removeProperty('disabled');
                            } else {
                                _this.next_btn.setProperty('disabled', true);
                            }
                        }
                    }
                }).inject(this.widget_body);

                if (this.current_topic == 'types') {
                    question_number = (this.current_question + 1);
                    if (this.current_question == this.number_of_questions) {
                        this.show_results = true;
                    }
                    this.options.container.getElement('.pager').set('html', question_number + ' of ' + this.number_of_questions);
                } else {
                    this.options.container.getElement('.pager').set('html', (this.current_question + 1) + ' of ' + this.options.data[this.current_topic].length);
                } // Disable previous button on first question
                if (this.current_question == 0) {
                    this.prev_btn.hide();
                } else {
                    this.prev_btn.show();
                } // Set stage
                this.options.container.setProperty('data-stage', 'survey');
                break;
            case 'results':
                var _this = this;
                this.result = "";
                // Collect all answers
                _this.options.data[_this.current_topic].each(function (question) {

                    if (_this.current_topic == 'types') {
                        if (typeof question.answer != 'undefined') {
                            _this.result += "<p><strong>" + question.question + "</strong><br>";
                            _this.result += question.answer + "</p>";
                        }
                    } else {
                        if (typeof question.answer == 'undefined')
                            question.answer = "";
                        _this.result += "<p><strong>" + question.question + "</strong><br>";
                        _this.result += question.answer + "</p>";
                    }
                });
                new Element('div.results-table', {
                    html: _this.result
                }).inject(this.widget_body);

                // Set stage
                this.options.container.setProperty('data-stage', 'results');
                break;
        }
    } // end render()
}); // end Class FillInApplication()
