var FillInApplication = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {},
    // initialize - widget initialization
    current_page: 0,
    //
    initialize: function (options) {
        var _this = this;


        this.parent(options);

        // remove the WEditor DOM on preview mode
        if (!this.isEditMode) {
            var lookForWeditorInterval = setInterval(function (){
                if ($$("div.mdwysiwyg").length) {
                    $$("div.mdwysiwyg").dispose();
                }

                clearTimeout(lookForWeditorInterval);
            }, 500); 
        }
    }, // end initialize()

    afterInitialize: function(){
        this.setUPSettings(this.options);
        this.generateDOM();
        this.addEvents();
    },

    setUPSettings:function(options){
        this.intro = options.data.intro!=null ? options.data.intro : '';
        this.intro_line_summary = options.data.intro_line_summary!=null ? options.data.intro_line_summary : '';
        this.intro_line_content = options.data.intro_line_content!=null ? options.data.intro_line_content : '';
        this.intro_line = options.data.intro_line!=null ? options.data.intro_line : '';
        this.lead_in_text = options.data.lead_in_text!=null ? options.data.lead_in_text : '';
        this.additional_summary_screen_text = options.data.additional_summary_screen_text!=null ? options.data.additional_summary_screen_text : '';

        this.show_introduction_panel = options.data.show_introduction_panel!=null ? options.data.show_introduction_panel : true;
        this.text_as_editable_passage = options.data.text_as_editable_passage!=null ? options.data.text_as_editable_passage : false;
        this.each_question_on_page = options.data.each_question_on_page!=null ? options.data.each_question_on_page : true;


        this.summary_screen_show_lead_in = options.data.summary_screen_show_lead_in!=null ? options.data.summary_screen_show_lead_in : true;
        this.summary_screen_show_print_button = options.data.summary_screen_show_print_button!=null ? options.data.summary_screen_show_print_button : true;
        this.summary_screen_repeat_questions = options.data.summary_screen_repeat_questions!=null ? options.data.summary_screen_repeat_questions : true;
        this.summary_screen_show_feedback = options.data.summary_screen_show_feedback!=null ? options.data.summary_screen_show_feedback : true;
        this.summary_show_scoring = options.data.summary_show_scoring!=null ? options.data.summary_show_scoring : true;

        if ( this.intro.replace(/(<([^>]+)>)/ig,"").trim()!="" || this.isEditMode ) {
            this.current_page = -1;
        }
    },

    addEvents: function(){
        $("restart").addEvent('click', this.restart.bind(this));
        $("next").addEvent('click', this.next.bind(this));
        $("previous").addEvent('click', this.previous.bind(this));
        $('print').addEvent('click', this.print.bind(this));
        $(window).addEvent('resize',this.updateTextareaHeight.bind(this));
    },

    print: function(e){
        this.preparePrint();
        window.print();
    },

    restart: function(e){
        //document.location.reload();
        $$(".pager-footer").set("html", "");
        $('next').setProperty("disabled", null);
        $('previous').setProperty("disabled", "disabled");
        $('print').setProperty("disabled", null);
        $('restart').setProperty("disabled", null);

        $('next').hide()
        $('previous').hide()
        $('print').hide()
        $('restart').hide()
        
        $('MetrodigiWidget').removeClass('current-intro');
        $('MetrodigiWidget').removeClass('current-summary');

        this.generateDOM();
    },

    next: function(e){
        var current_page = $$('.page-active')[0];
        var nextSibling = current_page.getNext('.page');
        $("print").hide();



        if(current_page.get('data-item-page') !==null && current_page.get('data-item-page')!==undefined && current_page.get('data-item-page')>=0 && current_page.get('data-item-page')!=='end' && !this.validate())
            return ;

        if(nextSibling.get('data-item-page') !==null && nextSibling.get('data-item-page')!==undefined && nextSibling.get('data-item-page')==='end'){
            current_page.removeAttribute('tabindex');
            if(current_page.getElement('[tabindex]')){
                current_page.getElement('[tabindex]').removeAttribute('tabindex');
            }
            this.showSummary();
            return;
        }

        $('MetrodigiWidget').removeClass('current-intro');
        $('MetrodigiWidget').removeClass('current-summary');



        if(nextSibling!=null){
            current_page.hide();
            current_page.removeClass("page-active");
            current_page.removeAttribute('tabindex');
            if( current_page.getElement('[tabindex]') ){
                current_page.getElement('[tabindex]').removeAttribute('tabindex');
            }
            nextSibling.show();
            nextSibling.addClass("page-active");
            $('next').setProperty("disabled",null);

            if(nextSibling.getNext('.page')==null)
                $('next').setProperty("disabled","disabled");
            nextSibling.setAttribute('tabindex', -1);
            if(nextSibling.getElement('iframe')){
              nextSibling.getElement('iframe').set('tabindex', 0).focus();
            }
            else{
                nextSibling.getElement('.answer-input, .answer-textarea').set('tabindex', 0).focus();
            }
        } else {
            $('next').setProperty("disabled","disabled");
        }

        $("previous").show();
        $("previous").setProperty("disabled", null);

        this.updatePager();
    },

    previous:function(e){
        var that = this;
        var current_page = $$('.page-active')[0];
        var nextSibling = current_page.getPrevious('.page');
        current_page.hide();
        current_page.removeClass("page-active");
        if( current_page.getElement('[tabindex]') ){
            current_page.getElement('[tabindex]').removeAttribute('tabindex');
        }
        nextSibling.show();
        nextSibling.addClass("page-active");
        nextSibling.setAttribute('tabindex', -1);
        $('next').setProperty("disabled",null);
        $("print").hide();

        $('MetrodigiWidget').removeClass('current-intro');
        $('MetrodigiWidget').removeClass('current-summary');

        if(nextSibling.getPrevious('.page')==null){
            //$("previous").hide();
            $("previous").setProperty("disabled", "disabled");
            if(nextSibling.hasClass('page-intro')) {
                $('MetrodigiWidget').addClass('current-intro');
                // focus intro if widget is in focus
                that.clearTimersOnUserInteraction(function (timers) {
                    timers.push(setTimeout(function () {
                        nextSibling.focus();
                    }, 0));
                });
            }
        } else {
            $("previous").show();
            $("previous").setProperty("disabled", null);
            if(nextSibling.getElement('p')) {
                nextSibling.getElement('p').set('tabindex', 0).focus();
            }
        }

        this.updatePager();

    },

    validate: function(){
        var success = true;
        var that = this;
        var focused = false;
        var current_page = $$('.page-active')[0];
        var inputsEls = current_page.getElements(".answer-input, .answer-textarea");
        inputsEls.removeClass("error");
        inputsEls.forEach(function(item, index){
            var value = item.get("value") || item.textContent;
            var id = item.get('id');
            item.removeAttribute('aria-describedby');
            if(value.trim()==""){
                success = false;
                item.addClass("error");
                if(!focused){
                    item.setAttribute('aria-invalid', true);
                    item.focus();
                    focused = true;
                }
                if (!current_page.getElement('.question-item-column #tamessage-'+id)){
                    item.set('aria-describedby', 'tamessage-'+id);
                    new Element('span', {
                        id: 'tamessage-'+id,
                        html: 'This field cannot be empty.'
                    }).inject(current_page.getElement('.question-item-column:last-child'));
                }
            } else {
                if (current_page.getElement('.question-item-column #tamessage-'+id))
                    current_page.getElement('.question-item-column #tamessage-'+id).remove();
            }
        });

        return success;
    },

    updatePager: function(){
        var current_page = $$('.page-active')[0]?$$('.page-active')[0].get('data-item-page'):null;
        
        if(current_page!=null){
            if(this.each_question_on_page)
                $$(".pager-footer").set("html",current_page +" of " + this.options.data.data.length);
            
            this.updateViewport();

            var _this = this;
            var imgEls = document.querySelectorAll('div[data-item-page="' + current_page + '"] img');

            imgEls.forEach(function (imgEl) {
                if (imgEl.onload) return;

                imgEl.onload = function () {
                    _this.updateViewport();
                };
            });
        } else {
            //if($("intro-line"))
            //    $("intro-line").hide();
            $$(".pager-footer").set("html","");
        }
    },

    showSummary: function(){
        var that = this;
        var current_page = $$('.page-active')[0];
        var nextSibling = $$('.page-end')[0];
        current_page.hide();
        current_page.removeClass("page-active");
        nextSibling.show();
        nextSibling.addClass("page-active");
        nextSibling.set('tabindex', 0).focus();
        $('next').setProperty("disabled","disabled");
        $$(".pager-footer").set("html","");
        $('previous').setProperty("disabled",null);
        $('previous').show();
        $('MetrodigiWidget').addClass('current-summary');


        if(that.summary_screen_show_print_button){
            if(!that.isMobile())  $("print").show();
        }

        if(this.options.data!=null && this.options.data.data!=null){
            $$("div.summary-resume")[0].empty();
            this.options.data.data.forEach(function(item, i){

                var question_answer = $$('[data-question-index="' + i + '"] .answer-input,[data-question-index="' + i + '"] .answer-textarea')[0];
                var Question_text = "";

                if(typeof item["Question"] !== 'undefined' && item["Question"] != null && (typeof item["Question Input 1"] === 'undefined' || item["Question Input 1"] == null) ){
                    var Question = item["Question"];
                    Question_text += '<div>'+that.renderItem(Question)+'</div>';
                }

                if(typeof item["Question Input 1"] !== 'undefined' && item["Question Input 1"] != null){
                    var Question = item["Question Input 1"];
                    Question_text += '<div>'+that.renderItem(Question)+'</div>';
                }

                if(typeof item["Question Input 2"] !== 'undefined' && item["Question Input 2"] != null){
                    var Question = item["Question Input 2"];
                    Question_text +=  that.renderItem(Question);
                }
                

                var question_item = new Element("div.summary-question-item",{
                    html: '<div class="question-item-columns">'+
                            '<div class="question-item-column question-item-column-col-1">'+(i+1)+'.</div>'+
                            '<div class="question-item-column question-item-column-col-2">'+(that.summary_screen_repeat_questions?Question_text:"")+'</div>'+
                        '</div>'
                });
                question_item.inject($$("div.summary-resume")[0]);

                var your_response = new Element("div.summary-question-item-your-response",{
                    html: '<strong>Your response:</strong> '+ (question_answer!=undefined?question_answer.get('value') || '<div style="display: inline">'+ question_answer.get('html') +'</div>' :'')
                });
                your_response.inject(question_item.getElement('.question-item-column-col-2'));
                if(that.summary_screen_show_feedback && item.Feedback!=null){
                    var feeback = new Element("div.summary-question-item-feedback",{
                        html: that.renderItemFeedback(item.Feedback)
                    });
                    feeback.inject(question_item.getElement('.question-item-column-col-2'));
                }

            });
        }

        this.updatePager();
    },

    preparePrint: function(){
        var that = this;

        if(this.options.data!=null && this.options.data.data!=null){
            $$("div.print-summary-resume")[0].empty();
            this.options.data.data.forEach(function(item, i){

                var Question_text = "";

                if(typeof item["Question"] !== 'undefined' && item["Question"] != null && (typeof item["Question Input 1"] === 'undefined' || item["Question Input 1"] == null) ){
                    var Question = item["Question"];
                    Question_text += '<div>'+that.renderItem(Question)+'</div>';
                }

                if(typeof item["Question Input 1"] !== 'undefined' && item["Question Input 1"] != null){
                    var Question = item["Question Input 1"];
                    Question_text += '<div>'+that.renderItem(Question)+'</div>';
                }

                if(typeof item["Question Input 2"] !== 'undefined' && item["Question Input 2"] != null){
                    var Question = item["Question Input 2"];
                    Question_text +=  that.renderItem(Question);
                }

                var question_answer = $$('[data-question-index="' + i + '"] .answer-input,[data-question-index="' + i + '"] .answer-textarea')[0];

                var question_item = new Element("div.summary-question-item",{
                    html: '<div class="question-item-columns">'+
                            '<div class="question-item-column question-item-column-col-1">'+(i+1)+'.</div>'+
                            '<div class="question-item-column question-item-column-col-2">'+(that.summary_screen_repeat_questions?Question_text:"")+'</div>'+
                        '</div>'
                });
                question_item.inject($$("div.print-summary-resume")[0]);

                var your_response = new Element("div.summary-question-item-your-response",{
                    html: '<strong>Your response:</strong> '+ (question_answer!=undefined?question_answer.get('value') || '<div style="display: inline">'+ question_answer.get('html') +'</div>' :'')
                });
                your_response.inject(question_item.getElement('.question-item-column-col-2'));
                if(that.summary_screen_show_feedback && item.Feedback!=null){
                    var feeback = new Element("div.summary-question-item-feedback",{
                        html: that.renderItemFeedback(item.Feedback)
                    });
                    feeback.inject(question_item.getElement('.question-item-column-col-2'));
                }

            });
        }
    },

    renderItem: function(content){
        var result  = '';
        if(content && content.type!=null){
            switch(content.type){
                case 'text':
                    if(content.data)
                        if(content.data.length>0)
                            result = this.sanitize(content.data[0].content);
                        else
                            result = '';
                    else
                        result = this.sanitize(content.content);
                    break;
                case 'image':
                    result = '<div><img src="' + content.value + '" /></div>';
                    break;
                case 'pearson_video':
                    result = '<div class="iframe-wrapper iframe-wrapper-video"><iframe allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="' + content.value + '"></iframe></div>';
                    break;
                case 'pearson_audio':
                    result = '<div class="iframe-wrapper iframe-wrapper-audio"><iframe src="' + content.value + '"></iframe></div>';
                    break;
            }
        } else {

        }

        return result;
    },

    renderItemFeedback: function(content){
        var prefix = '<strong>Feedback:</strong> ';
        var result  = '';
        if(content.type!=null){
            switch(content.type){
                case 'text':
                    if(content.data)
                        if(content.data.length>0)
                            result = this.sanitize(content.data[0].content);
                        else
                            result = '';
                    else
                        result = this.sanitize(content.content);
                    break;
                case 'image':
                    result = this.imageFeedbackAaccesibility(content.value);
                    break;
                case 'pearson_video':
                    result = '<div class="iframe-wrapper iframe-wrapper-video"><iframe allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="' + content.value + '"></iframe></div>';
                    break;
                case 'pearson_audio':
                    result = '<div class="iframe-wrapper iframe-wrapper-audio"><iframe src="' + content.value + '"></iframe></div>';
                    break;
            }
        } else {

        }

        return prefix+result;
    },

    imageFeedbackAaccesibility: function(path) {
        var string = '<div><img src="' + path + '" /></div>';
        $$('.image-feedback-hidden').forEach(function(item, i){
            var altText = item.get('data-alt')!=null ? item.get('data-alt') : '';
            var longText = item.get('data-longText')!=null ? item.get('data-longText') : '';
            if (item.get('src') === path){
                string = '<div><img src="' + path + '" alt="' + altText + '" aria-describedby="longstatic "/><div id="longstatic" style="display:none">'+ longText +'</div></div>';
            }
        });
        return string;
    },

    generateDOM: function () {
        var that = this;
        var timer_input = null;
        $$(".widget-body")[0].empty();
        var body_wrapper = $$(".widget-body")[0];
        var page_intro = null;

        var show_intro_panel = false;

        if(this.intro.replace(/(<([^>]+)>)/ig,"").trim()!="" || that.isEditMode){
            show_intro_panel = true;
        }

        if(show_intro_panel){
            page_intro = new Element("div.page.page-intro"+(this.current_page==-1?'.page-active':''),{
                html: this.intro,
                tabindex: 0
            }).inject(body_wrapper);
            // focus intro if widget is in focus
            that.clearTimersOnUserInteraction(function (timers) {
                timers.push(setTimeout(function () {
                    page_intro.focus();
                }, 0));
            });
            $('MetrodigiWidget').addClass('current-intro');
        } else {
            //if($("intro-line")){
                //$("intro-line").show();
            //}
        }

        if(this.each_question_on_page) {
            if(this.options.data!=null && this.options.data.data!=null){
                this.options.data.data.forEach(function (item, i){

                    var page_el = new Element("div.page-item.page.page-"+i+(that.current_page==i?'.page-active':''),{
                            'data-item-page': i + 1
                        }).inject(body_wrapper);

                    var question_text = "";
                    var textbox_text = "";

                    if (typeof item["Question"] !== 'undefined' && item["Question"] != null && (typeof item["Question Input 1"] === 'undefined' || item["Question Input 1"] == null) ){
                        var Question = item["Question"];
                        question_text += '<div>' + that.renderItem(Question) + '</div>';
                    }
                    
                    if (typeof item["Question Input 1"] !== 'undefined' && item["Question Input 1"] != null){
                        question_text += '<div>' + that.renderItem(item["Question Input 1"]) + "</div>";
                    }

                    if (typeof item["Question Input 2"] !== 'undefined' && item["Question Input 2"] != null){
                        var Question = item["Question Input 2"];

                        if(!that.text_as_editable_passage){
                            question_text+= that.renderItem(Question);
                        }

                        if (that.text_as_editable_passage){
                            if (Question.type && Question.type=='text' && Question.data && Question.data.length>1 ){
                                question_text+= that.sanitize(Question.data[0].content);
                                textbox_text = that.sanitize(Question.data[1].content);
                            } else {
                                textbox_text = that.renderItem(Question);
                            }
                        }
                    }

                    var question_item = new Element("div.question-item",{
                        html: '<div class="question-item-columns">'+
                                '<div class="question-item-column question-item-column-col-1">'+(i+1)+'.</div>'+
                                '<div class="question-item-column question-item-column-col-2">'+question_text+'</div>'+
                            '</div>',
                        'data-question-index': i
                    }).inject(page_el);

                    //vickoman
                    if (that.options.data!=null && that.options.data.data!=null){
                        var div = new Element("div.img-feedback-hidde", {
                            html: ''
                        }).inject(page_el);

                        that.options.data.data.forEach(function(item, i){
                            if(that.summary_screen_show_feedback && item.Feedback!=null){
                                if(item.Feedback.type == 'image'){
                                    var imghide = new Element("img.image-feedback-hidden", {
                                        styles: {
                                            display: 'none'
                                        },
                                        src: item.Feedback.value,
                                    }).inject(div);
                                }
                            }
                        });
                    }

                    var q_text = Question && Question.content? Question.content : question_text;
                    var q_text_title = ''
                    if (Elements.from(q_text)[0]) {
                        q_text_title = Elements.from(q_text)[0].get('text')
                    }

                    if (that.text_as_editable_passage) {
                        new Element("div.answer-textarea.question-item-response-area.question-response",{
                            html: textbox_text,
                            contenteditable: true,
                            id: i,
                            title: q_text_title
                        }).inject(question_item.getElement(".question-item-column-col-2"));
                    } else {
                        new Element("textarea.answer-textarea.question-item-response-area.question-response",{
                            html: textbox_text,
                            id: i,
                            title: q_text_title
                        }).inject(question_item.getElement(".question-item-column-col-2"));
                    }
                });

                if(!that.show_introduction_panel){
                    $$(".pager-footer").set("html", "1 of "+this.options.data.data.length);
                    $$("#next").show();
                } else {
                    $$("#restart").show();
                    $$("#next").show();
                }
            }

            this.updatePager();

        } else {
            if(this.options.data!=null && this.options.data.data!=null){
                var page_el = new Element("div.question-list-mode.page-item.page.page-0"+(that.current_page==0?'.page-active':''),{
                    'data-item-page': 0
                }).inject(body_wrapper);

                /*
                if(that.isEditMode){

                    new Element("div.lead-in-text",{
                        html: that.lead_in_text,
                        contenteditable: true
                    }).inject(page_el);

                    $$("div.lead-in-text[contenteditable]").addEvent("input",function(e){
                        var _this_el = this;
                        if(timer_input!=null){
                            clearTimeout(timer_input);
                        }
                        timer_input = setTimeout(function(){
                            this.sendPostMessages('async-widget-data-save',{
                                data_target: "lead_in_text",
                                value_send: $(_this_el).get("html")
                            })
                        }.bind(that),750)
                    });
                } else {

                    new Element("div.lead-in-text",{
                        html: that.lead_in_text
                    }).inject(page_el);
                }
                */


                this.options.data.data.forEach(function(item,i){

                    if(typeof item === 'undefined' || item===null) return;

                    var question_item = null;

                    var question_text = "";
                    var textbox_text = "";

                    if(typeof item["Question"] !== 'undefined' && item["Question"] != null && (typeof item["Question Input 1"] === 'undefined' || item["Question Input 1"] == null) ){
                        var Question = item["Question"];
                        question_text += '<div>'+that.renderItem(Question)+'</div>';
                    }

                    if(typeof item["Question Input 1"] !== 'undefined' && item["Question Input 1"] != null){
                        /*
                        new Element("div.lead-in-text",{
                            html: that.renderItem ( item["Question Input 1"] )
                        }).inject(page_el);
                        */
                        question_text+='<div>'+that.renderItem ( item["Question Input 1"] )+"</div>";
                    }

                    

                    if(typeof item["Question Input 2"] !== 'undefined' && item["Question Input 2"] != null){
                        var Question = item["Question Input 2"];
                        

                        if(!that.text_as_editable_passage){
                            question_text+= that.renderItem(Question);
                        }

                        if(that.text_as_editable_passage){
                            if(Question.type && Question.type=='text' && Question.data && Question.data.length>1 ){
                                question_text+= that.sanitize(Question.data[0].content);
                                textbox_text = that.sanitize(Question.data[1].content);
                            }
                            else {
                                textbox_text = that.renderItem(Question);
                            }
                        }


                        
                    }

                    if (that.text_as_editable_passage) {
                        question_item = new Element("div.question-item.question.question-item-"+i,{
                            html: '<div class="question-item-container">'+
                                    '<div class="question-item-title">' + question_text + '</div>'+
                                    '<div class="question-item-response"><div contenteditable="true" name="response" class="answer-input question-response">'+textbox_text+'</div></div>'+
                                '</div>',
                            'data-question-index': i
                        }).inject(page_el);
                    } else {
                        question_item = new Element("div.question-item.question.question-item-"+i,{
                            html: '<div class="question-item-container">'+
                                    '<div class="question-item-title">' + question_text + '</div>'+
                                    '<div class="question-item-response"><input type="text" name="response" class="answer-input question-response" value="'+textbox_text+'"/></div>'+
                                '</div>',
                            'data-question-index': i
                        }).inject(page_el);
                    }

                });

                if(!that.show_introduction_panel){
                    $$(".pager-footer").set("html", "");
                    $$("#next").show();
                } else {
                    $$("#restart").show();
                    $$("#next").show();
                }
            }
        }

        var page_summary = new Element("div.page.page-end",{
            'data-item-page': 'end'
        }).inject(body_wrapper);

        if(that.isEditMode){

            new Element("div.intro-line-summary",{
                html: that.intro_line_summary,
                contenteditable: true
            }).inject(page_summary);

            var timer_input_intro_line_summary = null;

            $$("div.intro-line-summary[contenteditable]").addEvent("input",function(e){
                var _this_el = this;
                if(timer_input_intro_line_summary!=null){
                    clearTimeout(timer_input_intro_line_summary);
                }
                timer_input_intro_line_summary = setTimeout(function(){
                    this.sendPostMessages('async-widget-data-save',{
                        data_target: "intro_line_summary",
                        value_send: $(_this_el).get("html")
                    })
                }.bind(that),750)
            });
        } else if(that.intro_line_summary.trim()!=''){

            new Element("div.intro-line-summary",{
                html: that.intro_line_summary
            }).inject(page_summary);
        }


        if(this.summary_screen_show_lead_in){
            if(that.isEditMode){

                new Element("div.lead-in-text-summary",{
                    html: that.lead_in_text,
                    contenteditable: true
                }).inject(page_summary);

                $$("div.lead-in-text-summary[contenteditable]").addEvent("input",function(e){
                    var _this_el = this;
                    if(timer_input!=null){
                        clearTimeout(timer_input);
                    }
                    timer_input = setTimeout(function(){
                        this.sendPostMessages('async-widget-data-save',{
                            data_target: "lead_in_text",
                            value_send: $(_this_el).get("html")
                        })
                    }.bind(that),750)
                });
            } else {

                new Element("div.lead-in-text-summary",{
                    html: that.lead_in_text
                }).inject(page_summary);
            }
        }

        new Element("div.summary-resume").inject(page_summary);

        if(that.summary_show_scoring){
            new Element("div.summary-intro",{
                html: that.additional_summary_screen_text
            }).inject(page_summary);
        }




        var page_print = new Element("div.print-version",{
            'data-item-page': 'print'
        }).inject(body_wrapper);

        if(this.summary_screen_show_lead_in){
            new Element("div.lead-in-text-summary",{
                html: that.lead_in_text
            }).inject(page_print);
        }

        new Element("div.print-summary-resume").inject(page_print);

        if(that.summary_show_scoring){
            new Element("div.summary-intro",{
                html: that.additional_summary_screen_text
            }).inject(page_print);
        }



        this.updateViewport();



        //this.showSummary();

    }, // end render()
    // respond to received messages
    customPostMessages: function (message) {
        switch (message.data.method) {
            case 'async-data-updated':
            case 'data-change':
                this.setUPSettings(message.data);
                this.options.data = message.data.data;
                if(message.data.step==0)
                    this.current_page = -1;
                if(message.data.step==1)
                    this.current_page = 0;
                this.generateDOM();

            case 'steped-datapanel-change':
                switch(message.data.step){
                    case 0:
                        $$('.page').hide();
                        $$('.page').removeClass("page-active");
                        $$('.page.page-intro').show();
                        $$('.page.page-intro').addClass("page-active");

                        $("previous").hide();
                        $("previous").setProperty("disabled", "disabled");
                        //if($("intro-line"))
                        //    $("intro-line").hide();
                        $('MetrodigiWidget').removeClass('current-intro');
                        $('MetrodigiWidget').removeClass('current-summary');

                        $('MetrodigiWidget').addClass('current-intro');

                        break;
                    case 1:
                        $$('.page').hide();
                        $$('.page').removeClass("page-active");
                        $$('.page.page-0').show();
                        $$('.page.page-0').addClass("page-active");

                        $("previous").show();
                        $("previous").setProperty("disabled", null);
                        //if($("intro-line"))
                        //    $("intro-line").show();

                        $('MetrodigiWidget').removeClass('current-intro');
                        $('MetrodigiWidget').removeClass('current-summary');
                        break;
                    case 2:
                        $$('.page').hide();
                        $$('.page').removeClass("page-active");
                        $$('.page.page-end').show();
                        $$('.page.page-end').addClass("page-active");
                        this.showSummary();
                        //if($("intro-line"))
                        //    $("intro-line").show();

                        $('MetrodigiWidget').removeClass('current-intro');
                        $('MetrodigiWidget').removeClass('current-summary');

                        $('MetrodigiWidget').addClass('current-summary');
                        break;
                }
                break;
        }


    },
    updateViewport:function(){
        var header = $$(".widget-header")[0].getSize().y;
        var footer = $$(".widget-footer")[0].getSize().y;
        var edit_diff = $$('body.md-edit-mode').length > 0 ? 52 : 0;
        
        $$(".widget-content").setStyles({
            //height: window.getHeight() - header.getSize().y - footer.getSize().y - 26 - 5
            height: 'calc( 100vh - '+ (footer + header + edit_diff) +'px )'
        });


        this.updateTextareaHeight();
    },
    updateTextareaHeight: function(){
        if(this.each_question_on_page){
            if($$('.page-active .answer-textarea').length>0){

                var textarea_position = $$('.page-active .answer-textarea')[0].getPosition() ;
                var header = $$(".widget-header")[0].getSize().y;
                var footer = $$(".widget-footer")[0].getSize().y;

                $$('.page-active .answer-textarea')[0].setStyle('height', window.getHeight() - footer - textarea_position.y - 20);
                $$('.page-active .answer-textarea')[0].addClass('resized');
            }
        }
    },
    sanitize: function(txt) {
        //txt = txt.replace(/<[\/]{0,1}(p|P)[^><]*>/g,"");
        txt = txt.replace(/style="[a-zA-Z0-9:;\.\s\(\)\-\,]*"/gi,"");
        txt = txt.replace(/style='[a-zA-Z0-9:;\.\s\(\)\-\,]*'/gi,"");
        txt = txt.replace(/size=("|')[a-zA-Z0-9:;\.\s\(\)\-\,]*("|')/gi,"");
        return txt;
    },
    /*
     * Send widget options defined in the HTML
     */
    sendWidgetOptions: function (extra) {
        if (parent && parent != window) {
            var _this = this;
            this.readRequest(function (data) {
                
                var shouldUpdateData = false;
                if( typeof data !== 'null' && typeof data !== 'undefined' && typeof data.data !== 'null' && typeof data.data !== 'undefined' && typeof data.data.data !== 'null' && typeof data.data.data !== 'undefined'){
                    if(data.data.data.length > 0){
                        data.data.data.forEach(function(item, index){
                            if(typeof item === 'undefined' || item===null) return;
                            if( typeof item.Question !== 'null' && typeof item.Question !== 'undefined' && (typeof item['Question Input 1'] === 'null' || typeof item['Question Input 1'] === 'undefined') ){
                                data.data.data[index]['Question Input 1'] = item.Question;
                                delete data.data.data[index].Question;
                                shouldUpdateData = true;
                            }
                        });
                    }
                }

                function sendDataToParent(){

                    var options = {
                        'data-xml-type': _this.container.get('data-xml-type'),
                        'widget-data': data
                    };
                    if (typeof extra !== 'undefined') {
                        Array.each(extra, function (item) {
                            options[item] = _this.container.get(item);
                        });
                    }
                    _this.sendPostMessages('widget-options', {
                        options: options
                    });
                    ;
                }

               if(!shouldUpdateData) {
                    sendDataToParent.call();
               } else {
                    _this.saveRequest({method: 'mdData', options: {'json': data.data }}, function(){
                        sendDataToParent.call();
                    });
               }
            });
        }
    },
    isMobile: function() {
        if( navigator.userAgent.match(/Android/i)
          || navigator.userAgent.match(/webOS/i)
          || navigator.userAgent.match(/iPhone/i)
          || navigator.userAgent.match(/iPad/i)
          || navigator.userAgent.match(/iPod/i)
          || navigator.userAgent.match(/BlackBerry/i)
          || navigator.userAgent.match(/Windows Phone/i)
        ){
            return true;
        } else {
            return false;
        }
    }
}); // end Class FillInApplication()